/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.impl.DelegatingBatchArtifactFactoryImpl;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DelegatingJobXMLLoaderServiceImpl
implements IJobXMLLoaderService {
    private static final Logger logger = Logger.getLogger(DelegatingBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = DelegatingBatchArtifactFactoryImpl.class.getName();
    protected static IJobXMLLoaderService preferredJobXmlLoader = ServicesManagerImpl.getInstance().getPreferredJobXMLLoaderService();
    public static final String PREFIX = "META-INF/batch-jobs/";

    @Override
    public String loadJob(String id) {
        String method = "loadJob";
        logger.entering(CLASSNAME, method);
        String jobXML = null;
        if (!preferredJobXmlLoader.getClass().equals(this.getClass())) {
            jobXML = preferredJobXmlLoader.loadJob(id);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "No preferred job xml loader is detected in configuration");
        }
        if (jobXML != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Preferred job xml loader loaded job with id " + id + ".");
            }
            return jobXML;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Preferred job xml loader failed to load " + id + ". Defaulting to " + PREFIX);
        }
        if ((jobXML = DelegatingJobXMLLoaderServiceImpl.loadJobFromBatchJobs(id)) == null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "Failed to load " + id + " from " + PREFIX);
            }
            throw new BatchContainerServiceException("Could not load job xml with id: " + id);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "Loaded job xml with " + id + " from " + PREFIX);
        }
        return jobXML;
    }

    private static String loadJobFromBatchJobs(String id) {
        String relativePath;
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        URL path = tccl.getResource(relativePath = PREFIX + id + ".xml");
        if (path == null) {
            throw new BatchContainerRuntimeException(new FileNotFoundException("Cannot find an XML file under META-INF/batch-jobs/ with the following name " + id + ".xml"));
        }
        String xmlString = DelegatingJobXMLLoaderServiceImpl.readJobXML(path.getPath());
        return xmlString;
    }

    @Override
    public String loadStep(String id) {
        return null;
    }

    @Override
    public String loadXJCL(String id) {
        return null;
    }

    private static String readJobXML(String fileWithPath) {
        StringBuffer xmlBuffer = fileWithPath == null ? null : new StringBuffer();
        try {
            if (fileWithPath != null) {
                BufferedReader in = new BufferedReader(new FileReader(new File(fileWithPath)));
                String input = in.readLine();
                do {
                    if (input == null) continue;
                    xmlBuffer.append(input);
                    input = in.readLine();
                } while (input != null);
                in.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new BatchContainerServiceException("Could not find file " + fileWithPath);
        }
        catch (IOException e) {
            throw new BatchContainerServiceException(e);
        }
        return xmlBuffer == null ? null : xmlBuffer.toString();
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }
}

