/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.persistence;

import com.ibm.jbatch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.CheckpointDataKey;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.CheckpointAlgorithm;

public class CheckpointManager {
    private static final String sourceClass = CheckpointManager.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private IPersistenceManagerService _persistenceManagerService = null;
    private ItemReaderProxy readerProxy = null;
    private ItemWriterProxy writerProxy = null;
    int commitInterval = 0;
    private CheckpointAlgorithm checkpointAlgorithm;
    private boolean ckptStarted;
    private long executionId = 0L;
    private String stepId = null;
    private long jobInstanceID = 0L;

    public CheckpointManager(ItemReaderProxy reader, ItemWriterProxy writer, CheckpointAlgorithm chkptAlg, long executionId, long jobInstanceID, String stepId) {
        this.readerProxy = reader;
        this.writerProxy = writer;
        this.checkpointAlgorithm = chkptAlg;
        this.executionId = executionId;
        this.stepId = stepId;
        this.jobInstanceID = jobInstanceID;
        this._persistenceManagerService = this.servicesManager.getPersistenceManagerService();
    }

    public void beginCheckpoint(int timeoutVal) {
        String method = "startCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        this.ckptStarted = true;
    }

    public void beginCheckpoint() {
        String method = "beginCheckpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("executionId=" + this.executionId);
        }
        this.ckptStarted = true;
    }

    public boolean ApplyCheckPointPolicy() {
        String method = "ApplyCheckPointPolicy";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        boolean checkpoint = false;
        try {
            checkpoint = this.checkpointAlgorithm.isReadyToCheckpoint();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Checkpoint algorithm failed", e);
        }
        if (logger.isLoggable(Level.FINE) && checkpoint) {
            logger.fine("ApplyCheckPointPolicy - " + checkpoint);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method);
        }
        return checkpoint;
    }

    public boolean isStarted() {
        return this.ckptStarted;
    }

    public void checkpoint() {
        String method = "checkpoint";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, " [executionId " + this.executionId + "] ");
        }
        ByteArrayOutputStream readerChkptBA = new ByteArrayOutputStream();
        ByteArrayOutputStream writerChkptBA = new ByteArrayOutputStream();
        ObjectOutputStream readerOOS = null;
        ObjectOutputStream writerOOS = null;
        CheckpointDataKey readerChkptDK = null;
        CheckpointDataKey writerChkptDK = null;
        try {
            readerOOS = new ObjectOutputStream(readerChkptBA);
            readerOOS.writeObject(this.readerProxy.checkpointInfo());
            readerOOS.close();
            CheckpointData readerChkptData = new CheckpointData(this.jobInstanceID, this.stepId, "READER");
            readerChkptData.setRestartToken(readerChkptBA.toByteArray());
            readerChkptDK = new CheckpointDataKey(this.jobInstanceID, this.stepId, "READER");
            this._persistenceManagerService.updateData(2, readerChkptDK, readerChkptData);
            writerOOS = new ObjectOutputStream(writerChkptBA);
            writerOOS.writeObject(this.writerProxy.checkpointInfo());
            writerOOS.close();
            CheckpointData writerChkptData = new CheckpointData(this.jobInstanceID, this.stepId, "WRITER");
            writerChkptData.setRestartToken(writerChkptBA.toByteArray());
            writerChkptDK = new CheckpointDataKey(this.jobInstanceID, this.stepId, "WRITER");
            this._persistenceManagerService.updateData(2, writerChkptDK, writerChkptData);
        }
        catch (Exception ex) {
            throw new BatchContainerServiceException("Cannot persist the checkpoint data for [" + this.stepId + "]", ex);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, " [executionId " + this.executionId + "] ");
        }
    }

    public int checkpointTimeout() {
        int returnTimeout = 0;
        try {
            returnTimeout = this.checkpointAlgorithm.checkpointTimeout();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Checkpoint algorithm checkpointTimeout() failed", e);
        }
        return returnTimeout;
    }
}

