/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jobinstance;

import com.ibm.jbatch.container.artifact.proxy.ListenerFactory;
import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.jobinstance.JobOperatorJobExecutionImpl;
import com.ibm.jbatch.container.jsl.Navigator;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import java.sql.Timestamp;
import java.util.Properties;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;

public class RuntimeJobExecutionImpl {
    private Navigator jobNavigator = null;
    private JobInstance jobInstance;
    private long executionId;
    private String restartOn;
    private JobContextImpl<?> jobContext = null;
    private ListenerFactory listenerFactory;
    private JobOperatorJobExecutionImpl operatorJobExecution = null;

    RuntimeJobExecutionImpl(Navigator jobNavigator, JobInstance jobInstance, long executionId) {
        this.jobNavigator = jobNavigator;
        this.jobInstance = jobInstance;
        this.executionId = executionId;
        JSLProperties jslProperties = new JSLProperties();
        if (jobNavigator.getJSL() != null && jobNavigator.getJSL() instanceof JSLJob) {
            jslProperties = ((JSLJob)jobNavigator.getJSL()).getProperties();
        }
        this.jobContext = new JobContextImpl(jobNavigator.getId(), jslProperties);
        this.operatorJobExecution = new JobOperatorJobExecutionImpl(executionId, jobInstance.getInstanceId(), this.jobContext);
    }

    RuntimeJobExecutionImpl(Navigator jobNavigator, JobInstance jobInstance, long executionId, String restartOn) {
        this(jobNavigator, jobInstance, executionId);
        this.restartOn = restartOn;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public long getInstanceId() {
        return this.jobInstance.getInstanceId();
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public Navigator<JSLJob> getJobNavigator() {
        return this.jobNavigator;
    }

    public JobContextImpl<?> getJobContext() {
        return this.jobContext;
    }

    public String getRestartOn() {
        return this.restartOn;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" executionId: " + this.executionId);
        buf.append(" restartOn: " + this.restartOn);
        buf.append("\n-----------------------\n");
        buf.append("jobInstance: \n   " + this.jobInstance);
        return buf.toString();
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(ListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public JobExecution getJobOperatorJobExecution() {
        return this.operatorJobExecution;
    }

    public JobOperator.BatchStatus getBatchStatus() {
        return this.jobContext.getBatchStatus();
    }

    public void setBatchStatus(String status) {
        this.operatorJobExecution.setBatchStatus(status);
    }

    public void setCreateTime(Timestamp ts) {
        this.operatorJobExecution.setCreateTime(ts);
    }

    public void setEndTime(Timestamp ts) {
        this.operatorJobExecution.setEndTime(ts);
    }

    public void setExitStatus(String status) {
        this.operatorJobExecution.setExitStatus(status);
    }

    public void setLastUpdateTime(Timestamp ts) {
        this.operatorJobExecution.setLastUpdateTime(ts);
    }

    public void setStartTime(Timestamp ts) {
        this.operatorJobExecution.setStartTime(ts);
    }

    public void setJobProperties(Properties jProps) {
        this.operatorJobExecution.setJobProperties(jProps);
    }
}

