/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jobinstance;

import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.jobinstance.JobInstanceImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.jbatch.container.jsl.ModelResolverFactory;
import com.ibm.jbatch.container.jsl.ModelSerializer;
import com.ibm.jbatch.container.jsl.ModelSerializerFactory;
import com.ibm.jbatch.container.jsl.Navigator;
import com.ibm.jbatch.container.jsl.NavigatorFactory;
import com.ibm.jbatch.container.modelresolver.PropertyResolver;
import com.ibm.jbatch.container.modelresolver.PropertyResolverFactory;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.JDBCPersistenceManagerImpl;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.spi.services.IJobIdManagementService;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.operations.exception.JobRestartException;
import javax.batch.operations.exception.JobStartException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;

public class JobExecutionHelper {
    private static final String CLASSNAME = JobExecutionHelper.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private static final String GENERATED_JOB = "GENERATED_JOB";
    private static ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private static IJobIdManagementService _jobIdManagementService = servicesManager.getJobIdManagementService();
    private static IJobStatusManagerService _jobStatusManagerService = servicesManager.getJobStatusManagerService();
    private static IPersistenceManagerService _persistenceManagementService = servicesManager.getPersistenceManagerService();

    public static RuntimeJobExecutionImpl startJob(String jobXML, Properties jobParameters) throws JobStartException {
        long instanceId = _jobIdManagementService.getInstanceId();
        long executionId = _jobIdManagementService.getExecutionId();
        JSLJob jobModel = (JSLJob)ModelResolverFactory.createJobResolver().resolveModel(jobXML);
        JobInstanceImpl jobInstanceImpl = new JobInstanceImpl(jobXML, jobParameters, instanceId);
        PropertyResolver propResolver = PropertyResolverFactory.createJobPropertyResolver((boolean)false);
        propResolver.substituteProperties((Object)jobModel, jobParameters);
        Navigator jobNavigator = NavigatorFactory.createJobNavigator((JSLJob)jobModel);
        JobExecutionHelper.validateAbstractJobDoNotStart(jobModel);
        jobInstanceImpl.setJobName(jobNavigator.getId());
        _jobStatusManagerService.createJobStatus(jobInstanceImpl, executionId);
        long time = System.currentTimeMillis();
        Timestamp starttime = null;
        Timestamp updatetime = new Timestamp(time);
        Timestamp endtime = null;
        Timestamp createtime = new Timestamp(time);
        _persistenceManagementService.jobOperatorCreateJobInstanceData(instanceId, jobNavigator.getId());
        RuntimeJobExecutionImpl rtJobExec = new RuntimeJobExecutionImpl(jobNavigator, jobInstanceImpl, executionId);
        rtJobExec.setStartTime(starttime);
        rtJobExec.setCreateTime(createtime);
        rtJobExec.setLastUpdateTime(updatetime);
        rtJobExec.setEndTime(endtime);
        rtJobExec.setJobProperties(jobParameters);
        JobExecutionHelper.createJobExecutionEntry(rtJobExec.getJobOperatorJobExecution());
        return rtJobExec;
    }

    private static void validateAbstractJobDoNotStart(JSLJob jobModel) throws JobStartException {
        if (jobModel.getAbstract() != null && jobModel.getAbstract().equalsIgnoreCase("true")) {
            throw new JobStartException("An abstract job is NOT executable.");
        }
    }

    public static RuntimeJobExecutionImpl restartJob(long executionId) throws JobRestartException {
        return JobExecutionHelper.restartJob(executionId, null, false);
    }

    public static RuntimeJobExecutionImpl restartJob(long executionId, Properties overrideJobParameters, boolean isPartitionedStep) throws JobRestartException {
        JobExecution jobEx = _persistenceManagementService.jobOperatorGetJobExecution(executionId);
        long jobInstanceId = jobEx.getInstanceId();
        JobStatus jobStatus = _jobStatusManagerService.getJobStatus(jobInstanceId);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("On restartJob with jobInstance Id = " + jobInstanceId + " , found JobStatus: " + jobStatus);
        }
        JobInstanceImpl jobInstance = jobStatus.getJobInstance();
        long nextExecutionId = _jobIdManagementService.getExecutionId();
        Properties originalJobParameters = jobInstance.getOriginalJobParams();
        Properties mergedRestartJobParameters = new Properties(originalJobParameters);
        if (overrideJobParameters != null) {
            for (String key : overrideJobParameters.stringPropertyNames()) {
                mergedRestartJobParameters.setProperty(key, overrideJobParameters.getProperty(key));
            }
        }
        JSLJob jobModel = (JSLJob)ModelResolverFactory.createJobResolver().resolveModel(jobInstance.getJobXML());
        PropertyResolver propResolver = PropertyResolverFactory.createJobPropertyResolver((boolean)isPartitionedStep);
        propResolver.substituteProperties((Object)jobModel, mergedRestartJobParameters);
        Navigator jobNavigator = NavigatorFactory.createJobNavigator((JSLJob)jobModel);
        JobExecutionHelper.validateRestartableFalseJobsDoNotRestart(jobModel);
        _jobStatusManagerService.updateJobStatusWithNewExecution(jobInstance.getInstanceId(), nextExecutionId);
        long time = System.currentTimeMillis();
        Timestamp starttime = null;
        Timestamp updatetime = new Timestamp(time);
        Timestamp endtime = null;
        Timestamp createtime = new Timestamp(time);
        RuntimeJobExecutionImpl rtJobExec = new RuntimeJobExecutionImpl(jobNavigator, jobInstance, nextExecutionId, jobStatus.getRestartOn());
        rtJobExec.setStartTime(starttime);
        rtJobExec.setCreateTime(createtime);
        rtJobExec.setLastUpdateTime(updatetime);
        rtJobExec.setEndTime(endtime);
        rtJobExec.setJobProperties(mergedRestartJobParameters);
        JobExecutionHelper.createJobExecutionEntry(rtJobExec.getJobOperatorJobExecution());
        return rtJobExec;
    }

    private static void validateRestartableFalseJobsDoNotRestart(JSLJob jobModel) throws JobRestartException {
        if (jobModel.getRestartable() != null && jobModel.getRestartable().equalsIgnoreCase("false")) {
            throw new JobRestartException("Job Restartable attribute is false, Job cannot be restarted.");
        }
    }

    public static RuntimeJobExecutionImpl startJob(JSLJob jobModel, Properties jobParameters, boolean isPartitionedStep) {
        long instanceId = _jobIdManagementService.getInstanceId();
        long executionId = _jobIdManagementService.getExecutionId();
        ModelSerializer serializer = ModelSerializerFactory.createJobModelSerializer();
        String jobXML = serializer.serializeModel((Object)jobModel);
        JobInstanceImpl jobInstanceImpl = new JobInstanceImpl(jobXML, jobParameters, instanceId);
        PropertyResolver propResolver = PropertyResolverFactory.createJobPropertyResolver((boolean)isPartitionedStep);
        propResolver.substituteProperties((Object)jobModel, jobParameters);
        Navigator jobNavigator = NavigatorFactory.createJobNavigator((JSLJob)jobModel);
        jobInstanceImpl.setJobName(jobNavigator.getId());
        _jobStatusManagerService.createJobStatus(jobInstanceImpl, executionId);
        long time = System.currentTimeMillis();
        Timestamp starttime = null;
        Timestamp updatetime = new Timestamp(time);
        Timestamp endtime = null;
        Timestamp createtime = new Timestamp(time);
        _persistenceManagementService.jobOperatorCreateJobInstanceData(instanceId, jobNavigator.getId());
        RuntimeJobExecutionImpl rtJobExec = new RuntimeJobExecutionImpl(jobNavigator, jobInstanceImpl, executionId);
        rtJobExec.setStartTime(starttime);
        rtJobExec.setCreateTime(createtime);
        rtJobExec.setLastUpdateTime(updatetime);
        rtJobExec.setEndTime(endtime);
        rtJobExec.setJobProperties(jobParameters);
        JobExecutionHelper.createJobExecutionEntry(rtJobExec.getJobOperatorJobExecution());
        return rtJobExec;
    }

    public static void persistStepExecution(long jobExecutionInstanceID, StepContextImpl stepContext) {
        String stepExecutionKey = JobExecutionHelper.getJobStepExecId(jobExecutionInstanceID, stepContext.getStepExecutionId());
        _persistenceManagementService.stepExecutionCreateStepExecutionData(stepExecutionKey, jobExecutionInstanceID, stepContext);
    }

    public static void createJobExecutionEntry(JobExecution jobEx) {
        long executionId = jobEx.getExecutionId();
        long instanceId = jobEx.getInstanceId();
        Timestamp starttime = new Timestamp(0L);
        Timestamp updatetime = new Timestamp(jobEx.getLastUpdatedTime().getTime());
        Timestamp endtime = new Timestamp(0L);
        Timestamp createtime = new Timestamp(jobEx.getCreateTime().getTime());
        Properties jobParameters = jobEx.getJobParameters();
        JobOperator.BatchStatus batchStatus = jobEx.getBatchStatus() == null ? JobOperator.BatchStatus.STARTING : jobEx.getBatchStatus();
        String exitstatus = jobEx.getExitStatus();
        _persistenceManagementService.jobOperatorCreateExecutionData(executionId, starttime, updatetime, endtime, createtime, jobParameters, instanceId, batchStatus.name(), exitstatus);
    }

    public static void updateJobExecutionEntry(JobExecution jobEx) {
        long executionId = jobEx.getExecutionId();
        long instanceId = jobEx.getInstanceId();
        Timestamp starttime = new Timestamp(jobEx.getStartTime().getTime());
        Timestamp updatetime = new Timestamp(jobEx.getLastUpdatedTime().getTime());
        Timestamp endtime = new Timestamp(jobEx.getEndTime().getTime());
        Timestamp createtime = new Timestamp(jobEx.getCreateTime().getTime());
        Properties jobParameters = jobEx.getJobParameters();
        JobOperator.BatchStatus batchStatus = jobEx.getBatchStatus();
        String exitstatus = jobEx.getExitStatus();
        _persistenceManagementService.jobOperatorCreateExecutionData(executionId, starttime, updatetime, endtime, createtime, jobParameters, instanceId, batchStatus.name(), exitstatus);
    }

    public static JobExecution getPersistedJobOperatorJobExecution(long jobExecutionId) {
        if (_persistenceManagementService instanceof JDBCPersistenceManagerImpl) {
            return _persistenceManagementService.jobOperatorGetJobExecution(jobExecutionId);
        }
        return null;
    }

    public static void updateBatchStatusUPDATEonly(long executionId, String batchStatusString, Timestamp ts) {
        _persistenceManagementService.jobOperatorUpdateBatchStatusWithUPDATETSonly(executionId, "batchstatus", batchStatusString, ts);
    }

    public static void updateBatchStatusSTART(long executionId, String batchStatusString, Timestamp startTs) {
        _persistenceManagementService.jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(executionId, "batchstatus", batchStatusString, startTs);
    }

    public static void updateBatchStatusSTOP(long executionId, String batchStatusString, Timestamp stopTs) {
        _persistenceManagementService.jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(executionId, "batchstatus", batchStatusString, stopTs);
    }

    public static void updateBatchStatusCOMPLETED(long executionId, String batchStatusString, Timestamp completedTs) {
        _persistenceManagementService.jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(executionId, "batchstatus", batchStatusString, completedTs);
    }

    public static void updateBatchStatusENDED(long executionId, String batchStatusString, Timestamp endedTs) {
        _persistenceManagementService.jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(executionId, "batchstatus", batchStatusString, endedTs);
    }

    public static void updateBatchStatusFAILED(long executionId, String batchStatusString, Timestamp failedTs) {
        _persistenceManagementService.jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(executionId, "batchstatus", batchStatusString, failedTs);
    }

    public static StepExecution getStepExecutionIDInfo(long stepexecutionId) {
        return _persistenceManagementService.getStepExecutionObjQueryByStepID(stepexecutionId);
    }

    public static List<StepExecution> getstepExecutionIDInfoList(long jobexecutionId) {
        return _persistenceManagementService.getStepExecutionIDListQueryByJobID(jobexecutionId);
    }

    private static String getJobStepExecId(long jobExecutionId, long stepExecutionId) {
        return String.valueOf(jobExecutionId) + ':' + String.valueOf(stepExecutionId);
    }

    public static JobInstance getJobInstance(long instanceId) {
        JobStatus jobStatus = _jobStatusManagerService.getJobStatus(instanceId);
        JobInstanceImpl jobInstance = jobStatus.getJobInstance();
        return jobInstance;
    }
}

