/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.AbortedBeforeStartException;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.PartitionedStepBuilder;
import com.ibm.jbatch.container.jobinstance.ParallelJobExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Split;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;

public class SplitControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SplitControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final RuntimeJobExecutionImpl jobExecutionImpl;
    private volatile List<ParallelJobExecution> parallelJobExecs;
    private final ServicesManager servicesManager;
    private final IBatchKernelService batchKernel;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();
    protected Split split;

    public SplitControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Split split) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.split = split;
        this.servicesManager = ServicesManagerImpl.getInstance();
        this.batchKernel = this.servicesManager.getBatchKernelService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelJobExecs != null) {
                for (ParallelJobExecution subJob : this.parallelJobExecs) {
                    try {
                        this.batchKernel.stopJob(subJob.getJobExecution().getInstanceId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute() throws AbortedBeforeStartException {
        String sourceMethod = "execute";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod);
        }
        List flows = this.split.getFlow();
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            for (Flow flow : flows) {
                this.subJobs.add(PartitionedStepBuilder.buildSubJob(this.jobExecutionImpl.getExecutionId(), this.split, flow, null));
            }
            this.parallelJobExecs = this.batchKernel.startParallelJobs(this.subJobs, null, null, null);
        }
        for (ParallelJobExecution subJob : this.parallelJobExecs) {
            subJob.waitForResult();
        }
        for (ParallelJobExecution subJob : this.parallelJobExecs) {
            JobOperator.BatchStatus batchStatus = subJob.getJobExecution().getJobContext().getBatchStatus();
            if (batchStatus.equals((Object)JobOperator.BatchStatus.FAILED)) {
                if (!logger.isLoggable(Level.FINE)) break;
                logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
                logger.fine("Starting logical transaction rollback.");
                break;
            }
            if (!batchStatus.equals((Object)JobOperator.BatchStatus.STOPPED)) continue;
            if (!logger.isLoggable(Level.FINE)) break;
            logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
            logger.fine("Starting logical transaction rollback.");
            break;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceMethod, sourceMethod);
        }
        return "SPLIT_CONTROLLER_RETURN_VALUE";
    }

    public void setStepContext(StepContextImpl<?, ? extends Serializable> stepContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: step context is not in scope within a flow.");
    }

    @Override
    public void setAnalyzerQueue(LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue) {
    }

    public List<ParallelJobExecution> getParallelJobExecs() {
        return this.parallelJobExecs;
    }

    @Override
    public void setSubJobExitStatusQueue(Stack<String> subJobExitStatusQueue) {
    }
}

