/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionMapperProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionReducerProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.BaseStepControllerImpl;
import com.ibm.jbatch.container.impl.PartitionedStepBuilder;
import com.ibm.jbatch.container.jobinstance.ParallelJobExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.jbatch.container.jsl.CloneUtility;
import com.ibm.jbatch.container.util.BatchPartitionPlan;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Analyzer;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.PartitionMapper;
import com.ibm.jbatch.jsl.model.PartitionReducer;
import com.ibm.jbatch.jsl.model.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.PartitionPlan;
import javax.batch.api.PartitionReducer;
import javax.batch.operations.JobOperator;
import javax.batch.operations.exception.JobRestartException;

public class PartitionedStepControllerImpl
extends BaseStepControllerImpl {
    private static final String sourceClass = PartitionedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final int DEFAULT_PARTITION_INSTANCES = 1;
    private static final int DEFAULT_THREADS = 0;
    private int partitions = 1;
    private int threads = 0;
    private Properties[] partitionProperties = null;
    private volatile List<ParallelJobExecution> parallelJobExecs;
    private PartitionReducerProxy partitionReducerProxy = null;
    private PartitionAnalyzerProxy analyzerProxy = null;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();

    protected PartitionedStepControllerImpl(RuntimeJobExecutionImpl jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.stepContext.setBatchStatus(JobOperator.BatchStatus.STOPPING);
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelJobExecs != null) {
                for (ParallelJobExecution subJob : this.parallelJobExecs) {
                    try {
                        batchKernel.stopJob(subJob.getJobExecution().getExecutionId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    private PartitionPlan generatePartitionPlan() {
        PartitionPlan plan = null;
        PartitionMapper partitionMapper = this.step.getPartition().getMapper();
        if (this.stepStatus.getPlan() != null) {
            plan = this.stepStatus.getPlan();
        } else if (partitionMapper != null) {
            PartitionMapperProxy partitionMapperProxy;
            List propertyList = partitionMapper.getProperties() == null ? null : partitionMapper.getProperties().getPropertyList();
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propertyList);
            try {
                partitionMapperProxy = ProxyFactory.createPartitionMapperProxy(partitionMapper.getRef(), injectionRef, this.stepContext);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the PartitionMapper [" + partitionMapper.getRef() + "]", e);
            }
            PartitionPlan mapperPlan = partitionMapperProxy.mapPartitions();
            plan = new BatchPartitionPlan();
            plan.setPartitionCount(mapperPlan.getPartitionCount());
            plan.setThreadCount(mapperPlan.getThreadCount());
            plan.setPartitionProperties(mapperPlan.getPartitionProperties());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Partition plan defined by partition mapper: " + plan);
            }
        } else if (this.step.getPartition().getPlan() != null) {
            int numThreads;
            String partitionsAttr = this.step.getPartition().getPlan().getPartitions();
            String threadsAttr = null;
            int numPartitions = Integer.MIN_VALUE;
            Properties[] partitionProps = null;
            if (partitionsAttr != null) {
                try {
                    numPartitions = Integer.parseInt(partitionsAttr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse partition instances value in stepId: " + this.step.getId() + ", with instances=" + partitionsAttr, e);
                }
                partitionProps = new Properties[numPartitions];
                if (numPartitions < 1) {
                    throw new IllegalArgumentException("Partition instances value must be 1 or greater in stepId: " + this.step.getId() + ", with instances=" + partitionsAttr);
                }
            }
            if ((threadsAttr = this.step.getPartition().getPlan().getThreads()) != null) {
                try {
                    numThreads = Integer.parseInt(partitionsAttr);
                    if (numThreads == 0) {
                        numThreads = numPartitions;
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse partition threads value in stepId: " + this.step.getId() + ", with instances=" + partitionsAttr, e);
                }
                if (numThreads < 0) {
                    throw new IllegalArgumentException("Threads value must be 0 or greater in stepId: " + this.step.getId() + ", with instances=" + partitionsAttr);
                }
            } else {
                numThreads = numPartitions;
            }
            if (this.step.getPartition().getPlan().getProperties() != null) {
                List jslProperties = this.step.getPartition().getPlan().getProperties();
                for (JSLProperties props : jslProperties) {
                    int targetPartition = Integer.parseInt(props.getPartition());
                    try {
                        partitionProps[targetPartition - 1] = CloneUtility.jslPropertiesToJavaProperties((JSLProperties)props);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new BatchContainerRuntimeException("There are only " + numPartitions + " partition instances, but there are " + jslProperties.size() + " partition properties lists defined.", e);
                    }
                }
            }
            plan = new BatchPartitionPlan();
            plan.setPartitionCount(numPartitions);
            plan.setThreadCount(this.threads);
            plan.setPartitionProperties(partitionProps);
        }
        return plan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invokeCoreStep() throws JobRestartException {
        PartitionPlan plan = this.generatePartitionPlan();
        this.partitions = plan.getPartitionCount();
        this.threads = plan.getThreadCount();
        this.partitionProperties = plan.getPartitionProperties();
        this.stepStatus.setPlan(plan);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Number of partitions in step: " + this.partitions + " in step " + this.step.getId());
            logger.fine("Subjob properties defined by partition mapper: " + this.partitionProperties);
        }
        LinkedBlockingQueue<PartitionDataWrapper> analyzerQueue = null;
        if (this.analyzerProxy != null) {
            analyzerQueue = new LinkedBlockingQueue<PartitionDataWrapper>();
        }
        this.subJobExitStatusQueue = new Stack();
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.jobExecutionImpl.getJobContext().getBatchStatus().equals((Object)JobOperator.BatchStatus.STOPPING)) {
                this.stepContext.setBatchStatus(JobOperator.BatchStatus.STOPPED);
                return;
            }
            for (int instance = 0; instance < this.partitions; ++instance) {
                this.subJobs.add(PartitionedStepBuilder.buildSubJob(this.jobExecutionImpl.getInstanceId(), this.step, instance));
            }
            this.parallelJobExecs = this.stepStatus.getStartCount() > 1 ? batchKernel.restartParallelJobs(this.subJobs, this.partitionProperties, analyzerQueue, this.subJobExitStatusQueue) : batchKernel.startParallelJobs(this.subJobs, this.partitionProperties, analyzerQueue, this.subJobExitStatusQueue);
        }
        int completedPartitions = 0;
        if (this.analyzerProxy != null) {
            do {
                try {
                    PartitionDataWrapper dataWrapper = analyzerQueue.take();
                    switch (dataWrapper.getEventType()) {
                        case ANALYZE_COLLECTOR_DATA: {
                            this.analyzerProxy.analyzeCollectorData(dataWrapper.getCollectorData());
                            break;
                        }
                        case ANALYZE_STATUS: {
                            this.analyzerProxy.analyzeStatus(dataWrapper.getBatchstatus().name(), dataWrapper.getExitStatus());
                            ++completedPartitions;
                            break;
                        }
                        case STEP_FINISHED: {
                            ++completedPartitions;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Invalid partition state");
                        }
                    }
                }
                catch (InterruptedException e) {
                    throw new BatchContainerRuntimeException(e);
                }
            } while (completedPartitions != this.partitions);
        }
        boolean rollback = false;
        boolean partitionedFailed = false;
        for (ParallelJobExecution subJob : this.parallelJobExecs) {
            subJob.waitForResult();
            JobOperator.BatchStatus batchStatus = subJob.getJobExecution().getJobContext().getBatchStatus();
            if (batchStatus.equals((Object)JobOperator.BatchStatus.FAILED)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
                    logger.fine("Starting logical transaction rollback.");
                }
                rollback = true;
                partitionedFailed = true;
                this.stepContext.setBatchStatus(JobOperator.BatchStatus.FAILED);
                continue;
            }
            if (!batchStatus.equals((Object)JobOperator.BatchStatus.STOPPED)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Subjob " + subJob.getJobExecution().getExecutionId() + "ended with status '" + batchStatus + "'");
                logger.fine("Starting logical transaction rollback.");
            }
            rollback = true;
            if (JobOperator.BatchStatus.FAILED.equals((Object)this.stepContext.getBatchStatus())) continue;
            this.stepContext.setBatchStatus(JobOperator.BatchStatus.STOPPED);
        }
        if (rollback) {
            if (this.partitionReducerProxy != null) {
                this.partitionReducerProxy.rollbackPartitionedStep();
            }
        } else if (this.partitionReducerProxy != null) {
            this.partitionReducerProxy.beforePartitionedStepCompletion();
        }
        if (partitionedFailed) {
            throw new BatchContainerRuntimeException("One or more partitions failed");
        }
        if (this.stepContext.getExitStatus() == null) {
            this.stepContext.setExitStatus((String)this.subJobExitStatusQueue.pop());
            this.subJobExitStatusQueue.clear();
        }
    }

    @Override
    protected void setupStepArtifacts() {
        PartitionReducer partitionReducer;
        Analyzer analyzer = this.step.getPartition().getAnalyzer();
        if (analyzer != null) {
            List propList = analyzer.getProperties() == null ? null : analyzer.getProperties().getPropertyList();
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            try {
                this.analyzerProxy = ProxyFactory.createPartitionAnalyzerProxy(analyzer.getRef(), injectionRef, this.stepContext);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the analyzer [" + analyzer.getRef() + "]", e);
            }
        }
        if ((partitionReducer = this.step.getPartition().getReducer()) != null) {
            List propList = partitionReducer.getProperties() == null ? null : partitionReducer.getProperties().getPropertyList();
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            try {
                this.partitionReducerProxy = ProxyFactory.createPartitionReducerProxy(partitionReducer.getRef(), injectionRef, this.stepContext);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the analyzer [" + partitionReducer.getRef() + "]", e);
            }
        }
    }

    @Override
    protected void invokePreStepArtifacts() {
        if (this.partitionReducerProxy != null) {
            this.partitionReducerProxy.beginPartitionedStep();
        }
    }

    @Override
    protected void invokePostStepArtifacts() {
        if (this.partitionReducerProxy != null) {
            if (JobOperator.BatchStatus.COMPLETED.equals((Object)this.stepContext.getBatchStatus())) {
                this.partitionReducerProxy.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.COMMIT);
            } else {
                this.partitionReducerProxy.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.ROLLBACK);
            }
        }
    }
}

