/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.impl.BatchletStepControllerImpl;
import com.ibm.jbatch.container.impl.ChunkStepControllerImpl;
import com.ibm.jbatch.container.impl.DecisionControllerImpl;
import com.ibm.jbatch.container.impl.FlowControllerImpl;
import com.ibm.jbatch.container.impl.PartitionedStepControllerImpl;
import com.ibm.jbatch.container.impl.SplitControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionImpl;
import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.jsl.model.Batchlet;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.Partition;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutionElementControllerFactory {
    private static final String CLASSNAME = ExecutionElementControllerFactory.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);

    public static IExecutionElementController getExecutionElementController(RuntimeJobExecutionImpl jobExecutionImpl, ExecutionElement executionElement) {
        String methodName = "getExecutionElementController";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASSNAME, methodName, "Get Execution Element Controller for", executionElement.getId());
        }
        if (executionElement instanceof Step) {
            Batchlet batchlet;
            Step step = (Step)executionElement;
            Partition partition = step.getPartition();
            if (partition != null) {
                if (partition.getMapper() != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASSNAME, methodName, "Found partitioned step with mapper", step);
                    }
                    return new PartitionedStepControllerImpl(jobExecutionImpl, step);
                }
                if (partition.getPlan() != null && partition.getPlan().getPartitions() != null) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASSNAME, methodName, "Found partitioned step with plan", step);
                    }
                    return new PartitionedStepControllerImpl(jobExecutionImpl, step);
                }
            }
            if ((batchlet = step.getBatchlet()) != null) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASSNAME, methodName, "Found batchlet", batchlet);
                }
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASSNAME, methodName, "Found batchlet", batchlet.getRef());
                }
                if (step.getChunk() != null) {
                    throw new IllegalArgumentException("Step contains both a batchlet and a chunk.  Aborting.");
                }
                return new BatchletStepControllerImpl(jobExecutionImpl, step);
            }
            Chunk chunk = step.getChunk();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASSNAME, methodName, "Found chunk", chunk);
            }
            if (chunk == null) {
                throw new IllegalArgumentException("Step does not contain either a batchlet or a chunk.  Aborting.");
            }
            return new ChunkStepControllerImpl(jobExecutionImpl, step);
        }
        if (executionElement instanceof Decision) {
            return new DecisionControllerImpl(jobExecutionImpl, (Decision)executionElement);
        }
        if (executionElement instanceof Flow) {
            return new FlowControllerImpl(jobExecutionImpl, (Flow)executionElement);
        }
        if (executionElement instanceof Split) {
            return new SplitControllerImpl(jobExecutionImpl, (Split)executionElement);
        }
        throw new UnsupportedOperationException("Only support steps, flows, splits, and decisions so far.");
    }
}

