/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.artifact.proxy;

import com.ibm.jbatch.container.artifact.proxy.BatchletProxy;
import com.ibm.jbatch.container.artifact.proxy.CheckpointAlgorithmProxy;
import com.ibm.jbatch.container.artifact.proxy.DeciderProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ItemProcessorProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemReaderProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemWriterProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionCollectorProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionMapperProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionReducerProxy;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.spi.services.IBatchArtifactFactory;
import javax.batch.api.Batchlet;
import javax.batch.api.CheckpointAlgorithm;
import javax.batch.api.Decider;
import javax.batch.api.ItemProcessor;
import javax.batch.api.ItemReader;
import javax.batch.api.ItemWriter;
import javax.batch.api.PartitionAnalyzer;
import javax.batch.api.PartitionCollector;
import javax.batch.api.PartitionMapper;
import javax.batch.api.PartitionReducer;

public class ProxyFactory {
    protected static ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private static ThreadLocal<InjectionReferences> injectionContext = new ThreadLocal();
    protected static IBatchArtifactFactory batchArtifactFactory = servicesManager.getDelegatingArtifactFactory();

    protected static Object loadArtifact(String id, InjectionReferences injectionReferences) {
        injectionContext.set(injectionReferences);
        Object loadedArtifact = null;
        try {
            loadedArtifact = batchArtifactFactory.load(id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return loadedArtifact;
    }

    public static InjectionReferences getInjectionReferences() {
        return injectionContext.get();
    }

    public static DeciderProxy createDeciderProxy(String id, InjectionReferences injectionRefs) throws ArtifactValidationException {
        Decider loadedArtifact = (Decider)ProxyFactory.loadArtifact(id, injectionRefs);
        DeciderProxy proxy = new DeciderProxy(loadedArtifact);
        return proxy;
    }

    public static BatchletProxy createBatchletProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        Batchlet loadedArtifact = (Batchlet)ProxyFactory.loadArtifact(id, injectionRefs);
        BatchletProxy proxy = new BatchletProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static CheckpointAlgorithmProxy createCheckpointAlgorithmProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        CheckpointAlgorithm loadedArtifact = (CheckpointAlgorithm)ProxyFactory.loadArtifact(id, injectionRefs);
        CheckpointAlgorithmProxy proxy = new CheckpointAlgorithmProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static ItemReaderProxy createItemReaderProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        ItemReader loadedArtifact = (ItemReader)ProxyFactory.loadArtifact(id, injectionRefs);
        ItemReaderProxy proxy = new ItemReaderProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static ItemProcessorProxy createItemProcessorProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        ItemProcessor loadedArtifact = (ItemProcessor)ProxyFactory.loadArtifact(id, injectionRefs);
        ItemProcessorProxy proxy = new ItemProcessorProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static ItemWriterProxy createItemWriterProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        ItemWriter loadedArtifact = (ItemWriter)ProxyFactory.loadArtifact(id, injectionRefs);
        ItemWriterProxy proxy = new ItemWriterProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static PartitionReducerProxy createPartitionReducerProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        PartitionReducer loadedArtifact = (PartitionReducer)ProxyFactory.loadArtifact(id, injectionRefs);
        PartitionReducerProxy proxy = new PartitionReducerProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static PartitionMapperProxy createPartitionMapperProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        PartitionMapper loadedArtifact = (PartitionMapper)ProxyFactory.loadArtifact(id, injectionRefs);
        PartitionMapperProxy proxy = new PartitionMapperProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static PartitionAnalyzerProxy createPartitionAnalyzerProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        PartitionAnalyzer loadedArtifact = (PartitionAnalyzer)ProxyFactory.loadArtifact(id, injectionRefs);
        PartitionAnalyzerProxy proxy = new PartitionAnalyzerProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }

    public static PartitionCollectorProxy createPartitionCollectorProxy(String id, InjectionReferences injectionRefs, StepContextImpl stepContext) throws ArtifactValidationException {
        PartitionCollector loadedArtifact = (PartitionCollector)ProxyFactory.loadArtifact(id, injectionRefs);
        PartitionCollectorProxy proxy = new PartitionCollectorProxy(loadedArtifact);
        proxy.setStepContext(stepContext);
        return proxy;
    }
}

