/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.artifact.proxy;

import com.ibm.jbatch.container.artifact.proxy.ChunkListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ItemProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ItemWriteListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.JobListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.artifact.proxy.RetryProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.RetryReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.RetryWriteListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipProcessListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipReadListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.SkipWriteListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.StepListenerProxy;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Listener;
import com.ibm.jbatch.jsl.model.Listeners;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.batch.api.ChunkListener;
import javax.batch.api.ItemProcessListener;
import javax.batch.api.ItemReadListener;
import javax.batch.api.ItemWriteListener;
import javax.batch.api.JobListener;
import javax.batch.api.RetryProcessListener;
import javax.batch.api.RetryReadListener;
import javax.batch.api.RetryWriteListener;
import javax.batch.api.SkipProcessListener;
import javax.batch.api.SkipReadListener;
import javax.batch.api.SkipWriteListener;
import javax.batch.api.StepListener;

public class ListenerFactory {
    private List<ListenerInfo> jobLevelListenerInfo = null;
    private Map<String, List<ListenerInfo>> stepLevelListenerInfo = new HashMap<String, List<ListenerInfo>>();

    public ListenerFactory(JSLJob jobModel, InjectionReferences injectionRefs) {
        this.initJobLevelListeners(jobModel, injectionRefs);
    }

    private void initJobLevelListeners(JSLJob jobModel, InjectionReferences injectionRefs) {
        this.jobLevelListenerInfo = new ArrayList<ListenerInfo>();
        Listeners jobLevelListeners = jobModel.getListeners();
        if (jobLevelListeners != null) {
            for (Listener listener : jobLevelListeners.getListenerList()) {
                ListenerInfo info = this.buildListenerInfo(listener, injectionRefs);
                this.jobLevelListenerInfo.add(info);
            }
        }
    }

    private synchronized List<ListenerInfo> getStepListenerInfo(Step step, InjectionReferences injectionRefs) {
        if (!this.stepLevelListenerInfo.containsKey(step.getId())) {
            ArrayList<ListenerInfo> stepListenerInfoList = new ArrayList<ListenerInfo>();
            this.stepLevelListenerInfo.put(step.getId(), stepListenerInfoList);
            Listeners stepLevelListeners = step.getListeners();
            if (stepLevelListeners != null) {
                for (Listener listener : stepLevelListeners.getListenerList()) {
                    ListenerInfo info = this.buildListenerInfo(listener, injectionRefs);
                    stepListenerInfoList.add(info);
                }
            }
            return stepListenerInfoList;
        }
        return this.stepLevelListenerInfo.get(step.getId());
    }

    private ListenerInfo buildListenerInfo(Listener listener, InjectionReferences injectionRefs) {
        String id = listener.getRef();
        List propList = listener.getProperties() == null ? null : listener.getProperties().getPropertyList();
        injectionRefs.setProps(propList);
        Object listenerArtifact = ProxyFactory.loadArtifact(id, injectionRefs);
        if (listenerArtifact == null) {
            throw new IllegalArgumentException("Load of artifact id: " + id + " returned <null>.");
        }
        ListenerInfo info = new ListenerInfo(listenerArtifact, propList);
        return info;
    }

    public List<JobListenerProxy> getJobListeners() {
        ArrayList<JobListenerProxy> retVal = new ArrayList<JobListenerProxy>();
        for (ListenerInfo li : this.jobLevelListenerInfo) {
            if (!li.isJobListener()) continue;
            JobListenerProxy proxy = new JobListenerProxy((JobListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ChunkListenerProxy> getChunkListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<ChunkListenerProxy> retVal = new ArrayList<ChunkListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isChunkListener()) continue;
            ChunkListenerProxy proxy = new ChunkListenerProxy((ChunkListener)li.getArtifact());
            proxy.setStepContext(stepContext);
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemProcessListenerProxy> getItemProcessListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<ItemProcessListenerProxy> retVal = new ArrayList<ItemProcessListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemProcessListener()) continue;
            ItemProcessListenerProxy proxy = new ItemProcessListenerProxy((ItemProcessListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemReadListenerProxy> getItemReadListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<ItemReadListenerProxy> retVal = new ArrayList<ItemReadListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemReadListener()) continue;
            ItemReadListenerProxy proxy = new ItemReadListenerProxy((ItemReadListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<ItemWriteListenerProxy> getItemWriteListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<ItemWriteListenerProxy> retVal = new ArrayList<ItemWriteListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isItemWriteListener()) continue;
            ItemWriteListenerProxy proxy = new ItemWriteListenerProxy((ItemWriteListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<RetryProcessListenerProxy> getRetryProcessListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<RetryProcessListenerProxy> retVal = new ArrayList<RetryProcessListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isRetryProcessListener()) continue;
            RetryProcessListenerProxy proxy = new RetryProcessListenerProxy((RetryProcessListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<RetryReadListenerProxy> getRetryReadListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<RetryReadListenerProxy> retVal = new ArrayList<RetryReadListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isRetryReadListener()) continue;
            RetryReadListenerProxy proxy = new RetryReadListenerProxy((RetryReadListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<RetryWriteListenerProxy> getRetryWriteListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<RetryWriteListenerProxy> retVal = new ArrayList<RetryWriteListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isRetryWriteListener()) continue;
            RetryWriteListenerProxy proxy = new RetryWriteListenerProxy((RetryWriteListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<SkipProcessListenerProxy> getSkipProcessListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<SkipProcessListenerProxy> retVal = new ArrayList<SkipProcessListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isSkipProcessListener()) continue;
            SkipProcessListenerProxy proxy = new SkipProcessListenerProxy((SkipProcessListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<SkipReadListenerProxy> getSkipReadListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<SkipReadListenerProxy> retVal = new ArrayList<SkipReadListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isSkipReadListener()) continue;
            SkipReadListenerProxy proxy = new SkipReadListenerProxy((SkipReadListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<SkipWriteListenerProxy> getSkipWriteListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<SkipWriteListenerProxy> retVal = new ArrayList<SkipWriteListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isSkipWriteListener()) continue;
            SkipWriteListenerProxy proxy = new SkipWriteListenerProxy((SkipWriteListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    public List<StepListenerProxy> getStepListeners(Step step, InjectionReferences injectionRefs, StepContextImpl stepContext) {
        List<ListenerInfo> stepListenerInfo = this.getStepListenerInfo(step, injectionRefs);
        ArrayList<StepListenerProxy> retVal = new ArrayList<StepListenerProxy>();
        for (ListenerInfo li : stepListenerInfo) {
            if (!li.isStepListener()) continue;
            StepListenerProxy proxy = new StepListenerProxy((StepListener)li.getArtifact());
            retVal.add(proxy);
        }
        return retVal;
    }

    private class ListenerInfo {
        Object listenerArtifact = null;
        Class listenerArtifactClass = null;
        List<Property> propList = null;

        Object getArtifact() {
            return this.listenerArtifact;
        }

        private ListenerInfo(Object listenerArtifact, List<Property> propList) {
            this.listenerArtifact = listenerArtifact;
            this.listenerArtifactClass = listenerArtifact.getClass();
            this.propList = propList;
        }

        boolean isJobListener() {
            return JobListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isStepListener() {
            return StepListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isChunkListener() {
            return ChunkListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isItemProcessListener() {
            return ItemProcessListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isItemReadListener() {
            return ItemReadListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isItemWriteListener() {
            return ItemWriteListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isRetryReadListener() {
            return RetryReadListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isRetryWriteListener() {
            return RetryWriteListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isRetryProcessListener() {
            return RetryProcessListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isSkipProcessListener() {
            return SkipProcessListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isSkipReadListener() {
            return SkipReadListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        boolean isSkipWriteListener() {
            return SkipWriteListener.class.isAssignableFrom(this.listenerArtifactClass);
        }

        List<Property> getPropList() {
            return this.propList;
        }

        void setPropList(List<Property> propList) {
            this.propList = propList;
        }
    }
}

