/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.artifact.proxy;

import com.ibm.jbatch.container.artifact.proxy.AbstractProxy;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.persistence.ItemCheckpointAlgorithm;
import javax.batch.api.CheckpointAlgorithm;

public class CheckpointAlgorithmProxy
extends AbstractProxy<CheckpointAlgorithm>
implements CheckpointAlgorithm {
    private String checkpointType = null;
    private String checkpointName = null;

    public CheckpointAlgorithmProxy(CheckpointAlgorithm delegate) {
        super(delegate);
        if (delegate instanceof ItemCheckpointAlgorithm) {
            this.checkpointType = "item";
            this.checkpointName = ItemCheckpointAlgorithm.class.getName();
        } else {
            this.checkpointType = "custom";
            this.checkpointName = delegate.getClass().getName();
        }
    }

    public String getCheckpointType() {
        return this.checkpointType;
    }

    public String getCheckpointAlgorithmClassName() {
        return this.checkpointName;
    }

    public void beginCheckpoint() {
        try {
            ((CheckpointAlgorithm)this.delegate).beginCheckpoint();
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            throw new BatchContainerRuntimeException(e);
        }
    }

    public int checkpointTimeout() {
        try {
            return ((CheckpointAlgorithm)this.delegate).checkpointTimeout();
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            throw new BatchContainerRuntimeException(e);
        }
    }

    public void endCheckpoint() {
        try {
            ((CheckpointAlgorithm)this.delegate).endCheckpoint();
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            throw new BatchContainerRuntimeException(e);
        }
    }

    public boolean isReadyToCheckpoint() {
        try {
            return ((CheckpointAlgorithm)this.delegate).isReadyToCheckpoint();
        }
        catch (Exception e) {
            this.stepContext.setException(e);
            throw new BatchContainerRuntimeException(e);
        }
    }
}

