/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.jsl.util;

import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.ModelResolver;
import com.ibm.jbatch.container.jsl.ModelResolverFactory;
import com.ibm.jbatch.container.jsl.ModelSerializer;
import com.ibm.jbatch.container.jsl.ModelSerializerFactory;
import com.ibm.jbatch.jsl.model.Chunk;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Listener;
import com.ibm.jbatch.jsl.model.Listeners;
import com.ibm.jbatch.jsl.model.ObjectFactory;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import java.util.ArrayList;
import java.util.List;

public class JSLMerger {
    public String mergeStep(String childJobXml, String parentStepXml, String childStepID) {
        JSLJob childJob = this.jobResolveHelper(childJobXml);
        Step parentStep = this.stepResolveHelper(parentStepXml);
        for (ExecutionElement elem : childJob.getExecutionElements()) {
            if (!(elem instanceof Step) || !parentStep.getId().equals(((Step)elem).getParent())) continue;
            childJob.getExecutionElements().remove(elem);
            childJob.getExecutionElements().add(this.mergeStep(parentStep, (Step)elem));
        }
        ModelSerializer<JSLJob> serializer = ModelSerializerFactory.createJobModelSerializer();
        return serializer.serializeModel(childJob);
    }

    public String mergeJob(String parentJobXML, String childJobXML) {
        JSLJob parentJob = this.jobResolveHelper(parentJobXML);
        JSLJob childJob = this.jobResolveHelper(childJobXML);
        if (parentJob != null && childJob != null) {
            JSLJob mergedJob = this.mergeJob(parentJob, childJob);
            ModelSerializer<JSLJob> serializer = ModelSerializerFactory.createJobModelSerializer();
            return serializer.serializeModel(mergedJob);
        }
        return childJobXML;
    }

    public JSLJob jobResolveHelper(String jobXML) {
        ModelResolver<JSLJob> jobResolver = ModelResolverFactory.createJobResolver();
        JSLJob job = null;
        try {
            job = jobResolver.resolveModel((JSLJob)((Object)jobXML));
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        return job;
    }

    public Step stepResolveHelper(String stepXML) {
        ModelResolver<Step> stepResolver = ModelResolverFactory.createStepResolver();
        Step step = null;
        try {
            step = stepResolver.resolveModel((Step)((Object)stepXML));
        }
        catch (ClassCastException cce) {
            // empty catch block
        }
        return step;
    }

    public Step mergeStep(Step parent, Step child) {
        if (!parent.getId().equals(child.getParent())) {
            return child;
        }
        ObjectFactory factory = new ObjectFactory();
        Step merge = factory.createStep();
        merge.setId(child.getId());
        merge.setProperties(this.mergeProperties(parent.getProperties(), child.getProperties()));
        merge.setListeners(this.mergeListeners(parent.getListeners(), child.getListeners()));
        merge.getControlElements().addAll(parent.getControlElements());
        merge.setChunk(this.mergeChunk(parent.getChunk(), child.getChunk()));
        if (child.getBatchlet() != null && parent.getBatchlet() != null) {
            if ("true".equals(child.getBatchlet().getProperties().getMerge())) {
                // empty if block
            }
            merge.setBatchlet(parent.getBatchlet());
        }
        return merge;
    }

    public Chunk mergeChunk(Chunk parentChunk, Chunk childChunk) {
        if (parentChunk == null && childChunk != null) {
            return childChunk;
        }
        if (parentChunk != null && childChunk == null) {
            return parentChunk;
        }
        if (parentChunk == null && childChunk == null) {
            return null;
        }
        Chunk merge = new ObjectFactory().createChunk();
        merge.setCheckpointPolicy(childChunk.getCheckpointPolicy() == null ? parentChunk.getCheckpointPolicy() : childChunk.getCheckpointPolicy());
        merge.setItemCount(childChunk.getItemCount() == null ? parentChunk.getItemCount() : childChunk.getItemCount());
        merge.setRetryLimit(childChunk.getRetryLimit() == null ? parentChunk.getRetryLimit() : childChunk.getRetryLimit());
        merge.setSkipLimit(childChunk.getRetryLimit() == null ? parentChunk.getSkipLimit() : childChunk.getSkipLimit());
        merge.setCheckpointAlgorithm(childChunk.getCheckpointAlgorithm() == null ? parentChunk.getCheckpointAlgorithm() : childChunk.getCheckpointAlgorithm());
        merge.setProcessor(childChunk.getProcessor() == null ? parentChunk.getProcessor() : childChunk.getProcessor());
        merge.setReader(childChunk.getReader() == null ? parentChunk.getReader() : childChunk.getReader());
        merge.setWriter(childChunk.getWriter() == null ? parentChunk.getWriter() : childChunk.getWriter());
        merge.setSkippableExceptionClasses(childChunk.getSkippableExceptionClasses() == null ? parentChunk.getSkippableExceptionClasses() : childChunk.getSkippableExceptionClasses());
        merge.setRetryableExceptionClasses(childChunk.getRetryableExceptionClasses() == null ? parentChunk.getRetryableExceptionClasses() : childChunk.getRetryableExceptionClasses());
        merge.setNoRollbackExceptionClasses(childChunk.getNoRollbackExceptionClasses() == null ? parentChunk.getNoRollbackExceptionClasses() : childChunk.getNoRollbackExceptionClasses());
        return merge;
    }

    public JSLJob mergeJob(JSLJob parent, JSLJob child) {
        if (!parent.getId().equals(child.getParent())) {
            return child;
        }
        ObjectFactory factory = new ObjectFactory();
        JSLJob merge = factory.createJSLJob();
        merge.setId(child.getId());
        merge.setProperties(this.mergeProperties(parent.getProperties(), child.getProperties()));
        merge.setListeners(this.mergeListeners(parent.getListeners(), child.getListeners()));
        List<ExecutionElement> mergedExecutionElements = this.mergeExecutionElements(parent.getExecutionElements(), child.getExecutionElements());
        merge.getExecutionElements().addAll(mergedExecutionElements);
        return merge;
    }

    private List<ExecutionElement> mergeExecutionElements(List<ExecutionElement> parent, List<ExecutionElement> child) {
        ArrayList<ExecutionElement> merged = new ArrayList<ExecutionElement>();
        merged.addAll(child);
        block0: for (ExecutionElement parentElement : parent) {
            Object theElement = null;
            for (ExecutionElement cElem : child) {
                if (parentElement.getId().equals(cElem.getId())) continue;
                merged.add(parentElement);
                continue block0;
            }
        }
        return this.resolveSteps(merged);
    }

    private List<ExecutionElement> resolveSteps(List<ExecutionElement> executionElements) {
        ArrayList<ExecutionElement> resolved = new ArrayList<ExecutionElement>();
        for (ExecutionElement executionElement : executionElements) {
            if (executionElement instanceof Step) {
                resolved.add(ModelResolverFactory.createStepResolver().resolveModel((Step)executionElement));
                continue;
            }
            resolved.add(executionElement);
        }
        return resolved;
    }

    public JSLJob mergeJobSteps(JSLJob jslJob) {
        ObjectFactory factory = new ObjectFactory();
        JSLJob merge = factory.createJSLJob();
        merge.setId(jslJob.getId());
        merge.setProperties(jslJob.getProperties());
        merge.setListeners(jslJob.getListeners());
        for (ExecutionElement elem : jslJob.getExecutionElements()) {
            ExecutionElement theElement = null;
            theElement = elem instanceof Step ? (ExecutionElement)ModelResolverFactory.createStepResolver().resolveModel((Step)elem) : elem;
            merge.getExecutionElements().add(theElement);
        }
        return merge;
    }

    private JSLProperties mergeProperties(JSLProperties parentProps, JSLProperties childProps) {
        if (parentProps == null) {
            return childProps;
        }
        if (childProps == null) {
            childProps = new JSLProperties();
        }
        if ("false".equals(childProps.getMerge())) {
            childProps.setMerge(null);
            return childProps;
        }
        JSLProperties mergedProps = new JSLProperties();
        mergedProps.getPropertyList().addAll(childProps.getPropertyList());
        for (Property parentProp : parentProps.getPropertyList()) {
            boolean foundParentProp = false;
            for (Property childProp : childProps.getPropertyList()) {
                if (parentProp.getName() == null || !parentProp.getName().equals(childProp.getName())) continue;
                foundParentProp = true;
            }
            if (foundParentProp) continue;
            mergedProps.getPropertyList().add(parentProp);
        }
        return mergedProps;
    }

    private Listeners mergeListeners(Listeners parentListeners, Listeners childListeners) {
        if (parentListeners == null) {
            return childListeners;
        }
        if (childListeners == null) {
            childListeners = new Listeners();
        }
        if ("false".equals(childListeners.getMerge())) {
            childListeners.setMerge(null);
            return childListeners;
        }
        Listeners mergedListeners = new Listeners();
        mergedListeners.getListenerList().addAll(childListeners.getListenerList());
        for (Listener parentListener : parentListeners.getListenerList()) {
            boolean foundParentListener = false;
            for (Listener childListener : childListeners.getListenerList()) {
                if (parentListener.getRef() == null || !parentListener.getRef().equals(childListener.getRef())) continue;
                foundParentListener = true;
            }
            if (foundParentListener) continue;
            mergedListeners.getListenerList().add(parentListener);
        }
        return mergedListeners;
    }
}

