/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.JobControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionHelper;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;

public class BatchWorkUnit
implements Runnable {
    private String CLASSNAME = BatchWorkUnit.class.getName();
    private Logger logger = Logger.getLogger(BatchWorkUnit.class.getPackage().getName());
    private RuntimeJobExecutionHelper jobExecutionImpl = null;
    private IBatchKernelService batchKernel = null;
    private final JobControllerImpl controller;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue;
    private Stack<String> subJobExitStatusQueue;
    private BlockingQueue<BatchWorkUnit> completedThreadQueue;
    private boolean notifyCallbackWhenDone;
    private List<String> containment = null;
    private RuntimeJobExecutionHelper rootJobExecution = null;

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobExecutionHelper jobExecutionImpl) {
        this(batchKernel, jobExecutionImpl, null, null, null, null, jobExecutionImpl, true);
    }

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobExecutionHelper jobExecutionImpl, BlockingQueue<PartitionDataWrapper> analyzerQueue, Stack<String> subJobExitStatusQueue, BlockingQueue<BatchWorkUnit> completedThreadQueue, List<String> containment, RuntimeJobExecutionHelper rootJobExecution, boolean notifyCallbackWhenDone) {
        this.setBatchKernel(batchKernel);
        this.setJobExecutionImpl(jobExecutionImpl);
        this.setAnalyzerQueue(analyzerQueue);
        this.setSubJobExitStatus(subJobExitStatusQueue);
        this.setCompletedThreadQueue(completedThreadQueue);
        this.setNotifyCallbackWhenDone(notifyCallbackWhenDone);
        this.setContainment(containment);
        if (rootJobExecution == null) {
            this.setRootJobExecution(jobExecutionImpl);
        } else {
            this.setRootJobExecution(rootJobExecution);
        }
        this.controller = new JobControllerImpl(this.getJobExecutionImpl(), this.containment, this.rootJobExecution);
        this.controller.setAnalyzerQueue(this.analyzerQueue);
        this.controller.setSubJobExitStatusQueue(subJobExitStatusQueue);
    }

    public JobControllerImpl getController() {
        return this.controller;
    }

    @Override
    public void run() {
        String method = "run";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.CLASSNAME, method);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("==========================================================");
            this.logger.fine("Invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.fine("==========================================================");
        }
        try {
            this.controller.executeJob();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Exception when invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
                this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            }
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            if (this.completedThreadQueue != null) {
                this.completedThreadQueue.add(this);
            }
            throw new BatchContainerRuntimeException("This job failed unexpectedly.", e);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("==========================================================");
            this.logger.fine("Done invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            this.logger.fine("==========================================================");
        }
        if (this.isNotifyCallbackWhenDone()) {
            this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
        }
        if (this.completedThreadQueue != null) {
            this.completedThreadQueue.add(this);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.CLASSNAME, method);
        }
    }

    private JobOperator.BatchStatus getBatchStatus() {
        return this.jobExecutionImpl.getJobContext().getBatchStatus();
    }

    private String getExitStatus() {
        return this.jobExecutionImpl.getJobContext().getExitStatus();
    }

    public void setBatchKernel(IBatchKernelService batchKernel) {
        this.batchKernel = batchKernel;
    }

    public IBatchKernelService getBatchKernel() {
        return this.batchKernel;
    }

    public void setJobExecutionImpl(RuntimeJobExecutionHelper jobExecutionImpl) {
        this.jobExecutionImpl = jobExecutionImpl;
    }

    public RuntimeJobExecutionHelper getJobExecutionImpl() {
        return this.jobExecutionImpl;
    }

    public void setNotifyCallbackWhenDone(boolean notifyCallbackWhenDone) {
        this.notifyCallbackWhenDone = notifyCallbackWhenDone;
    }

    public boolean isNotifyCallbackWhenDone() {
        return this.notifyCallbackWhenDone;
    }

    public BlockingQueue<PartitionDataWrapper> getAnalyzerQueue() {
        return this.analyzerQueue;
    }

    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerQueue = analyzerQueue;
    }

    public Stack<String> getSubJobExitStatusQueue() {
        return this.subJobExitStatusQueue;
    }

    public void setSubJobExitStatus(Stack<String> subJobExitStatusQueue2) {
        this.subJobExitStatusQueue = subJobExitStatusQueue2;
    }

    public BlockingQueue<BatchWorkUnit> getCompletedThreadQueue() {
        return this.completedThreadQueue;
    }

    public void setCompletedThreadQueue(BlockingQueue<BatchWorkUnit> completedThreadQueue) {
        this.completedThreadQueue = completedThreadQueue;
    }

    public List<String> getContainment() {
        return this.containment;
    }

    public void setContainment(List<String> containment) {
        this.containment = containment;
    }

    public RuntimeJobExecutionHelper getRootJobExecution() {
        return this.rootJobExecution;
    }

    public void setRootJobExecution(RuntimeJobExecutionHelper rootJobExecution) {
        this.rootJobExecution = rootJobExecution;
    }
}

