/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.status;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.persistence.PersistentDataWrapper;
import com.ibm.jbatch.container.util.TCCLObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.Serializable;
import javax.batch.api.partition.PartitionPlan;
import javax.batch.operations.JobOperator;

public class StepStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long stepId;
    private JobOperator.BatchStatus batchStatus;
    private String exitStatus;
    private int startCount = 1;
    private PersistentDataWrapper persistentUserData;
    private PartitionPlan plan;

    public StepStatus(long stepId) {
        this.stepId = stepId;
        this.batchStatus = JobOperator.BatchStatus.STARTING;
    }

    public void setBatchStatus(JobOperator.BatchStatus batchStatus) {
        this.batchStatus = batchStatus;
    }

    public JobOperator.BatchStatus getBatchStatus() {
        return this.batchStatus;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("stepId: " + this.stepId);
        buf.append(",batchStatus: " + this.batchStatus);
        buf.append(",startCount: " + this.startCount);
        return buf.toString();
    }

    public long getStepId() {
        return this.stepId;
    }

    public int getStartCount() {
        return this.startCount;
    }

    public void incrementStartCount() {
        ++this.startCount;
    }

    public void setExitStatus(String exitStatus) {
        this.exitStatus = exitStatus;
    }

    public String getExitStatus() {
        return this.exitStatus;
    }

    public void setPersistentUserData(PersistentDataWrapper persistentUserData) {
        this.persistentUserData = persistentUserData;
    }

    public Externalizable getPersistentUserData() {
        byte[] persistentToken = this.persistentUserData.getPersistentDataBytes();
        ByteArrayInputStream persistentByteArrayInputStream = new ByteArrayInputStream(persistentToken);
        TCCLObjectInputStream persistentOIS = null;
        Externalizable persistentObject = null;
        try {
            persistentOIS = new TCCLObjectInputStream(persistentByteArrayInputStream);
            persistentObject = (Externalizable)persistentOIS.readObject();
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException(e);
        }
        return persistentObject;
    }

    public void setPlan(PartitionPlan plan) {
        this.plan = plan;
    }

    public PartitionPlan getPlan() {
        return this.plan;
    }
}

