/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.spi.services.IBatchConfig;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;

public class JobStatusManagerImpl
implements IJobStatusManagerService {
    private static final String CLASSNAME = JobStatusManagerImpl.class.getName();
    private static Logger logger = Logger.getLogger(JobStatusManagerImpl.class.getPackage().getName());
    private IPersistenceManagerService _persistenceManager;
    private String _jobId;

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public JobStatus createJobStatus(long jobInstanceId) throws BatchContainerServiceException {
        JobStatus jobStatus = null;
        jobStatus = this._persistenceManager.createJobStatus(jobInstanceId);
        return jobStatus;
    }

    @Override
    public JobStatus getJobStatus(long jobInstanceId) throws BatchContainerServiceException {
        JobStatus jobStatus = null;
        jobStatus = this._persistenceManager.getJobStatus(jobInstanceId);
        return jobStatus;
    }

    @Override
    public void updateJobStatus(JobStatus jobStatus) {
        this.persistJobStatus(jobStatus.getJobInstanceId(), jobStatus);
    }

    @Override
    public JobStatus getJobStatusFromExecutionId(long executionId) throws BatchContainerServiceException {
        JobStatus retVal = null;
        List<JobStatus> data = this._persistenceManager.getJobStatusFromExecution(executionId);
        if (data == null) {
            throw new IllegalStateException("Null entry for JobInstance associated with execution id: " + executionId);
        }
        if (data.size() == 0) {
            throw new IllegalStateException("Empty entry for JobInstance associated with execution id: " + executionId);
        }
        if (data.size() != 1) {
            throw new IllegalStateException("Should only be one entry for JobInstance associated with execution id: " + executionId);
        }
        try {
            retVal = data.get(0);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException("Expected JobStatus but found" + data.get(0));
        }
        return retVal;
    }

    @Override
    public void updateJobBatchStatus(long jobInstanceId, JobOperator.BatchStatus batchStatus) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setBatchStatus(batchStatus);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobExecutionStatus(long jobInstanceId, JobOperator.BatchStatus batchStatus, String exitStatus) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setBatchStatus(batchStatus);
        js.setExitStatus(exitStatus);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobCurrentStep(long jobInstanceId, String currentStepName) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setCurrentStepId(currentStepName);
        this.persistJobStatus(jobInstanceId, js);
    }

    @Override
    public void updateJobStatusWithNewExecution(long jobInstanceId, long newExecutionId) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setLatestExecutionId(newExecutionId);
        this.persistJobStatus(jobInstanceId, js);
    }

    private void persistJobStatus(long jobInstanceId, JobStatus newJobStatus) throws BatchContainerServiceException {
        this._persistenceManager.updateJobStatus(jobInstanceId, newJobStatus);
    }

    @Override
    public StepStatus createStepStatus(long stepExecutionId) throws BatchContainerServiceException {
        return this._persistenceManager.createStepStatus(stepExecutionId);
    }

    @Override
    public StepStatus getStepStatus(long jobInstanceId, String stepId) throws BatchContainerServiceException {
        String method = "getStepStatus";
        logger.entering(CLASSNAME, method, new Object[]{jobInstanceId, stepId});
        StepStatus stepStatus = this._persistenceManager.getStepStatus(jobInstanceId, stepId);
        logger.exiting(CLASSNAME, method, stepStatus);
        return stepStatus;
    }

    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus newStepStatus) {
        this._persistenceManager.updateStepStatus(stepExecutionId, newStepStatus);
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        String method = "init";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, method);
        }
        ServicesManager sm = ServicesManagerImpl.getInstance();
        this._persistenceManager = sm.getPersistenceManagerService();
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, method);
        }
    }

    @Override
    public List<JobStatus> getAllJobStatus() throws BatchContainerServiceException {
        return null;
    }

    @Override
    public void updateJobStatusFromJSLStop(long jobInstanceId, String restartOn) throws BatchContainerServiceException {
        JobStatus js = this.getJobStatus(jobInstanceId);
        if (js == null) {
            throw new IllegalStateException("Couldn't find entry to update for id = " + jobInstanceId);
        }
        js.setRestartOn(restartOn);
        this.persistJobStatus(jobInstanceId, js);
    }
}

