/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.exception.PersistenceException;
import com.ibm.jbatch.container.jobinstance.JobInstanceImpl;
import com.ibm.jbatch.container.jobinstance.JobOperatorJobExecutionImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionHelper;
import com.ibm.jbatch.container.jobinstance.StepExecutionImpl;
import com.ibm.jbatch.container.jsl.Navigator;
import com.ibm.jbatch.container.persistence.CheckpointData;
import com.ibm.jbatch.container.persistence.CheckpointDataKey;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.impl.AbstractPersistenceManagerImpl;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.container.status.JobStatusKey;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.container.status.StepStatusKey;
import com.ibm.jbatch.container.util.TCCLObjectInputStream;
import com.ibm.jbatch.spi.services.IBatchConfig;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;
import javax.batch.runtime.StepExecution;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class JDBCPersistenceManagerImpl
extends AbstractPersistenceManagerImpl {
    private static final String CLASSNAME = JDBCPersistenceManagerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private static final String JOBSTATUS_TABLE = "JOBSTATUS";
    private static final String STEPSTATUS_TABLE = "STEPSTATUS";
    private static final String CHECKPOINTDATA_TABLE = "CHECKPOINTDATA";
    private static final String JOBINSTANCEDATA_TABLE = "JOBINSTANCEDATA";
    private static final String EXECUTIONINSTANCEDATA_TABLE = "EXECUTIONINSTANCEDATA";
    private static final String STEPEXECUTIONINSTANCEDATA_TABLE = "STEPEXECUTIONINSTANCEDATA";
    private static final String CREATE_TAB_JOBSTATUS = "CREATE TABLE JOBSTATUS(id BIGINT CONSTRAINT JOBSTATUS_PK PRIMARY KEY,obj BLOB,CONSTRAINT JOBSTATUS_JOBINST_FK FOREIGN KEY (id) REFERENCES JOBINSTANCEDATA (jobinstanceid) ON DELETE CASCADE)";
    private static final String CREATE_TAB_STEPSTATUS = "CREATE TABLE STEPSTATUS(id BIGINT CONSTRAINT STEPSTATUS_PK PRIMARY KEY,obj BLOB,CONSTRAINT STEPSTATUS_STEPEXEC_FK FOREIGN KEY (id) REFERENCES STEPEXECUTIONINSTANCEDATA (stepexecid) ON DELETE CASCADE)";
    private static final String CREATE_TAB_CHECKPOINTDATA = "CREATE TABLE CHECKPOINTDATA(id VARCHAR(512),obj BLOB)";
    private static final String CREATE_TAB_JOBINSTANCEDATA = "CREATE TABLE JOBINSTANCEDATA(jobinstanceid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBINSTANCE_PK PRIMARY KEY,name VARCHAR(512),apptag VARCHAR(512))";
    private static final String CREATE_TAB_EXECUTIONINSTANCEDATA = "CREATE TABLE EXECUTIONINSTANCEDATA(jobexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT JOBEXECUTION_PK PRIMARY KEY,jobinstanceid BIGINT,createtime TIMESTAMP,starttime TIMESTAMP,endtime TIMESTAMP,updatetime TIMESTAMP,parameters BLOB,batchstatus VARCHAR(512),exitstatus VARCHAR(512),CONSTRAINT JOBINST_JOBEXEC_FK FOREIGN KEY (jobinstanceid) REFERENCES JOBINSTANCEDATA (jobinstanceid))";
    private static final String CREATE_TAB_STEPEXECUTIONINSTANCEDATA = "CREATE TABLE STEPEXECUTIONINSTANCEDATA(stepexecid BIGINT NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) CONSTRAINT STEPEXECUTION_PK PRIMARY KEY,jobexecid BIGINT,batchstatus VARCHAR(512),exitstatus VARCHAR(512),stepname VARCHAR(512),stepcontainmentcsv VARCHAR(512),readcount INTEGER,writecount INTEGER,commitcount INTEGER,rollbackcount INTEGER,readskipcount INTEGER,processskipcount INTEGER,filtercount INTEGER,writeskipcount INTEGER,startTime TIMESTAMP,endTime TIMESTAMP,persistentData BLOB,CONSTRAINT JOBEXEC_STEPEXEC_FK FOREIGN KEY (jobexecid) REFERENCES EXECUTIONINSTANCEDATA (jobexecid))";
    private static final String INSERT_JOBSTATUS = "insert into jobstatus values(?, ?)";
    private static final String UPDATE_JOBSTATUS = "update jobstatus set obj = ? where id = ?";
    private static final String SELECT_JOBSTATUS = "select id, obj from jobstatus where id = ?";
    private static final String DELETE_JOBSTATUS = "delete from jobstatus where id = ?";
    private static final String INSERT_STEPSTATUS = "insert into stepstatus values(?, ?)";
    private static final String UPDATE_STEPSTATUS = "update stepstatus set obj = ? where id = ?";
    private static final String SELECT_STEPSTATUS = "select id, obj from stepstatus where id = ?";
    private static final String DELETE_STEPSTATUS = "delete from stepstatus where id = ?";
    private static final String INSERT_CHECKPOINTDATA = "insert into checkpointdata values(?, ?)";
    private static final String UPDATE_CHECKPOINTDATA = "update checkpointdata set obj = ? where id = ?";
    private static final String SELECT_CHECKPOINTDATA = "select id, obj from checkpointdata where id = ?";
    private static final String CREATE_CHECKPOINTDATA_INDEX = "create index chk_index on checkpointdata(id)";
    private static final String DELETE_CHECKPOINTDATA = "delete from checkpointdata where id = ?";
    private static final String INSERT_JOBINSTANCEDATA = "insert into jobinstancedata (name, apptag) values(?, ?)";
    private static final String INSERT_EXECUTIONDATA = "insert into executionInstanceData (jobinstanceid, parameters) values(?, ?)";
    private static final String SELECT_JOBINSTANCEDATA_COUNT = "select count(jobinstanceid) as jobinstancecount from jobinstancedata where name = ?";
    private static final String SELECT_JOBINSTANCEDATA_IDS = "select jobinstanceid from jobinstancedata where name = ?";
    private static final String SELECT_JOBINSTANCEDATA_NAMES = "select name from jobinstancedata where apptag = ?";
    private static final String SELECT_JOBINSTANCEDATA_APPTAG = "select apptag from jobinstancedata where jobinstanceid = ?";
    public static final String START_TIME = "starttime";
    public static final String CREATE_TIME = "createtime";
    public static final String END_TIME = "endtime";
    public static final String UPDATE_TIME = "updatetime";
    public static final String BATCH_STATUS = "batchstatus";
    public static final String EXIT_STATUS = "exitstatus";
    public static final String INSTANCE_ID = "instanceId";
    public static final String JOBEXEC_ID = "jobexecid";
    public static final String STEPEXEC_ID = "stepexecid";
    public static final String STEPCONTEXT = "stepcontext";
    public static final String APPTAG = "apptag";
    protected DataSource dataSource = null;
    protected String jndiName = null;
    protected String driver = "";
    protected String schema = "";
    protected String url = "";
    protected String userId = "";
    protected String pwd = "";

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        super.init(batchConfig);
        logger.entering(CLASSNAME, "init", batchConfig);
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        if (!batchConfig.isJ2seMode()) {
            this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
            logger.log(Level.FINE, "JNDI name is {0}", this.jndiName);
            if (this.jndiName == null || this.jndiName.equals("")) {
                throw new BatchContainerServiceException("JNDI name is not defined.");
            }
            try {
                InitialContext ctx = new InitialContext();
                this.dataSource = (DataSource)ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
                throw new BatchContainerServiceException(e);
            }
        } else {
            this.driver = batchConfig.getDatabaseConfigurationBean().getJdbcDriver();
            this.url = batchConfig.getDatabaseConfigurationBean().getJdbcUrl();
            this.userId = batchConfig.getDatabaseConfigurationBean().getDbUser();
            this.pwd = batchConfig.getDatabaseConfigurationBean().getDbPassword();
            logger.log(Level.FINE, "driver: {0}, url: {1}", new Object[]{this.driver, this.url});
        }
        try {
            if (this.isDerby()) {
                if (!this.isSchemaValid()) {
                    this.createSchema();
                }
                this.checkAllTables();
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException(e);
        }
        logger.exiting(CLASSNAME, "init");
    }

    private boolean isSchemaValid() throws SQLException {
        logger.entering(CLASSNAME, "isSchemaValid");
        Connection conn = this.getConnectionToDefaultSchema();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getSchemas();
        while (rs.next()) {
            if (!this.schema.equalsIgnoreCase(rs.getString("TABLE_SCHEM"))) continue;
            this.cleanupConnection(conn, rs, null);
            logger.exiting(CLASSNAME, "isSchemaValid", true);
            return true;
        }
        this.cleanupConnection(conn, rs, null);
        logger.exiting(CLASSNAME, "isSchemaValid", false);
        return false;
    }

    private boolean isDerby() throws SQLException {
        logger.entering(CLASSNAME, "isDerby");
        Connection conn = this.getConnectionToDefaultSchema();
        DatabaseMetaData dbmd = conn.getMetaData();
        boolean derby = dbmd.getDatabaseProductName().toLowerCase().indexOf("derby") > 0;
        logger.exiting(CLASSNAME, "isDerby", derby);
        return derby;
    }

    private void createSchema() throws SQLException {
        logger.entering(CLASSNAME, "createSchema");
        Connection conn = this.getConnectionToDefaultSchema();
        logger.log(Level.WARNING, this.schema + " schema does not exists. Trying to create it.");
        PreparedStatement ps = null;
        ps = conn.prepareStatement("CREATE SCHEMA " + this.schema);
        ps.execute();
        this.cleanupConnection(conn, null, ps);
        logger.exiting(CLASSNAME, "createSchema");
    }

    private void checkAllTables() throws SQLException {
        logger.entering(CLASSNAME, "checkAllTables");
        this.createIfNotExists(CHECKPOINTDATA_TABLE, CREATE_TAB_CHECKPOINTDATA);
        this.executeStatement(CREATE_CHECKPOINTDATA_INDEX);
        this.createIfNotExists(JOBINSTANCEDATA_TABLE, CREATE_TAB_JOBINSTANCEDATA);
        this.createIfNotExists(EXECUTIONINSTANCEDATA_TABLE, CREATE_TAB_EXECUTIONINSTANCEDATA);
        this.createIfNotExists(STEPEXECUTIONINSTANCEDATA_TABLE, CREATE_TAB_STEPEXECUTIONINSTANCEDATA);
        this.createIfNotExists(JOBSTATUS_TABLE, CREATE_TAB_JOBSTATUS);
        this.createIfNotExists(STEPSTATUS_TABLE, CREATE_TAB_STEPSTATUS);
        logger.exiting(CLASSNAME, "checkAllTables");
    }

    private void createIfNotExists(String tableName, String createTableStatement) throws SQLException {
        logger.entering(CLASSNAME, "createIfNotExists", new Object[]{tableName, createTableStatement});
        Connection conn = this.getConnection();
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getTables(null, this.schema, tableName, null);
        PreparedStatement ps = null;
        if (!rs.next()) {
            logger.log(Level.WARNING, tableName + " table does not exists. Trying to create it.");
            ps = conn.prepareStatement(createTableStatement);
            ps.executeUpdate();
        }
        this.cleanupConnection(conn, rs, ps);
        logger.exiting(CLASSNAME, "createIfNotExists");
    }

    private void executeStatement(String statement) throws SQLException {
        logger.entering(CLASSNAME, "executeStatement", statement);
        Connection conn = this.getConnection();
        PreparedStatement ps = null;
        ps = conn.prepareStatement(statement);
        ps.executeUpdate();
        this.cleanupConnection(conn, ps);
        logger.exiting(CLASSNAME, "executeStatement");
    }

    @Override
    protected void _createJobStatus(JobStatusKey key, JobStatus value) {
        logger.entering(CLASSNAME, "_createJobStatus", new Object[]{key, value});
        this.executeInsert(key.getJobInstanceId(), value, INSERT_JOBSTATUS);
        logger.exiting(CLASSNAME, "_createJobStatus");
    }

    @Override
    protected List<JobStatus> _getJobStatus(JobStatusKey key) {
        logger.entering(CLASSNAME, "_getJobStatus", key);
        List<JobStatus> jobStatuses = this.executeQuery(key.getJobInstanceId(), SELECT_JOBSTATUS);
        logger.exiting(CLASSNAME, "_getJobStatus", jobStatuses);
        return jobStatuses;
    }

    @Override
    protected void _updateJobStatus(JobStatusKey key, JobStatus value) {
        logger.entering(CLASSNAME, "_updateJobStatus", new Object[]{key, value});
        List data = this.executeQuery(key.getJobInstanceId(), SELECT_JOBSTATUS);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getJobInstanceId(), UPDATE_JOBSTATUS);
        }
        logger.exiting(CLASSNAME, "_updateJobStatus");
    }

    @Override
    protected void _deleteJobStatus(JobStatusKey key) {
        logger.entering(CLASSNAME, "_deleteJobStatus", key);
        this.executeDelete(key.getJobInstanceId(), DELETE_JOBSTATUS);
        logger.exiting(CLASSNAME, "_deleteJobStatus");
    }

    @Override
    protected void _createStepStatus(StepStatusKey key, StepStatus value) {
        logger.entering(CLASSNAME, "_createStepStatus", new Object[]{key, value});
        this.executeInsert(key.getKeyPrimitive(), value, INSERT_STEPSTATUS);
        logger.exiting(CLASSNAME, "_createStepStatus");
    }

    @Override
    protected List<StepStatus> _getStepStatus(StepStatusKey key) {
        logger.entering(CLASSNAME, "_getStepStatus", key);
        List<StepStatus> stepStatuses = this.executeQuery(key.getStepId(), SELECT_STEPSTATUS);
        logger.exiting(CLASSNAME, "_getStepStatus", stepStatuses);
        return stepStatuses;
    }

    @Override
    protected void _updateStepStatus(StepStatusKey key, StepStatus value) {
        logger.entering(CLASSNAME, "_updateStepStatus", new Object[]{key, value});
        List data = this.executeQuery(key.getKeyPrimitive(), SELECT_STEPSTATUS);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getKeyPrimitive(), UPDATE_STEPSTATUS);
        }
        logger.exiting(CLASSNAME, "_updateStepStatus");
    }

    @Override
    protected void _deleteStepStatus(StepStatusKey key) {
        logger.entering(CLASSNAME, "_deleteStepStatus", key);
        this.executeDelete(key.getKeyPrimitive(), DELETE_STEPSTATUS);
        logger.exiting(CLASSNAME, "_deleteStepStatus");
    }

    @Override
    protected void _createCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "_createCheckpointData", new Object[]{key, value});
        this.executeInsert(key.getCommaSeparatedKey(), value, INSERT_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_createCheckpointData");
    }

    @Override
    protected List<CheckpointData> _getCheckpointData(CheckpointDataKey key) {
        logger.entering(CLASSNAME, "_getCheckpointData", key);
        List<CheckpointData> checkpointData = this.executeQuery(key.getCommaSeparatedKey(), SELECT_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_getCheckpointData", checkpointData);
        return checkpointData;
    }

    @Override
    protected void _updateCheckpointData(CheckpointDataKey key, CheckpointData value) {
        logger.entering(CLASSNAME, "_updateCheckpointData", new Object[]{key, value});
        List data = this.executeQuery(key.getCommaSeparatedKey(), SELECT_CHECKPOINTDATA);
        if (data != null && !data.isEmpty()) {
            this.executeUpdate(value, key.getCommaSeparatedKey(), UPDATE_CHECKPOINTDATA);
        } else {
            this._createCheckpointData(key, value);
        }
        logger.exiting(CLASSNAME, "_updateCheckpointData");
    }

    @Override
    protected void _deleteCheckpointData(CheckpointDataKey key) {
        this.executeDelete(key.getJobInstanceId(), DELETE_CHECKPOINTDATA);
        logger.entering(CLASSNAME, "_deleteCheckpointData", key);
        this.executeDelete(key.getCommaSeparatedKey(), DELETE_CHECKPOINTDATA);
        logger.exiting(CLASSNAME, "_deleteCheckpointData");
    }

    protected Connection getConnection() throws SQLException {
        logger.entering(CLASSNAME, "getConnection");
        Connection connection = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.finer("J2EE mode, getting connection from data source");
            connection = this.dataSource.getConnection();
            logger.finer("autocommit=" + connection.getAutoCommit());
        } else {
            try {
                Class.forName(this.driver);
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(e);
            }
            logger.log(Level.FINER, "JSE mode, getting connection from {0}", this.url);
            connection = DriverManager.getConnection(this.url, this.userId, this.pwd);
            logger.finer("autocommit=" + connection.getAutoCommit());
        }
        this.setSchemaOnConnection(connection);
        logger.exiting(CLASSNAME, "getConnection", connection);
        return connection;
    }

    protected Connection getConnectionToDefaultSchema() throws SQLException {
        logger.entering(CLASSNAME, "getConnection");
        Connection connection = null;
        if (!this.batchConfig.isJ2seMode()) {
            logger.finer("J2EE mode, getting connection from data source");
            connection = this.dataSource.getConnection();
            logger.finer("autocommit=" + connection.getAutoCommit());
        } else {
            try {
                Class.forName(this.driver);
            }
            catch (ClassNotFoundException e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                logger.log(Level.SEVERE, "ClassNotFoundException: Cannot load driver class: " + this.driver + "; Exception stack trace: " + sw);
                throw new PersistenceException(e);
            }
            logger.log(Level.FINER, "JSE mode, getting connection from {0}", this.url);
            connection = DriverManager.getConnection(this.url, this.userId, this.pwd);
            logger.finer("autocommit=" + connection.getAutoCommit());
        }
        logger.exiting(CLASSNAME, "getConnection", connection);
        return connection;
    }

    private void setSchemaOnConnection(Connection connection) throws SQLException {
        logger.entering(CLASSNAME, "setSchemaOnConnection");
        PreparedStatement ps = null;
        ps = connection.prepareStatement("SET SCHEMA ?");
        ps.setString(1, this.schema);
        ps.executeUpdate();
        ps.close();
        logger.exiting(CLASSNAME, "setSchemaOnConnection");
    }

    private <T> void executeInsert(Object key, T value, String query) {
        logger.entering(CLASSNAME, "executeInsert", new Object[]{key, value, query});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setObject(1, key);
            statement.setBytes(2, b);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeInsert");
    }

    private void executeJobInstanceDataInsert(long key, String jobName, String apptag, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(jobName);
            byte[] b = baos.toByteArray();
            statement.setLong(1, key);
            statement.setString(2, jobName);
            statement.setString(3, apptag);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    private void executeExecutionDataInsert(long key, Timestamp createtime, Timestamp starttime, Timestamp endtime, Timestamp updatetime, Properties parms, long instanceID, String batchstatus, String exitstatus, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(parms);
            byte[] b = baos.toByteArray();
            statement.setLong(1, key);
            statement.setTimestamp(2, createtime);
            statement.setTimestamp(3, starttime);
            statement.setTimestamp(4, endtime);
            statement.setTimestamp(5, updatetime);
            statement.setBytes(6, b);
            statement.setLong(7, instanceID);
            statement.setString(8, batchstatus);
            statement.setString(9, exitstatus);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    private <T> void executeUpdate(T value, Object key, String query) {
        logger.entering(CLASSNAME, "executeUpdate", new Object[]{key, value, query});
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(value);
            byte[] b = baos.toByteArray();
            statement.setBytes(1, b);
            statement.setObject(2, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeUpdate");
    }

    @Override
    public void jobExecutionTimestampUpdate(long key, String timestampToUpdate, Timestamp ts) {
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("update executioninstancedata set " + timestampToUpdate + " = ? where jobexecid = ?");
            statement.setTimestamp(1, ts);
            statement.setObject(2, key);
            statement.executeUpdate();
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void jobExecutionStatusStringUpdate(long key, String statusToUpdate, String statusString, Timestamp updatets) {
        ObjectOutputStream oout;
        PreparedStatement statement;
        Connection conn;
        block15: {
            conn = null;
            statement = null;
            ByteArrayOutputStream baos = null;
            oout = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("update executioninstancedata set " + statusToUpdate + " = ?, updatetime = ? where jobexecid = ?");
                statement.setString(1, statusString);
                statement.setTimestamp(2, updatets);
                statement.setLong(3, key);
                statement.executeUpdate();
                if (baos == null) break block15;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    if (oout != null) {
                        try {
                            oout.close();
                        }
                        catch (IOException e3) {
                            throw new PersistenceException(e3);
                        }
                    }
                    this.cleanupConnection(conn, null, statement);
                    throw throwable;
                }
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, null, statement);
    }

    private void executeExecutionDataUpdate(long key, Timestamp createtime, Timestamp starttime, Timestamp endtime, Timestamp updatetime, Properties parms, long instanceID, String status, String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(parms);
            byte[] b = baos.toByteArray();
            statement.setObject(1, key);
            statement.setTimestamp(2, createtime);
            statement.setTimestamp(3, starttime);
            statement.setTimestamp(4, endtime);
            statement.setTimestamp(5, updatetime);
            statement.setBytes(6, b);
            statement.setString(7, status);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, null, statement);
        }
    }

    private void executeDelete(Object key, String query) {
        logger.entering(CLASSNAME, "executeDelete", new Object[]{key, query});
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setObject(1, key);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "executeDelete");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> List<T> executeQuery(Object key, String query) {
        ArrayList<Object> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            logger.entering(CLASSNAME, "executeQuery", new Object[]{key, query});
            conn = null;
            statement = null;
            rs = null;
            data = new ArrayList<Object>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement(query);
                statement.setObject(1, key);
                rs = statement.executeQuery();
                while (rs.next()) {
                    byte[] buf = rs.getBytes("obj");
                    if (buf == null) continue;
                    objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    Object deSerializedObject = objectIn.readObject();
                    data.add(deSerializedObject);
                }
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        logger.exiting(CLASSNAME, "executeQuery");
        return data;
    }

    private Set<String> executeNameQuery(String query) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashSet<String> data = new HashSet<String>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            while (rs.next()) {
                String name = rs.getString("name");
                data.add(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    private void cleanupConnection(Connection conn, ResultSet rs, PreparedStatement statement) {
        logger.entering(CLASSNAME, "cleanupConnection", new Object[]{conn, rs, statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        logger.exiting(CLASSNAME, "cleanupConnection");
    }

    private void cleanupConnection(Connection conn, PreparedStatement statement) {
        logger.entering(CLASSNAME, "cleanupConnection", new Object[]{conn, statement});
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new PersistenceException(e);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    throw new PersistenceException(e);
                }
            }
        }
        logger.exiting(CLASSNAME, "cleanupConnection");
    }

    @Override
    public void jobOperatorCreateJobInstanceData(long key, String Value, String apptag) {
        this.executeJobInstanceDataInsert(key, Value, apptag, INSERT_JOBINSTANCEDATA);
    }

    @Override
    public int jobOperatorGetJobInstanceCount(String jobName) {
        int count;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object status = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(SELECT_JOBINSTANCEDATA_COUNT);
            statement.setString(1, jobName);
            rs = statement.executeQuery();
            rs.next();
            count = rs.getInt("jobinstancecount");
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return count;
    }

    @Override
    public List<Long> jobOperatorgetJobInstanceIds(String jobName, int start, int count) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        ArrayList<Long> data = new ArrayList<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(SELECT_JOBINSTANCEDATA_IDS);
            statement.setObject(1, jobName);
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                data.add(id);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        if (data.size() > 0) {
            try {
                return data.subList(start, start + count);
            }
            catch (IndexOutOfBoundsException oobEx) {
                return data;
            }
        }
        return data;
    }

    @Override
    public HashMap jobOperatorGetJobInstanceData() {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashMap<Long, String> data = new HashMap<Long, String>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select distinct jobinstanceid, name from jobinstancedata");
            rs = statement.executeQuery();
            while (rs.next()) {
                long id = rs.getLong("jobinstanceid");
                String name = rs.getString("name");
                data.put(id, name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    @Override
    public Set<String> jobOperatorgetJobNames() {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashSet<String> data = new HashSet<String>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(SELECT_JOBINSTANCEDATA_NAMES);
            rs = statement.executeQuery();
            while (rs.next()) {
                String name = rs.getString("name");
                data.add(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return data;
    }

    @Override
    public void jobOperatorCreateExecutionData(long key, Timestamp createTime, Timestamp starttime, Timestamp endtime, Timestamp updateTime, Properties parms, long instanceID, String batchstatus, String exitstatus) {
        this.executeExecutionDataInsert(key, createTime, starttime, endtime, updateTime, parms, instanceID, batchstatus, exitstatus, INSERT_EXECUTIONDATA);
    }

    @Override
    public Timestamp jobOperatorQueryJobExecutionTimestamp(long key, String requestedTimestamp) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Timestamp timestamp = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select " + requestedTimestamp + " from executioninstancedata where jobexecid = ?");
            statement.setObject(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                timestamp = rs.getTimestamp(requestedTimestamp);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return timestamp;
    }

    @Override
    public String jobOperatorQueryJobExecutionStatus(long key, String requestedStatus) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String status = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select " + requestedStatus + " from executioninstancedata where jobexecid = ?");
            statement.setLong(1, key);
            rs = statement.executeQuery();
            while (rs.next()) {
                status = rs.getString(requestedStatus);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return status;
    }

    @Override
    public long jobOperatorQueryJobExecutionJobInstanceId(long executionID) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobinstanceID = 0L;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select jobinstanceid from executioninstancedata where jobexecid = ?");
            statement.setLong(1, executionID);
            rs = statement.executeQuery();
            while (rs.next()) {
                jobinstanceID = rs.getLong("jobinstanceid");
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobinstanceID;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<IJobExecution> jobOperatorGetJobExecutionsByJobInstanceID(long jobInstanceID) {
        ArrayList<IJobExecution> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            data = new ArrayList<IJobExecution>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select * from executioninstancedata where jobinstanceid = ?");
                statement.setLong(1, jobInstanceID);
                rs = statement.executeQuery();
                while (rs.next()) {
                    JobOperatorJobExecutionImpl jobExecutionImpl = new JobOperatorJobExecutionImpl(rs.getLong("id"), rs.getLong("jobinstanceid"), null);
                    jobExecutionImpl.setCreateTime(rs.getTimestamp(CREATE_TIME));
                    jobExecutionImpl.setStartTime(rs.getTimestamp(START_TIME));
                    jobExecutionImpl.setLastUpdateTime(rs.getTimestamp(UPDATE_TIME));
                    jobExecutionImpl.setEndTime(rs.getTimestamp(END_TIME));
                    jobExecutionImpl.setBatchStatus(rs.getString(BATCH_STATUS));
                    jobExecutionImpl.setExitStatus(rs.getString(EXIT_STATUS));
                    Properties props = null;
                    byte[] buf = rs.getBytes("parameters");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                        props = (Properties)objectIn.readObject();
                    }
                    jobExecutionImpl.setJobParameters(props);
                    data.add(jobExecutionImpl);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return data;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getParameters(long instanceId) {
        Properties props;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block12: {
            conn = null;
            statement = null;
            rs = null;
            props = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select parameters from executioninstancedata where jobinstanceid = ?");
                statement.setLong(1, instanceId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    byte[] buf = rs.getBytes("parameters");
                    if (buf == null) continue;
                    objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    props = (Properties)objectIn.readObject();
                }
                if (objectIn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return props;
    }

    @Override
    public void stepExecutionCreateStepExecutionData(String stepExecutionKey, long jobExecutionID, StepContextImpl stepContext, List<String> stepContainment) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long stepExecutionID = stepContext.getStepExecutionId();
        String batchStatus = stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        String stepContainmentCSV = StepExecutionImpl.getStepContainmentCSV(stepContainment);
        Object persistentData = stepContext.getPersistentUserData();
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oout = null;
        long readCnt = 0L;
        long writeCnt = 0L;
        long processSkipCnt = 0L;
        long commitCnt = 0L;
        long rollbackCnt = 0L;
        long readSkipCnt = 0L;
        long filterCnt = 0L;
        long writeSkipCnt = 0L;
        Timestamp startTimeTS = stepContext.getStartTimeTS();
        Timestamp endTimeTS = stepContext.getEndTimeTS();
        Metric[] metrics = stepContext.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCnt = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCnt = metrics[i].getValue();
                continue;
            }
            if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIPCOUNT)) continue;
            writeSkipCnt = metrics[i].getValue();
        }
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("insert into stepexecutionInstanceData values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setString(1, stepExecutionKey);
            statement.setLong(2, jobExecutionID);
            statement.setLong(3, stepExecutionID);
            statement.setString(4, batchStatus);
            statement.setString(5, exitStatus);
            statement.setString(6, stepName);
            statement.setString(7, stepContainmentCSV);
            statement.setLong(8, readCnt);
            statement.setLong(9, writeCnt);
            statement.setLong(10, commitCnt);
            statement.setLong(11, rollbackCnt);
            statement.setLong(12, readSkipCnt);
            statement.setLong(13, processSkipCnt);
            statement.setLong(14, filterCnt);
            statement.setLong(15, writeSkipCnt);
            statement.setTimestamp(16, startTimeTS);
            statement.setTimestamp(17, endTimeTS);
            baos = new ByteArrayOutputStream();
            oout = new ObjectOutputStream(baos);
            oout.writeObject(persistentData);
            byte[] pdataBytes = baos.toByteArray();
            statement.setObject(18, pdataBytes);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            if (oout != null) {
                try {
                    oout.close();
                }
                catch (IOException e) {
                    throw new PersistenceException(e);
                }
            }
            this.cleanupConnection(conn, rs, statement);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<StepExecution<?>> getStepExecutionIDListQueryByJobID(long execid) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        long jobexecid = 0L;
        long stepexecid = 0L;
        String stepname = null;
        String stepContainmentCSV = null;
        String batchstatus = null;
        String exitstatus = null;
        Object ex = null;
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTS = null;
        Timestamp endTS = null;
        StepExecutionImpl stepEx = null;
        TCCLObjectInputStream objectIn = null;
        ArrayList data = new ArrayList();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select * from stepexecutioninstancedata where jobexecid = ?");
            statement.setLong(1, execid);
            rs = statement.executeQuery();
            while (true) {
                if (!rs.next()) {
                    this.cleanupConnection(conn, rs, statement);
                    return data;
                }
                jobexecid = rs.getLong(JOBEXEC_ID);
                stepexecid = rs.getLong(STEPEXEC_ID);
                stepname = rs.getString("stepname");
                stepContainmentCSV = rs.getString("stepcontainmentcsv");
                batchstatus = rs.getString(BATCH_STATUS);
                exitstatus = rs.getString(EXIT_STATUS);
                readCount = rs.getLong("readcount");
                writeCount = rs.getLong("writecount");
                commitCount = rs.getLong("commitcount");
                rollbackCount = rs.getLong("rollbackcount");
                readSkipCount = rs.getLong("readskipcount");
                processSkipCount = rs.getLong("processskipcount");
                filterCount = rs.getLong("filtercount");
                writeSkipCount = rs.getLong("writeSkipCount");
                startTS = rs.getTimestamp("startTime");
                endTS = rs.getTimestamp("endTime");
                Serializable persistentData = null;
                byte[] pDataBytes = rs.getBytes("persistentData");
                if (pDataBytes != null) {
                    objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                    persistentData = (Serializable)objectIn.readObject();
                }
                stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                stepEx.setBatchStatus(JobOperator.BatchStatus.valueOf((String)batchstatus));
                stepEx.setExitStatus(exitstatus);
                stepEx.setStepName(stepname);
                stepEx.setStepContainment(StepExecutionImpl.split(stepContainmentCSV));
                stepEx.setReadCount(readCount);
                stepEx.setWriteCount(writeCount);
                stepEx.setCommitCount(commitCount);
                stepEx.setRollbackCount(rollbackCount);
                stepEx.setReadSkipCount(readSkipCount);
                stepEx.setProcessSkipCount(processSkipCount);
                stepEx.setFilterCount(filterCount);
                stepEx.setWriteSkipCount(writeSkipCount);
                stepEx.setStartTime(startTS);
                stepEx.setEndTime(endTS);
                stepEx.setpersistentUserData(persistentData);
                data.add(stepEx);
            }
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepExecution getStepExecutionObjQueryByStepID(long stepExecutionId) {
        StepExecutionImpl stepEx;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            long jobexecid = 0L;
            long stepexecid = 0L;
            String stepname = null;
            String stepContainmentCSV = null;
            String batchstatus = null;
            String exitstatus = null;
            Object ex = null;
            long readCount = 0L;
            long writeCount = 0L;
            long commitCount = 0L;
            long rollbackCount = 0L;
            long readSkipCount = 0L;
            long processSkipCount = 0L;
            long filterCount = 0L;
            long writeSkipCount = 0L;
            Timestamp startTS = null;
            Timestamp endTS = null;
            stepEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select * from stepexecutioninstancedata where stepexecid = ?");
                statement.setLong(1, stepExecutionId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    jobexecid = rs.getLong(JOBEXEC_ID);
                    stepexecid = rs.getLong(STEPEXEC_ID);
                    stepname = rs.getString("stepname");
                    stepContainmentCSV = rs.getString("stepcontainmentcsv");
                    batchstatus = rs.getString(BATCH_STATUS);
                    exitstatus = rs.getString(EXIT_STATUS);
                    readCount = rs.getLong("readcount");
                    writeCount = rs.getLong("writecount");
                    commitCount = rs.getLong("commitcount");
                    rollbackCount = rs.getLong("rollbackcount");
                    readSkipCount = rs.getLong("readskipcount");
                    processSkipCount = rs.getLong("processskipcount");
                    filterCount = rs.getLong("filtercount");
                    writeSkipCount = rs.getLong("writeSkipCount");
                    startTS = rs.getTimestamp("startTime");
                    endTS = rs.getTimestamp("endTime");
                    byte[] pDataBytes = rs.getBytes("persistentData");
                    Serializable persistentDataObj = null;
                    if (pDataBytes != null) {
                        objectIn = new TCCLObjectInputStream(new ByteArrayInputStream(pDataBytes));
                        persistentDataObj = (Serializable)objectIn.readObject();
                    }
                    stepEx = new StepExecutionImpl(jobexecid, stepexecid);
                    stepEx.setBatchStatus(JobOperator.BatchStatus.valueOf((String)batchstatus));
                    stepEx.setExitStatus(exitstatus);
                    stepEx.setStepName(stepname);
                    stepEx.setStepContainment(StepExecutionImpl.split(stepContainmentCSV));
                    stepEx.setReadCount(readCount);
                    stepEx.setWriteCount(writeCount);
                    stepEx.setCommitCount(commitCount);
                    stepEx.setRollbackCount(rollbackCount);
                    stepEx.setReadSkipCount(readSkipCount);
                    stepEx.setProcessSkipCount(processSkipCount);
                    stepEx.setFilterCount(filterCount);
                    stepEx.setWriteSkipCount(writeSkipCount);
                    stepEx.setStartTime(startTS);
                    stepEx.setEndTime(endTS);
                    stepEx.setpersistentUserData(persistentDataObj);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return stepEx;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void jobOperatorUpdateBatchStatusWithUPDATETSonly(long key, String statusToUpdate, String statusString, Timestamp updatets) {
        ObjectOutputStream oout;
        PreparedStatement statement;
        Connection conn;
        block15: {
            conn = null;
            statement = null;
            ByteArrayOutputStream baos = null;
            oout = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("update executioninstancedata set " + statusToUpdate + " = ?, updatetime = ?, createtime = ? where jobexecid = ?");
                statement.setString(1, statusString);
                statement.setTimestamp(2, updatets);
                statement.setTimestamp(3, updatets);
                statement.setLong(4, key);
                statement.executeUpdate();
                if (baos == null) break block15;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    if (oout != null) {
                        try {
                            oout.close();
                        }
                        catch (IOException e3) {
                            throw new PersistenceException(e3);
                        }
                    }
                    this.cleanupConnection(conn, null, statement);
                    throw throwable;
                }
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, null, statement);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(long key, String statusToUpdate, String statusString, Timestamp updatets) {
        ObjectOutputStream oout;
        PreparedStatement statement;
        Connection conn;
        block15: {
            conn = null;
            statement = null;
            ByteArrayOutputStream baos = null;
            oout = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("update executioninstancedata set " + statusToUpdate + " = ?, starttime = ?, updatetime = ? where jobexecid = ?");
                statement.setString(1, statusString);
                statement.setTimestamp(2, updatets);
                statement.setTimestamp(3, updatets);
                statement.setLong(4, key);
                statement.executeUpdate();
                if (baos == null) break block15;
            }
            catch (SQLException e) {
                try {
                    e.printStackTrace();
                    throw new PersistenceException(e);
                }
                catch (Throwable throwable) {
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException e2) {
                            throw new PersistenceException(e2);
                        }
                    }
                    if (oout != null) {
                        try {
                            oout.close();
                        }
                        catch (IOException e3) {
                            throw new PersistenceException(e3);
                        }
                    }
                    this.cleanupConnection(conn, null, statement);
                    throw throwable;
                }
            }
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        if (oout != null) {
            try {
                oout.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, null, statement);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IJobExecution jobOperatorGetJobExecution(long jobExecutionId) {
        JobOperatorJobExecutionImpl jobEx;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            Timestamp createtime = null;
            Timestamp starttime = null;
            Timestamp endtime = null;
            Timestamp updatetime = null;
            long instanceId = 0L;
            String batchStatus = null;
            String exitStatus = null;
            jobEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select createtime, starttime, endtime, updatetime, parameters, jobinstanceid, batchstatus, exitstatus from executioninstancedata where jobexecid = ?");
                statement.setLong(1, jobExecutionId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    createtime = rs.getTimestamp(CREATE_TIME);
                    starttime = rs.getTimestamp(START_TIME);
                    endtime = rs.getTimestamp(END_TIME);
                    updatetime = rs.getTimestamp(UPDATE_TIME);
                    instanceId = rs.getLong("jobinstanceid");
                    batchStatus = rs.getString(BATCH_STATUS);
                    exitStatus = rs.getString(EXIT_STATUS);
                    Properties params = null;
                    byte[] buf = rs.getBytes("parameters");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                        params = (Properties)objectIn.readObject();
                    }
                    jobEx = new JobOperatorJobExecutionImpl(jobExecutionId, instanceId, null);
                    jobEx.setCreateTime(createtime);
                    jobEx.setStartTime(starttime);
                    jobEx.setEndTime(endtime);
                    jobEx.setJobParameters(params);
                    jobEx.setLastUpdateTime(updatetime);
                    jobEx.setBatchStatus(batchStatus);
                    jobEx.setExitStatus(exitStatus);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return jobEx;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<IJobExecution> jobOperatorGetJobExecutions(long jobInstanceId) {
        ArrayList<IJobExecution> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block13: {
            conn = null;
            statement = null;
            rs = null;
            Timestamp createtime = null;
            Timestamp starttime = null;
            Timestamp endtime = null;
            Timestamp updatetime = null;
            long jobExecutionId = 0L;
            long instanceId = 0L;
            String batchStatus = null;
            String exitStatus = null;
            data = new ArrayList<IJobExecution>();
            JobOperatorJobExecutionImpl jobEx = null;
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select jobexecid, createtime, starttime, endtime, updatetime, parameters, batchstatus, exitstatus  from executioninstancedata where jobinstanceid = ?");
                statement.setLong(1, jobInstanceId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    jobExecutionId = rs.getLong(JOBEXEC_ID);
                    createtime = rs.getTimestamp(CREATE_TIME);
                    starttime = rs.getTimestamp(START_TIME);
                    endtime = rs.getTimestamp(END_TIME);
                    updatetime = rs.getTimestamp(UPDATE_TIME);
                    batchStatus = rs.getString(BATCH_STATUS);
                    exitStatus = rs.getString(EXIT_STATUS);
                    byte[] buf = rs.getBytes("parameters");
                    Properties params = null;
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                        params = (Properties)objectIn.readObject();
                    }
                    jobEx = new JobOperatorJobExecutionImpl(jobExecutionId, instanceId, null);
                    jobEx.setCreateTime(createtime);
                    jobEx.setStartTime(starttime);
                    jobEx.setEndTime(endtime);
                    jobEx.setLastUpdateTime(updatetime);
                    jobEx.setBatchStatus(batchStatus);
                    jobEx.setExitStatus(exitStatus);
                    data.add(jobEx);
                }
                if (objectIn == null) break block13;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        return data;
    }

    @Override
    public Set<Long> jobOperatorGetRunningExecutions(String jobName) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashSet<Long> executionIds = new HashSet<Long>();
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("SELECT A.jobexecid FROM executioninstancedata AS A INNER JOIN jobinstancedata AS B ON A.jobinstanceid = B.jobinstanceid WHERE A.batchstatus IN (?,?) AND B.name = ?");
            statement.setString(1, JobOperator.BatchStatus.STARTED.name());
            statement.setString(2, JobOperator.BatchStatus.STARTING.name());
            statement.setString(3, jobName);
            rs = statement.executeQuery();
            while (rs.next()) {
                executionIds.add(rs.getLong(JOBEXEC_ID));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return executionIds;
    }

    @Override
    public String getJobCurrentTag(long jobInstanceId) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String apptag = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(SELECT_JOBINSTANCEDATA_APPTAG);
            statement.setLong(1, jobInstanceId);
            rs = statement.executeQuery();
            while (rs.next()) {
                apptag = rs.getString(APPTAG);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return apptag;
    }

    @Override
    public void purge(String apptag) {
        logger.entering(CLASSNAME, "purge", apptag);
        String deleteJobs = "DELETE FROM jobinstancedata WHERE apptag = ?";
        String deleteJobExecutions = "DELETE FROM executioninstancedata WHERE jobexecid IN (SELECT B.jobexecid FROM jobinstancedata AS A INNER JOIN executioninstancedata AS B ON A.jobinstanceid = B.jobinstanceid WHERE A.apptag = ?)";
        String deleteStepExecutions = "DELETE FROM stepexecutioninstancedata WHERE stepexecid IN (SELECT C.stepexecid FROM jobinstancedata AS A INNER JOIN executioninstancedata AS B ON A.jobinstanceid = B.jobinstanceid INNER JOIN stepexecutioninstancedata AS C ON B.jobexecid = C.jobexecid WHERE A.apptag = ?)";
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(deleteStepExecutions);
            statement.setString(1, apptag);
            statement.executeUpdate();
            statement = conn.prepareStatement(deleteJobExecutions);
            statement.setString(1, apptag);
            statement.executeUpdate();
            statement = conn.prepareStatement(deleteJobs);
            statement.setString(1, apptag);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "purge");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<JobStatus> getJobStatusFromExecution(long executionId) {
        ArrayList<JobStatus> data;
        ResultSet rs;
        PreparedStatement statement;
        Connection conn;
        block14: {
            long instanceId = 0L;
            conn = null;
            statement = null;
            rs = null;
            data = new ArrayList<JobStatus>();
            ObjectInputStream objectIn = null;
            try {
                conn = this.getConnection();
                statement = conn.prepareStatement("select jobinstanceid from executioninstancedata where jobexecid = ?");
                statement.setLong(1, executionId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    instanceId = rs.getLong("jobinstanceid");
                }
                statement = conn.prepareStatement("select obj from jobstatus where id = ?");
                statement.setLong(1, instanceId);
                rs = statement.executeQuery();
                while (rs.next()) {
                    byte[] buf = rs.getBytes("obj");
                    if (buf != null) {
                        objectIn = new ObjectInputStream(new ByteArrayInputStream(buf));
                    }
                    JobStatus deSerializedObject = (JobStatus)objectIn.readObject();
                    data.add(deSerializedObject);
                }
                if (objectIn == null) break block14;
            }
            catch (SQLException e) {
                try {
                    throw new PersistenceException(e);
                    catch (IOException e2) {
                        throw new PersistenceException(e2);
                    }
                    catch (ClassNotFoundException e3) {
                        throw new PersistenceException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (objectIn != null) {
                        try {
                            objectIn.close();
                        }
                        catch (IOException e4) {
                            throw new PersistenceException(e4);
                        }
                    }
                    this.cleanupConnection(conn, rs, statement);
                    throw throwable;
                }
            }
            try {
                objectIn.close();
            }
            catch (IOException e) {
                throw new PersistenceException(e);
            }
        }
        this.cleanupConnection(conn, rs, statement);
        logger.exiting(CLASSNAME, "executeQuery");
        return data;
    }

    @Override
    public long getJobInstanceIdByExecutionId(long executionId) {
        long instanceId = 0L;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("select jobinstanceid from executioninstancedata where jobexecid = ?");
            statement.setObject(1, executionId);
            rs = statement.executeQuery();
            while (rs.next()) {
                instanceId = rs.getLong("jobinstanceid");
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return instanceId;
    }

    private byte[] serializeObject(Serializable theObject) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(baos);
        oout.writeObject(theObject);
        byte[] data = baos.toByteArray();
        baos.close();
        oout.close();
        return data;
    }

    private Serializable deserializeObject(byte[] buffer) throws IOException, ClassNotFoundException {
        Serializable theObject = null;
        ObjectInputStream objectIn = null;
        if (buffer != null) {
            objectIn = new ObjectInputStream(new ByteArrayInputStream(buffer));
            theObject = (Serializable)objectIn.readObject();
            objectIn.close();
        }
        return theObject;
    }

    @Override
    public JobInstance createJobInstance(String name, String apptag, String jobXml, Properties jobParameters) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        JobInstanceImpl jobInstance = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO jobinstancedata (name, apptag) VALUES(?, ?)", 1);
            statement.setString(1, name);
            statement.setString(2, apptag);
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long jobInstanceID = rs.getLong(1);
                jobInstance = new JobInstanceImpl(jobXml, jobParameters, jobInstanceID);
                jobInstance.setJobName(name);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        return jobInstance;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RuntimeJobExecutionHelper createJobExecution(Navigator jobNavigator, JobInstance jobInstance, Properties jobParameters, JobContextImpl jobContext) {
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        RuntimeJobExecutionHelper jobExecution = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO executioninstancedata (jobinstanceid, createtime, updatetime, batchstatus, parameters) VALUES(?, ?, ?, ?, ?)", 1);
            statement.setLong(1, jobInstance.getInstanceId());
            statement.setTimestamp(2, now);
            statement.setTimestamp(3, now);
            statement.setString(4, jobContext.getBatchStatus().name());
            statement.setObject(5, this.serializeObject(jobParameters));
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long jobExecutionId = rs.getLong(1);
                jobExecution = new RuntimeJobExecutionHelper(jobNavigator, jobInstance, jobExecutionId, jobContext);
                jobExecution.setBatchStatus(jobContext.getBatchStatus().name());
                jobExecution.setCreateTime(now);
                jobExecution.setLastUpdateTime(now);
            }
            this.cleanupConnection(conn, rs, statement);
            return jobExecution;
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
    }

    @Override
    public StepExecutionImpl createStepExecution(long rootJobExecId, StepContextImpl stepContext, List<String> containment) {
        StepExecutionImpl stepExecution = null;
        String batchStatus = stepContext.getBatchStatus() == null ? JobOperator.BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        String stepContainmentCSV = StepExecutionImpl.getStepContainmentCSV(containment);
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        Metric[] metrics = stepContext.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metrics[i].getValue();
                continue;
            }
            if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIPCOUNT)) continue;
            writeSkipCount = metrics[i].getValue();
        }
        Object persistentData = stepContext.getPersistentUserData();
        stepExecution = this.createStepExecution(rootJobExecId, batchStatus, exitStatus, stepName, stepContainmentCSV, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, (Serializable)persistentData);
        return stepExecution;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StepExecutionImpl createStepExecution(long rootJobExecId, String batchStatus, String exitStatus, String stepName, String stepContainmentCSV, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        logger.entering(CLASSNAME, "createStepExecution", new Object[]{rootJobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData});
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        StepExecutionImpl stepExecution = null;
        String query = "INSERT INTO stepexecutioninstancedata (jobexecid, batchstatus, exitstatus, stepname, stepcontainmentcsv, readcount,writecount, commitcount, rollbackcount, readskipcount, processskipcount, filtercount, writeskipcount, starttime,endtime, persistentdata) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query, 1);
            statement.setLong(1, rootJobExecId);
            statement.setString(2, batchStatus);
            statement.setString(3, exitStatus);
            statement.setString(4, stepName);
            statement.setString(5, stepContainmentCSV);
            statement.setLong(6, readCount);
            statement.setLong(7, writeCount);
            statement.setLong(8, commitCount);
            statement.setLong(9, rollbackCount);
            statement.setLong(10, readSkipCount);
            statement.setLong(11, processSkipCount);
            statement.setLong(12, filterCount);
            statement.setLong(13, writeSkipCount);
            statement.setTimestamp(14, startTime);
            statement.setTimestamp(15, endTime);
            statement.setObject(16, this.serializeObject(persistentData));
            statement.executeUpdate();
            rs = statement.getGeneratedKeys();
            if (rs.next()) {
                long stepExecutionId = rs.getLong(1);
                stepExecution = new StepExecutionImpl(rootJobExecId, stepExecutionId);
                stepExecution.setStepName(stepName);
            }
            this.cleanupConnection(conn, null, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, null, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "createStepExecution");
        return stepExecution;
    }

    @Override
    public void updateStepExecution(long rootJobExecId, StepContextImpl stepContext, List<String> containment) {
        long stepExecutionId = stepContext.getStepExecutionId();
        String batchStatus = stepContext.getBatchStatus() == null ? JobOperator.BatchStatus.STARTING.name() : stepContext.getBatchStatus().name();
        String exitStatus = stepContext.getExitStatus();
        String stepName = stepContext.getStepName();
        String stepContainmentCSV = StepExecutionImpl.getStepContainmentCSV(containment);
        long readCount = 0L;
        long writeCount = 0L;
        long commitCount = 0L;
        long rollbackCount = 0L;
        long readSkipCount = 0L;
        long processSkipCount = 0L;
        long filterCount = 0L;
        long writeSkipCount = 0L;
        Timestamp startTime = stepContext.getStartTimeTS();
        Timestamp endTime = stepContext.getEndTimeTS();
        Metric[] metrics = stepContext.getMetrics();
        for (int i = 0; i < metrics.length; ++i) {
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_COUNT)) {
                readCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.WRITE_COUNT)) {
                writeCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.PROCESS_SKIP_COUNT)) {
                processSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.COMMIT_COUNT)) {
                commitCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.ROLLBACK_COUNT)) {
                rollbackCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.READ_SKIP_COUNT)) {
                readSkipCount = metrics[i].getValue();
                continue;
            }
            if (metrics[i].getType().equals((Object)Metric.MetricType.FILTER_COUNT)) {
                filterCount = metrics[i].getValue();
                continue;
            }
            if (!metrics[i].getType().equals((Object)Metric.MetricType.WRITE_SKIPCOUNT)) continue;
            writeSkipCount = metrics[i].getValue();
        }
        Object persistentData = stepContext.getPersistentUserData();
        this.updateStepExecution(stepExecutionId, rootJobExecId, batchStatus, exitStatus, stepName, stepContainmentCSV, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, (Serializable)persistentData);
    }

    private void updateStepExecution(long stepExecutionId, long jobExecId, String batchStatus, String exitStatus, String stepName, String stepContainmentCSV, long readCount, long writeCount, long commitCount, long rollbackCount, long readSkipCount, long processSkipCount, long filterCount, long writeSkipCount, Timestamp startTime, Timestamp endTime, Serializable persistentData) {
        logger.entering(CLASSNAME, "updateStepExecution", new Object[]{stepExecutionId, jobExecId, batchStatus, exitStatus, stepName, readCount, writeCount, commitCount, rollbackCount, readSkipCount, processSkipCount, filterCount, writeSkipCount, startTime, endTime, persistentData});
        Connection conn = null;
        PreparedStatement statement = null;
        Object rs = null;
        Object stepExecution = null;
        String query = "UPDATE stepexecutioninstancedata SET jobexecid = ?, batchstatus = ?, exitstatus = ?, stepname = ?, stepcontainmentcsv = ?, readcount = ?,writecount = ?, commitcount = ?, rollbackcount = ?, readskipcount = ?, processskipcount = ?, filtercount = ?, writeskipcount = ?, starttime = ?, endtime = ?, persistentdata = ? WHERE stepexecid = ?";
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, jobExecId);
            statement.setString(2, batchStatus);
            statement.setString(3, exitStatus);
            statement.setString(4, stepName);
            statement.setString(5, stepContainmentCSV);
            statement.setLong(6, readCount);
            statement.setLong(7, writeCount);
            statement.setLong(8, commitCount);
            statement.setLong(9, rollbackCount);
            statement.setLong(10, readSkipCount);
            statement.setLong(11, processSkipCount);
            statement.setLong(12, filterCount);
            statement.setLong(13, writeSkipCount);
            statement.setTimestamp(14, startTime);
            statement.setTimestamp(15, endTime);
            statement.setObject(16, this.serializeObject(persistentData));
            statement.setLong(17, stepExecutionId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "updateStepExecution");
    }

    @Override
    public JobStatus createJobStatus(long jobInstanceId) {
        logger.entering(CLASSNAME, "createJobStatus", jobInstanceId);
        Connection conn = null;
        PreparedStatement statement = null;
        JobStatus jobStatus = new JobStatus(jobInstanceId);
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO jobstatus (id, obj) VALUES(?, ?)");
            statement.setLong(1, jobInstanceId);
            statement.setBytes(2, this.serializeObject(jobStatus));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "createJobStatus");
        return jobStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JobStatus getJobStatus(long instanceId) {
        logger.entering(CLASSNAME, "getJobStatus", instanceId);
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object jobExecution = null;
        String query = "SELECT obj FROM jobstatus WHERE id = ?";
        JobStatus jobStatus = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, instanceId);
            rs = statement.executeQuery();
            if (rs.next()) {
                jobStatus = (JobStatus)this.deserializeObject(rs.getBytes(1));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getJobStatus", jobStatus);
        return jobStatus;
    }

    @Override
    public void updateJobStatus(long instanceId, JobStatus jobStatus) {
        logger.entering(CLASSNAME, "updateJobStatus", new Object[]{instanceId, jobStatus});
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("UPDATE jobstatus SET obj = ? WHERE id = ?");
            statement.setBytes(1, this.serializeObject(jobStatus));
            statement.setLong(2, instanceId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "updateJobStatus");
    }

    @Override
    public StepStatus createStepStatus(long stepExecId) {
        logger.entering(CLASSNAME, "createStepStatus", stepExecId);
        Connection conn = null;
        PreparedStatement statement = null;
        StepStatus stepStatus = new StepStatus(stepExecId);
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("INSERT INTO stepstatus (id, obj) VALUES(?, ?)");
            statement.setLong(1, stepExecId);
            statement.setBytes(2, this.serializeObject(stepStatus));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "createStepStatus");
        return stepStatus;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StepStatus getStepStatus(long instanceId, String stepName) {
        logger.entering(CLASSNAME, "getStepStatus", new Object[]{instanceId, stepName});
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        Object jobExecution = null;
        String query = "SELECT obj FROM stepstatus WHERE id IN (SELECT B.stepexecid FROM executioninstancedata A INNER JOIN stepexecutioninstancedata B ON A.jobexecid = B.jobexecid WHERE A.jobinstanceid = ? and B.stepname = ?)";
        StepStatus stepStatus = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, instanceId);
            statement.setString(2, stepName);
            rs = statement.executeQuery();
            if (rs.next()) {
                stepStatus = (StepStatus)this.deserializeObject(rs.getBytes(1));
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
                catch (IOException e2) {
                    throw new PersistenceException(e2);
                }
                catch (ClassNotFoundException e3) {
                    throw new PersistenceException(e3);
                }
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getStepStatus", stepStatus);
        return stepStatus;
    }

    @Override
    public void updateStepStatus(long stepExecutionId, StepStatus stepStatus) {
        logger.entering(CLASSNAME, "updateStepStatus", new Object[]{stepExecutionId, stepStatus});
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement("UPDATE stepstatus SET obj = ? WHERE id = ?");
            statement.setBytes(1, this.serializeObject(stepStatus));
            statement.setLong(2, stepExecutionId);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
        finally {
            this.cleanupConnection(conn, null, statement);
        }
        logger.exiting(CLASSNAME, "updateStepStatus");
    }

    @Override
    public String getTagName(long jobExecutionId) {
        logger.entering(CLASSNAME, "getTagName", jobExecutionId);
        String apptag = null;
        Connection conn = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        String query = "SELECT A.apptag FROM jobinstancedata A INNER JOIN executioninstancedata B ON A.jobinstanceid = B.jobinstanceidWHERE B.jobexecid = ?";
        try {
            conn = this.getConnection();
            statement = conn.prepareStatement(query);
            statement.setLong(1, jobExecutionId);
            rs = statement.executeQuery();
            if (rs.next()) {
                apptag = rs.getString(1);
            }
            this.cleanupConnection(conn, rs, statement);
        }
        catch (SQLException e) {
            try {
                throw new PersistenceException(e);
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, rs, statement);
                throw throwable;
            }
        }
        logger.exiting(CLASSNAME, "getTagName");
        return apptag;
    }
}

