/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.services.impl;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchArtifactFactory;
import com.ibm.jbatch.spi.services.IBatchConfig;
import java.lang.reflect.Type;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.InitialContext;

public class CDIBatchArtifactFactoryImpl
implements IBatchArtifactFactory {
    private static final Logger logger = Logger.getLogger(CDIBatchArtifactFactoryImpl.class.getName());
    private static final String CLASSNAME = CDIBatchArtifactFactoryImpl.class.getName();

    @Override
    public Object load(String batchId) {
        Object loadedArtifact;
        String methodName = "load";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(CLASSNAME, methodName, "Loading batch artifact id = " + batchId);
        }
        if ((loadedArtifact = this.getArtifactById(batchId)) == null) {
            throw new IllegalArgumentException("Could not load any artifacts with batch id=" + batchId);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASSNAME, methodName, "For batch artifact id = " + batchId + ", loaded artifact instance: " + loadedArtifact + " of type: " + loadedArtifact.getClass().getCanonicalName());
        }
        return loadedArtifact;
    }

    private Object getArtifactById(String id) {
        Object artifactInstance = null;
        try {
            InitialContext initialContext = new InitialContext();
            BeanManager bm = (BeanManager)initialContext.lookup("java:comp/BeanManager");
            Bean bean = (Bean)bm.getBeans(id).iterator().next();
            Class clazz = bean.getBeanClass();
            artifactInstance = bm.getReference(bean, (Type)clazz, bm.createCreationalContext((Contextual)bean));
        }
        catch (Exception e) {
            throw new BatchContainerRuntimeException("Tried but failed to load artifact with id: " + id, e);
        }
        return artifactInstance;
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }
}

