/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.AbortedBeforeStartException;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.PartitionedStepBuilder;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionHelper;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Split;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;

public class SplitControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SplitControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final RuntimeJobExecutionHelper jobExecutionImpl;
    private volatile List<BatchWorkUnit> parallelBatchWorkUnits;
    private final ServicesManager servicesManager;
    private final IBatchKernelService batchKernel;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();
    protected Split split;

    public SplitControllerImpl(RuntimeJobExecutionHelper jobExecutionImpl, Split split) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.split = split;
        this.servicesManager = ServicesManagerImpl.getInstance();
        this.batchKernel = this.servicesManager.getBatchKernelService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelBatchWorkUnits != null) {
                for (BatchWorkUnit subJob : this.parallelBatchWorkUnits) {
                    try {
                        this.batchKernel.stopJob(subJob.getJobExecutionImpl().getExecutionId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String execute(List<String> containment, RuntimeJobExecutionHelper rootJobExecution) throws AbortedBeforeStartException, JobRestartException, JobStartException {
        String sourceMethod = "execute";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod);
        }
        LinkedBlockingQueue<BatchWorkUnit> completedWorkQueue = new LinkedBlockingQueue<BatchWorkUnit>();
        List<Flow> flows = this.split.getFlow();
        this.parallelBatchWorkUnits = new ArrayList<BatchWorkUnit>();
        ArrayList<String> splitContainment = new ArrayList<String>();
        if (containment != null) {
            splitContainment.addAll(containment);
        }
        splitContainment.add(this.split.getId());
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            for (Flow flow : flows) {
                this.subJobs.add(PartitionedStepBuilder.buildSubJob(this.jobExecutionImpl.getExecutionId(), this.jobExecutionImpl.getJobContext(), this.split, flow, null));
            }
            for (JSLJob job : this.subJobs) {
                int count = this.batchKernel.getJobInstanceCount(job.getId());
                if (count == 0) {
                    this.parallelBatchWorkUnits.add(this.batchKernel.buildNewBatchWorkUnit(job, null, null, null, completedWorkQueue, splitContainment, rootJobExecution));
                    continue;
                }
                if (count == 1) {
                    this.parallelBatchWorkUnits.add(this.batchKernel.buildRestartableBatchWorkUnit(job, null, null, null, completedWorkQueue, splitContainment, rootJobExecution));
                    continue;
                }
                throw new IllegalStateException("There is an inconsistency somewhere in the internal subjob creation");
            }
        }
        for (BatchWorkUnit work : this.parallelBatchWorkUnits) {
            int count = this.batchKernel.getJobInstanceCount(work.getJobExecutionImpl().getJobInstance().getJobName());
            assert (count <= 1);
            if (count == 1) {
                this.batchKernel.startGeneratedJob(work);
                continue;
            }
            if (count > 1) {
                this.batchKernel.restartGeneratedJob(work);
                continue;
            }
            throw new IllegalStateException("There is an inconsistency somewhere in the internal subjob creation");
        }
        boolean flowFailed = false;
        for (int i = 0; i < this.subJobs.size(); ++i) {
            BatchWorkUnit batchWork;
            try {
                batchWork = (BatchWorkUnit)completedWorkQueue.take();
            }
            catch (InterruptedException e) {
                throw new BatchContainerRuntimeException(e);
            }
            JobOperator.BatchStatus batchStatus = batchWork.getJobExecutionImpl().getJobContext().getBatchStatus();
            if (batchStatus.equals((Object)JobOperator.BatchStatus.FAILED)) {
                if (!logger.isLoggable(Level.FINE)) continue;
                logger.fine("Subjob " + batchWork.getJobExecutionImpl().getExecutionId() + "ended with status '" + batchStatus + "'");
                continue;
            }
            if (!batchStatus.equals((Object)JobOperator.BatchStatus.STOPPED) || !logger.isLoggable(Level.FINE)) continue;
            logger.fine("Subjob " + batchWork.getJobExecutionImpl().getExecutionId() + "ended with status '" + batchStatus + "'");
        }
        if (flowFailed) {
            throw new BatchContainerRuntimeException("One or more flows failed");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceMethod, sourceMethod);
        }
        return "SPLIT_CONTROLLER_RETURN_VALUE";
    }

    @Override
    public void setStepContext(StepContextImpl<?, ? extends Serializable> stepContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: step context is not in scope within a flow.");
    }

    @Override
    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
    }

    public List<BatchWorkUnit> getParallelJobExecs() {
        return this.parallelBatchWorkUnits;
    }

    @Override
    public void setSubJobExitStatusQueue(Stack<String> subJobExitStatusQueue) {
    }
}

