/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.artifact.proxy.StepListenerProxy;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.BaseStepControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionHelper;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Collector;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import java.util.List;
import java.util.logging.Logger;

public abstract class SingleThreadedStepControllerImpl
extends BaseStepControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SingleThreadedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    List<StepListenerProxy> stepListeners = null;

    protected SingleThreadedStepControllerImpl(RuntimeJobExecutionHelper jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    @Override
    protected void setupStepArtifacts() {
        Collector collector;
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, null);
        this.stepListeners = this.jobExecutionImpl.getListenerFactory().getStepListeners(this.step, injectionRef, this.stepContext);
        if (this.step.getPartition() != null && (collector = this.step.getPartition().getCollector()) != null) {
            List<Property> propList = collector.getProperties() == null ? null : collector.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            try {
                this.collectorProxy = ProxyFactory.createPartitionCollectorProxy(collector.getRef(), injectionRef, this.stepContext);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the collector [" + collector.getRef() + "]", e);
            }
        }
    }

    @Override
    protected void invokePreStepArtifacts() {
        if (this.stepListeners == null) {
            return;
        }
        for (StepListenerProxy listenerProxy : this.stepListeners) {
            listenerProxy.beforeStep();
        }
    }

    @Override
    protected void invokePostStepArtifacts() {
        if (this.stepListeners != null) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.afterStep();
            }
        }
    }
}

