/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.artifact.proxy.BatchletProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.SingleThreadedStepControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionHelper;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Batchlet;
import com.ibm.jbatch.jsl.model.Partition;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import java.io.Serializable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobOperator;

public class BatchletStepControllerImpl
extends SingleThreadedStepControllerImpl {
    private static final String sourceClass = BatchletStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private BatchletProxy batchletProxy;

    public BatchletStepControllerImpl(RuntimeJobExecutionHelper jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    private void invokeBatchlet(Batchlet batchlet) throws BatchContainerServiceException {
        String batchletId = batchlet.getRef();
        List<Property> propList = batchlet.getProperties() == null ? null : batchlet.getProperties().getPropertyList();
        String sourceMethod = "invokeBatchlet";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod, batchletId);
        }
        String exitStatus = null;
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
        try {
            this.batchletProxy = ProxyFactory.createBatchletProxy(batchletId, injectionRef, this.stepContext);
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the batchlet [" + batchletId + "]", e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Batchlet is loaded and validated: " + this.batchletProxy);
        }
        if (this.jobExecutionImpl.getJobContext().getBatchStatus().equals((Object)JobOperator.BatchStatus.STOPPING)) {
            this.statusStopped();
        } else {
            exitStatus = this.batchletProxy.process();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("StepContext exit status set to process() return value.");
                logger.exiting(sourceClass, sourceMethod, exitStatus);
            }
            this.stepContext.setExitStatus(exitStatus);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void invokeCoreStep() throws BatchContainerServiceException {
        Partition partition = this.step.getPartition();
        if (partition != null) {
            // empty if block
        }
        try {
            this.invokeBatchlet(this.step.getBatchlet());
        }
        finally {
            if (this.collectorProxy != null) {
                Serializable data = this.collectorProxy.collectPartitionData();
                if (this.analyzerStatusQueue != null) {
                    PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
                    dataWrapper.setCollectorData(data);
                    dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_COLLECTOR_DATA);
                    this.analyzerStatusQueue.add(dataWrapper);
                }
            }
            if (this.analyzerStatusQueue != null) {
                PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
                dataWrapper.setBatchStatus(this.stepStatus.getBatchStatus());
                dataWrapper.setExitStatus(this.stepStatus.getExitStatus());
                dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_STATUS);
                this.analyzerStatusQueue.add(dataWrapper);
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (JobOperator.BatchStatus.STARTING.equals((Object)this.stepContext.getBatchStatus()) || JobOperator.BatchStatus.STARTED.equals((Object)this.stepContext.getBatchStatus())) {
            this.stepContext.setBatchStatus(JobOperator.BatchStatus.STOPPING);
            if (this.batchletProxy != null) {
                this.batchletProxy.stop();
            }
        }
    }
}

