/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.JobControllerImpl;
import com.ibm.jbatch.container.jobinstance.JobExecutionHelper;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecutionHelper;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.JSEBatchSecurityHelper;
import com.ibm.jbatch.container.services.impl.RuntimeBatchJobUtil;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.tck.bridge.IJobEndCallbackService;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.spi.BatchJobUtil;
import com.ibm.jbatch.spi.BatchSPIManager;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.jbatch.spi.services.ParallelTaskResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;

public class BatchKernelImpl
implements IBatchKernelService {
    private static final String sourceClass = BatchKernelImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Map<Long, JobControllerImpl> instanceId2jobControllerMap = new ConcurrentHashMap<Long, JobControllerImpl>();
    private Map<Long, RuntimeJobExecutionHelper> jobExecutionInstancesMap = new ConcurrentHashMap<Long, RuntimeJobExecutionHelper>();
    ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private IBatchThreadPoolService executorService = this.servicesManager.getThreadPoolService();
    private IJobEndCallbackService callbackService = this.servicesManager.getJobCallbackService();
    private IPersistenceManagerService persistenceService = this.servicesManager.getPersistenceManagerService();
    private BatchSecurityHelper batchSecurity = null;
    private BatchJobUtil batchJobUtil = new RuntimeBatchJobUtil();
    public static final int THREAD_POOL_SIZE = 5;

    public BatchKernelImpl() {
        BatchSPIManager.getInstance().registerBatchJobUtil(this.batchJobUtil);
    }

    @Override
    public BatchSecurityHelper getBatchSecurityHelper() {
        this.batchSecurity = BatchSPIManager.getInstance().getBatchSecurityHelper();
        if (this.batchSecurity == null) {
            this.batchSecurity = new JSEBatchSecurityHelper();
        }
        return this.batchSecurity;
    }

    @Override
    public void init(IBatchConfig pgcConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public IJobExecution startJob(String jobXML) throws JobStartException {
        return this.startJob(jobXML, null);
    }

    @Override
    public IJobExecution startJob(String jobXML, Properties jobParameters) throws JobStartException {
        String method = "startJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobXML, jobParameters});
        }
        RuntimeJobExecutionHelper jobExecution = JobExecutionHelper.startJob(jobXML, jobParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.executorService.executeTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void stopJob(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        long jobInstanceId = this.persistenceService.jobOperatorQueryJobExecutionJobInstanceId(executionId);
        JobControllerImpl controller = this.instanceId2jobControllerMap.get(jobInstanceId);
        if (controller == null) {
            String msg = "JobExecution with execution id of " + jobInstanceId + "is not running.";
            logger.warning("stopJob(): " + msg);
            throw new JobExecutionNotRunningException(msg);
        }
        controller.stop();
    }

    @Override
    public IJobExecution restartJob(long executionId) throws JobRestartException {
        String method = "restartJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Properties dummyPropObj = new Properties();
        return this.restartJob(executionId, dummyPropObj);
    }

    @Override
    public IJobExecution restartJob(long executionId, Properties jobOverrideProps) throws JobRestartException {
        String method = "restartJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        RuntimeJobExecutionHelper jobExecution = JobExecutionHelper.restartJob(executionId, jobOverrideProps, false);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.executorService.executeTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void jobExecutionDone(RuntimeJobExecutionHelper jobExecution) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution done, getting ready to invoke callbacks for JobExecution: " + jobExecution.getExecutionId());
        }
        this.callbackService.done(jobExecution.getExecutionId());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Done invoking callbacks for JobExecution: " + jobExecution.getExecutionId());
        }
        this.instanceId2jobControllerMap.remove(jobExecution.getInstanceId());
    }

    @Override
    public IJobExecution getJobExecution(long executionId) {
        String method = "getJobExecution";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, executionId);
        }
        IJobExecution retVal = null;
        retVal = JobExecutionHelper.getPersistedJobOperatorJobExecution(executionId);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, retVal);
        }
        return retVal;
    }

    @Override
    public List<StepExecution<?>> getStepExecutions(long executionId) {
        return JobExecutionHelper.getstepExecutionIDInfoList(executionId);
    }

    @Override
    public StepExecution<? extends Serializable> getStepExecution(long stepExecutionId) {
        return JobExecutionHelper.getStepExecutionIDInfo(stepExecutionId);
    }

    @Override
    public void startGeneratedJob(BatchWorkUnit batchWork) {
        String method = "startGeneratedJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{batchWork});
        }
        ParallelTaskResult result = this.executorService.executeParallelTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, new Object[]{batchWork});
        }
    }

    @Override
    public BatchWorkUnit buildNewBatchWorkUnit(JSLJob jobModel, Properties partitionProps, BlockingQueue<PartitionDataWrapper> analyzerQueue, Stack<String> subJobExitStatusQueue, BlockingQueue<BatchWorkUnit> completedQueue, List<String> containment, RuntimeJobExecutionHelper rootJobExecution) throws JobStartException {
        String method = "buildBatchWorkUnit";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobModel, partitionProps});
        }
        RuntimeJobExecutionHelper jobExecution = JobExecutionHelper.startJob(jobModel, partitionProps, true);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution, analyzerQueue, subJobExitStatusQueue, completedQueue, containment, rootJobExecution, false);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.jobExecutionInstancesMap.put(jobExecution.getExecutionId(), jobExecution);
        return batchWork;
    }

    @Override
    public List<BatchWorkUnit> buildNewParallelJobs(List<JSLJob> jobModels, Properties[] partitionProperties, BlockingQueue<PartitionDataWrapper> analyzerQueue, Stack<String> subJobExitStatusQueue, BlockingQueue<BatchWorkUnit> completedQueue, List<String> containment, RuntimeJobExecutionHelper rootJobExecution) throws JobRestartException, JobStartException {
        ArrayList<BatchWorkUnit> batchWorkUnits = new ArrayList<BatchWorkUnit>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties partitionProps = partitionProperties == null ? null : partitionProperties[instance];
            BatchWorkUnit batchWork = this.buildNewBatchWorkUnit(parallelJob, partitionProps, analyzerQueue, subJobExitStatusQueue, completedQueue, containment, rootJobExecution);
            batchWorkUnits.add(batchWork);
            ++instance;
        }
        return batchWorkUnits;
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        int jobInstanceCount = 0;
        jobInstanceCount = this.persistenceService.jobOperatorGetJobInstanceCount(jobName);
        return jobInstanceCount;
    }

    @Override
    public JobInstance getJobInstance(long executionId) {
        return JobExecutionHelper.getJobInstance(executionId);
    }

    @Override
    public List<BatchWorkUnit> buildRestartableParallelJobs(List<JSLJob> jobModels, Properties[] partitionProperties, BlockingQueue<PartitionDataWrapper> analyzerQueue, Stack<String> subJobExitStatusQueue, BlockingQueue<BatchWorkUnit> completedQueue, List<String> containment, RuntimeJobExecutionHelper rootJobExecution) throws JobRestartException {
        ArrayList<BatchWorkUnit> batchWorkUnits = new ArrayList<BatchWorkUnit>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties partitionProps = partitionProperties == null ? null : partitionProperties[instance];
            BatchWorkUnit batchWork = this.buildRestartableBatchWorkUnit(parallelJob, partitionProps, analyzerQueue, subJobExitStatusQueue, completedQueue, containment, rootJobExecution);
            batchWorkUnits.add(batchWork);
            ++instance;
        }
        return batchWorkUnits;
    }

    @Override
    public void restartGeneratedJob(BatchWorkUnit batchWork) throws JobRestartException {
        String method = "restartGeneratedJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{batchWork});
        }
        ParallelTaskResult result = this.executorService.executeParallelTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, batchWork);
        }
    }

    @Override
    public BatchWorkUnit buildRestartableBatchWorkUnit(JSLJob jobModel, Properties partitionProps, BlockingQueue<PartitionDataWrapper> analyzerQueue, Stack<String> subJobExitStatusQueue, BlockingQueue<BatchWorkUnit> completedQueue, List<String> containment, RuntimeJobExecutionHelper rootJobExecution) throws JobRestartException {
        String method = "restartGeneratedJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobModel, partitionProps});
        }
        List<Long> instanceIds = this.persistenceService.jobOperatorgetJobInstanceIds(jobModel.getId(), 0, 2);
        assert (instanceIds.size() == 1);
        List<IJobExecution> partitionExecs = this.persistenceService.jobOperatorGetJobExecutions(instanceIds.get(0));
        Long execId = Long.MIN_VALUE;
        for (IJobExecution partitionExec : partitionExecs) {
            if (partitionExec.getExecutionId() <= execId) continue;
            execId = partitionExec.getExecutionId();
        }
        RuntimeJobExecutionHelper jobExecution = JobExecutionHelper.restartJob(execId, partitionProps, true);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution, analyzerQueue, subJobExitStatusQueue, completedQueue, containment, rootJobExecution, false);
        this.instanceId2jobControllerMap.put(jobExecution.getInstanceId(), batchWork.getController());
        this.jobExecutionInstancesMap.put(jobExecution.getExecutionId(), jobExecution);
        return batchWork;
    }
}

