/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.api.impl;

import com.ibm.jbatch.container.jobinstance.JobInstanceImpl;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.JobStatus;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.services.IJobXMLLoaderService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;

public class JobOperatorImpl
implements JobOperator {
    private static final String sourceClass = JobOperatorImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private IBatchKernelService batchKernel = this.servicesManager.getBatchKernelService();
    private IPersistenceManagerService persistenceService = this.servicesManager.getPersistenceManagerService();
    private IJobXMLLoaderService jobXMLLoaderService = this.servicesManager.getDelegatingJobXMLLoaderService();
    private IJobStatusManagerService _jobStatusManagerService = this.servicesManager.getJobStatusManagerService();

    public long start(String jobXMLName, Properties submittedProps) throws JobStartException {
        String jobXML = this.jobXMLLoaderService.loadJSL(jobXMLName);
        long executionId = 0L;
        if (logger.isLoggable(Level.FINE)) {
            int concatLen = jobXML.length() > 200 ? 200 : jobXML.length();
            logger.fine("Starting job: " + jobXML.substring(0, concatLen) + "... truncated ...");
        }
        IJobExecution execution = this.batchKernel.startJob(jobXML, submittedProps);
        executionId = execution.getExecutionId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobOperator start received executionId: " + executionId);
        }
        return executionId;
    }

    public void abandon(long executionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        IJobExecution jobEx = this.persistenceService.jobOperatorGetJobExecution(executionId);
        if (jobEx == null) {
            logger.fine("Job Execution: " + executionId + " not found");
            throw new NoSuchJobInstanceException("Job Execution: " + executionId + " not found");
        }
        if (jobEx.getBatchStatus().equals((Object)JobOperator.BatchStatus.STARTED) && jobEx.getBatchStatus().equals((Object)JobOperator.BatchStatus.STARTING)) {
            logger.warning("Job Execution: " + executionId + " is still running");
            throw new JobExecutionIsRunningException("Job Execution: " + executionId + " is still running");
        }
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.persistenceService.jobOperatorUpdateBatchStatusWithSTATUSandUPDATETSonly(jobEx.getExecutionId(), "batchstatus", JobOperator.BatchStatus.ABANDONED.name(), timestamp);
        logger.fine("Job Execution: " + executionId + " was abandoned");
    }

    public IJobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        IJobExecution theJobExecution = null;
        IJobExecution execution = this.persistenceService.jobOperatorGetJobExecution(executionId);
        if (execution == null) {
            logger.fine("getJobExecution(): No job execution exists for job execution id: " + executionId);
            throw new NoSuchJobExecutionException("No job execution exists for job execution id: " + executionId);
        }
        theJobExecution = this.batchKernel.getJobExecution(executionId);
        return theJobExecution;
    }

    public List<JobExecution> getJobExecutions(JobInstance instance) throws NoSuchJobInstanceException, JobSecurityException {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        if (this.isAuthorized(instance.getInstanceId())) {
            List<IJobExecution> executionImpls = this.persistenceService.jobOperatorGetJobExecutions(instance.getInstanceId());
            if (executionImpls.size() == 0) {
                logger.warning("The current user is not authorized to perform this operation");
                throw new NoSuchJobInstanceException("Job: " + instance.getJobName() + " does not exist");
            }
            for (IJobExecution e : executionImpls) {
                executions.add(e);
            }
        } else {
            logger.warning("The current user is not authorized to perform this operation");
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        return executions;
    }

    public JobInstance getJobInstance(long executionId) throws NoSuchJobExecutionException {
        JobInstance jobInstance = this.batchKernel.getJobInstance(executionId);
        if (jobInstance == null) {
            throw new NoSuchJobExecutionException("No JobInstance found for job execution id: " + executionId);
        }
        return this.batchKernel.getJobInstance(executionId);
    }

    public int getJobInstanceCount(String jobName) throws NoSuchJobException {
        int jobInstanceCount = 0;
        jobInstanceCount = this.persistenceService.jobOperatorGetJobInstanceCount(jobName);
        if (jobInstanceCount > 0) {
            return jobInstanceCount;
        }
        logger.fine("getJobInstanceCount: Job Name " + jobName + " not found");
        throw new NoSuchJobException("Job " + jobName + " not found");
    }

    public List<JobInstance> getJobInstances(String jobName, int start, int count) throws NoSuchJobException {
        logger.entering(sourceClass, "getJobInstances", new Object[]{jobName, start, count});
        ArrayList<JobInstance> jobInstances = new ArrayList<JobInstance>();
        List<Long> instanceIds = this.persistenceService.jobOperatorgetJobInstanceIds(jobName, start, count);
        if (instanceIds.size() > 0) {
            for (long id : instanceIds) {
                JobStatus jobStatus = this._jobStatusManagerService.getJobStatus(id);
                JobInstanceImpl jobInstance = jobStatus.getJobInstance();
                if (!this.isAuthorized(jobInstance.getInstanceId())) continue;
                jobInstances.add(jobInstance);
            }
            logger.exiting(sourceClass, "getJobInstances", jobInstances);
            return jobInstances;
        }
        logger.fine("getJobInstances: Job Name " + jobName + " not found");
        throw new NoSuchJobException("Job Name " + jobName + " not found");
    }

    public Set<String> getJobNames() {
        HashSet<String> jobNames = new HashSet<String>();
        HashMap data = this.persistenceService.jobOperatorGetJobInstanceData();
        for (Map.Entry entry : data.entrySet()) {
            long instanceId = (Long)entry.getKey();
            if (!this.isAuthorized(instanceId)) continue;
            String name = (String)entry.getValue();
            jobNames.add(name);
        }
        return jobNames;
    }

    public Properties getParameters(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        Properties props = null;
        IJobExecution exec = this.batchKernel.getJobExecution(executionId);
        JobInstance requestedJobInstance = this.batchKernel.getJobInstance(executionId);
        if (this.isAuthorized(requestedJobInstance.getInstanceId())) {
            props = this.persistenceService.getParameters(requestedJobInstance.getInstanceId());
            if (props == null) {
                logger.fine("getParameters: executionId: " + executionId + " was not found");
                throw new NoSuchJobExecutionException("executionId: " + executionId + " was not found");
            }
        } else {
            logger.warning("getParameters: The current user is not authorized to perform this operation");
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        return props;
    }

    public List<Long> getRunningExecutions(String jobName) throws NoSuchJobException {
        logger.entering(sourceClass, "getRunningExecutions", jobName);
        ArrayList<Long> jobExecutions = new ArrayList<Long>();
        Set<Long> executionIds = this.persistenceService.jobOperatorGetRunningExecutions(jobName);
        if (executionIds.size() > 0) {
            for (long id : executionIds) {
                IJobExecution jobEx = this.batchKernel.getJobExecution(id);
                if (!this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(id))) continue;
                jobExecutions.add(jobEx.getExecutionId());
            }
            logger.exiting(sourceClass, "getRunningExecutions", jobExecutions);
            return jobExecutions;
        }
        logger.fine("getRunningExecutions: Job Name " + jobName + " not found");
        throw new NoSuchJobException("Job Name " + jobName + " not found");
    }

    public List<StepExecution<?>> getStepExecutions(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        logger.entering(sourceClass, "getStepExecutions", executionId);
        ArrayList<StepExecution<?>> stepExecutions = new ArrayList();
        IJobExecution jobEx = this.batchKernel.getJobExecution(executionId);
        if (!this.isAuthorized(this.persistenceService.getJobInstanceIdByExecutionId(executionId))) {
            logger.warning("getStepExecutions: The current user is not authorized to perform this operation");
            throw new JobSecurityException("The current user is not authorized to perform this operation");
        }
        stepExecutions = this.persistenceService.getStepExecutionIDListQueryByJobID(executionId);
        logger.exiting(sourceClass, "getStepExecutions", stepExecutions);
        return stepExecutions;
    }

    public long restart(long executionId, Properties restartParameters) throws NoSuchJobExecutionException, NoSuchJobException, JobRestartException, JobSecurityException {
        long newExecutionId = -1L;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarting job with instanceID: " + executionId);
        }
        IJobExecution jobEx = this.batchKernel.getJobExecution(executionId);
        IJobExecution execution = this.batchKernel.restartJob(executionId, restartParameters);
        newExecutionId = execution.getExecutionId();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restarted job with instanceID: " + executionId + ", and new executionID: " + newExecutionId);
        }
        return newExecutionId;
    }

    public void stop(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        logger.entering(sourceClass, "stop", executionId);
        this.batchKernel.stopJob(executionId);
        logger.exiting(sourceClass, "stop");
    }

    public void purge(String apptag) {
        logger.entering(sourceClass, "purge", apptag);
        if (this.batchKernel.getBatchSecurityHelper().isAdmin(apptag)) {
            this.persistenceService.purge(apptag);
        }
        logger.exiting(sourceClass, "purge");
    }

    private boolean isAuthorized(long instanceId) {
        logger.entering(sourceClass, "isAuthorized", instanceId);
        boolean retVal = false;
        String apptag = this.persistenceService.getJobCurrentTag(instanceId);
        BatchSecurityHelper bsh = this.batchKernel.getBatchSecurityHelper();
        if (bsh.isAdmin(apptag) || bsh.getCurrentTag().equals(apptag)) {
            retVal = true;
        }
        logger.exiting(sourceClass, "isAuthorized", retVal);
        return retVal;
    }
}

