/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.task.core;

import com.ibm.fhir.task.api.ITaskCollector;
import com.ibm.fhir.task.api.ITaskGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class Node {
    private final Set<Node> dependencies = new HashSet<Node>();
    private final String name;

    public Node(String name) {
        this.name = name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            throw new IllegalArgumentException("Object other is null");
        }
        if (other instanceof Node) {
            Node that = (Node)other;
            return this.name.equals(that.name);
        }
        throw new IllegalArgumentException("Not a Node: " + other);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String children = this.dependencies.stream().map(n -> n.getName()).collect(Collectors.joining(","));
        return this.name + ": " + children;
    }

    public void addDependency(Node n) {
        this.dependencies.add(n);
    }

    public void addDependencies(Node ... deps) {
        for (Node n : deps) {
            this.addDependency(n);
        }
    }

    public Set<Node> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public ITaskGroup collect(ITaskCollector collector) {
        ArrayList<ITaskGroup> children = null;
        if (this.dependencies.size() > 0) {
            children = new ArrayList<ITaskGroup>(this.dependencies.size());
            for (Node n : this.dependencies) {
                ITaskGroup child = n.collect(collector);
                children.add(child);
            }
        }
        return collector.makeTaskGroup(this.name, () -> this.processNode(), children);
    }

    public void processNode() {
        System.out.println("[" + Thread.currentThread().getId() + "] Processing node: " + this.name);
    }
}

