/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.database.utils.common;

import com.ibm.fhir.database.utils.api.DataAccessException;
import com.ibm.fhir.database.utils.common.DateMath;
import java.util.Date;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DateMathTest {
    @Test(enabled=true)
    public void testDay() {
        String s1 = "2017-01-01";
        Date d1 = DateMath.parse((String)s1);
        Assert.assertEquals((String)s1, (String)DateMath.format((Date)d1));
        String s2 = "2017-01-02";
        Date d2 = DateMath.parse((String)s2);
        Assert.assertEquals((Object)d2, (Object)DateMath.addDays((Date)d1, (int)1));
    }

    @Test(enabled=true)
    public void testMonth() {
        String s1 = "2017-01-01";
        Date d1 = DateMath.parse((String)s1);
        Assert.assertEquals((String)s1, (String)DateMath.format((Date)d1));
        String s2 = "2017-02-01";
        Date d2 = DateMath.parse((String)s2);
        Assert.assertEquals((Object)d2, (Object)DateMath.addMonths((Date)d1, (int)1));
    }

    @Test(enabled=true)
    public void testFormat2() {
        String s1 = "2017-01-01";
        String s2 = "20170101";
        Date d1 = DateMath.parse((String)"2017-01-01");
        Assert.assertEquals((String)"20170101", (String)DateMath.format2((Date)d1));
    }

    @Test(enabled=true, expectedExceptions={DataAccessException.class})
    public void testError() {
        String s1 = "2017/01/01";
        DateMath.parse((String)"2017/01/01");
        Assert.fail((String)"Expected exception for 2017/01/01");
    }

    @Test(enabled=true)
    public void testTrunc() {
        String s01 = "2017-01-01";
        String s14 = "2017-01-14";
        Date d01 = DateMath.parse((String)"2017-01-01");
        Date d14 = DateMath.parse((String)"2017-01-14");
        Assert.assertEquals((Object)DateMath.truncateToMonth((Date)d14), (Object)d01);
    }
}

