/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.binder;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.StaticProfileConstants;
import com.ibm.db2.cmx.runtime.internal.db.StaticProfileCaptureHelper;
import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.parser.EscapeLexer;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.wrappers.ConnectionExecutionHandler;
import com.ibm.db2.cmx.runtime.internal.xml.DOMUtil;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import com.ibm.db2.cmx.tools.Tool;
import com.ibm.db2.cmx.tools.internal.PureQueryUtility;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.binder.MetaDataReplacerImpl;
import com.ibm.db2.cmx.tools.internal.binder.ObservedBindPropsGenerator;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.ArtifactOptionsSet;
import com.ibm.db2.cmx.tools.internal.optionsProcessing.PossibleArgs;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatementBinderHelper {
    private List<Element> posUpdateStmtsInFile_ = new ArrayList<Element>();
    private List<Element> zeroSpecialRegStmtList_ = new ArrayList<Element>();
    private LinkedHashMap<Element, String> oneSpecialRegStmtMap_ = new LinkedHashMap();
    private List<Element> multipleSpecialRegStmtList_ = new ArrayList<Element>();
    private List<String> uniqueSRVal_ = new ArrayList<String>();
    private List<Element> zeroDDLSpecialRegStmtList_ = new ArrayList<Element>();
    private LinkedHashMap<Element, String> oneDDLSpecialRegStmtMap_ = new LinkedHashMap();
    private List<Element> multipleDDLSpecialRegStmtList_ = new ArrayList<Element>();
    private List<String> uniqueDDLSRVal_ = new ArrayList<String>();
    private List<Element> refQueryStmts_ = new ArrayList<Element>();
    private List<Element> newStatementSetList_ = new ArrayList<Element>();
    private ArrayList<String> ddlList_ = new ArrayList();
    private int sqlLimit_ = 0;
    private int currentPkgSqlCount_ = 0;
    private int totalSETStmtCount_ = 0;
    private int totalSETUsedAfterConnectionInitAttributeCount_ = 0;
    private PossibleArgs.PredefinedOptionValues setPostStatusOfAllPkgs_ = null;
    private String setPreStatusOfAllPkgs_ = null;
    private boolean finalUnnamedPkgFound_ = false;
    private String rootPkgName_ = null;
    private String markDDL_ = null;
    private String forceSingleBindIsolation_ = null;
    private String collectionNameGiven_ = null;
    private String collectionName_ = null;
    private String pkgVersion_ = null;
    private String pkgVersionForAllStmtSets_ = null;
    private String removeInactiveSQLBefore_ = null;
    private boolean groupSqlBySpecialRegisters_ = false;
    private boolean havePrintedMessageIndicatingPreviouslySpecifiedGroupSqlBySpecialRegisters_ = false;
    private String currentPkgSuffix_ = "A";
    private int currentPkgSuffixLength_ = 1;
    private boolean cleanConfOption_ = false;
    private boolean markDDLUnspecified_ = false;
    private String markDDLForBind_ = "false";
    private int currentCursorNdx_ = 1;
    private HashMap<String, StmtCursorInfo> stmtCursorToKeyMap_ = new HashMap();
    private HashMap<String, String> stmtKeyToCursorMap_ = new HashMap();
    private List<Element> replaceablePosUpdateStmtList_ = new ArrayList<Element>();
    private boolean isConfigStatusChangeReqd_ = false;
    private String sqlGroupedByString_ = null;
    private String sqlGroupedByJavaPackage_ = null;
    public final String groupSQLByJavaPackagesOption_ = "-groupSQLByJavaPackages";
    private LinkedHashMap<String, Integer> orderedInputOfJavaPackageForSQLMatch_ = null;
    private HashMap<Integer, String> xmlTagsForSqlGroupedByJavaPackage_ = null;
    private boolean showDetails_ = false;
    private static String locationMap_ = null;
    private static String schemaMap_ = null;
    private HashMap<String, String> locationMapPairs_ = new HashMap();
    private HashMap<String, String> schemaMapPairs_ = new HashMap();
    private LinkedHashMap<String, Integer> orderedInputOfStringsForSQLMatch_ = null;
    private HashMap<Integer, String> xmlTagsForSqlGroupedByString_ = null;
    public static DatatypeFactory datatypeFactory_;
    boolean restoreInvalidSqlForce_ = false;
    boolean removeInvalidSql_ = false;
    int maxMissingSections_ = -1;

    private static int getSqlLimit(ArtifactOptionsSet artifactOptionsSet) {
        String string = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.SQL_LIMIT);
        int n2 = 100;
        if (null != string) {
            try {
                n2 = Integer.parseInt(string);
                if (n2 == 0) {
                    n2 = 100;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_PROFILER_SQLLIMIT_INTEGER", "SQLLIMIT", string), numberFormatException, 10519);
            }
        }
        return n2;
    }

    private void checkAndPossiblyFixPackage(Element element, ArtifactOptionsSet artifactOptionsSet, PrintWriter printWriter) {
        ArrayList<String> arrayList;
        ConfigureStatusValues configureStatusValues = ConfigureStatusValues.getValueOf(element.getAttribute("configureStatus"));
        Element element2 = DOMUtil.getFirstChildByName(element, "statements");
        ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element2, "statement");
        Element element3 = DOMUtil.getFirstChildByName(element, "package");
        String string = element3.getAttribute("name");
        ArrayList<String> arrayList3 = arrayList = ConfigureStatusValues.FINAL == configureStatusValues ? new ArrayList<String>() : null;
        if (ConfigureStatusValues.REQUIRED != configureStatusValues && (null == string || string.matches("\\s*") || artifactOptionsSet.getOptionValueBoolean(PossibleArgs.CLEAN_CONFIGURE))) {
            configureStatusValues = ConfigureStatusValues.REQUIRED;
        }
        ConfigureResult configureResult = ConfigureResult.NO_CHANGE_NEEDED;
        int n2 = arrayList2.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            ConfigureResult configureResult2;
            Element element4 = arrayList2.get(i10);
            Element element5 = DOMUtil.getFirstChildByName(element4, "statementDescriptor");
            String string2 = DOMUtil.getFirstValueByName(element5, "statementType");
            Element element6 = DOMUtil.getFirstChildByName(element5, "statementAttributes");
            if (string2.equals("INSERT")) {
                configureResult2 = this.checkAndPossiblyFixInsertForceHoldCursor(configureStatusValues, element4);
                configureResult2.checkConfigureResult(configureStatusValues);
                if (ConfigureResult.NO_CHANGE_NEEDED != configureResult2 && configureResult2 != configureResult) {
                    configureResult = configureResult2;
                }
            }
            if (!string2.equals("QUERY") && !element6.hasAttribute("allowStaticRowsetCursors")) continue;
            configureResult2 = this.checkAndPossiblyFixAllowStaticRowsetCursors(configureStatusValues, string, element4, artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.ALLOW_STATIC_ROWSET_CURSORS), arrayList, printWriter);
            configureResult2.checkConfigureResult(configureStatusValues);
            if (ConfigureResult.NO_CHANGE_NEEDED == configureResult2 || configureResult2 == configureResult) continue;
            configureResult = configureResult2;
        }
        if (ConfigureResult.CHANGE_NEEDED_BUT_FINAL == configureResult) {
            StringBuilder stringBuilder = new StringBuilder();
            if (null != arrayList && 0 < arrayList.size()) {
                stringBuilder.append(XmlTags.CRLF);
                for (int i11 = 0; i11 < arrayList.size(); ++i11) {
                    stringBuilder.append("(" + (i11 + 1) + ") " + (String)arrayList.get(i11) + XmlTags.CRLF);
                }
            }
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_FINAL_STATEMENT_SET_HAS_ERROR", string, "configureStatus", "statementSet", "FINAL", "REQUIRED", stringBuilder.toString()), null, 10693);
        }
        if (ConfigureResult.CHANGED == configureResult) {
            element.setAttribute("configureStatus", "REQUIRED");
        }
    }

    private ConfigureResult checkAndPossiblyFixAllowStaticRowsetCursors(ConfigureStatusValues configureStatusValues, String string, Element element, PossibleArgs.PredefinedOptionValues predefinedOptionValues, List<String> list, PrintWriter printWriter) {
        ConfigureResult configureResult = ConfigureResult.NO_CHANGE_NEEDED;
        Element element2 = DOMUtil.getFirstChildByName(element, "statementDescriptor");
        String string2 = DOMUtil.getFirstValueByName(element2, "prepareSql");
        String string3 = element.getAttribute("id");
        String string4 = DOMUtil.getFirstValueByName(element2, "statementType");
        SqlStatementType sqlStatementType = SqlStatementType.getSqlStatementType(string4);
        Element element3 = DOMUtil.getFirstChildByName(element2, "statementAttributes");
        String string5 = element3.getAttribute("resultSetType");
        int n2 = null == string5 || 0 == string5.trim().length() ? 1003 : XmlTags.getCursorTypeNumber(string5);
        String string6 = element3.getAttribute("resultSetConcurrency");
        int n3 = null == string6 || 0 == string6.trim().length() ? 1007 : XmlTags.getConcurrencyNumber(string6);
        String string7 = element3.hasAttribute("allowStaticRowsetCursors") ? element3.getAttribute("allowStaticRowsetCursors") : null;
        boolean bl2 = XmlTags.getValueOfBoolean(string7, false);
        Element element4 = DOMUtil.getFirstChildByName(element2, "resultSetMetadata");
        ArrayList<Element> arrayList = null != element4 ? DOMUtil.getNodesByName(element4, "column") : null;
        StringBuffer stringBuffer = ConfigureStatusValues.REQUIRED != configureStatusValues && bl2 ? new StringBuffer() : null;
        boolean bl3 = StatementUtilities.doesPureQueryAllowSQLToUseRowsetCursors(string2, sqlStatementType, false, n3, arrayList, null, stringBuffer);
        String string8 = null != stringBuffer ? stringBuffer.toString() : "";
        boolean bl4 = false;
        if (null == predefinedOptionValues) {
            bl4 = bl2;
        } else if (ConfigureStatusValues.REQUIRED == configureStatusValues) {
            switch (predefinedOptionValues) {
                case NEVER: {
                    bl4 = false;
                    break;
                }
                case READ_ONLY_SCROLLABLE: {
                    bl4 = 1005 == n2 || 1004 == n2;
                    break;
                }
                case READ_ONLY_FORWARD_ONLY: {
                    bl4 = 1003 == n2;
                    break;
                }
                case READ_ONLY: {
                    bl4 = true;
                    break;
                }
                default: {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{predefinedOptionValues}), null, 10818);
                }
            }
        }
        bl4 &= bl3;
        switch (configureStatusValues) {
            case FINAL: {
                if (!bl2 || bl3) break;
                configureResult = ConfigureResult.CHANGE_NEEDED_BUT_FINAL;
                if (null == list) break;
                list.add(Messages.getText("ERR_ALLOWSTATICROWSETCURSOR_NOT_ALLOWED_XML2", string, string3, "allowStaticRowsetCursors", "true", string8));
                break;
            }
            case AUTO: {
                if (bl3) break;
                element3.removeAttribute("allowStaticRowsetCursors");
                if (!bl2) break;
                configureResult = ConfigureResult.CHANGED;
                break;
            }
            case REQUIRED: {
                String string9;
                if (!bl3) {
                    element3.removeAttribute("allowStaticRowsetCursors");
                    if (bl2) {
                        configureResult = ConfigureResult.CHANGED;
                    }
                } else if (null != predefinedOptionValues) {
                    string9 = XmlTags.getStringValueOfBoolean(bl4);
                    element3.setAttribute("allowStaticRowsetCursors", string9);
                    if (bl2 != bl4) {
                        configureResult = ConfigureResult.CHANGED;
                    }
                }
                if (bl3 || ConfigureResult.CHANGED != configureResult || null != predefinedOptionValues) break;
                string9 = "";
                string9 = string == null || string.matches("\\s*") ? Messages.getText("ERR_ALLOWSTATICROWSETCURSOR_NOT_ALLOWED_STMT_TEXT", string3, string2, "allowStaticRowsetCursors", "true", "false", string8) : Messages.getText("ERR_ALLOWSTATICROWSETCURSOR_NOT_ALLOWED_XML_AUTO2", string3, string, "allowStaticRowsetCursors", "true", "false", string8);
                printWriter.println(string9);
                WarningFactory.createPureQueryWarningForToolsLogOnly(string9, 10832, this.getClass(), "checkAndPossiblyFixAllowStaticRowsetCursors");
            }
        }
        return configureResult;
    }

    private ConfigureResult checkAndPossiblyFixInsertForceHoldCursor(ConfigureStatusValues configureStatusValues, Element element) {
        ConfigureResult configureResult = ConfigureResult.NO_CHANGE_NEEDED;
        Element element2 = DOMUtil.getFirstChildByName(element, "statementDescriptor");
        Element element3 = DOMUtil.getFirstChildByName(element2, "statementAttributes");
        Boolean bl2 = element3.hasAttribute("forceHoldCursor") && Boolean.valueOf(element3.getAttribute("forceHoldCursor")) != false;
        String string = element3.getAttribute("resultSetHoldability");
        int n2 = XmlTags.getHoldabilityNumber(string, 1);
        if (n2 != 1 && !bl2.booleanValue() && StaticProfileConstants.areAutoGeneratedKeysRequested(element)) {
            switch (configureStatusValues) {
                case FINAL: {
                    configureResult = ConfigureResult.CHANGE_NEEDED_BUT_FINAL;
                    break;
                }
                case AUTO: 
                case REQUIRED: {
                    element3.setAttribute("forceHoldCursor", "true");
                    configureResult = ConfigureResult.CHANGED;
                }
            }
        }
        return configureResult;
    }

    private void setMarkDDLForBind(String string) {
        if (string != null) {
            this.markDDLForBind_ = string;
        } else {
            this.markDDLUnspecified_ = true;
        }
    }

    public static boolean isStmtWithRefQueryAttr(Node node) {
        Node node2 = ((Element)node).getElementsByTagName("statementAttributes").item(0);
        String string = ((Element)node2).getAttribute("referencedQuery");
        return !"".equals(string);
    }

    private void setPackageLevelIsBindable(Element element, String string) {
        Element element2 = DOMUtil.getFirstChildByName(element, "package");
        element2.setAttribute("isBindable", string);
    }

    public static boolean checkForReferencedQueryAttribute(Node node, String string) {
        Element element = (Element)((Element)node).getElementsByTagName("statementAttributes").item(0);
        String string2 = element.getAttribute("referencedQuery");
        return string2.equals(string);
    }

    private void checkAndSetIfNonBindable(Element element) {
        block4: {
            NodeList nodeList;
            NodeList nodeList2;
            String string;
            block3: {
                if (!StatementBinderHelper.isBindableStmt(element)) {
                    return;
                }
                string = element.getElementsByTagName("statementType").item(0).getTextContent();
                if (!string.equals("OTHERSQL") && !string.equals("SET")) break block3;
                String string2 = element.getElementsByTagName("prepareSql").item(0).getTextContent();
                string2 = EscapeLexer.filterComments(string2, true);
                Matcher matcher = StaticProfileConstants.COMMITPat.matcher(string2);
                Matcher matcher2 = StaticProfileConstants.ROLLBACKPat.matcher(string2);
                Matcher matcher3 = StaticProfileConstants.SAVEPOINTPat.matcher(string2);
                Matcher matcher4 = StaticProfileConstants.SetCurrentPackagePat.matcher(string2);
                if (!matcher.find() && !matcher2.find() && !matcher3.find() && !matcher4.find()) break block4;
                Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
                element2.setAttribute("isBindable", "false");
                break block4;
            }
            if (string.equals("CALL") && (nodeList2 = element.getElementsByTagName("parameterMetadata")) != null && nodeList2.getLength() > 0 && (nodeList = ((Element)nodeList2.item(0)).getElementsByTagName("parameter")) != null) {
                int n2 = nodeList.getLength();
                boolean bl2 = false;
                int n3 = 0;
                for (int i10 = 0; i10 < n2; ++i10) {
                    bl2 = Boolean.valueOf(((Element)nodeList.item(i10)).getAttribute("isArray"));
                    n3 = Integer.valueOf(((Element)nodeList.item(i10)).getAttribute("db2type"));
                    if (!bl2 && (n3 &= 0xFFFFFFFE) != 2440) continue;
                    Element element3 = (Element)element.getElementsByTagName("statementAttributes").item(0);
                    element3.setAttribute("isBindable", "false");
                    break;
                }
            }
        }
    }

    private String getNextPkgName() {
        String string = this.rootPkgName_ + this.currentPkgSuffix_;
        String string2 = "";
        char c10 = (char)(this.currentPkgSuffix_.charAt(this.currentPkgSuffix_.length() - 1) + '\u0001');
        this.currentPkgSuffixLength_ = this.currentPkgSuffix_.length();
        if (c10 > 'Z') {
            if (this.currentPkgSuffixLength_ == 1) {
                this.currentPkgSuffix_ = "AA";
                ++this.currentPkgSuffixLength_;
            } else {
                this.currentPkgSuffix_ = this.currentPkgSuffix_.substring(0, this.currentPkgSuffixLength_ - 1).concat("A");
                for (int i10 = this.currentPkgSuffixLength_ - 1; i10 > 0; --i10) {
                    if (this.currentPkgSuffix_.charAt(i10 - 1) == 'Z') {
                        if (i10 == 1) {
                            ++this.currentPkgSuffixLength_;
                            this.currentPkgSuffix_ = "";
                            for (int i11 = this.currentPkgSuffixLength_; i11 > 0; --i11) {
                                this.currentPkgSuffix_ = this.currentPkgSuffix_.concat("A");
                            }
                            break;
                        }
                        this.currentPkgSuffix_ = this.currentPkgSuffix_.substring(0, i10 - 1) + "A" + this.currentPkgSuffix_.substring(i10, this.currentPkgSuffix_.length());
                        continue;
                    }
                    this.currentPkgSuffix_ = this.currentPkgSuffix_.substring(0, i10 - 1) + (char)(this.currentPkgSuffix_.charAt(i10 - 1) + '\u0001') + this.currentPkgSuffix_.substring(i10, this.currentPkgSuffix_.length());
                    break;
                }
            }
            return string;
        }
        if (this.currentPkgSuffixLength_ > 1) {
            string2 = this.currentPkgSuffix_.substring(0, this.currentPkgSuffix_.length() - 1);
        }
        this.currentPkgSuffix_ = string2 + c10;
        return string;
    }

    private String getDDLFileNameFromCaptureFile(CentralStoreKey centralStoreKey) {
        String string;
        String string2 = null;
        String string3 = centralStoreKey.getFileName() + (centralStoreKey.hasExtension() ? "." + centralStoreKey.getKeyExtension() : "");
        int n2 = string3.lastIndexOf(46);
        string2 = n2 == -1 ? string3 + ".ddl" : ((string = string3.substring(n2 + 1)).equals("") || string.equalsIgnoreCase("xml") || string.equalsIgnoreCase("pdqxml") ? string3.substring(0, n2 + 1) + "ddl" : centralStoreKey + ".ddl");
        return string2;
    }

    private void createDLLScriptFile(String string) throws FileNotFoundException, IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        for (int i10 = 0; i10 < this.ddlList_.size(); ++i10) {
            bufferedWriter.write(this.ddlList_.get(i10));
            bufferedWriter.write(";");
            bufferedWriter.write("\r\n");
            bufferedWriter.flush();
        }
        bufferedWriter.close();
    }

    private boolean deleteDDLScriptFile(String string) {
        boolean bl2 = new File(string).delete();
        return bl2;
    }

    private CentralStoreKey renameCaptureFileWithVersionAppended(CentralStoreKey centralStoreKey, String string) throws SQLException {
        String string2 = centralStoreKey.getComposedFileName() + "_";
        if (!string.equals("\"\"")) {
            string2 = string2 + string;
        }
        return new CentralStoreKey(string2, null, false, null);
    }

    private void updateSETStmtCounts(XmlFileHelper xmlFileHelper) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        int n2 = arrayList.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            Element element = arrayList.get(i10);
            Element element2 = DOMUtil.getFirstChildByName(element, "statements");
            ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element2, "statement");
            int n3 = arrayList2.size();
            for (int i11 = 0; i11 < n3; ++i11) {
                Element element3 = arrayList2.get(i11);
                Element element4 = (Element)element3.getElementsByTagName("statementType").item(0);
                if (!element4.getTextContent().equals("SET") && !element4.getTextContent().equals("SET_METHOD")) continue;
                ++this.totalSETStmtCount_;
                if (!element4.hasAttribute("isSETUsedAfterConnectionInit")) continue;
                ++this.totalSETUsedAfterConnectionInitAttributeCount_;
            }
        }
    }

    private boolean checkIfSectionNumbersNotInOrder(XmlFileHelper xmlFileHelper, int n2, Integer[] integerArray) {
        int n3;
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        Node node = arrayList.get(n2);
        Element element = (Element)((Element)node).getElementsByTagName("package").item(0);
        Element element2 = null;
        if (element.getAttribute("isBindable").equalsIgnoreCase("true")) {
            NodeList nodeList = arrayList.get(n2).getElementsByTagName("statement");
            n3 = 0;
            int n4 = 0;
            int n5 = 0;
            Element element3 = null;
            int n6 = nodeList.getLength();
            for (int i10 = 0; i10 < n6; ++i10) {
                n5 = i10;
                Element element4 = (Element)nodeList.item(n5);
                if (element4 != null) {
                    if (!this.isBindableAndIsValid(element4)) continue;
                    n3 = Integer.parseInt(element4.getAttribute("sectionNumber"));
                    element2 = element4;
                }
                if ((element3 = (Element)nodeList.item(++n5)) == null) continue;
                while (element3 != null && !this.isBindableAndIsValid(element3)) {
                    element3 = (Element)nodeList.item(++n5);
                }
                if (element3 == null) continue;
                element3 = (Element)nodeList.item(n5);
                n4 = Integer.parseInt(element3.getAttribute("sectionNumber"));
                element2 = element3;
                int n7 = XmlFileHelper.countReservedSectionsReqd(element4);
                if (n4 >= n3 + n7 + 1) continue;
                return true;
            }
        }
        if (null != integerArray) {
            if (null == element2) {
                integerArray[0] = 0;
            } else {
                int n8 = Integer.parseInt(element2.getAttribute("sectionNumber"));
                if (0 < n8) {
                    n3 = XmlFileHelper.countReservedSectionsReqd(element2);
                    integerArray[0] = n8 + n3;
                } else {
                    integerArray[0] = 0;
                }
            }
        }
        return false;
    }

    private int fixSectionNumberOrdering(XmlFileHelper xmlFileHelper, int n2) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        Element element = arrayList.get(n2);
        Element element2 = (Element)element.getElementsByTagName("package").item(0);
        int n3 = 0;
        if (element2.getAttribute("isBindable").equalsIgnoreCase("true")) {
            int n4 = 1;
            Element element3 = DOMUtil.getFirstChildByName(element, "statements");
            ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element3, "statement");
            int n5 = arrayList2.size();
            for (int i10 = 0; i10 < n5; ++i10) {
                Element element4 = null;
                element4 = arrayList2.get(i10);
                if (element4 == null) continue;
                if (this.isBindableAndIsValid(element4)) {
                    xmlFileHelper.setAttributeValueForNode(element4, "sectionNumber", String.valueOf(n4++));
                    int n6 = XmlFileHelper.countReservedSectionsReqd(element4);
                    if (n6 <= 0) continue;
                    element4.setAttribute("numReservedSections", "" + n6);
                    n4 += n6;
                    continue;
                }
                xmlFileHelper.setAttributeValueForNode(element4, "sectionNumber", String.valueOf(0));
            }
            if (1 < n4) {
                n3 = Math.max(n3, n4 - 1);
            }
        }
        return n3;
    }

    private boolean checkPackageNameDuplication(XmlFileHelper xmlFileHelper, String string, int n2) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        int n3 = arrayList.size();
        for (int i10 = n2 + 1; i10 < n3; ++i10) {
            Element element = arrayList.get(i10);
            Element element2 = DOMUtil.getFirstChildByName(element, "package");
            String string2 = element2.getAttribute("name");
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private void checkForPackageNameDuplicationAndLogMessage(XmlFileHelper xmlFileHelper, String string, int n2, PrintWriter printWriter) {
        boolean bl2 = this.checkPackageNameDuplication(xmlFileHelper, string, n2);
        if (bl2) {
            String string2 = Messages.getText("MSG_DUPLICATE_STATEMENT_SET_NAME", string);
            printWriter.println(string2);
            WarningFactory.createPureQueryWarningForToolsLogOnly(string2, 10694, this.getClass(), "checkForPackageNameDuplicationAndLogMessage");
        }
    }

    private boolean checkForCursorReferences(XmlFileHelper xmlFileHelper, int n2, PrintWriter printWriter) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        String string = null;
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = null;
        Element element = DOMUtil.getFirstChildByName(arrayList.get(n2), "statements");
        ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element, "statement");
        int n3 = arrayList2.size();
        for (int i10 = 0; i10 < n3; ++i10) {
            Node node = arrayList2.get(i10);
            string = XmlFileHelper.getUpdatableCursorName(node);
            if (string == null) continue;
            String string3 = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries((Element)node, null);
            int n4 = arrayList.size();
            for (int i11 = 0; i11 < n4; ++i11) {
                if (i11 == n2) continue;
                Element element2 = DOMUtil.getFirstChildByName(arrayList.get(i11), "statements");
                ArrayList<Element> arrayList3 = DOMUtil.getNodesByName(element2, "statement");
                int n5 = arrayList3.size();
                for (int i12 = 0; i12 < n5; ++i12) {
                    Node node2 = arrayList3.get(i12);
                    Element element3 = (Element)((Element)node2).getElementsByTagName("statementAttributes").item(0);
                    if (element3.hasAttribute("cursorName") && element3.getAttribute("cursorName").equals(string)) {
                        bl2 = true;
                        string2 = string;
                    }
                    if (!StatementBinderHelper.checkForReferencedQueryAttribute(node2, string3)) continue;
                    bl3 = true;
                }
            }
        }
        if (!bl2 && bl3) {
            return true;
        }
        if (bl2) {
            String string4 = Messages.getText("MSG_DUPLICATE_CURSOR_NAME_DEFINED_IN_OTHER_STATEMENT_SET", string2);
            printWriter.println(string4);
            WarningFactory.createPureQueryWarningForToolsLogOnly(string4, 10695, this.getClass(), "checkForCursorReferences");
        }
        return false;
    }

    private void fixCursorReferences(XmlFileHelper xmlFileHelper, int n2, PrintWriter printWriter) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        String string = null;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        Element element = DOMUtil.getFirstChildByName(arrayList.get(n2), "statements");
        ArrayList<Element> arrayList3 = DOMUtil.getNodesByName(element, "statement");
        int n3 = arrayList3.size();
        for (int i10 = 0; i10 < n3; ++i10) {
            Object object;
            Node node;
            int n4;
            NodeList nodeList;
            int n5;
            Node node2 = arrayList3.get(i10);
            string = XmlFileHelper.getUpdatableCursorName(node2);
            if (string == null) continue;
            String string2 = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries((Element)node2, null);
            int n6 = arrayList.size();
            for (n5 = 0; n5 < n6; ++n5) {
                if (n5 == n2) continue;
                nodeList = arrayList.get(n5).getElementsByTagName("statement");
                for (n4 = 0; n4 < nodeList.getLength(); ++n4) {
                    node = nodeList.item(n4);
                    object = (Element)((Element)node).getElementsByTagName("statementAttributes").item(0);
                    if (!object.hasAttribute("cursorName") || !object.getAttribute("cursorName").equals(string)) continue;
                    arrayList2.add(string);
                }
            }
            for (n5 = 0; n5 < n6; ++n5) {
                if (n5 == n2) continue;
                nodeList = arrayList.get(n5).getElementsByTagName("statement");
                for (n4 = 0; n4 < nodeList.getLength(); ++n4) {
                    node = (Element)nodeList.item(n4);
                    if (StatementBinderHelper.checkForReferencedQueryAttribute(node, string2) && !arrayList2.contains(string)) {
                        element.appendChild(node);
                    }
                    if (!arrayList2.contains(string)) continue;
                    object = Messages.getText("MSG_DUPLICATE_CURSOR_NAME_DEFINED_IN_OTHER_STATEMENT_SET", string);
                    printWriter.println((String)object);
                    WarningFactory.createPureQueryWarningForToolsLogOnly((String)object, 10696, this.getClass(), "fixCursorReferences");
                }
            }
        }
    }

    private boolean fixCursorReferencesIfNeeded(XmlFileHelper xmlFileHelper, int n2, PrintWriter printWriter) {
        boolean bl2 = this.checkForCursorReferences(xmlFileHelper, n2, printWriter);
        boolean bl3 = false;
        if (bl2) {
            this.fixCursorReferences(xmlFileHelper, n2, printWriter);
            bl3 = true;
        }
        return bl3;
    }

    private boolean fixSectionNumberOrderingIfNeeded(XmlFileHelper xmlFileHelper, int n2, Integer[] integerArray) {
        boolean bl2 = this.checkIfSectionNumbersNotInOrder(xmlFileHelper, n2, integerArray);
        boolean bl3 = false;
        if (bl2) {
            integerArray[0] = this.fixSectionNumberOrdering(xmlFileHelper, n2);
            bl3 = true;
        }
        return bl3;
    }

    private long assignNewConsistencyTokenAndSetGreatestSectionNumberUsed(XmlFileHelper xmlFileHelper, int n2, Integer n3) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        Element element = arrayList.get(n2);
        return XmlFileHelper.assignNewConsistencyTokenAndSetGreatestSectionNumberUsed(element, n3);
    }

    private void validatePackagesWithConfigureStatusFinal(XmlFileHelper xmlFileHelper, PrintWriter printWriter) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        int n2 = arrayList.size();
        boolean bl2 = false;
        int n3 = 1;
        for (int i10 = 0; i10 < n2; ++i10) {
            Element element = arrayList.get(i10);
            ConfigureStatusValues configureStatusValues = ConfigureStatusValues.getValueOf(element.getAttribute("configureStatus"));
            Element element2 = DOMUtil.getFirstChildByName(element, "package");
            String string = element2.getAttribute("name");
            if (ConfigureStatusValues.FINAL != configureStatusValues || string == null || string.matches("\\s*")) continue;
            if (!bl2) {
                printWriter.println(Messages.getText("MSG_CONFIGURESTATUS_FINAL_STATEMENT_SETS", "configureStatus", "FINAL"));
            }
            bl2 = true;
            printWriter.println("    (" + n3 + ") " + string);
            ++n3;
            this.processStatementsWithSetMaxRowsInformationNeeded(xmlFileHelper, i10, printWriter);
            if (this.checkIfSectionNumbersNotInOrder(xmlFileHelper, i10, null)) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_SECTION_NUMBERS_NOT_IN_ORDER2", string), null, 10697);
            }
            if (this.checkForCursorReferences(xmlFileHelper, i10, printWriter)) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_CURSOR_REFERENCE_IN_OTHER_STATEMENT_SETS", string), null, 10699);
            }
            if (this.removeInactiveSQLBefore_ != null) {
                this.checkIfUnusedSQLPresent(xmlFileHelper, i10, printWriter);
            }
            if (this.groupSqlBySpecialRegisters_) {
                this.checkIfSRValueChangeNeeded(xmlFileHelper, i10, printWriter);
            }
            StatementBinderHelper.checkAndFixSQLGroupedBySpecialRegisters(element);
            this.updateDDLList(element);
        }
    }

    private boolean mergeSRValuesInAllStmts(XmlFileHelper xmlFileHelper, int n2) {
        boolean bl2 = false;
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        Node node = arrayList.get(n2);
        Element element = DOMUtil.getFirstChildByName(node, "statements");
        ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element, "statement");
        int n3 = arrayList2.size();
        for (int i10 = 0; i10 < n3; ++i10) {
            Element element2 = arrayList2.get(i10);
            bl2 |= this.mergeStmtAttr(element2);
        }
        return bl2;
    }

    private boolean moveStmtsIfNeeded(Element element, String string) {
        int n2;
        boolean bl2 = false;
        Element element2 = DOMUtil.getFirstChildByName(element, "statements");
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(element2, "statement");
        int n3 = arrayList.size();
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        ArrayList<Element> arrayList3 = new ArrayList<Element>();
        for (n2 = 0; n2 < n3; ++n2) {
            arrayList3.clear();
            Element element3 = this.getStatementAssociatedPositionedUpdates(arrayList, n2, arrayList3);
            n2 += arrayList3.size();
            if (!this.addStmtToSRList(element3, string, arrayList3)) continue;
            arrayList2.add(element3);
            arrayList2.addAll(arrayList3);
            bl2 = true;
        }
        if (!arrayList2.isEmpty()) {
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                element2.removeChild((Node)arrayList2.get(n2));
            }
        }
        return bl2;
    }

    private Element getStatementAssociatedPositionedUpdates(List<Element> list, int n2, List<Element> list2) {
        Element element = list.get(n2);
        list2.clear();
        String string = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries(element, null);
        if (null != string && null != XmlFileHelper.getUpdatableCursorName(element)) {
            int n3 = list.size();
            boolean bl2 = false;
            for (int i10 = n2 + 1; i10 < n3 && !bl2; ++i10) {
                Element element2 = list.get(i10);
                if (StatementBinderHelper.checkForReferencedQueryAttribute(element2, string)) {
                    list2.add(element2);
                    continue;
                }
                bl2 = true;
            }
        }
        return element;
    }

    private void validatePackagesWithConfigureStatusAuto(XmlFileHelper xmlFileHelper, PrintWriter printWriter) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        int n2 = arrayList.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            Object object;
            boolean bl2 = false;
            Element element = arrayList.get(i10);
            ConfigureStatusValues configureStatusValues = ConfigureStatusValues.getValueOf(element.getAttribute("configureStatus"));
            Element element2 = DOMUtil.getFirstChildByName(element, "package");
            String string = element2.getAttribute("name");
            if (ConfigureStatusValues.AUTO != configureStatusValues || string == null || string.matches("\\s*")) continue;
            if (this.removeInactiveSQLBefore_ != null) {
                this.removeUnusedStmts(element, printWriter);
            }
            bl2 |= this.processStatementSetsWithMaxRowsInformation(xmlFileHelper, i10);
            bl2 |= this.fixCursorReferencesIfNeeded(xmlFileHelper, i10, printWriter);
            String string2 = element2.getAttribute("SQLGroupedBySpecialRegisters");
            boolean bl3 = false;
            bl3 = this.mergeSRValuesInAllStmts(xmlFileHelper, i10);
            if (string2.length() > 0 && !this.groupSqlBySpecialRegisters_) {
                if (!this.havePrintedMessageIndicatingPreviouslySpecifiedGroupSqlBySpecialRegisters_) {
                    object = Messages.getText("MSG_SR_GROUPING_DONE_PREVIOUSLY_CONFIGURE", new Object[]{PossibleArgs.GROUPSQLBYSPECIALREGISTERS, PossibleArgs.PredefinedOptionValues.FALSE, PossibleArgs.PredefinedOptionValues.TRUE});
                    printWriter.println(XmlTags.CRLF + (String)object);
                    WarningFactory.createPureQueryWarningForToolsLogOnly((String)object, 10847, this.getClass(), "validatePackagesWithConfigureStatusAuto");
                    this.havePrintedMessageIndicatingPreviouslySpecifiedGroupSqlBySpecialRegisters_ = true;
                }
            } else if (string2.length() > 0 && this.groupSqlBySpecialRegisters_) {
                if (bl3) {
                    bl2 |= this.moveStmtsIfNeeded(element, string2);
                }
            } else if (string2.length() == 0 && this.groupSqlBySpecialRegisters_) {
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_SR_GROUPING_NOT_DONE", string), 10871, this.getClass(), "validatePackagesWithConfigureStatusAuto");
            }
            object = new Integer[]{null};
            StatementBinderHelper.checkAndFixSQLGroupedBySpecialRegisters(element);
            if (bl2 |= this.fixSectionNumberOrderingIfNeeded(xmlFileHelper, i10, (Integer[])object)) {
                long l2 = this.assignNewConsistencyTokenAndSetGreatestSectionNumberUsed(xmlFileHelper, i10, object[0]);
                boolean bl4 = XmlFileHelper.isBindable(element2);
                if (this.pkgVersion_ != null && bl4) {
                    if (this.pkgVersionForAllStmtSets_ == null) {
                        this.pkgVersionForAllStmtSets_ = StatementUtilities.getPackageVersion(this.pkgVersion_, l2);
                    }
                    if (this.pkgVersionForAllStmtSets_ != null) {
                        xmlFileHelper.setAttributeValueForNode(element2, "version", this.pkgVersionForAllStmtSets_);
                    }
                }
            }
            this.updateDDLList(element);
        }
    }

    private void validatePackagesWithConfigureStatusRequired(XmlFileHelper xmlFileHelper, PrintWriter printWriter) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        int n2 = arrayList.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            Element element = arrayList.get(i10);
            ConfigureStatusValues configureStatusValues = ConfigureStatusValues.getValueOf(element.getAttribute("configureStatus"));
            Element element2 = DOMUtil.getFirstChildByName(element, "package");
            Element element3 = DOMUtil.getFirstChildByName(element, "statements");
            String string = element2.getAttribute("name");
            if (ConfigureStatusValues.REQUIRED != configureStatusValues || string == null || string.matches("\\s*")) continue;
            if (this.removeInactiveSQLBefore_ != null) {
                this.removeUnusedStmts(element, printWriter);
            }
            this.processStatementSetsWithMaxRowsInformation(xmlFileHelper, i10);
            this.fixCursorReferences(xmlFileHelper, i10, printWriter);
            int n3 = this.fixSectionNumberOrdering(xmlFileHelper, i10);
            String string2 = element2.getAttribute("SQLGroupedBySpecialRegisters");
            this.mergeSRValuesInAllStmts(xmlFileHelper, i10);
            if (string2.length() > 0 && !this.groupSqlBySpecialRegisters_) {
                if (!this.havePrintedMessageIndicatingPreviouslySpecifiedGroupSqlBySpecialRegisters_) {
                    String string3 = Messages.getText("MSG_SR_GROUPING_DONE_PREVIOUSLY_CONFIGURE", new Object[]{PossibleArgs.GROUPSQLBYSPECIALREGISTERS, PossibleArgs.PredefinedOptionValues.FALSE, PossibleArgs.PredefinedOptionValues.TRUE});
                    printWriter.println(XmlTags.CRLF + string3);
                    WarningFactory.createPureQueryWarningForToolsLogOnly(string3, 10848, this.getClass(), "validatePackagesWithConfigureStatusRequired");
                    this.havePrintedMessageIndicatingPreviouslySpecifiedGroupSqlBySpecialRegisters_ = true;
                }
            } else if (string2.length() > 0 && this.groupSqlBySpecialRegisters_) {
                this.moveStmtsIfNeeded(element, string2);
            } else if (string2.length() == 0 && this.groupSqlBySpecialRegisters_) {
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_SR_GROUPING_NOT_DONE", string), 10872, this.getClass(), "validatePackagesWithConfigureStatusRequired");
            }
            long l2 = this.assignNewConsistencyTokenAndSetGreatestSectionNumberUsed(xmlFileHelper, i10, n3);
            String string4 = element2.getAttribute("isDDLPackage");
            if (string4.equalsIgnoreCase("true") && this.markDDL_ != null) {
                element2.setAttribute("isBindable", this.markDDL_);
                ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element3, "statement");
                int n4 = arrayList2.size();
                Element element4 = null;
                for (int i11 = 0; i11 < n4; ++i11) {
                    element4 = arrayList2.get(i11);
                    Element element5 = (Element)element4.getElementsByTagName("statementAttributes").item(0);
                    element5.setAttribute("isBindable", this.markDDL_);
                }
            }
            boolean bl2 = XmlFileHelper.isBindable(element2);
            if (this.collectionNameGiven_ != null && bl2) {
                xmlFileHelper.setAttributeValueForNode(element2, "collection", this.collectionName_);
            }
            if (this.forceSingleBindIsolation_ != null && this.forceSingleBindIsolation_.equalsIgnoreCase("true")) {
                xmlFileHelper.setAttributeValueForNode(element2, "forceSingleBindIsolation", this.forceSingleBindIsolation_);
            } else if (this.forceSingleBindIsolation_ != null && this.forceSingleBindIsolation_.equalsIgnoreCase("false")) {
                element2.removeAttribute("forceSingleBindIsolation");
            }
            if (this.pkgVersion_ != null && bl2) {
                if (this.pkgVersionForAllStmtSets_ == null) {
                    this.pkgVersionForAllStmtSets_ = StatementUtilities.getPackageVersion(this.pkgVersion_, l2);
                }
                if (this.pkgVersionForAllStmtSets_ != null) {
                    xmlFileHelper.setAttributeValueForNode(element2, "version", this.pkgVersionForAllStmtSets_);
                }
            }
            StatementBinderHelper.checkAndFixSQLGroupedBySpecialRegisters(element);
            this.updateDDLList(element);
        }
    }

    private boolean addStmtToSRList(Element element, String string, List<Element> list) {
        String string2;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = null;
        if (((Element)element.getElementsByTagName("statementAttributes").item(0)).hasAttribute("specialRegValuesUsed")) {
            string3 = ((Element)element.getElementsByTagName("statementAttributes").item(0)).getAttribute("specialRegValuesUsed");
        }
        if (StaticProfileCaptureHelper.isDDLStatementTag(string2 = ((Element)element.getElementsByTagName("statementType").item(0)).getTextContent())) {
            bl3 = true;
        }
        List<Element> list2 = null;
        LinkedHashMap<Element, String> linkedHashMap = null;
        if (string3 == null || string3.matches("\\s*")) {
            if (!string.equals("NO_SRINFO")) {
                list2 = bl3 ? this.zeroDDLSpecialRegStmtList_ : this.zeroSpecialRegStmtList_;
            }
        } else if (string3.indexOf(44) == -1) {
            if (!string3.equals(string)) {
                linkedHashMap = bl3 ? this.oneDDLSpecialRegStmtMap_ : this.oneSpecialRegStmtMap_;
            }
        } else if (!string.equals("MULTI_SRINFO")) {
            list2 = bl3 ? this.multipleDDLSpecialRegStmtList_ : this.multipleSpecialRegStmtList_;
        }
        if (null != list2) {
            list2.add(element);
            if (null != list) {
                list2.addAll(list);
            }
            bl2 = true;
        } else if (null != linkedHashMap) {
            linkedHashMap.put(element, string3);
            if (null != list) {
                for (Element element2 : list) {
                    linkedHashMap.put(element2, string3);
                }
            }
            bl2 = true;
        }
        return bl2;
    }

    public static String getSRValuesUsedAttr(Element element, String string, String string2, String string3, String string4, String string5, String string6) {
        TreeSet<Integer> treeSet;
        TreeSet<Integer> treeSet2 = XmlFileHelper.getAttributeValueIntegerSet(element, string, string2, string3);
        TreeSet<Integer> treeSet3 = XmlFileHelper.getAttributeValueIntegerSet(element, string4, string5, string6);
        if (null != treeSet2) {
            treeSet = treeSet2;
            if (null != treeSet3) {
                treeSet.addAll(treeSet3);
            }
        } else {
            treeSet = treeSet3;
        }
        return XmlFileHelper.getIntegerSetAsString(treeSet);
    }

    private boolean mergeStmtAttr(Element element) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl2 = false;
        if (((Element)element.getElementsByTagName("statementAttributes").item(0)).hasAttribute("specialRegValuesUsed")) {
            string = ((Element)element.getElementsByTagName("statementAttributes").item(0)).getAttribute("specialRegValuesUsed");
        }
        if (((Element)element.getElementsByTagName("statementAttributes").item(0)).hasAttribute("incrementalSpecialRegValuesUsed")) {
            string2 = ((Element)element.getElementsByTagName("statementAttributes").item(0)).getAttribute("incrementalSpecialRegValuesUsed");
        }
        if (((Element)element.getElementsByTagName("statementAttributes").item(0)).hasAttribute("mriIndicator")) {
            string3 = ((Element)element.getElementsByTagName("statementAttributes").item(0)).getAttribute("mriIndicator");
        }
        if (((Element)element.getElementsByTagName("statementAttributes").item(0)).hasAttribute("parameterType")) {
            string4 = ((Element)element.getElementsByTagName("statementAttributes").item(0)).getAttribute("parameterType");
        }
        if ((string == null || string.matches("\\s*")) && string2 != null) {
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).setAttribute("specialRegValuesUsed", string2);
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).removeAttribute("incrementalSpecialRegValuesUsed");
            bl2 = true;
        } else if (string != null && string2 != null) {
            string = StatementBinderHelper.getSRValuesUsedAttr(element, "statementAttributes", "specialRegValuesUsed", string, "statementAttributes", "incrementalSpecialRegValuesUsed", string2);
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).setAttribute("specialRegValuesUsed", string);
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).removeAttribute("incrementalSpecialRegValuesUsed");
            bl2 = true;
        }
        if ((string4 == null || string4.equals("SINGLE_ROW_PARAMETERS")) && string3 != null && string3.equals("true")) {
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).setAttribute("parameterType", "MULTI_ROW_PARAMETERS");
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).removeAttribute("mriIndicator");
            int n2 = XmlFileHelper.countReservedSectionsReqd(element);
            if (n2 > 0) {
                element.setAttribute("numReservedSections", "" + n2);
            }
        } else if (string4 != null && string4.equals("MULTI_ROW_PARAMETERS") && string3 != null) {
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).removeAttribute("mriIndicator");
        }
        return bl2;
    }

    private boolean checkIfSRValueChangeNeeded(XmlFileHelper xmlFileHelper, int n2, PrintWriter printWriter) {
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        Element element = null;
        Element element2 = null;
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        NodeList nodeList = arrayList.get(n2).getElementsByTagName("statement");
        int n3 = nodeList.getLength();
        for (int i10 = 0; i10 < n3; ++i10) {
            Element element3 = (Element)nodeList.item(i10);
            String string3 = element3.getElementsByTagName("prepareSql").item(0).getTextContent();
            element = (Element)element3.getElementsByTagName("statementAttributes").item(0);
            if (element != null && element.hasAttribute("specialRegValuesUsed")) {
                string = ((Element)element3.getElementsByTagName("statementAttributes").item(0)).getAttribute("specialRegValuesUsed");
            }
            if ((element2 = (Element)element3.getElementsByTagName("statementAttributes").item(0)) != null && element2.hasAttribute("incrementalSpecialRegValuesUsed")) {
                string2 = ((Element)element3.getElementsByTagName("statementAttributes").item(0)).getAttribute("incrementalSpecialRegValuesUsed");
            }
            if ((string == null || string.matches("\\s*")) && string2 != null && string2.indexOf(44) == -1) {
                bl2 = true;
                printWriter.println(Messages.getText("MSG_SR_GROUPING_NEEDED", string3));
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_SR_GROUPING_NEEDED", string3), 10846, this.getClass(), "checkIfSRValueChangeNeeded");
                continue;
            }
            if ((string == null || string.indexOf(44) == -1) && (string2 == null || string2.indexOf(44) == -1)) continue;
            bl2 = true;
            printWriter.println(Messages.getText("MSG_SR_GROUPING_NEEDED", string3));
            WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_SR_GROUPING_NEEDED", string3), 11265, this.getClass(), "checkIfSRValueChangeNeeded");
        }
        return bl2;
    }

    private void checkIfUnusedSQLPresent(XmlFileHelper xmlFileHelper, int n2, PrintWriter printWriter) {
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        Element element = DOMUtil.getFirstChildByName(arrayList.get(n2), "statements");
        ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element, "statement");
        int n3 = arrayList2.size();
        for (int i10 = 0; i10 < n3; ++i10) {
            XMLGregorianCalendar xMLGregorianCalendar;
            XMLGregorianCalendar xMLGregorianCalendar2;
            Element element2 = arrayList2.get(i10);
            String string = element2.getElementsByTagName("prepareSql").item(0).getTextContent();
            Element element3 = (Element)element2.getElementsByTagName("captureStatistics").item(0);
            String string2 = null;
            if (element3.getElementsByTagName("lastUsedTimestamp").item(0) != null) {
                string2 = element3.getElementsByTagName("lastUsedTimestamp").item(0).getTextContent();
            }
            if (string2 == null || this.removeInactiveSQLBefore_ == null || (xMLGregorianCalendar2 = datatypeFactory_.newXMLGregorianCalendar(string2)).compare(xMLGregorianCalendar = datatypeFactory_.newXMLGregorianCalendar(this.removeInactiveSQLBefore_)) >= 0) continue;
            printWriter.println(Messages.getText("MSG_OLD_SQL_CANNOT_BE_REMOVED", string));
            WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_OLD_SQL_CANNOT_BE_REMOVED", string), 10849, this.getClass(), "checkIfUnusedSQLPresent");
        }
    }

    private boolean removeUnusedStmts(Node node, PrintWriter printWriter) {
        Object object;
        int n2;
        boolean bl2 = false;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Element element = DOMUtil.getFirstChildByName(node, "statements");
        ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element, "statement");
        int n3 = arrayList2.size();
        int n4 = this.posUpdateStmtsInFile_.size();
        XMLGregorianCalendar xMLGregorianCalendar = null;
        XMLGregorianCalendar xMLGregorianCalendar2 = null;
        if (this.removeInactiveSQLBefore_ != null) {
            xMLGregorianCalendar2 = datatypeFactory_.newXMLGregorianCalendar(this.removeInactiveSQLBefore_);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            object = arrayList2.get(n2);
            Element element2 = (Element)object.getElementsByTagName("captureStatistics").item(0);
            String string = null;
            if (element2.getElementsByTagName("lastUsedTimestamp").item(0) != null) {
                string = element2.getElementsByTagName("lastUsedTimestamp").item(0).getTextContent();
            }
            if (string == null || this.removeInactiveSQLBefore_ == null) continue;
            xMLGregorianCalendar = datatypeFactory_.newXMLGregorianCalendar(string);
            if (this.removeInactiveSQLBefore_ == null && this.removeInactiveSQLBefore_.matches("\\s*") || xMLGregorianCalendar == null || xMLGregorianCalendar.compare(xMLGregorianCalendar2) >= 0) continue;
            String string2 = XmlFileHelper.getUpdatableCursorName((Node)object);
            if (string2 == null || StatementBinderHelper.isStmtWithRefQueryAttr((Node)object)) {
                arrayList.add(object);
                bl2 = true;
                continue;
            }
            if (string2 == null) continue;
            boolean bl3 = false;
            String string3 = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries((Element)object, null);
            for (int i10 = 0; i10 < n4; ++i10) {
                Element element3 = this.posUpdateStmtsInFile_.get(i10);
                if (!StatementBinderHelper.checkForReferencedQueryAttribute(element3, string3)) continue;
                Element element4 = (Element)element3.getElementsByTagName("captureStatistics").item(0);
                String string4 = null;
                if (element4.getElementsByTagName("lastUsedTimestamp").item(0) != null) {
                    string4 = element4.getElementsByTagName("lastUsedTimestamp").item(0).getTextContent();
                }
                if (string4 == null) continue;
                XMLGregorianCalendar xMLGregorianCalendar3 = datatypeFactory_.newXMLGregorianCalendar(string4);
                if (bl3 || xMLGregorianCalendar3 == null || xMLGregorianCalendar3.compare(xMLGregorianCalendar2) <= 0) continue;
                bl3 = true;
                String string5 = ((Element)object.getElementsByTagName("prepareSql").item(0)).getTextContent();
                printWriter.println(Messages.getText("MSG_MERGE_LATER_POSUPDATE_FOUND", string5));
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_MERGE_LATER_POSUPDATE_FOUND", string5), 10873, this.getClass(), "removeUnusedStmts");
            }
            if (bl3) continue;
            arrayList.add(object);
            bl2 = true;
        }
        if (!arrayList.isEmpty()) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                element.removeChild((Node)arrayList.get(n2));
                if (!this.showDetails_) continue;
                object = ((Element)arrayList.get(n2)).getElementsByTagName("prepareSql").item(0).getTextContent();
                printWriter.println(Messages.getText("MSG_STMT_REMOVED", object));
            }
        }
        return bl2;
    }

    private Element initBindableStmtSet(XmlFileHelper xmlFileHelper, String string, String string2, String string3) {
        Element element = xmlFileHelper.getXmlDocument().createElement("statementSet");
        element.setAttribute("configureStatus", "AUTO");
        Element element2 = xmlFileHelper.getXmlDocument().createElement("package");
        Element element3 = xmlFileHelper.getXmlDocument().createElement("statements");
        element2.setAttribute("version", "");
        element2.setAttribute("collection", "NULLID");
        element2.setAttribute("isDDLPackage", "false");
        if (string != null) {
            element2.setAttribute("SQLGroupedBySpecialRegisters", string);
        }
        if (string2 != null) {
            element2.setAttribute("SQLGroupedByStrings", string2);
        }
        if (string3 != null) {
            element2.setAttribute("SQLGroupedByJavaPackages", string3);
        }
        element.appendChild(element2);
        element.appendChild(element3);
        xmlFileHelper.getXmlDocument().getDocumentElement().appendChild(element);
        XmlFileHelper.assignNewConsistencyTokenAndSetGreatestSectionNumberUsed(element, 0);
        this.currentPkgSqlCount_ = 0;
        return element;
    }

    private Element initDDLStmtSet(XmlFileHelper xmlFileHelper, String string, String string2, String string3) {
        Element element = xmlFileHelper.getXmlDocument().createElement("statementSet");
        element.setAttribute("configureStatus", "AUTO");
        Element element2 = xmlFileHelper.getXmlDocument().createElement("package");
        element2.setAttribute("version", "");
        element2.setAttribute("collection", "NULLID");
        element2.setAttribute("isDDLPackage", "true");
        if (string != null) {
            element2.setAttribute("SQLGroupedBySpecialRegisters", string);
        }
        if (string2 != null) {
            element2.setAttribute("SQLGroupedByStrings", string2);
        }
        if (string3 != null) {
            element2.setAttribute("SQLGroupedByJavaPackages", string3);
        }
        Element element3 = xmlFileHelper.getXmlDocument().createElement("statements");
        element.appendChild(element2);
        element.appendChild(element3);
        xmlFileHelper.getXmlDocument().getDocumentElement().appendChild(element);
        XmlFileHelper.assignNewConsistencyTokenAndSetGreatestSectionNumberUsed(element, 0);
        return element;
    }

    private void filterDDLStmtsAndAddToFile(XmlFileHelper xmlFileHelper, List<Element> list) {
        int n2;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n3 = list == null ? 0 : list.size();
        for (n2 = 0; n2 < n3; ++n2) {
            String string;
            Element element = list.get(n2);
            String string2 = ((Element)element.getElementsByTagName("statementType").item(0)).getTextContent();
            if (!StaticProfileCaptureHelper.isDDLStatementTag(string2)) continue;
            this.mergeStmtAttr(element);
            if (this.groupSqlBySpecialRegisters_) {
                this.groupStmtBasedOnSpecialRegisters(element);
            }
            if (!this.ddlList_.contains(string = ((Element)element.getElementsByTagName("prepareSql").item(0)).getTextContent())) {
                this.ddlList_.add(string);
            }
            arrayList.add(element);
        }
        if (this.groupSqlBySpecialRegisters_) {
            this.groupStmtsIntoStmtSetsBasedOnSpecialRegisters(xmlFileHelper, true);
        } else {
            this.addDDLStmtSetToList(arrayList, xmlFileHelper, null);
        }
        n2 = arrayList == null ? 0 : arrayList.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            list.remove(arrayList.get(i10));
        }
    }

    private void addDDLStmtSetToList(List<Element> list, XmlFileHelper xmlFileHelper, String string) {
        Element element = null;
        element = this.initDDLStmtSet(xmlFileHelper, string, null, null);
        for (int i10 = 0; i10 < list.size(); ++i10) {
            Element element2 = list.get(i10);
            this.moveStatement(xmlFileHelper, element, element2);
        }
        this.newStatementSetList_.add(element);
    }

    private void groupStmtsIntoStmtSetsBasedOnSpecialRegisters(XmlFileHelper xmlFileHelper, boolean bl2) {
        List<Object> list = new ArrayList();
        HashMap hashMap = new HashMap();
        List<Object> list2 = new ArrayList();
        List<Object> list3 = new ArrayList();
        if (bl2) {
            list = this.zeroDDLSpecialRegStmtList_;
            hashMap = this.oneDDLSpecialRegStmtMap_;
            list2 = this.multipleDDLSpecialRegStmtList_;
            list3 = this.uniqueDDLSRVal_;
        } else {
            list = this.zeroSpecialRegStmtList_;
            hashMap = this.oneSpecialRegStmtMap_;
            list2 = this.multipleSpecialRegStmtList_;
            list3 = this.uniqueSRVal_;
        }
        if (list.size() > 0) {
            if (bl2) {
                this.addDDLStmtSetToList(list, xmlFileHelper, "NO_SRINFO");
            } else {
                this.addStmtSetToList(list, xmlFileHelper, "NO_SRINFO");
            }
        }
        if (hashMap.size() > 0) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (int i10 = 0; list3.size() != 0 && i10 < list3.size(); ++i10) {
                String string = (String)list3.get(i10);
                for (Map.Entry entry : hashMap.entrySet()) {
                    Element element = (Element)entry.getKey();
                    String string2 = (String)entry.getValue();
                    if (!string2.equals(string)) continue;
                    arrayList.add(element);
                }
                if (arrayList.size() > 0) {
                    if (bl2) {
                        this.addDDLStmtSetToList(arrayList, xmlFileHelper, string);
                    } else {
                        this.addStmtSetToList(arrayList, xmlFileHelper, string);
                    }
                }
                arrayList.clear();
            }
        }
        if (list2.size() > 0) {
            if (bl2) {
                this.addDDLStmtSetToList(list2, xmlFileHelper, "MULTI_SRINFO");
            } else {
                this.addStmtSetToList(list2, xmlFileHelper, "MULTI_SRINFO");
            }
        }
    }

    private void moveStatement(XmlFileHelper xmlFileHelper, Element element, Node node) {
        Element element2 = DOMUtil.getFirstChildByName(element, "statements");
        element2.appendChild(xmlFileHelper.getXmlDocument().importNode(node, true));
        ++this.currentPkgSqlCount_;
    }

    private void getNextSuffix(XmlFileHelper xmlFileHelper) {
        NodeList nodeList = xmlFileHelper.getRootElement().getElementsByTagName("statementSet");
        String string = null;
        String string2 = "";
        String string3 = "";
        boolean bl2 = true;
        int n2 = nodeList.getLength();
        for (int i10 = 0; i10 < n2; ++i10) {
            Node node = nodeList.item(i10);
            Element element = (Element)((Element)node).getElementsByTagName("package").item(0);
            if (!element.hasAttribute("name")) continue;
            string = element.getAttribute("name");
            if (!string.equals("")) {
                bl2 = false;
            }
            if (!string.startsWith(this.rootPkgName_)) continue;
            string3 = string.substring(this.rootPkgName_.length(), string.length());
            if (string2.equals("") && !string3.equals("")) {
                string2 = string3;
                continue;
            }
            if (string3.compareTo(string2) <= 0 && string3.length() <= string2.length()) continue;
            string2 = string3;
        }
        if (bl2) {
            this.cleanConfOption_ = true;
        }
        if (0 != string2.length()) {
            this.currentPkgSuffix_ = string2;
            this.getNextPkgName();
        }
    }

    private void addStmtsToStmtList(List<Element> list) {
        int n2;
        Element element;
        int n3;
        for (n3 = 0; !this.zeroSpecialRegStmtList_.isEmpty() && n3 < this.zeroSpecialRegStmtList_.size(); ++n3) {
            list.add(this.zeroSpecialRegStmtList_.get(n3));
        }
        this.zeroSpecialRegStmtList_.clear();
        for (n3 = 0; !this.zeroDDLSpecialRegStmtList_.isEmpty() && n3 < this.zeroDDLSpecialRegStmtList_.size(); ++n3) {
            list.add(this.zeroDDLSpecialRegStmtList_.get(n3));
        }
        this.zeroDDLSpecialRegStmtList_.clear();
        for (Map.Entry<Element, String> entry : this.oneSpecialRegStmtMap_.entrySet()) {
            element = entry.getKey();
            list.add(element);
        }
        this.oneSpecialRegStmtMap_.clear();
        for (Map.Entry<Element, String> entry : this.oneDDLSpecialRegStmtMap_.entrySet()) {
            element = entry.getKey();
            list.add(element);
        }
        this.oneDDLSpecialRegStmtMap_.clear();
        for (n2 = 0; !this.multipleSpecialRegStmtList_.isEmpty() && n2 < this.multipleSpecialRegStmtList_.size(); ++n2) {
            list.add(this.multipleSpecialRegStmtList_.get(n2));
        }
        this.multipleSpecialRegStmtList_.clear();
        for (n2 = 0; !this.multipleDDLSpecialRegStmtList_.isEmpty() && n2 < this.multipleDDLSpecialRegStmtList_.size(); ++n2) {
            list.add(this.multipleDDLSpecialRegStmtList_.get(n2));
        }
        this.multipleDDLSpecialRegStmtList_.clear();
    }

    private boolean processStatementWithSetMaxRowsInformation(Element element) {
        boolean bl2 = false;
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        String string = element2.getAttribute("maxRows");
        String string2 = element2.getAttribute("incrementalMaxRows");
        if (!StaticProfileConstants.isValueSet(string) && !StaticProfileConstants.isValueSet(string2)) {
            return bl2;
        }
        String string3 = null;
        if (StaticProfileConstants.isValueSet(string)) {
            string3 = string;
            if (StaticProfileConstants.isValueSet(string2) && Integer.parseInt(string) < Integer.parseInt(string2)) {
                string3 = string2;
                bl2 = true;
            }
        } else if (StaticProfileConstants.isValueSet(string2)) {
            string3 = string2;
            bl2 = true;
        }
        if (element2.hasAttribute("incrementalMaxRows")) {
            element2.removeAttribute("incrementalMaxRows");
        }
        if (string3 != null && bl2) {
            String string4;
            element2.setAttribute("maxRows", string3);
            if (StaticProfileConstants.isValueSet(string) && Integer.parseInt(string) == 1 && element2.hasAttribute("rowType") && "SINGLE_ROW_RESULT".equals(string4 = element2.getAttribute("rowType"))) {
                element2.removeAttribute("rowType");
            }
        }
        return bl2;
    }

    private boolean processStatementSetsWithMaxRowsInformation(XmlFileHelper xmlFileHelper, int n2) {
        boolean bl2 = false;
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        NodeList nodeList = arrayList.get(n2).getElementsByTagName("statement");
        int n3 = nodeList.getLength();
        for (int i10 = 0; i10 < n3; ++i10) {
            Element element = (Element)nodeList.item(i10);
            bl2 |= this.processStatementWithSetMaxRowsInformation(element);
        }
        return bl2;
    }

    private boolean processStatementsWithSetMaxRowsInformationNeeded(XmlFileHelper xmlFileHelper, int n2, PrintWriter printWriter) {
        boolean bl2 = false;
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        NodeList nodeList = arrayList.get(n2).getElementsByTagName("statement");
        int n3 = nodeList.getLength();
        for (int i10 = 0; i10 < n3; ++i10) {
            Element element = (Element)nodeList.item(i10);
            String string = element.getElementsByTagName("prepareSql").item(0).getTextContent();
            Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
            if (!element2.hasAttribute("incrementalMaxRows")) continue;
            printWriter.println(Messages.getText("MSG_MAX_ROWS_PROCESSING_NEEDED", "incrementalMaxRows", "configureStatus", "maxRows", string));
            WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_MAX_ROWS_PROCESSING_NEEDED", "incrementalMaxRows", "configureStatus", "maxRows", string), 11264, this.getClass(), "processStatementsWithSetMaxRowsInformationNeeded");
            bl2 = true;
        }
        return bl2;
    }

    private void configureUnnamedPackages(XmlFileHelper xmlFileHelper, PrintWriter printWriter) throws SQLException {
        Object object;
        Object object2;
        int n2;
        ArrayList<List<Element>> arrayList = new ArrayList<List<Element>>();
        this.getNextSuffix(xmlFileHelper);
        this.setMarkDDLForBind(this.markDDL_);
        boolean bl2 = false;
        ArrayList<Element> arrayList2 = new ArrayList<Element>();
        if (!this.newStatementSetList_.isEmpty()) {
            this.newStatementSetList_.clear();
        }
        ArrayList<Element> arrayList3 = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        int n3 = arrayList3.size();
        for (n2 = 0; n2 < n3; ++n2) {
            object2 = arrayList3.get(n2);
            Element element = (Element)object2.getElementsByTagName("package").item(0);
            object = element.getAttribute("name");
            if (object == null || ((String)object).matches("\\s*")) {
                String string;
                if (this.finalUnnamedPkgFound_ && !bl2) {
                    printWriter.println(Messages.getText("MSG_PROFILER_FINAL_PKG_CONFIGURED1", new Object[0]));
                    ToolsLogger.getLogger().log(Level.INFO, Messages.getText("MSG_PROFILER_FINAL_PKG_CONFIGURED1", new Object[0]));
                    bl2 = true;
                }
                if (!"false".equals(string = element.getAttribute("isBindable")) && !"true".equals(string)) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_ISBINDABLE", string, "isBindable"), null, 10757);
                }
                NodeList nodeList = object2.getElementsByTagName("statement");
                int n4 = nodeList.getLength();
                int n5 = this.posUpdateStmtsInFile_.size();
                Element element2 = null;
                XMLGregorianCalendar xMLGregorianCalendar = null;
                XMLGregorianCalendar xMLGregorianCalendar2 = null;
                if (this.removeInactiveSQLBefore_ != null) {
                    xMLGregorianCalendar2 = datatypeFactory_.newXMLGregorianCalendar(this.removeInactiveSQLBefore_);
                }
                for (int i10 = 0; i10 < n4; ++i10) {
                    String string2;
                    element2 = (Element)nodeList.item(i10);
                    this.checkAndSetIfNonBindable(element2);
                    Element element3 = (Element)element2.getElementsByTagName("captureStatistics").item(0);
                    String string3 = null;
                    if (element3.getElementsByTagName("lastUsedTimestamp").item(0) != null) {
                        string3 = element3.getElementsByTagName("lastUsedTimestamp").item(0).getTextContent();
                    }
                    if (string3 != null) {
                        xMLGregorianCalendar = datatypeFactory_.newXMLGregorianCalendar(string3);
                    }
                    boolean bl3 = true;
                    if (this.removeInactiveSQLBefore_ == null || this.removeInactiveSQLBefore_.matches("\\s*") || (this.removeInactiveSQLBefore_ != null || !this.removeInactiveSQLBefore_.matches("\\s*")) && xMLGregorianCalendar != null && xMLGregorianCalendar2 != null) {
                        string2 = XmlFileHelper.getUpdatableCursorName(element2);
                        if (xMLGregorianCalendar2 == null || xMLGregorianCalendar.compare(xMLGregorianCalendar2) > 0) {
                            arrayList2.add(element2);
                            bl3 = false;
                        } else if (string2 != null) {
                            boolean bl4 = false;
                            String string4 = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries(element2, null);
                            for (int i11 = 0; i11 < n5 && !bl4; ++i11) {
                                Element element4 = this.posUpdateStmtsInFile_.get(i11);
                                if (!StatementBinderHelper.checkForReferencedQueryAttribute(element4, string4)) continue;
                                Element element5 = (Element)element4.getElementsByTagName("captureStatistics").item(0);
                                String string5 = null;
                                if (element5.getElementsByTagName("lastUsedTimestamp").item(0) != null) {
                                    string5 = element5.getElementsByTagName("lastUsedTimestamp").item(0).getTextContent();
                                }
                                if (string5 == null) continue;
                                XMLGregorianCalendar xMLGregorianCalendar3 = datatypeFactory_.newXMLGregorianCalendar(string5);
                                if (bl4 || xMLGregorianCalendar3 == null || xMLGregorianCalendar2 == null || xMLGregorianCalendar3.compare(xMLGregorianCalendar2) <= 0) continue;
                                bl4 = true;
                                String string6 = element2.getElementsByTagName("prepareSql").item(0).getTextContent();
                                printWriter.println(Messages.getText("MSG_MERGE_LATER_POSUPDATE_FOUND", string6));
                                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_MERGE_LATER_POSUPDATE_FOUND", string6), 11023, this.getClass(), "configureUnnamedPackages");
                            }
                            if (bl4) {
                                arrayList2.add(element2);
                                bl3 = false;
                            }
                        }
                    }
                    if (this.showDetails_ && bl3) {
                        string2 = element2.getElementsByTagName("prepareSql").item(0).getTextContent();
                        printWriter.println(Messages.getText("MSG_STMT_REMOVED", string2));
                    }
                    this.processStatementWithSetMaxRowsInformation(element2);
                }
                arrayList.add((List<Element>)object2);
                continue;
            }
            if (this.zeroSpecialRegStmtList_.isEmpty() && this.oneSpecialRegStmtMap_.isEmpty() && this.multipleSpecialRegStmtList_.isEmpty() && this.zeroDDLSpecialRegStmtList_.isEmpty() && this.oneDDLSpecialRegStmtMap_.isEmpty() && this.multipleDDLSpecialRegStmtList_.isEmpty()) continue;
            this.addStmtsToStmtList(arrayList2);
        }
        if (!arrayList.isEmpty()) {
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                object2 = (Node)arrayList.get(n2);
                xmlFileHelper.getRootElement().removeChild((Node)object2);
            }
        }
        if (!arrayList2.isEmpty()) {
            this.filterDDLStmtsAndAddToFile(xmlFileHelper, arrayList2);
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                object2 = (Element)arrayList2.get(n2);
                this.mergeStmtAttr((Element)object2);
                if (this.groupSqlBySpecialRegisters_ && !StatementBinderHelper.isStmtWithRefQueryAttr((Node)object2)) {
                    this.groupStmtBasedOnSpecialRegisters((Element)object2);
                    continue;
                }
                if (this.groupSqlBySpecialRegisters_ && StatementBinderHelper.isStmtWithRefQueryAttr((Node)object2)) {
                    this.refQueryStmts_.add((Element)object2);
                    continue;
                }
                if (this.groupSqlBySpecialRegisters_ || !StatementBinderHelper.isStmtWithRefQueryAttr((Node)object2)) continue;
                this.refQueryStmts_.add((Element)object2);
            }
            if (this.groupSqlBySpecialRegisters_) {
                this.groupStmtsIntoStmtSetsBasedOnSpecialRegisters(xmlFileHelper, false);
            } else {
                for (n2 = 0; n2 < this.refQueryStmts_.size(); ++n2) {
                    arrayList2.remove(this.refQueryStmts_.get(n2));
                }
                this.addStmtSetToList(arrayList2, xmlFileHelper, null);
            }
            if (this.sqlGroupedByString_ != null && !this.newStatementSetList_.isEmpty()) {
                ArrayList<Element> arrayList4 = new ArrayList<Element>();
                object2 = null;
                for (int i12 = 0; i12 < this.newStatementSetList_.size(); ++i12) {
                    object = this.newStatementSetList_.get(i12);
                    object2 = this.groupSQLsMatchedByStringsIntoStatementsSets(xmlFileHelper, (Element)object);
                    arrayList4.addAll((Collection<Element>)object2);
                    xmlFileHelper.getRootElement().removeChild((Node)object);
                }
                this.newStatementSetList_ = arrayList4;
            }
            if (this.sqlGroupedByJavaPackage_ != null && !this.newStatementSetList_.isEmpty()) {
                ArrayList<Element> arrayList5 = new ArrayList<Element>();
                object2 = null;
                for (int i13 = 0; i13 < this.newStatementSetList_.size(); ++i13) {
                    object = this.newStatementSetList_.get(i13);
                    object2 = this.groupSQLsMatchedByJavaPackageIntoStatementsSets(xmlFileHelper, (Element)object);
                    arrayList5.addAll((Collection<Element>)object2);
                    xmlFileHelper.getRootElement().removeChild((Node)object);
                }
                this.newStatementSetList_ = arrayList5;
            }
            this.moveRefQueryStmtsAndApplySQLLimit(xmlFileHelper);
            if (xmlFileHelper != null && !this.newStatementSetList_.isEmpty()) {
                this.setisBindableAndSectionNumberAndConsistencyTokenForNewStmts(this.newStatementSetList_, xmlFileHelper);
            }
        }
    }

    private void setFirstUsedTS(XmlFileHelper xmlFileHelper, Element element, Element element2) {
        String string = element2.getTextContent();
        Element element3 = (Element)element.getElementsByTagName("firstUsedTimestamp").item(0);
        if (element3 == null) {
            element3 = xmlFileHelper.getXmlDocument().createElement("firstUsedTimestamp");
            element.insertBefore(element3, element2);
        } else if (element3.getTextContent() != null && element3.getTextContent().length() > 0) {
            return;
        }
        element3.setTextContent(string);
    }

    private void moveRefQueryStmtsAndApplySQLLimit(XmlFileHelper xmlFileHelper) {
        int n2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n2 = 0; !this.newStatementSetList_.isEmpty() && n2 < this.newStatementSetList_.size(); ++n2) {
            Object object;
            Element element = this.newStatementSetList_.get(n2);
            Element element2 = DOMUtil.getFirstChildByName(element, "package");
            String string = null;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (element2.hasAttribute("SQLGroupedBySpecialRegisters")) {
                string = element2.getAttribute("SQLGroupedBySpecialRegisters");
            }
            if (element2.hasAttribute("SQLGroupedByStrings")) {
                string2 = element2.getAttribute("SQLGroupedByStrings");
            }
            if (element2.hasAttribute("SQLGroupedByJavaPackages")) {
                string4 = element2.getAttribute("SQLGroupedByJavaPackages");
            }
            if (element2.hasAttribute("isDDLPackage")) {
                string3 = element2.getAttribute("isDDLPackage");
            }
            Element element3 = DOMUtil.getFirstChildByName(element, "statements");
            ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element3, "statement");
            int n3 = arrayList2.size();
            ArrayList<Element> arrayList3 = new ArrayList<Element>();
            for (int i10 = 0; i10 < n3; ++i10) {
                Element element4 = arrayList2.get(i10);
                arrayList3.add(element4);
            }
            ArrayList<Element> arrayList4 = new ArrayList<Element>();
            xmlFileHelper.getRootElement().removeChild(element);
            for (int i11 = 0; i11 < n3; ++i11) {
                Element element5;
                int n4;
                Object object2;
                Element element6 = arrayList2.get(i11);
                object = XmlFileHelper.getUpdatableCursorName(element6);
                if (object != null) {
                    arrayList4.add(element6);
                    arrayList3.remove(element6);
                    object2 = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries(element6, null);
                    for (n4 = 0; n4 < this.refQueryStmts_.size(); ++n4) {
                        element5 = this.refQueryStmts_.get(n4);
                        if (element5 == null || !StatementBinderHelper.checkForReferencedQueryAttribute(element5, (String)object2)) continue;
                        arrayList4.add(element5);
                    }
                } else if (!StatementBinderHelper.isStmtWithRefQueryAttr(element6) || object == null) {
                    arrayList4.add(element6);
                    arrayList3.remove(element6);
                }
                object2 = null;
                if (arrayList4.isEmpty() || arrayList4.size() < this.sqlLimit_) continue;
                object2 = string3.equals("true") ? this.initDDLStmtSet(xmlFileHelper, string, string2, string4) : this.initBindableStmtSet(xmlFileHelper, string, string2, string4);
                for (n4 = 0; n4 < arrayList4.size(); ++n4) {
                    element5 = (Element)arrayList4.get(n4);
                    this.moveStatement(xmlFileHelper, (Element)object2, element5);
                }
                arrayList.add(object2);
                arrayList4.clear();
            }
            if (arrayList4.isEmpty()) continue;
            Element element7 = null;
            element7 = string3.equals("true") ? this.initDDLStmtSet(xmlFileHelper, string, string2, string4) : this.initBindableStmtSet(xmlFileHelper, string, string2, string4);
            for (int i12 = 0; i12 < arrayList4.size(); ++i12) {
                object = (Element)arrayList4.get(i12);
                this.moveStatement(xmlFileHelper, element7, (Node)object);
            }
            arrayList.add(element7);
        }
        if (!arrayList.isEmpty()) {
            this.newStatementSetList_.clear();
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                this.newStatementSetList_.add((Element)arrayList.get(n2));
            }
        }
    }

    private void addStmtSetToList(List<Element> list, XmlFileHelper xmlFileHelper, String string) {
        Element element = null;
        element = this.initBindableStmtSet(xmlFileHelper, string, null, null);
        int n2 = list.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            Element element2 = list.get(i10);
            String string2 = element2.getElementsByTagName("statementType").item(0).getTextContent();
            if (StaticProfileCaptureHelper.isDDLStatementTag(string2)) continue;
            this.moveStatement(xmlFileHelper, element, element2);
        }
        this.newStatementSetList_.add(element);
    }

    private void groupStmtBasedOnSpecialRegisters(Element element) {
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        String string3 = ((Element)element.getElementsByTagName("statementType").item(0)).getTextContent();
        if (StaticProfileCaptureHelper.isDDLStatementTag(string3)) {
            bl2 = true;
        }
        if (((Element)element.getElementsByTagName("statementAttributes").item(0)).hasAttribute("specialRegValuesUsed")) {
            string = ((Element)element.getElementsByTagName("statementAttributes").item(0)).getAttribute("specialRegValuesUsed");
        }
        if (((Element)element.getElementsByTagName("statementAttributes").item(0)).hasAttribute("incrementalSpecialRegValuesUsed")) {
            string2 = ((Element)element.getElementsByTagName("statementAttributes").item(0)).getAttribute("incrementalSpecialRegValuesUsed");
        }
        if ((string == null || string.matches("\\s*")) && (string2 == null || string2.matches("\\s*"))) {
            if (bl2) {
                this.zeroDDLSpecialRegStmtList_.add(element);
            } else {
                this.zeroSpecialRegStmtList_.add(element);
            }
        } else if (string != null && string.indexOf(44) == -1 && (string2 == null || string2.matches("\\s*"))) {
            if (bl2) {
                this.oneDDLSpecialRegStmtMap_.put(element, string);
                if (!this.uniqueDDLSRVal_.contains(string)) {
                    this.uniqueDDLSRVal_.add(string);
                }
            } else {
                this.oneSpecialRegStmtMap_.put(element, string);
                if (!this.uniqueSRVal_.contains(string)) {
                    this.uniqueSRVal_.add(string);
                }
            }
        } else if ((string == null || string.matches("\\s*")) && string2 != null && string2.indexOf(44) == -1) {
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).setAttribute("specialRegValuesUsed", string2);
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).removeAttribute("incrementalSpecialRegValuesUsed");
            if (bl2) {
                this.oneDDLSpecialRegStmtMap_.put(element, string2);
                if (!this.uniqueDDLSRVal_.contains(string2)) {
                    this.uniqueDDLSRVal_.add(string2);
                }
            } else {
                this.oneSpecialRegStmtMap_.put(element, string2);
                if (!this.uniqueSRVal_.contains(string2)) {
                    this.uniqueSRVal_.add(string2);
                }
            }
        } else if ((string == null || string.matches("\\s*")) && string2 != null && string2.indexOf(44) != -1) {
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).setAttribute("specialRegValuesUsed", string2);
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).removeAttribute("incrementalSpecialRegValuesUsed");
            if (bl2) {
                this.multipleDDLSpecialRegStmtList_.add(element);
            } else {
                this.multipleSpecialRegStmtList_.add(element);
            }
        } else if (string != null && string2 != null) {
            string = StatementBinderHelper.getSRValuesUsedAttr(element, "statementAttributes", "specialRegValuesUsed", string, "statementAttributes", "incrementalSpecialRegValuesUsed", string2);
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).setAttribute("specialRegValuesUsed", string);
            ((Element)element.getElementsByTagName("statementAttributes").item(0)).removeAttribute("incrementalSpecialRegValuesUsed");
            if (bl2) {
                this.multipleDDLSpecialRegStmtList_.add(element);
            } else {
                this.multipleSpecialRegStmtList_.add(element);
            }
        } else if (string != null && string.indexOf(44) != -1 && (string2 == null || string2.matches("\\s*"))) {
            if (bl2) {
                this.multipleDDLSpecialRegStmtList_.add(element);
            } else {
                this.multipleSpecialRegStmtList_.add(element);
            }
        }
    }

    public static void checkAndFixSQLGroupedBySpecialRegisters(Element element) {
        if (null == element) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsNoLog(Messages.getText("ERR_PUREQUERYXML_INVALID_NONAME", new Object[0]), null, 11092);
        }
        Element element2 = (Element)element.getElementsByTagName("package").item(0);
        String string = element2.getAttribute("SQLGroupedBySpecialRegisters");
        if (XmlFileHelper.isAttributeSet(string)) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            String string2 = null;
            String string3 = null;
            NodeList nodeList = element.getElementsByTagName("statement");
            int n2 = nodeList.getLength();
            for (int i10 = 0; i10 < n2 && !"INCONSISTENT_SRINFO".equals(string2); ++i10) {
                Element element3 = (Element)nodeList.item(i10);
                Element element4 = (Element)element3.getElementsByTagName("statementAttributes").item(0);
                if (null == string3 || !StatementBinderHelper.checkForReferencedQueryAttribute(element3, string3)) {
                    int n3;
                    TreeSet<Integer> treeSet = XmlFileHelper.getAttributeValueIntegerSet(element3, element4, "specialRegValuesUsed", false, null);
                    if (null == treeSet) {
                        n3 = 0;
                    } else {
                        hashSet.addAll(treeSet);
                        n3 = treeSet.size();
                        if (2 < n3) {
                            n3 = 2;
                        }
                    }
                    hashSet2.add(n3);
                }
                if (element4.hasAttribute("cursorName")) {
                    string3 = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries(element3, element4);
                }
                string2 = StatementBinderHelper.getCorrectSQLGroupedBySpecialRegistersValue(hashSet, hashSet2);
            }
            if (!string.equals(string2)) {
                element2.setAttribute("SQLGroupedBySpecialRegisters", string2);
            }
        }
    }

    private static String getCorrectSQLGroupedBySpecialRegistersValue(HashSet<Integer> hashSet, HashSet<Integer> hashSet2) {
        String string;
        if (1 != hashSet2.size()) {
            string = "INCONSISTENT_SRINFO";
        } else {
            int n2 = hashSet2.iterator().next();
            switch (n2) {
                case 0: {
                    string = "NO_SRINFO";
                    break;
                }
                case 1: {
                    if (1 == hashSet.size()) {
                        string = Integer.toString(hashSet.iterator().next());
                        break;
                    }
                    string = "INCONSISTENT_SRINFO";
                    break;
                }
                case 2: {
                    string = "MULTI_SRINFO";
                    break;
                }
                default: {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", n2), null, 11094);
                }
            }
        }
        return string;
    }

    private void setisBindableAndSectionNumberAndConsistencyTokenForNewStmts(List<Element> list, XmlFileHelper xmlFileHelper) {
        boolean bl2 = false;
        Element element = null;
        int n2 = 0;
        int n3 = 0;
        String string = "false";
        int n4 = list.size();
        for (int i10 = 0; i10 < n4; ++i10) {
            Element element2 = list.get(i10);
            Element element3 = DOMUtil.getFirstChildByName(element2, "package");
            string = element3.hasAttribute("isDDLPackage") ? element3.getAttribute("isDDLPackage") : "false";
            int n5 = 0;
            Element element4 = DOMUtil.getFirstChildByName(element2, "statements");
            ArrayList<Element> arrayList = DOMUtil.getNodesByName(element4, "statement");
            n2 = arrayList.size();
            bl2 = false;
            int n6 = 1;
            for (n3 = 0; n3 < n2; ++n3) {
                element = arrayList.get(n3);
                Element element5 = DOMUtil.getFirstChildByName(element, "statementDescriptor");
                Element element6 = DOMUtil.getFirstChildByName(element5, "statementAttributes");
                if (string.equals("true") && !this.markDDLUnspecified_) {
                    element6.setAttribute("isBindable", this.markDDLForBind_);
                }
                if (this.isBindableAndIsValid(element)) {
                    bl2 = true;
                    xmlFileHelper.setAttributeValueForNode(element, "sectionNumber", String.valueOf(n6++));
                    int n7 = XmlFileHelper.countReservedSectionsReqd(element);
                    if (n7 <= 0) continue;
                    element.setAttribute("numReservedSections", "" + n7);
                    n6 += n7;
                    continue;
                }
                xmlFileHelper.setAttributeValueForNode(element, "sectionNumber", String.valueOf(0));
            }
            if (!bl2) {
                this.setPackageLevelIsBindable(element2, "false");
            } else {
                this.setPackageLevelIsBindable(element2, "true");
            }
            if (1 < n6) {
                n5 = Math.max(n5, n6 - 1);
            }
            if (element3.getAttribute("isBindable").equalsIgnoreCase("true")) {
                long l2 = XmlFileHelper.assignNewConsistencyTokenAndSetGreatestSectionNumberUsed(element2, n5);
                if (this.pkgVersionForAllStmtSets_ == null) {
                    this.pkgVersionForAllStmtSets_ = StatementUtilities.getPackageVersion(this.pkgVersion_, l2);
                }
                if (this.pkgVersion_ != null && this.pkgVersionForAllStmtSets_ != null) {
                    xmlFileHelper.setAttributeValueForNode(element3, "version", this.pkgVersionForAllStmtSets_);
                }
                xmlFileHelper.setAttributeValueForNode(element3, "collection", this.collectionName_);
                if (this.forceSingleBindIsolation_ != null && this.forceSingleBindIsolation_.equalsIgnoreCase("true")) {
                    xmlFileHelper.setAttributeValueForNode(element3, "forceSingleBindIsolation", this.forceSingleBindIsolation_);
                }
            } else {
                xmlFileHelper.setAttributeValueForNode(element3, "version", "");
                xmlFileHelper.setAttributeValueForNode(element3, "collection", "");
                xmlFileHelper.setAttributeValueForNode(element3, "isBindable", "false");
            }
            if (this.cleanConfOption_ && n4 == 1) {
                element3.setAttribute("name", this.rootPkgName_);
            } else {
                element3.setAttribute("name", this.getNextPkgName());
            }
            StatementBinderHelper.checkAndFixSQLGroupedBySpecialRegisters(element2);
        }
    }

    private boolean isBindableAndIsValid(Element element) {
        return StatementBinderHelper.isBindableStmt(element) && StatementBinderHelper.isValidStmt(element);
    }

    public static void removeEmptyNodes(XmlFileHelper xmlFileHelper) {
        int n2;
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Element element = xmlFileHelper.getRootElement();
        ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element, "statementSet");
        int n3 = arrayList2.size();
        for (int i10 = 0; i10 < n3; ++i10) {
            Element element2 = arrayList2.get(i10);
            object = element2.getElementsByTagName("statement");
            NodeList nodeList = element2.getElementsByTagName("statements");
            int n4 = nodeList.getLength();
            if (object.getLength() == 0 || n4 == 0) {
                arrayList.add(element2);
            }
            if (n4 == 0) continue;
            for (int i11 = 0; i11 < n4; ++i11) {
                Element element3 = (Element)nodeList.item(i11);
                NodeList nodeList2 = element3.getChildNodes();
                for (int i12 = 0; i12 < nodeList2.getLength(); ++i12) {
                    Node node = nodeList2.item(i12);
                    if (node.getNodeType() != 3 || !Pattern.matches("[ \t\r\n]*", node.getNodeValue())) continue;
                    element3.removeChild(node);
                }
            }
        }
        NodeList nodeList = element.getChildNodes();
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            object = nodeList.item(n2);
            if (object.getNodeType() != 3 || !Pattern.matches("[ \t\r\n]*", object.getNodeValue())) continue;
            arrayList.add(object);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            xmlFileHelper.getRootElement().removeChild((Node)arrayList.get(n2));
        }
    }

    public static void cleanDownlevelFiles(XmlFileHelper xmlFileHelper) {
        NodeList nodeList;
        if (xmlFileHelper.getPureQueryXmlVersion() < 4 && (nodeList = xmlFileHelper.getXmlDocument().getElementsByTagName("package")) != null) {
            int n2 = nodeList.getLength();
            for (int i10 = 0; i10 < n2; ++i10) {
                Element element = (Element)nodeList.item(i10);
                if (!element.hasAttribute("greatestSectionNumberUsed")) continue;
                element.removeAttribute("greatestSectionNumberUsed");
            }
        }
    }

    protected void resolveCursorNames(XmlFileHelper xmlFileHelper, Node node, boolean bl2, boolean bl3, CentralStoreKey centralStoreKey, PrintWriter printWriter) {
        String string;
        Element element = DOMUtil.getFirstChildByName(node, "statements");
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(element, "statement");
        String string2 = ((Element)node).getAttribute("configureStatus");
        boolean bl4 = false;
        Element element2 = null;
        Element element3 = null;
        String string3 = null;
        Element element4 = DOMUtil.getCaptureRecord(xmlFileHelper.getXmlDocument());
        if (element4.hasAttribute("lastCursorIndex") && bl3) {
            string = element4.getAttribute("lastCursorIndex");
            this.currentCursorNdx_ = string.matches("\\s*") ? 1 : Integer.parseInt(string) + 1;
        }
        string = null;
        Element element5 = DOMUtil.getFirstChildByName(node, "package");
        string = element5.getAttribute("name");
        if (bl2) {
            bl4 = true;
            if (bl3) {
                this.currentCursorNdx_ = 1;
            }
        } else if (string2.equals("REQUIRED")) {
            bl4 = true;
        } else if ((string2.equals("FINAL") || string2.equals("AUTO")) && (string == null || string.matches("\\s*"))) {
            if (string2.equals("FINAL")) {
                this.finalUnnamedPkgFound_ = true;
            }
            bl4 = true;
        }
        int n2 = arrayList.size();
        long l2 = new File(centralStoreKey.getFileName()).lastModified();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(l2);
        XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory_.newXMLGregorianCalendar(gregorianCalendar);
        boolean bl5 = xmlFileHelper.getPureQueryXmlVersion() >= 4;
        for (int i10 = 0; i10 < n2; ++i10) {
            Object object;
            element2 = arrayList.get(i10);
            Element element6 = (Element)element2.getElementsByTagName("captureStatistics").item(0);
            if (bl5) {
                object = (Element)element6.getElementsByTagName("lastUsedTimestamp").item(0);
                if (object == null) {
                    object = xmlFileHelper.getXmlDocument().createElement("lastUsedTimestamp");
                    element6.appendChild((Node)object);
                    object.setTextContent(xMLGregorianCalendar.toXMLFormat());
                }
                this.setFirstUsedTS(xmlFileHelper, element6, (Element)object);
            }
            element3 = (Element)element2.getElementsByTagName("statementAttributes").item(0);
            object = element2.getElementsByTagName("statementType").item(0).getTextContent();
            if (((String)object).equals("QUERY")) {
                this.checkAndSetCursorName(string2, bl4, element2, element3, string, node, printWriter);
                continue;
            }
            if (StaticProfileConstants.userSQLIsNestedInASELECTForAGKs(element2)) {
                this.checkAndSetCursorName(string2, bl4, element2, element3, string, node, printWriter);
                continue;
            }
            if (!element3.hasAttribute("positionedUpdateCursor") || !this.isCursorCandidateForReplacement(string2, bl4, string3 = element3.getAttribute("positionedUpdateCursor")) && !this.isCursorNameOverrideNeeded(string3, bl4, string2, element2)) continue;
            this.replaceablePosUpdateStmtList_.add(element2);
            this.isConfigStatusChangeReqd_ = true;
        }
        if (this.isConfigStatusChangeReqd_) {
            ((Element)node).setAttribute("configureStatus", "REQUIRED");
        }
    }

    private void updateCaptureRecord(XmlFileHelper xmlFileHelper) {
        Element element = DOMUtil.getCaptureRecord(xmlFileHelper.getXmlDocument());
        if (element != null) {
            element.setAttribute("lastCursorIndex", "" + (this.currentCursorNdx_ - 1));
        }
    }

    private void checkAndSetCursorName(String string, boolean bl2, Element element, Element element2, String string2, Node node, PrintWriter printWriter) {
        String string3;
        String string4 = null;
        if (element2.hasAttribute("cursorName")) {
            string4 = element2.getAttribute("cursorName");
        }
        if (string4 == null || string4.matches("\\s*") || this.isCursorCandidateForReplacement(string, bl2, string4)) {
            string4 = "DB_PDQ_SPC" + this.currentCursorNdx_;
            element2.setAttribute("cursorName", string4);
            ++this.currentCursorNdx_;
            this.isConfigStatusChangeReqd_ = true;
        }
        if (null != (string3 = XmlFileHelper.getCursorKeyAsUsedByReferencedQueries(element, element2))) {
            string4 = element2.getAttribute("cursorName");
            String string5 = string2 == null || string2.matches("\\s*") ? "unnamed" : string2;
            this.checkAndLogWarningOrExceptionForDupCursor(node, string4, string5, printWriter);
            this.stmtKeyToCursorMap_.put(string3.toString(), string4);
            this.stmtCursorToKeyMap_.put(string4, new StmtCursorInfo(string3.toString(), node));
        }
    }

    private void checkAndLogWarningOrExceptionForDupCursor(Node node, String string, String string2, PrintWriter printWriter) {
        if (this.stmtCursorToKeyMap_.containsKey(string)) {
            StmtCursorInfo stmtCursorInfo = this.stmtCursorToKeyMap_.get(string);
            Node node2 = stmtCursorInfo.getStmtSet();
            if (node2.equals(node)) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_DUPLICATE_CURSOR_DEFINED_IN_STATEMENT_SET", string2, string), null, 10698);
            }
            String string3 = Messages.getText("MSG_DUPLICATE_CURSOR_NAME_DEFINED_IN_OTHER_STATEMENT_SET", string);
            printWriter.println(DataLogger.warningMessagePrefix + string3);
            WarningFactory.createPureQueryWarningForToolsLogOnly(string3, 10741, this.getClass(), "checkAndSetCursorName");
        }
    }

    private boolean isCursorCandidateForReplacement(String string, boolean bl2, String string2) {
        return bl2 && this.isValidCursorPrefix(string2) || string.equals("AUTO") && (string2 == null || string2.startsWith("SQL_CUR"));
    }

    private boolean isCursorNameOverrideNeeded(String string, boolean bl2, String string2, Element element) {
        String string3;
        Matcher matcher;
        if (bl2) {
            return true;
        }
        if (string2.equals("AUTO") && (matcher = StaticProfileConstants.WCOPat_.matcher(string3 = element.getElementsByTagName("prepareSql").item(0).getTextContent())).find()) {
            String string4 = matcher.group(2);
            return this.isValidCursorPrefix(string4);
        }
        return false;
    }

    private boolean isValidCursorPrefix(String string) {
        if (string == null) {
            return true;
        }
        return string.startsWith("SQL_CUR") || string.startsWith("DB_PDQ_SPC");
    }

    public static boolean isValidStmt(Element element) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        String string = element2.getAttribute("isValid");
        return !string.equalsIgnoreCase("false");
    }

    public static boolean isBindableStmt(Element element) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        String string = element2.getAttribute("isBindable");
        return string.equalsIgnoreCase("true");
    }

    public static boolean removeIsValidAttr(Element element) {
        Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
        boolean bl2 = element2.hasAttribute("isValid");
        if (bl2) {
            element2.removeAttribute("isValid");
            return true;
        }
        return false;
    }

    protected void resolvePositionUpdateCursors(XmlFileHelper xmlFileHelper, PrintWriter printWriter) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i10 = 0; i10 < this.replaceablePosUpdateStmtList_.size(); ++i10) {
            Object object;
            Element element = this.replaceablePosUpdateStmtList_.get(i10);
            Element element2 = (Element)element.getElementsByTagName("statementAttributes").item(0);
            string = element2.getAttribute("referencedQuery");
            string2 = this.stmtKeyToCursorMap_.get(string);
            String string5 = element2.getAttribute("positionedUpdateCursor");
            element2.setAttribute("positionedUpdateCursor", string2);
            string3 = element.getElementsByTagName("prepareSql").item(0).getTextContent();
            if (string2 != null && (object = ConnectionExecutionHandler.replacePosUpdateCursorName(string3, string2))[1] != null) {
                String[] stringArray;
                element.getElementsByTagName("prepareSql").item(0).setTextContent(object[0]);
                string4 = XmlFileHelper.getElementTextValue(element, "processedSql", null);
                if (string4 != null && string4.length() > 0 && (stringArray = ConnectionExecutionHandler.replacePosUpdateCursorName(string4, string2))[1] != null) {
                    element.getElementsByTagName("processedSql").item(0).setTextContent(stringArray[0]);
                }
            }
            if (string2 != null) continue;
            object = string4 != null && string4.length() > 0 ? string4 : string3;
            printWriter.println(Messages.getText("MSG_IC_CURSOR_DECLARATION_NOT_FOUND", string5, object));
            WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_IC_CURSOR_DECLARATION_NOT_FOUND", string5, object), 10740, this.getClass(), "resolvePositionUpdateCursors");
        }
        this.isConfigStatusChangeReqd_ = false;
        this.replaceablePosUpdateStmtList_.clear();
        this.stmtKeyToCursorMap_.clear();
        this.updateCaptureRecord(xmlFileHelper);
        xmlFileHelper.setRootElement();
    }

    public void checkConfigureStatusAndValidatePackages(XmlFileHelper xmlFileHelper, ArtifactOptionsSet artifactOptionsSet, PrintWriter printWriter) throws SQLException, IOException {
        NodeList nodeList = xmlFileHelper.getRootElement().getElementsByTagName("statementSet");
        int n2 = nodeList.getLength();
        for (int i10 = 0; i10 < n2; ++i10) {
            if (!((Element)nodeList.item(i10)).hasAttribute("configureStatus")) {
                ((Element)nodeList.item(i10)).setAttribute("configureStatus", "REQUIRED");
            }
            if (this.setPreStatusOfAllPkgs_ != null && this.setPreStatusOfAllPkgs_.equalsIgnoreCase("AUTO")) {
                ((Element)nodeList.item(i10)).setAttribute("configureStatus", "AUTO");
            } else if (this.setPreStatusOfAllPkgs_ != null && this.setPreStatusOfAllPkgs_.equalsIgnoreCase("REQUIRED")) {
                ((Element)nodeList.item(i10)).setAttribute("configureStatus", "REQUIRED");
            } else if (this.setPreStatusOfAllPkgs_ != null && this.setPreStatusOfAllPkgs_.equalsIgnoreCase("FINAL")) {
                ((Element)nodeList.item(i10)).setAttribute("configureStatus", "FINAL");
            }
            Node node = nodeList.item(i10);
            Element element = (Element)((Element)node).getElementsByTagName("package").item(0);
            String string = element.getAttribute("name");
            if (string != null && !string.matches("\\s*")) {
                this.checkForPackageNameDuplicationAndLogMessage(xmlFileHelper, string, i10, printWriter);
            }
            this.checkAndPossiblyFixPackage((Element)nodeList.item(i10), artifactOptionsSet, printWriter);
        }
        if (locationMap_ != null || schemaMap_ != null) {
            MetaDataReplacerImpl.runMetaDataReplacer(xmlFileHelper, this.locationMapPairs_, this.schemaMapPairs_, this.showDetails_, printWriter);
        }
        this.validatePackagesWithConfigureStatusFinal(xmlFileHelper, printWriter);
        this.validatePackagesWithConfigureStatusAuto(xmlFileHelper, printWriter);
        this.validatePackagesWithConfigureStatusRequired(xmlFileHelper, printWriter);
        this.configureUnnamedPackages(xmlFileHelper, printWriter);
    }

    public void configurePackages(PureQueryUtility.UtilityResult utilityResult, boolean bl2, XmlFileHelper xmlFileHelper, CentralStoreKey centralStoreKey, ArtifactOptionsSet artifactOptionsSet, PrintWriter printWriter, boolean bl3, ObservedBindPropsGenerator observedBindPropsGenerator) throws FileNotFoundException, IOException, SQLException {
        Object object;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        int n3;
        this.readCommandLineOptionsAndPopulateInstanceVariables(xmlFileHelper, artifactOptionsSet, printWriter);
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(xmlFileHelper.getRootElement(), "statementSet");
        int n4 = arrayList.size();
        if (this.removeInvalidSql_ || this.restoreInvalidSqlForce_ || this.removeInactiveSQLBefore_ != null) {
            for (n3 = 0; n3 < n4; ++n3) {
                Element element = arrayList.get(n3);
                Element element2 = DOMUtil.getFirstChildByName(element, "statements");
                object4 = DOMUtil.getNodesByName(element2, "statement");
                int n5 = ((ArrayList)object4).size();
                if (this.removeInvalidSql_) {
                    String string = element.getAttribute("configureStatus");
                    object3 = (Element)element.getElementsByTagName("package").item(0);
                    object2 = object3.getAttribute("name");
                    boolean bl4 = object2 != null && ((String)object2).trim().length() > 0;
                    for (n2 = 0; n2 < n5; ++n2) {
                        object = (Element)((ArrayList)object4).get(n2);
                        if (StatementBinderHelper.isValidStmt((Element)object)) continue;
                        if (!string.equals("FINAL") || !bl4) {
                            if (object.getParentNode() == null) continue;
                            object.getParentNode().removeChild((Node)object);
                            continue;
                        }
                        String string2 = object.getAttribute("id");
                        WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_CONFIGURE_STMT_NOT_REMOVED", string2), 11142, this.getClass(), "configurePackages");
                    }
                }
                int n6 = 0;
                if (this.restoreInvalidSqlForce_) {
                    for (int i10 = 0; i10 < n5; ++i10) {
                        object2 = (Element)((ArrayList)object4).get(i10);
                        if (StatementBinderHelper.isValidStmt((Element)object2) || !StatementBinderHelper.removeIsValidAttr((Element)object2)) continue;
                        ++n6;
                    }
                }
                if (this.removeInactiveSQLBefore_ == null) continue;
                for (int i11 = 0; i11 < n5; ++i11) {
                    object2 = (Element)((ArrayList)object4).get(i11);
                    if (!StatementBinderHelper.isStmtWithRefQueryAttr((Node)object2)) continue;
                    this.posUpdateStmtsInFile_.add((Element)object2);
                }
            }
        }
        if ((n3 = this.maxMissingSections_) > -1) {
            int n7 = 0;
            block4: for (int i12 = 0; i12 < n4; ++i12) {
                Object object5;
                int n8;
                object4 = arrayList.get(i12);
                String string = object4.getAttribute("configureStatus");
                Element element = (Element)object4.getElementsByTagName("package").item(0);
                object3 = element.getAttribute("name");
                if (object3 == null || ((String)object3).trim().length() <= 0) continue;
                object2 = DOMUtil.getFirstChildByName((Node)object4, "statements");
                ArrayList<Element> arrayList2 = DOMUtil.getNodesByName((Node)object2, "statement");
                n2 = arrayList2.size();
                object = new ArrayList(n2);
                for (n8 = 0; n8 < n2; ++n8) {
                    Element element3 = arrayList2.get(n8);
                    object5 = new Object[]{element3, Integer.parseInt(element3.getAttribute("sectionNumber"))};
                    ((ArrayList)object).add(object5);
                }
                Collections.sort(object, new Comparator<Object[]>(){

                    @Override
                    public int compare(Object[] objectArray, Object[] objectArray2) {
                        int n2 = (Integer)objectArray[1];
                        int n3 = (Integer)objectArray2[1];
                        return n2 - n3;
                    }
                });
                n8 = 0;
                for (int i13 = 0; i13 < n2; ++i13) {
                    int n9;
                    object5 = (Element)((Object[])((ArrayList)object).get(i13))[0];
                    if (!this.isBindableAndIsValid((Element)object5)) continue;
                    int n10 = Integer.parseInt(object5.getAttribute("sectionNumber"));
                    int n11 = 0;
                    String string3 = object5.getAttribute("numReservedSections");
                    if (string3 != null && string3.length() > 0) {
                        n11 = Integer.parseInt(string3);
                    }
                    if ((n8 += (n9 = n10 + n11) - (n7 + n11 + 1)) > 0 && n8 >= n3) {
                        if (!string.equals("FINAL")) {
                            object4.setAttribute("configureStatus", "REQUIRED");
                        } else if (string.equals("FINAL")) {
                            printWriter.println(Messages.getText("MSG_MISSING_SECTIONS_BUT_CANT_MODIFY_FINAL", object3 != null ? object3 : ""));
                        }
                        n7 = 0;
                        continue block4;
                    }
                    n7 = n9;
                }
            }
        }
        if (bl2) {
            this.cleanConfOption_ = true;
            if (this.setPreStatusOfAllPkgs_ != null && (this.setPreStatusOfAllPkgs_.equalsIgnoreCase("AUTO") || this.setPreStatusOfAllPkgs_.equalsIgnoreCase("FINAL"))) {
                printWriter.println(Messages.getText("MSG_STATUS_ALL_PKGS_AUTO", new Object[0]));
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_STATUS_ALL_PKGS_AUTO", new Object[0]), 10853, this.getClass(), "configurePackages");
            }
            for (int i14 = 0; i14 < n4; ++i14) {
                arrayList.get(i14).setAttribute("configureStatus", "REQUIRED");
                Node node = arrayList.get(i14);
                object4 = DOMUtil.getFirstChildByName(node, "package");
                String string = object4.getAttribute("name");
                if (string != null || !string.matches("\\s*")) {
                    object4.setAttribute("name", "");
                }
                this.checkAndPossiblyFixPackage(arrayList.get(i14), artifactOptionsSet, printWriter);
            }
            if (locationMap_ != null || schemaMap_ != null) {
                MetaDataReplacerImpl.runMetaDataReplacer(xmlFileHelper, this.locationMapPairs_, this.schemaMapPairs_, this.showDetails_, printWriter);
            }
            this.configureUnnamedPackages(xmlFileHelper, printWriter);
        } else {
            this.checkConfigureStatusAndValidatePackages(xmlFileHelper, artifactOptionsSet, printWriter);
        }
        StatementBinderHelper.removeEmptyNodes(xmlFileHelper);
        this.updateSETStmtCounts(xmlFileHelper);
        boolean bl5 = xmlFileHelper.userCaresAboutSpecialRegistersInThisFile(this.groupSqlBySpecialRegisters_);
        String string = this.getSpecialRegisterOutput(xmlFileHelper, observedBindPropsGenerator, bl5);
        if (0 < string.length()) {
            printWriter.println(XmlTags.CRLF + string);
            ToolsLogger.getLogger().log(Level.INFO, string);
        }
        if (null != observedBindPropsGenerator) {
            observedBindPropsGenerator.addPureQueryXmlFile(artifactOptionsSet.getArtifactName(), xmlFileHelper, bl5);
            object4 = bl3 ? observedBindPropsGenerator.writeToFile() : observedBindPropsGenerator.getMessageForPrintingObservedBindPropsPathAfterArtifact();
            if (observedBindPropsGenerator.isFailureDetected()) {
                utilityResult.downgradeUtilityResultType(PureQueryUtility.UtilityResultType.FAILURE, (String)object4);
            } else {
                utilityResult.messagesToPrint = object4;
            }
        }
        this.setPostStatusOfStatementSets(xmlFileHelper);
        StatementBinderHelper.cleanDownlevelFiles(xmlFileHelper);
        this.writeModificationsToPureQueryXmlFile(utilityResult, xmlFileHelper, centralStoreKey);
    }

    private void updateDDLList(Element element) {
        Element element2 = DOMUtil.getFirstChildByName(element, "statements");
        ArrayList<Element> arrayList = DOMUtil.getNodesByName(element2, "statement");
        int n2 = arrayList.size();
        for (int i10 = 0; i10 < n2; ++i10) {
            String string;
            Element element3 = arrayList.get(i10);
            String string2 = ((Element)element3.getElementsByTagName("statementType").item(0)).getTextContent();
            if (!StaticProfileCaptureHelper.isDDLStatementTag(string2) || this.ddlList_.contains(string = ((Element)element3.getElementsByTagName("prepareSql").item(0)).getTextContent())) continue;
            this.ddlList_.add(string);
        }
    }

    private void writeModificationsToPureQueryXmlFile(PureQueryUtility.UtilityResult utilityResult, XmlFileHelper xmlFileHelper, CentralStoreKey centralStoreKey) throws FileNotFoundException, IOException, SQLException {
        boolean bl2 = false;
        if (PureQueryUtility.UtilityResultType.FAILURE != utilityResult.utilityResultType) {
            Object object;
            BufferedWriter[] bufferedWriterArray = new BufferedWriter[1];
            bl2 = xmlFileHelper.printToFileIfChanged(xmlFileHelper.getXmlDocument(), centralStoreKey, bufferedWriterArray[0]);
            if (bl2) {
                if (null != this.pkgVersion_) {
                    if (this.pkgVersionForAllStmtSets_ == null) {
                        this.pkgVersionForAllStmtSets_ = StatementUtilities.getPackageVersion(this.pkgVersion_, 0L);
                    }
                    object = this.renameCaptureFileWithVersionAppended(centralStoreKey, this.pkgVersionForAllStmtSets_);
                    xmlFileHelper.printToFile(xmlFileHelper.getXmlDocument(), (CentralStoreKey)object, bufferedWriterArray[0]);
                }
            } else {
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_CONFIGURE_NO_OP", new Object[0]), 11079, this.getClass(), "writeModificationsToPureQueryXmlFile");
            }
            object = this.getDDLFileNameFromCaptureFile(centralStoreKey);
            if (this.ddlList_ != null && !this.ddlList_.isEmpty()) {
                this.createDLLScriptFile((String)object);
            } else {
                this.deleteDDLScriptFile((String)object);
            }
        }
    }

    private void setPostStatusOfStatementSets(XmlFileHelper xmlFileHelper) {
        NodeList nodeList = xmlFileHelper.getRootElement().getElementsByTagName("statementSet");
        int n2 = nodeList.getLength();
        for (int i10 = 0; i10 < n2; ++i10) {
            Element element = (Element)nodeList.item(i10);
            if (PossibleArgs.PredefinedOptionValues.FINAL == this.setPostStatusOfAllPkgs_) {
                element.setAttribute("configureStatus", "FINAL");
                continue;
            }
            if ("FINAL".equalsIgnoreCase(element.getAttribute("configureStatus"))) continue;
            element.setAttribute("configureStatus", "AUTO");
        }
    }

    private String getSpecialRegisterOutput(XmlFileHelper xmlFileHelper, ObservedBindPropsGenerator observedBindPropsGenerator, boolean bl2) {
        int n2 = this.totalSETStmtCount_ - this.totalSETUsedAfterConnectionInitAttributeCount_;
        int n3 = this.totalSETUsedAfterConnectionInitAttributeCount_;
        Boolean bl3 = this.doSQLStatementsInFileUseDifferingSpecialRegisterValuesSets(xmlFileHelper);
        boolean bl4 = null != bl3 && bl3 != false;
        boolean bl5 = bl4 || null == bl3 || 0 < n3;
        String string = XmlTags.CRLF + XmlTags.CRLF;
        StringBuilder stringBuilder = new StringBuilder();
        if (bl5 || 0 < n2) {
            CharSequence charSequence;
            if (0 < n2) {
                charSequence = Messages.getText("MSG_SET_STATEMENT_COUNT_BEFORE_OTHER_SQL_EXECUTION2", n2);
                stringBuilder.append((String)charSequence);
            }
            if (bl5) {
                if (0 < stringBuilder.length()) {
                    stringBuilder.append(string);
                }
                charSequence = new StringBuilder();
                if (!bl2) {
                    ((StringBuilder)charSequence).append(Messages.getText("MSG_WARN", new Object[0])).append(" ");
                }
                if (0 < n3) {
                    ((StringBuilder)charSequence).append(Messages.getText("MSG_SET_STATEMENT_COUNT_AFTER_OTHER_SQL_EXECUTION_PART1", n3));
                    ((StringBuilder)charSequence).append("  ");
                    ((StringBuilder)charSequence).append(Messages.getText("MSG_SET_STATEMENT_COUNT_AFTER_OTHER_SQL_EXECUTION_PART2", new Object[0]));
                } else if (bl4) {
                    ((StringBuilder)charSequence).append(Messages.getText("MSG_STATEMENTS_WITH_DIFFERING_SR_SETTINGS_DEFINITE", new Object[0]));
                } else {
                    ((StringBuilder)charSequence).append(Messages.getText("MSG_STATEMENTS_WITH_DIFFERING_SR_SETTINGS_POSSIBLE", new Object[0]));
                }
                stringBuilder.append(charSequence);
                WarningFactory.createPureQueryWarningForToolsLogOnly(((StringBuilder)charSequence).toString(), 10878, this.getClass(), "getSpecialRegisterOutput");
            }
            if (4 > xmlFileHelper.getPureQueryXmlVersion()) {
                stringBuilder.append(string).append(Messages.getText("MSG_INFO_ABOUT_GROUPSQLBYSPECIALREGISTERS_AND_OBSERVEDBINDPROPS_PUREQUERYXML_VERSION3", "pureQuery Runtime", "IBM InfoSphere Optim pureQuery Runtime", "2.2.0.3", PossibleArgs.GROUPSQLBYSPECIALREGISTERS.externalOptionName(), PossibleArgs.OPTIONS_FILE_FORBIND.externalOptionName()));
            } else if (bl2) {
                if (null == observedBindPropsGenerator) {
                    if (this.groupSqlBySpecialRegisters_) {
                        if (this.cleanConfOption_) {
                            stringBuilder.append(string).append(Messages.getText("MSG_CONFIGURE_SR_GROUPING_DONE_CLEANCONFIGURETRUE", PossibleArgs.GROUPSQLBYSPECIALREGISTERS.externalOptionName(), PossibleArgs.PredefinedOptionValues.TRUE.getOptionValue()));
                        } else {
                            stringBuilder.append(string).append(Messages.getText("MSG_CONFIGURE_SR_GROUPING_DONE_CLEANCONFIGUREFALSE", PossibleArgs.GROUPSQLBYSPECIALREGISTERS.externalOptionName(), PossibleArgs.PredefinedOptionValues.TRUE.getOptionValue()));
                        }
                    } else {
                        stringBuilder.append(string).append(Messages.getText("MSG_CONFIGURE_SR_GROUPING_DONE_GROUPING_EXISTING", PossibleArgs.GROUPSQLBYSPECIALREGISTERS.externalOptionName(), PossibleArgs.PredefinedOptionValues.TRUE.getOptionValue()));
                    }
                    stringBuilder.append(Messages.getText("MSG_CONFIGURE_SR_OBSERVEDBINDPROPS", PossibleArgs.OPTIONS_FILE_FORBIND.externalOptionName()));
                }
            } else {
                charSequence = Messages.getText("MSG_INFO_ABOUT_GROUPSQLBYSPECIALREGISTERS_AND_OBSERVEDBINDPROPS", new Object[]{PossibleArgs.GROUPSQLBYSPECIALREGISTERS.externalOptionName(), PossibleArgs.CLEAN_CONFIGURE.externalOptionName(), PossibleArgs.PredefinedOptionValues.TRUE, PossibleArgs.OPTIONS_FILE_FORBIND.externalOptionName()});
                stringBuilder.append(string).append((String)charSequence);
            }
        }
        return stringBuilder.toString();
    }

    private Boolean doSQLStatementsInFileUseDifferingSpecialRegisterValuesSets(XmlFileHelper xmlFileHelper) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        boolean bl2 = false;
        NodeList nodeList = xmlFileHelper.getRootElement().getElementsByTagName("statementAttributes");
        if (null != nodeList) {
            int n2 = nodeList.getLength();
            for (int i10 = 0; i10 < n2; ++i10) {
                TreeSet<Integer> treeSet2;
                Element element = (Element)nodeList.item(i10);
                TreeSet<Integer> treeSet3 = XmlFileHelper.getAttributeValueIntegerSet(null, element, "specialRegValuesUsed", false, null);
                if (null != treeSet3) {
                    treeSet.addAll(treeSet3);
                }
                if (null != (treeSet2 = XmlFileHelper.getAttributeValueIntegerSet(null, element, "incrementalSpecialRegValuesUsed", false, null))) {
                    treeSet.addAll(treeSet2);
                }
                if (null == treeSet3 && null == treeSet2) {
                    bl2 = true;
                }
                if (1 >= treeSet.size()) continue;
                return true;
            }
        }
        if (1 < treeSet.size()) {
            return true;
        }
        if (bl2) {
            return null;
        }
        return false;
    }

    public static String getDateGiven(String string) {
        String string2 = null;
        if (null != string) {
            try {
                int n2 = Integer.parseInt(string);
                if (n2 > 0) {
                    Duration duration = datatypeFactory_.newDuration(false, 0, 0, n2, 0, 0, 0);
                    XMLGregorianCalendar xMLGregorianCalendar = datatypeFactory_.newXMLGregorianCalendar(new GregorianCalendar());
                    xMLGregorianCalendar.add(duration);
                    xMLGregorianCalendar.setHour(0);
                    xMLGregorianCalendar.setMinute(0);
                    xMLGregorianCalendar.setSecond(0);
                    xMLGregorianCalendar.setMillisecond(0);
                    xMLGregorianCalendar.setFractionalSecond(new BigDecimal(0));
                    string2 = xMLGregorianCalendar.toXMLFormat();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_PROFILER_SQLLIMIT_INTEGER", new Object[]{PossibleArgs.REMOVEINACTIVESQLBEFORE, string}), numberFormatException, 10891);
            }
        }
        return string2;
    }

    private void readCommandLineOptionsAndPopulateInstanceVariables(XmlFileHelper xmlFileHelper, ArtifactOptionsSet artifactOptionsSet, PrintWriter printWriter) throws SQLException {
        this.rootPkgName_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.ROOT_PKG_NAME);
        this.collectionNameGiven_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.COLLECTION, false);
        this.collectionName_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.COLLECTION, true);
        this.pkgVersion_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.PACKAGE_VERSION);
        this.forceSingleBindIsolation_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.FORCE_SINGLE_BIND_ISOLATION);
        boolean bl2 = artifactOptionsSet.isOptionOrArtifactSpecified(PossibleArgs.MARKDDLFORBIND);
        this.markDDL_ = bl2 ? XmlTags.getStringValueOfBoolean(artifactOptionsSet.getOptionValueBoolean(PossibleArgs.MARKDDLFORBIND)) : null;
        this.sqlLimit_ = StatementBinderHelper.getSqlLimit(artifactOptionsSet);
        this.setPostStatusOfAllPkgs_ = artifactOptionsSet.getOptionSingleValueFromPredefinedOptionValues(PossibleArgs.SETPOSTSTATUSOFALLPKGS);
        this.setPreStatusOfAllPkgs_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.SETPRESTATUSOFALLPKGS);
        String string = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.REMOVEINACTIVESQLBEFORE);
        this.groupSqlBySpecialRegisters_ = artifactOptionsSet.getOptionValueBoolean(PossibleArgs.GROUPSQLBYSPECIALREGISTERS);
        String string2 = xmlFileHelper.getRootElement().getAttribute("version");
        this.sqlGroupedByString_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GROUP_SQL_BY_STRINGS);
        if (this.sqlGroupedByString_ != null) {
            this.orderedInputOfStringsForSQLMatch_ = this.returnOrderedMapFromInputOfGroupSQLByStringsOption(printWriter);
        }
        this.sqlGroupedByJavaPackage_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.GROUP_SQL_BY_JAVAPACKAGES);
        if (this.sqlGroupedByJavaPackage_ != null) {
            this.orderedInputOfJavaPackageForSQLMatch_ = this.returnOrderedMapFromInputOfGroupSQLByJavaPackageOption(printWriter);
        }
        if ((string != null || this.groupSqlBySpecialRegisters_ || this.sqlGroupedByString_ != null || this.sqlGroupedByJavaPackage_ != null) && !string2.equals("4")) {
            if (string != null) {
                printWriter.println(Messages.getText("MSG_OPTION_IGNORED_FOR_THIS_VERSION", new Object[]{string2, PossibleArgs.REMOVEINACTIVESQLBEFORE}));
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_OPTION_IGNORED_FOR_THIS_VERSION", new Object[]{string2, PossibleArgs.REMOVEINACTIVESQLBEFORE}), 10854, this.getClass(), "readCommandLineOptionsAndPopulateInstanceVariables");
                string = null;
            }
            if (this.groupSqlBySpecialRegisters_) {
                printWriter.println(Messages.getText("MSG_OPTION_IGNORED_FOR_THIS_VERSION", new Object[]{string2, PossibleArgs.GROUPSQLBYSPECIALREGISTERS}));
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_OPTION_IGNORED_FOR_THIS_VERSION", new Object[]{string2, PossibleArgs.GROUPSQLBYSPECIALREGISTERS}), 10894, this.getClass(), "readCommandLineOptionsAndPopulateInstanceVariables");
                this.groupSqlBySpecialRegisters_ = false;
            }
            if (this.sqlGroupedByString_ != null) {
                printWriter.println(Messages.getText("MSG_OPTION_IGNORED_FOR_THIS_VERSION", new Object[]{string2, PossibleArgs.GROUP_SQL_BY_STRINGS}));
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_OPTION_IGNORED_FOR_THIS_VERSION", new Object[]{string2, PossibleArgs.GROUP_SQL_BY_STRINGS}), 10855, this.getClass(), "readCommandLineOptionsAndPopulateInstanceVariables");
                this.sqlGroupedByString_ = null;
            }
            if (this.sqlGroupedByJavaPackage_ != null) {
                printWriter.println(Messages.getText("MSG_OPTION_IGNORED_FOR_THIS_VERSION", new Object[]{string2, PossibleArgs.GROUP_SQL_BY_JAVAPACKAGES}));
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_OPTION_IGNORED_FOR_THIS_VERSION", new Object[]{string2, PossibleArgs.GROUP_SQL_BY_JAVAPACKAGES}), 11762, this.getClass(), "readCommandLineOptionsAndPopulateInstanceVariables");
                this.sqlGroupedByJavaPackage_ = null;
            }
        }
        this.removeInactiveSQLBefore_ = StatementBinderHelper.getDateGiven(string);
        this.showDetails_ = artifactOptionsSet.getOptionValueBoolean(PossibleArgs.SHOW_DETAILS);
        locationMap_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.LOCATION_MAP);
        if (locationMap_ != null) {
            this.locationMapPairs_ = StatementBinderHelper.getOldAndNewPairs(PossibleArgs.LOCATION_MAP, locationMap_, printWriter);
        }
        if ((schemaMap_ = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.SCHEMA_MAP)) != null) {
            this.schemaMapPairs_ = StatementBinderHelper.getOldAndNewPairs(PossibleArgs.SCHEMA_MAP, schemaMap_, printWriter);
        }
        this.restoreInvalidSqlForce_ = artifactOptionsSet.getOptionValueBoolean(PossibleArgs.RESTORE_INVALID_SQL_FORCE);
        this.removeInvalidSql_ = artifactOptionsSet.getOptionValueBoolean(PossibleArgs.REMOVE_INVALID_SQL);
        String string3 = artifactOptionsSet.getOptionOrArtifactSingleValue(PossibleArgs.MAX_MISSING_SECTIONS);
        if (string3 != null) {
            try {
                this.maxMissingSections_ = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(PossibleArgs.MAX_MISSING_SECTIONS.errorMessage(Tool.CONFIGURE), exception, 11129);
            }
        }
    }

    private static boolean isDelimited(String string) {
        return string.startsWith("\"") || string.startsWith("'");
    }

    private static boolean isNonDelimited(String string) {
        return !string.startsWith("\"") && !string.startsWith("'");
    }

    public static HashMap<String, String> getOldAndNewPairs(PossibleArgs possibleArgs, String string, PrintWriter printWriter) throws SQLException {
        String string2 = "()>";
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        int n3 = 0;
        String string5 = null;
        String string6 = null;
        boolean bl2 = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        EscapeLexer escapeLexer = new EscapeLexer(string, string2);
        while (escapeLexer.hasMoreTokensRecognizeDoubleQuotedStrings(string2)) {
            string3 = escapeLexer.getNextTokenInReplacerOptions();
            if (string3.equals("(")) {
                if (string4 != null && !string4.equals(")") && !string4.equals("(")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_MAP", new Object[]{string, possibleArgs}), null, 11134);
                }
                ++n2;
            } else if (string3.equals(">")) {
                if (string4 == null || string4.equals("(") || string4.equals(")") || string4.equals(">")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_MAP", new Object[]{string, possibleArgs}), null, 11135);
                }
            } else if (string3.equals(")")) {
                if (string4 == null || string4.equals("(") || string4.equals(">")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_MAP", new Object[]{string, possibleArgs}), null, 11136);
                }
                ++n3;
            } else {
                if (string4 == null) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_MAP", new Object[]{string, possibleArgs}), null, 11206);
                }
                if (string4.equals(")")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_MAP", new Object[]{string, possibleArgs}), null, 11137);
                }
                if (string4.equals("(")) {
                    if (StatementBinderHelper.isDelimited(string3)) {
                        if (string3.substring(1, string3.length() - 1).contains("\"\"") || string3.substring(1, string3.length() - 1).contains("''")) {
                            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_MAP_WITH_QUOTES", new Object[]{possibleArgs, string3}), null, 11231);
                        }
                        string5 = string3.trim();
                    } else {
                        string5 = string3.toUpperCase().trim();
                    }
                }
                if (string4.equals(">")) {
                    if (StatementBinderHelper.isDelimited(string3) && (string3.substring(1, string3.length() - 1).contains("\"\"") || string3.substring(1, string3.length() - 1).contains("''"))) {
                        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_MAP_WITH_QUOTES", new Object[]{possibleArgs, string3}), null, 11232);
                    }
                    string6 = string3.trim();
                }
                if (!(string5 == null || string6 == null || string5.equals("\"\"") || string6.equals("\"\"") || string5.equals("''") || string6.equals("''"))) {
                    if (hashMap.containsKey(string5)) {
                        printWriter.println(Messages.getText("MSG_WARN_DUPLICATE_MAP", new Object[]{possibleArgs, string5}));
                        WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_WARN_DUPLICATE_MAP", new Object[]{possibleArgs, string5}), 11141, StatementBinderHelper.class.getClass(), "getOldAndNewPairs");
                    }
                    if (string5.startsWith("\"") && !string6.startsWith("\"") || !string5.startsWith("\"") && string6.startsWith("\"") || string5.startsWith("'") && !string6.startsWith("'") || !string5.startsWith("'") && string6.startsWith("'")) {
                        throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_MAPPING", new Object[]{string, possibleArgs, "pureQuery Runtime"}), null, 11140);
                    }
                    hashMap.put(string5, string6);
                    string5 = null;
                    string6 = null;
                } else if ((string5 != null && (string5.equals("\"\"") || string5.equals("''")) || string6 != null && (string6.equals("\"\"") || string6.equals("''"))) && !bl2) {
                    printWriter.println(Messages.getText("MSG_WARN_MAP_IGNORED", new Object[]{possibleArgs, string}));
                    WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_WARN_MAP_IGNORED", new Object[]{possibleArgs, string}), 11233, StatementBinderHelper.class.getClass(), "getOldAndNewPairs");
                    bl2 = true;
                }
            }
            string4 = string3;
        }
        if (n2 != n3) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_MAP", new Object[]{string, possibleArgs}), null, 11138);
        }
        Set set = hashMap.keySet();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (String string7 : set) {
            if (string7 == null) continue;
            String string8 = hashMap.get(string7);
            if (StatementBinderHelper.isNonDelimited(string7) && StatementBinderHelper.isNonDelimited(string8)) {
                if (!hashMap.containsKey("\"" + string7.toUpperCase() + "\"")) {
                    hashMap2.put("\"" + string7.toUpperCase() + "\"", "\"" + string8.toUpperCase() + "\"");
                }
                if (!hashMap.containsKey("'" + string7.toUpperCase() + "'")) {
                    hashMap2.put("'" + string7.toUpperCase() + "'", "'" + string8.toUpperCase() + "'");
                }
            }
            if (string7.startsWith("'") && string8.startsWith("'") && !hashMap.containsKey("\"" + string7.substring(1, string7.length() - 1) + "\"")) {
                hashMap2.put("\"" + string7.substring(1, string7.length() - 1) + "\"", "\"" + string8.substring(1, string8.length() - 1) + "\"");
            }
            if (!string7.startsWith("\"") || !string8.startsWith("\"") || hashMap.containsKey("'" + string7.substring(1, string7.length() - 1) + "'")) continue;
            hashMap2.put("'" + string7.substring(1, string7.length() - 1) + "'", "'" + string8.substring(1, string8.length() - 1) + "'");
        }
        hashMap.putAll(hashMap2);
        return hashMap;
    }

    public List<Element> groupSQLsMatchedByStringsIntoStatementsSets(XmlFileHelper xmlFileHelper, Element element) throws SQLException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        String string = "false";
        LinkedHashMap<Integer, Element> linkedHashMap = new LinkedHashMap<Integer, Element>();
        Element element2 = DOMUtil.getFirstChildByName(element, "statements");
        ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element2, "statement");
        Element element3 = (Element)element.getElementsByTagName("package").item(0);
        String string2 = null;
        String string3 = null;
        if (element3.hasAttribute("SQLGroupedBySpecialRegisters")) {
            string2 = element3.getAttribute("SQLGroupedBySpecialRegisters");
        }
        if (element3.hasAttribute("isDDLPackage")) {
            string = element3.getAttribute("isDDLPackage");
        }
        Element element4 = null;
        String string4 = null;
        Element element5 = null;
        boolean bl2 = false;
        int n2 = this.orderedInputOfStringsForSQLMatch_.size();
        int n3 = 0;
        int n4 = arrayList2.size();
        for (int i10 = 0; i10 < n4; ++i10) {
            element4 = arrayList2.get(i10);
            Element element6 = (Element)element4.getElementsByTagName("prepareSql").item(0);
            String string5 = element6.getTextContent();
            EscapeLexer escapeLexer = new EscapeLexer(string5);
            string4 = escapeLexer.upperCaseSQLNotInQuotedString();
            bl2 = false;
            Iterator<String> iterator = this.orderedInputOfStringsForSQLMatch_.keySet().iterator();
            for (n3 = 0; n3 < n2 && !bl2; ++n3) {
                String string6 = iterator.next();
                if (!string4.contains(string6)) continue;
                bl2 = true;
                if (linkedHashMap.size() > 0 && (element5 = (Element)linkedHashMap.get(this.orderedInputOfStringsForSQLMatch_.get(string6))) != null) {
                    this.moveStatement(xmlFileHelper, element5, element4);
                    continue;
                }
                element5 = string.equals("true") ? this.initDDLStmtSet(xmlFileHelper, string2, this.xmlTagsForSqlGroupedByString_.get(this.orderedInputOfStringsForSQLMatch_.get(string6)), string3) : this.initBindableStmtSet(xmlFileHelper, string2, this.xmlTagsForSqlGroupedByString_.get(this.orderedInputOfStringsForSQLMatch_.get(string6)), string3);
                this.moveStatement(xmlFileHelper, element5, element4);
                arrayList.add(element5);
                linkedHashMap.put(this.orderedInputOfStringsForSQLMatch_.get(string6), element5);
            }
            if (bl2) continue;
            if (linkedHashMap.size() > 0 && (element5 = (Element)linkedHashMap.get(-999)) != null) {
                this.moveStatement(xmlFileHelper, element5, element4);
                continue;
            }
            element5 = string.equals("true") ? this.initDDLStmtSet(xmlFileHelper, string2, "*NO_MATCH_FOUND*", string3) : this.initBindableStmtSet(xmlFileHelper, string2, "*NO_MATCH_FOUND*", string3);
            this.moveStatement(xmlFileHelper, element5, element4);
            arrayList.add(element5);
            linkedHashMap.put(-999, element5);
        }
        return arrayList;
    }

    private LinkedHashMap<String, Integer> returnOrderedMapFromInputOfGroupSQLByStringsOption(PrintWriter printWriter) throws SQLException {
        String string;
        String string2 = "()|";
        EscapeLexer escapeLexer = new EscapeLexer(this.sqlGroupedByString_, string2);
        String string3 = null;
        int n2 = -1;
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = 0;
        String string4 = null;
        while (escapeLexer.hasMoreTokens()) {
            string3 = escapeLexer.nextToken();
            if (string3.equals("(")) {
                if (string4 != null && !string4.equals(")") && !string4.equals("(")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_GROUPBYSQL", this), null, 10856);
                }
                ++n2;
                ++n3;
            } else if (string3.equals("|")) {
                if (string4 == null || string4.equals("(") || string4.equals(")")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_GROUPBYSQL", this), null, 10857);
                }
            } else if (string3.equals(")")) {
                if (string4 == null || string4.equals("(") || string4.equals("|")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_GROUPBYSQL", this), null, 10858);
                }
                ++n4;
            } else {
                if (string4.equals(")")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_GROUPBYSQL", this), null, 10859);
                }
                if (string3.contains("\"")) {
                    EscapeLexer escapeLexer2 = new EscapeLexer(string3);
                    string = escapeLexer2.upperCaseSQLNotInQuotedString();
                    if (linkedHashMap.get(string.trim()) == null) {
                        linkedHashMap.put(string.trim(), n2);
                        arrayList.add(string.trim());
                    } else {
                        printWriter.println(Messages.getText("MSG_DUPLICATE_STRING_IN_GROUPBYSQL", string3));
                        WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_DUPLICATE_STRING_IN_GROUPBYSQL", string), 10860, this.getClass(), "returnOrderedMapFromInputOfGroupSQLByStringsOption");
                    }
                } else if (linkedHashMap.get(string3.trim()) == null) {
                    linkedHashMap.put(string3.trim().toUpperCase(), n2);
                    arrayList.add(string3.trim().toUpperCase());
                } else {
                    printWriter.println(Messages.getText("MSG_DUPLICATE_STRING_IN_GROUPBYSQL", string3));
                    WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_DUPLICATE_STRING_IN_GROUPBYSQL", string3), 10861, this.getClass(), "returnOrderedMapFromInputOfGroupSQLByStringsOption");
                }
            }
            string4 = string3;
        }
        if (n3 != n4) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_INPUT_STRING_IN_GROUPBYSQL", this), null, 10862);
        }
        this.xmlTagsForSqlGroupedByString_ = this.buildMapOfXmlTag(arrayList, linkedHashMap);
        for (int i10 = 0; i10 < arrayList.size(); ++i10) {
            string = (String)arrayList.get(i10);
            for (int i11 = i10 + 1; i11 < arrayList.size(); ++i11) {
                if (!((String)arrayList.get(i11)).contains(string)) continue;
                printWriter.println(Messages.getText("MSG_MATCHES_PREVIOUS_STRING_IN_GROUPBYSQL", string, arrayList.get(i11)));
                WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_MATCHES_PREVIOUS_STRING_IN_GROUPBYSQL", string, arrayList.get(i11)), 10863, this.getClass(), "returnOrderedMapFromInputOfGroupSQLByStringsOption");
            }
        }
        return linkedHashMap;
    }

    private HashMap<Integer, String> buildMapOfXmlTag(List<String> list, LinkedHashMap<String, Integer> linkedHashMap) {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        String string = "";
        int n2 = 0;
        int n3 = -1;
        String string2 = null;
        for (int i10 = 0; i10 < list.size(); ++i10) {
            string2 = list.get(i10);
            n2 = linkedHashMap.get(string2);
            if (n3 == -1) {
                string = string2;
            } else if (n2 == n3) {
                string = string + "|" + string2;
            } else {
                hashMap.put(n3, string);
                string = string2;
            }
            n3 = n2;
            hashMap.put(n3, string);
        }
        return hashMap;
    }

    public List<Element> groupSQLsMatchedByJavaPackageIntoStatementsSets(XmlFileHelper xmlFileHelper, Element element) throws SQLException {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        String string = "false";
        LinkedHashMap<Integer, Element> linkedHashMap = new LinkedHashMap<Integer, Element>();
        Element element2 = DOMUtil.getFirstChildByName(element, "statements");
        ArrayList<Element> arrayList2 = DOMUtil.getNodesByName(element2, "statement");
        Element element3 = (Element)element.getElementsByTagName("package").item(0);
        String string2 = null;
        String string3 = null;
        if (element3.hasAttribute("SQLGroupedBySpecialRegisters")) {
            string2 = element3.getAttribute("SQLGroupedBySpecialRegisters");
        }
        if (element3.hasAttribute("SQLGroupedByStrings")) {
            string3 = element3.getAttribute("SQLGroupedByStrings");
        }
        if (element3.hasAttribute("isDDLPackage")) {
            string = element3.getAttribute("isDDLPackage");
        }
        Element element4 = null;
        String string4 = null;
        Element element5 = null;
        int n2 = arrayList2.size();
        int n3 = this.orderedInputOfJavaPackageForSQLMatch_.size();
        boolean bl2 = false;
        NodeList nodeList = null;
        String string5 = null;
        for (int i10 = 0; i10 < n2; ++i10) {
            element4 = arrayList2.get(i10);
            Element element6 = (Element)element4.getElementsByTagName("sqlDefinitionStackTraces").item(0);
            if (element6 != null) {
                nodeList = element6.getElementsByTagName("traceEntry");
                int n4 = 0;
                while (n4 < nodeList.getLength() && !bl2) {
                    Element element7;
                    if ((element7 = (Element)nodeList.item(n4++)) == null) continue;
                    String string6 = element7.getAttribute("containingPkg");
                    string4 = string6.trim();
                    Iterator<String> iterator = this.orderedInputOfJavaPackageForSQLMatch_.keySet().iterator();
                    for (int i11 = 0; i11 < n3 && !bl2; ++i11) {
                        string5 = iterator.next();
                        if (string5.endsWith("*") && string5.length() > 1) {
                            String string7 = string5.substring(0, string5.length() - 1);
                            if (!string4.startsWith(string7)) continue;
                            bl2 = true;
                            continue;
                        }
                        if (!string4.equals(string5)) continue;
                        bl2 = true;
                    }
                }
                if (bl2) {
                    if (linkedHashMap.size() > 0 && (element5 = linkedHashMap.get(this.orderedInputOfJavaPackageForSQLMatch_.get(string5))) != null) {
                        this.moveStatement(xmlFileHelper, element5, element4);
                    } else {
                        element5 = string.equals("true") ? this.initDDLStmtSet(xmlFileHelper, string2, string3, this.xmlTagsForSqlGroupedByJavaPackage_.get(this.orderedInputOfJavaPackageForSQLMatch_.get(string5))) : this.initBindableStmtSet(xmlFileHelper, string2, string3, this.xmlTagsForSqlGroupedByJavaPackage_.get(this.orderedInputOfJavaPackageForSQLMatch_.get(string5)));
                        this.moveStatement(xmlFileHelper, element5, element4);
                        arrayList.add(element5);
                        linkedHashMap.put(this.orderedInputOfJavaPackageForSQLMatch_.get(string5), element5);
                    }
                } else {
                    this.printNoMatchFound(linkedHashMap, xmlFileHelper, element5, element4, string2, string3, string, arrayList);
                }
            } else {
                this.printNoMatchFound(linkedHashMap, xmlFileHelper, element5, element4, string2, string3, string, arrayList);
            }
            bl2 = false;
        }
        return arrayList;
    }

    public void printNoMatchFound(LinkedHashMap<Integer, Element> linkedHashMap, XmlFileHelper xmlFileHelper, Element element, Element element2, String string, String string2, String string3, List<Element> list) {
        if (linkedHashMap.size() > 0 && (element = linkedHashMap.get(-999)) != null) {
            this.moveStatement(xmlFileHelper, element, element2);
        } else {
            element = string3.equals("true") ? this.initDDLStmtSet(xmlFileHelper, string, string2, "*NO_MATCH_FOUND*") : this.initBindableStmtSet(xmlFileHelper, string, string2, "*NO_MATCH_FOUND*");
            this.moveStatement(xmlFileHelper, element, element2);
            list.add(element);
            linkedHashMap.put(-999, element);
        }
    }

    private LinkedHashMap<String, Integer> returnOrderedMapFromInputOfGroupSQLByJavaPackageOption(PrintWriter printWriter) throws SQLException {
        String string = "()|";
        EscapeLexer escapeLexer = new EscapeLexer(this.sqlGroupedByJavaPackage_, string);
        String string2 = null;
        int n2 = -1;
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        int n4 = 0;
        String string3 = null;
        while (escapeLexer.hasMoreTokens()) {
            string2 = escapeLexer.nextToken().trim();
            if (string2.endsWith(".") || string2.startsWith(".") || string2.startsWith("*")) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GROUPBYJAVAPACKAGE_STRING", "-groupSQLByJavaPackages", this.sqlGroupedByJavaPackage_, this), null, 11763);
            }
            if (string2.endsWith("*") && string2.length() > 1 && string2.charAt(string2.length() - 2) != '.') {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GROUPBYJAVAPACKAGE_STRING", "-groupSQLByJavaPackages", this.sqlGroupedByJavaPackage_, this), null, 11764);
            }
            if (string2.equals("(")) {
                if (string3 != null && !string3.equals(")") && !string3.equals("(")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GROUPBYJAVAPACKAGE_STRING", "-groupSQLByJavaPackages", this.sqlGroupedByJavaPackage_, this), null, 11765);
                }
                ++n2;
                ++n3;
            } else if (string2.equals("|")) {
                if (string3 == null || string3.equals("(") || string3.equals(")")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GROUPBYJAVAPACKAGE_STRING", "-groupSQLByJavaPackages", this.sqlGroupedByJavaPackage_, this), null, 11766);
                }
            } else if (string2.equals(")")) {
                if (string3 == null || string3.equals("(") || string3.equals("|")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GROUPBYJAVAPACKAGE_STRING", "-groupSQLByJavaPackages", this.sqlGroupedByJavaPackage_, this), null, 11767);
                }
                ++n4;
            } else if (string3 != null) {
                if (string3.equals(")")) {
                    throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GROUPBYJAVAPACKAGE_STRING", "-groupSQLByJavaPackages", this.sqlGroupedByJavaPackage_, this), null, 11768);
                }
                boolean bl2 = false;
                String string4 = null;
                String string5 = null;
                for (int i10 = 0; i10 < arrayList.size(); ++i10) {
                    String string6 = (String)arrayList.get(i10);
                    if (string6 == null) continue;
                    if (string6.equals(string2)) {
                        bl2 = true;
                        string4 = string2;
                        string5 = string6;
                        continue;
                    }
                    if (!string6.endsWith("*") || string6.length() <= 2 || !string2.startsWith(string6.substring(0, string6.length() - 1))) continue;
                    bl2 = true;
                    string4 = string2;
                    string5 = string6;
                }
                if (linkedHashMap.get(string2) == null && !bl2) {
                    linkedHashMap.put(string2, n2);
                    arrayList.add(string2);
                } else if (string4.equals(string5)) {
                    printWriter.println(Messages.getText("MSG_DUPLICATE_STRING_IN_GROUPBYJAVAPACKAGE", "-groupSQLByJavaPackages " + this.sqlGroupedByJavaPackage_, string5, string4));
                    WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_DUPLICATE_STRING_IN_GROUPBYJAVAPACKAGE", "-groupSQLByJavaPackages " + this.sqlGroupedByJavaPackage_, string5, string4), 11769, this.getClass(), "returnOrderedMapFromInputOfGroupSQLByStringsOption");
                } else {
                    printWriter.println(Messages.getText("MSG_MATCHES_PREVIOUS_STRING_IN_GROUPBYJAVAPACKAGE", "-groupSQLByJavaPackages " + this.sqlGroupedByJavaPackage_, string5, string4));
                    WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("MSG_MATCHES_PREVIOUS_STRING_IN_GROUPBYJAVAPACKAGE", "-groupSQLByJavaPackages " + this.sqlGroupedByJavaPackage_ + " ", string5, string4), 11770, this.getClass(), "returnOrderedMapFromInputOfGroupSQLByStringsOption");
                }
            }
            string3 = string2;
        }
        if (n3 != n4) {
            throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_GROUPBYJAVAPACKAGE_STRING", "-groupSQLByJavaPackages", this.sqlGroupedByJavaPackage_, this), null, 11771);
        }
        this.xmlTagsForSqlGroupedByJavaPackage_ = this.buildMapOfXmlTag(arrayList, linkedHashMap);
        return linkedHashMap;
    }

    static {
        ClassLoader classLoader = null;
        try {
            classLoader = XmlFileHelper.changeContextClassLoader(XmlFileHelper.class.getClassLoader(), true);
            datatypeFactory_ = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new RuntimeException(Messages.getText("ERR_PROFILER_INTIALIZING_CAPTURE_STATEMENT_CLASS", new Object[0]), datatypeConfigurationException);
        }
        finally {
            if (null != classLoader) {
                XmlFileHelper.setContextClassloader(classLoader);
            }
        }
    }

    class StmtCursorInfo {
        String stmtKey_;
        Node stmtSet_;

        private StmtCursorInfo(String string, Node node) {
            this.stmtKey_ = string;
            this.stmtSet_ = node;
        }

        private Node getStmtSet() {
            return this.stmtSet_;
        }
    }

    private static enum ConfigureResult {
        NO_CHANGE_NEEDED,
        CHANGED,
        CHANGE_NEEDED_BUT_FINAL;


        public void checkConfigureResult(ConfigureStatusValues configureStatusValues) {
            if (CHANGED == this && ConfigureStatusValues.FINAL == configureStatusValues || CHANGE_NEEDED_BUT_FINAL == this && ConfigureStatusValues.FINAL != configureStatusValues) {
                throw ExceptionFactory.createDataRuntimeExceptionForToolsOnly(Messages.getText("ERR_INVALID_SWITCH_CASE", new Object[]{this}), null, 10816);
            }
        }
    }

    public static enum SQLGroupedBySpecialRegistersValues {
        NO_SRINFO("NO_SRINFO", "NO_SRINFO", null, true, false),
        MULTI_SRINFO("MULTI_SRINFO", "MULTI_SRINFO", PossibleArgs.PredefinedOptionValues.MULTIPLE_SPECIAL_REGISTER_VALUES_SETS, true, true),
        INCONSISTENT_SRINFO("INCONSISTENT_SRINFO", "INCONSISTENT_SRINFO", PossibleArgs.PredefinedOptionValues.SPECIAL_REGISTER_GROUPING_INCONSISTENT, true, true),
        NOT_GROUPED(null, "NOT_GROUPED", null, true, false);

        public final String xmlStringValue_;
        public final String tokenInObservedBindProps_;
        public final PossibleArgs.PredefinedOptionValues configureWarningValue_;
        public final boolean indicatesAWarningCondition_;
        public final boolean searchStatementsAndListFoundSRValuesSets_;

        private SQLGroupedBySpecialRegistersValues(String string2, String string3, PossibleArgs.PredefinedOptionValues predefinedOptionValues, boolean bl2, boolean bl3) {
            this.xmlStringValue_ = string2;
            this.tokenInObservedBindProps_ = string3;
            this.configureWarningValue_ = predefinedOptionValues;
            this.indicatesAWarningCondition_ = bl2;
            this.searchStatementsAndListFoundSRValuesSets_ = bl3;
        }

        public static SQLGroupedBySpecialRegistersValues getValueOf(String string) {
            if (null == string || !XmlFileHelper.isAttributeSet(string)) {
                return NOT_GROUPED;
            }
            for (SQLGroupedBySpecialRegistersValues sQLGroupedBySpecialRegistersValues : SQLGroupedBySpecialRegistersValues.values()) {
                if (!string.equalsIgnoreCase(sQLGroupedBySpecialRegistersValues.xmlStringValue_)) continue;
                return sQLGroupedBySpecialRegistersValues;
            }
            return null;
        }

        public static Integer getValueOfInteger(String string) {
            Integer n2 = null;
            if (null != string) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return n2;
        }

        public String toString() {
            return this.xmlStringValue_;
        }
    }

    public static enum ConfigureStatusValues {
        FINAL("FINAL"),
        AUTO("AUTO"),
        REQUIRED("REQUIRED");

        public final String xmlStringValue_;

        private ConfigureStatusValues(String string2) {
            this.xmlStringValue_ = string2;
        }

        public static ConfigureStatusValues getValueOf(String string) {
            if (null == string || "" == string) {
                return REQUIRED;
            }
            for (ConfigureStatusValues configureStatusValues : ConfigureStatusValues.values()) {
                if (!configureStatusValues.xmlStringValue_.equalsIgnoreCase(string)) continue;
                return configureStatusValues;
            }
            return REQUIRED;
        }

        public String toString() {
            return this.xmlStringValue_;
        }
    }
}

