/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jpountz.lz4.LZ4ByteBufferUtils;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Constants;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4UnsafeUtils;
import net.jpountz.lz4.LZ4Utils;
import net.jpountz.util.ByteBufferUtils;
import net.jpountz.util.UnsafeUtils;

final class LZ4JavaUnsafeCompressor
extends LZ4Compressor {
    public static final LZ4Compressor INSTANCE = new LZ4JavaUnsafeCompressor();

    LZ4JavaUnsafeCompressor() {
    }

    static int compress64k(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        int n6 = n2 + n3;
        int n7 = n6 - 5;
        int n8 = n6 - 12;
        int n9 = n2;
        int n10 = n4;
        int n11 = n9++;
        if (n3 >= 13) {
            short[] sArray = new short[8192];
            block0: while (true) {
                int n12;
                int n13;
                int n14 = n9;
                int n15 = 1;
                int n16 = 1 << LZ4Constants.SKIP_STRENGTH;
                do {
                    n9 = n14;
                    if ((n14 += (n15 = n16++ >>> LZ4Constants.SKIP_STRENGTH)) > n8) break block0;
                    n12 = LZ4Utils.hash64k(UnsafeUtils.readInt(byArray, n9));
                    n13 = n2 + UnsafeUtils.readShort(sArray, n12);
                    UnsafeUtils.writeShort(sArray, n12, n9 - n2);
                } while (!LZ4UnsafeUtils.readIntEquals(byArray, n13, n9));
                n12 = LZ4UnsafeUtils.commonBytesBackward(byArray, n13, n9, n2, n11);
                n13 -= n12;
                int n17 = (n9 -= n12) - n11;
                int n18 = n10++;
                if (n10 + n17 + 8 + (n17 >>> 8) > n5) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                if (n17 >= 15) {
                    UnsafeUtils.writeByte(byArray2, n18, 240);
                    n10 = LZ4UnsafeUtils.writeLen(n17 - 15, byArray2, n10);
                } else {
                    UnsafeUtils.writeByte(byArray2, n18, n17 << 4);
                }
                LZ4UnsafeUtils.wildArraycopy(byArray, n11, byArray2, n10, n17);
                n10 += n17;
                while (true) {
                    UnsafeUtils.writeShortLE(byArray2, n10, (short)(n9 - n13));
                    int n19 = LZ4UnsafeUtils.commonBytes(byArray, n13 += 4, n9 += 4, n7);
                    if ((n10 += 2) + 6 + (n19 >>> 8) > n5) {
                        throw new LZ4Exception("maxDestLen is too small");
                    }
                    n9 += n19;
                    if (n19 >= 15) {
                        UnsafeUtils.writeByte(byArray2, n18, UnsafeUtils.readByte(byArray2, n18) | 0xF);
                        n10 = LZ4UnsafeUtils.writeLen(n19 - 15, byArray2, n10);
                    } else {
                        UnsafeUtils.writeByte(byArray2, n18, UnsafeUtils.readByte(byArray2, n18) | n19);
                    }
                    if (n9 > n8) {
                        n11 = n9;
                        break block0;
                    }
                    UnsafeUtils.writeShort(sArray, LZ4Utils.hash64k(UnsafeUtils.readInt(byArray, n9 - 2)), n9 - 2 - n2);
                    int n20 = LZ4Utils.hash64k(UnsafeUtils.readInt(byArray, n9));
                    n13 = n2 + UnsafeUtils.readShort(sArray, n20);
                    UnsafeUtils.writeShort(sArray, n20, n9 - n2);
                    if (!LZ4UnsafeUtils.readIntEquals(byArray, n9, n13)) break;
                    n18 = n10++;
                    UnsafeUtils.writeByte(byArray2, n18, 0);
                }
                n11 = n9++;
            }
        }
        n10 = LZ4UnsafeUtils.lastLiterals(byArray, n11, n6 - n11, byArray2, n10, n5);
        return n10 - n4;
    }

    @Override
    public int compress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4, int n5) {
        UnsafeUtils.checkRange(byArray, n2, n3);
        UnsafeUtils.checkRange(byArray2, n4, n5);
        int n6 = n4 + n5;
        if (n3 < 65547) {
            return LZ4JavaUnsafeCompressor.compress64k(byArray, n2, n3, byArray2, n4, n6);
        }
        int n7 = n2 + n3;
        int n8 = n7 - 5;
        int n9 = n7 - 12;
        int n10 = n2;
        int n11 = n4;
        int n12 = n10++;
        int[] nArray = new int[4096];
        Arrays.fill(nArray, n12);
        block0: while (true) {
            int n13;
            int n14;
            int n15;
            int n16 = n10;
            int n17 = 1;
            int n18 = 1 << LZ4Constants.SKIP_STRENGTH;
            do {
                n10 = n16;
                if ((n16 += (n17 = n18++ >>> LZ4Constants.SKIP_STRENGTH)) > n9) break block0;
                n13 = LZ4Utils.hash(UnsafeUtils.readInt(byArray, n10));
                n14 = UnsafeUtils.readInt(nArray, n13);
                n15 = n10 - n14;
                UnsafeUtils.writeInt(nArray, n13, n10);
            } while (n15 >= 65536 || !LZ4UnsafeUtils.readIntEquals(byArray, n14, n10));
            n13 = LZ4UnsafeUtils.commonBytesBackward(byArray, n14, n10, n2, n12);
            n14 -= n13;
            int n19 = (n10 -= n13) - n12;
            int n20 = n11++;
            if (n11 + n19 + 8 + (n19 >>> 8) > n6) {
                throw new LZ4Exception("maxDestLen is too small");
            }
            if (n19 >= 15) {
                UnsafeUtils.writeByte(byArray2, n20, 240);
                n11 = LZ4UnsafeUtils.writeLen(n19 - 15, byArray2, n11);
            } else {
                UnsafeUtils.writeByte(byArray2, n20, n19 << 4);
            }
            LZ4UnsafeUtils.wildArraycopy(byArray, n12, byArray2, n11, n19);
            n11 += n19;
            while (true) {
                UnsafeUtils.writeShortLE(byArray2, n11, n15);
                int n21 = LZ4UnsafeUtils.commonBytes(byArray, n14 + 4, n10 += 4, n8);
                if ((n11 += 2) + 6 + (n21 >>> 8) > n6) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                n10 += n21;
                if (n21 >= 15) {
                    UnsafeUtils.writeByte(byArray2, n20, UnsafeUtils.readByte(byArray2, n20) | 0xF);
                    n11 = LZ4UnsafeUtils.writeLen(n21 - 15, byArray2, n11);
                } else {
                    UnsafeUtils.writeByte(byArray2, n20, UnsafeUtils.readByte(byArray2, n20) | n21);
                }
                if (n10 > n9) {
                    n12 = n10;
                    break block0;
                }
                UnsafeUtils.writeInt(nArray, LZ4Utils.hash(UnsafeUtils.readInt(byArray, n10 - 2)), n10 - 2);
                int n22 = LZ4Utils.hash(UnsafeUtils.readInt(byArray, n10));
                n14 = UnsafeUtils.readInt(nArray, n22);
                UnsafeUtils.writeInt(nArray, n22, n10);
                n15 = n10 - n14;
                if (n15 >= 65536 || !LZ4UnsafeUtils.readIntEquals(byArray, n14, n10)) break;
                n20 = n11++;
                UnsafeUtils.writeByte(byArray2, n20, 0);
            }
            n12 = n10++;
        }
        n11 = LZ4UnsafeUtils.lastLiterals(byArray, n12, n7 - n12, byArray2, n11, n6);
        return n11 - n4;
    }

    static int compress64k(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        int n6 = n2 + n3;
        int n7 = n6 - 5;
        int n8 = n6 - 12;
        int n9 = n2;
        int n10 = n4;
        int n11 = n9++;
        if (n3 >= 13) {
            short[] sArray = new short[8192];
            block0: while (true) {
                int n12;
                int n13;
                int n14 = n9;
                int n15 = 1;
                int n16 = 1 << LZ4Constants.SKIP_STRENGTH;
                do {
                    n9 = n14;
                    if ((n14 += (n15 = n16++ >>> LZ4Constants.SKIP_STRENGTH)) > n8) break block0;
                    n12 = LZ4Utils.hash64k(ByteBufferUtils.readInt(byteBuffer, n9));
                    n13 = n2 + UnsafeUtils.readShort(sArray, n12);
                    UnsafeUtils.writeShort(sArray, n12, n9 - n2);
                } while (!LZ4ByteBufferUtils.readIntEquals(byteBuffer, n13, n9));
                n12 = LZ4ByteBufferUtils.commonBytesBackward(byteBuffer, n13, n9, n2, n11);
                n13 -= n12;
                int n17 = (n9 -= n12) - n11;
                int n18 = n10++;
                if (n10 + n17 + 8 + (n17 >>> 8) > n5) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                if (n17 >= 15) {
                    ByteBufferUtils.writeByte(byteBuffer2, n18, 240);
                    n10 = LZ4ByteBufferUtils.writeLen(n17 - 15, byteBuffer2, n10);
                } else {
                    ByteBufferUtils.writeByte(byteBuffer2, n18, n17 << 4);
                }
                LZ4ByteBufferUtils.wildArraycopy(byteBuffer, n11, byteBuffer2, n10, n17);
                n10 += n17;
                while (true) {
                    ByteBufferUtils.writeShortLE(byteBuffer2, n10, (short)(n9 - n13));
                    int n19 = LZ4ByteBufferUtils.commonBytes(byteBuffer, n13 += 4, n9 += 4, n7);
                    if ((n10 += 2) + 6 + (n19 >>> 8) > n5) {
                        throw new LZ4Exception("maxDestLen is too small");
                    }
                    n9 += n19;
                    if (n19 >= 15) {
                        ByteBufferUtils.writeByte(byteBuffer2, n18, ByteBufferUtils.readByte(byteBuffer2, n18) | 0xF);
                        n10 = LZ4ByteBufferUtils.writeLen(n19 - 15, byteBuffer2, n10);
                    } else {
                        ByteBufferUtils.writeByte(byteBuffer2, n18, ByteBufferUtils.readByte(byteBuffer2, n18) | n19);
                    }
                    if (n9 > n8) {
                        n11 = n9;
                        break block0;
                    }
                    UnsafeUtils.writeShort(sArray, LZ4Utils.hash64k(ByteBufferUtils.readInt(byteBuffer, n9 - 2)), n9 - 2 - n2);
                    int n20 = LZ4Utils.hash64k(ByteBufferUtils.readInt(byteBuffer, n9));
                    n13 = n2 + UnsafeUtils.readShort(sArray, n20);
                    UnsafeUtils.writeShort(sArray, n20, n9 - n2);
                    if (!LZ4ByteBufferUtils.readIntEquals(byteBuffer, n9, n13)) break;
                    n18 = n10++;
                    ByteBufferUtils.writeByte(byteBuffer2, n18, 0);
                }
                n11 = n9++;
            }
        }
        n10 = LZ4ByteBufferUtils.lastLiterals(byteBuffer, n11, n6 - n11, byteBuffer2, n10, n5);
        return n10 - n4;
    }

    @Override
    public int compress(ByteBuffer byteBuffer, int n2, int n3, ByteBuffer byteBuffer2, int n4, int n5) {
        if (byteBuffer.hasArray() && byteBuffer2.hasArray()) {
            return this.compress(byteBuffer.array(), n2 + byteBuffer.arrayOffset(), n3, byteBuffer2.array(), n4 + byteBuffer2.arrayOffset(), n5);
        }
        byteBuffer = ByteBufferUtils.inNativeByteOrder(byteBuffer);
        byteBuffer2 = ByteBufferUtils.inNativeByteOrder(byteBuffer2);
        ByteBufferUtils.checkRange(byteBuffer, n2, n3);
        ByteBufferUtils.checkRange(byteBuffer2, n4, n5);
        int n6 = n4 + n5;
        if (n3 < 65547) {
            return LZ4JavaUnsafeCompressor.compress64k(byteBuffer, n2, n3, byteBuffer2, n4, n6);
        }
        int n7 = n2 + n3;
        int n8 = n7 - 5;
        int n9 = n7 - 12;
        int n10 = n2;
        int n11 = n4;
        int n12 = n10++;
        int[] nArray = new int[4096];
        Arrays.fill(nArray, n12);
        block0: while (true) {
            int n13;
            int n14;
            int n15;
            int n16 = n10;
            int n17 = 1;
            int n18 = 1 << LZ4Constants.SKIP_STRENGTH;
            do {
                n10 = n16;
                if ((n16 += (n17 = n18++ >>> LZ4Constants.SKIP_STRENGTH)) > n9) break block0;
                n13 = LZ4Utils.hash(ByteBufferUtils.readInt(byteBuffer, n10));
                n14 = UnsafeUtils.readInt(nArray, n13);
                n15 = n10 - n14;
                UnsafeUtils.writeInt(nArray, n13, n10);
            } while (n15 >= 65536 || !LZ4ByteBufferUtils.readIntEquals(byteBuffer, n14, n10));
            n13 = LZ4ByteBufferUtils.commonBytesBackward(byteBuffer, n14, n10, n2, n12);
            n14 -= n13;
            int n19 = (n10 -= n13) - n12;
            int n20 = n11++;
            if (n11 + n19 + 8 + (n19 >>> 8) > n6) {
                throw new LZ4Exception("maxDestLen is too small");
            }
            if (n19 >= 15) {
                ByteBufferUtils.writeByte(byteBuffer2, n20, 240);
                n11 = LZ4ByteBufferUtils.writeLen(n19 - 15, byteBuffer2, n11);
            } else {
                ByteBufferUtils.writeByte(byteBuffer2, n20, n19 << 4);
            }
            LZ4ByteBufferUtils.wildArraycopy(byteBuffer, n12, byteBuffer2, n11, n19);
            n11 += n19;
            while (true) {
                ByteBufferUtils.writeShortLE(byteBuffer2, n11, n15);
                int n21 = LZ4ByteBufferUtils.commonBytes(byteBuffer, n14 + 4, n10 += 4, n8);
                if ((n11 += 2) + 6 + (n21 >>> 8) > n6) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                n10 += n21;
                if (n21 >= 15) {
                    ByteBufferUtils.writeByte(byteBuffer2, n20, ByteBufferUtils.readByte(byteBuffer2, n20) | 0xF);
                    n11 = LZ4ByteBufferUtils.writeLen(n21 - 15, byteBuffer2, n11);
                } else {
                    ByteBufferUtils.writeByte(byteBuffer2, n20, ByteBufferUtils.readByte(byteBuffer2, n20) | n21);
                }
                if (n10 > n9) {
                    n12 = n10;
                    break block0;
                }
                UnsafeUtils.writeInt(nArray, LZ4Utils.hash(ByteBufferUtils.readInt(byteBuffer, n10 - 2)), n10 - 2);
                int n22 = LZ4Utils.hash(ByteBufferUtils.readInt(byteBuffer, n10));
                n14 = UnsafeUtils.readInt(nArray, n22);
                UnsafeUtils.writeInt(nArray, n22, n10);
                n15 = n10 - n14;
                if (n15 >= 65536 || !LZ4ByteBufferUtils.readIntEquals(byteBuffer, n14, n10)) break;
                n20 = n11++;
                ByteBufferUtils.writeByte(byteBuffer2, n20, 0);
            }
            n12 = n10++;
        }
        n11 = LZ4ByteBufferUtils.lastLiterals(byteBuffer, n12, n7 - n12, byteBuffer2, n11, n6);
        return n11 - n4;
    }
}

