/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementDescriptorImpl;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.PDQPlugin;
import com.ibm.db2.cmx.tools.internal.StatementUtilities;
import com.ibm.db2.cmx.tools.internal.ToolsLogger;
import com.ibm.db2.cmx.tools.internal.generator.metadata.ClassInfo;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

public class CodeDumper {
    String rootPath_;
    ClassInfo classInfo_;
    IJavaProject javaProject_;
    String selectedLineSeparator_;

    public CodeDumper(String string, ClassInfo classInfo, IJavaProject iJavaProject, String string2) {
        this.rootPath_ = string;
        this.classInfo_ = classInfo;
        this.javaProject_ = iJavaProject;
        this.selectedLineSeparator_ = string2;
    }

    public String mergeAndWriteCode(String string, IFile iFile, boolean bl2) throws Exception {
        return this.mergeAndDumpOutputToFile(string, iFile, bl2);
    }

    public void writeMetadata(String string, Writer writer, String string2) {
        if (null != writer) {
            try {
                writer.write(string);
                writer.flush();
            }
            catch (IOException iOException) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GENERATOR_METADATA_WRITE_FAILRUE", new Object[0]), iOException, 10313, null, null);
            }
        } else if (null != string2) {
            this.writeOutputXml(string, string2);
        }
    }

    private String checkVersionAndGetTargetSource(String string) {
        int n2 = string.indexOf("String generatorVersion =");
        if (n2 != -1) {
            int n3;
            String string2 = string.substring(n2 + 27, string.indexOf("\"", n2 + 27)).trim();
            int n4 = Integer.parseInt(string2.substring(0, 1));
            if (!this.shouldAttemptMerge(n4, n3 = Integer.parseInt(string2.substring(2, 3)))) {
                string = null;
            }
            return string;
        }
        return null;
    }

    protected IFile createIFile(String string) {
        String string2 = this.getFileName(string);
        IProject iProject = this.javaProject_.getProject();
        return iProject.getFile(string2);
    }

    private String getFileName(String string) {
        String string2 = null != this.classInfo_.getPackageName() ? File.separator + this.classInfo_.getPackageName().replace('.', File.separatorChar) + File.separatorChar + this.classInfo_.getTypeName() + string : this.classInfo_.getTypeName() + string;
        return string2;
    }

    private JControlModel getJControlModel() {
        JControlModel jControlModel = new JControlModel();
        jControlModel.initialize((FacadeHelper)new ASTFacadeHelper(), PDQPlugin.getMergeXmlPath());
        return jControlModel;
    }

    private String mergeAndDumpOutputToFile(String string, IFile iFile, boolean bl2) throws Exception {
        if (bl2) {
            iFile = this.createIFile("Impl.java");
        }
        String string2 = this.mergeCode(string, iFile);
        if (bl2) {
            try {
                this.saveGenerated(string2, iFile, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException coreException) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_GENERATOR_WRITE_FILE_FAILURE", iFile.getLocation()), coreException, 10325, null, null);
            }
        }
        return string2;
    }

    private String mergeCode(String string, IFile iFile) throws Exception {
        String string2 = null;
        try {
            String[] stringArray;
            JControlModel jControlModel = this.getJControlModel();
            JMerger jMerger = new JMerger(jControlModel);
            String string3 = null;
            if (null != iFile && iFile.exists() && (string3 = this.readTargetFile(iFile)) != null && (string3 = this.checkVersionAndGetTargetSource(string3)) != null) {
                jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForContents(string3));
            }
            jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(string));
            jMerger.merge();
            string2 = jMerger.getTargetCompilationUnitContents();
            if (string3 != null && (stringArray = this.resolveConsistencyTokenAndPackageVersionToUse(string3, string2)) != null) {
                ToolsLogger.getLogger().info("Re-using consistency token from old code: " + stringArray[0]);
                this.classInfo_.setConTokenBytes(this.getConsistencyTokenBytes(stringArray[0]));
                string2 = string2.replaceAll("public static final long generationTime = .*?;", "public static final long generationTime = " + stringArray[0] + ";");
                ToolsLogger.getLogger().info("Re-using package version from old code: " + stringArray[1]);
                string2 = string2.replaceAll("public static final String packageVersion = .*?;", "public static final String packageVersion = " + stringArray[1] + ";");
            }
        }
        catch (Exception exception) {
            ToolsLogger.getLogger().log(Level.FINEST, "Generated Code before merge:\n******************************************************************************\n" + string);
            throw exception;
        }
        if (!"\n".equals(this.selectedLineSeparator_)) {
            string2 = string2.replace("\n", this.selectedLineSeparator_);
        }
        return string2;
    }

    private byte[] getConsistencyTokenBytes(String string) {
        long l10 = this.getConsistencyTokenLong(string);
        return StatementDescriptorImpl.timestampToBytes(l10);
    }

    private long getConsistencyTokenLong(String string) {
        if (string.endsWith("L") || string.endsWith("l")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("0x")) {
            string = string.substring(2);
            return Long.parseLong(string, 16);
        }
        return Long.parseLong(string, 16);
    }

    private String[] resolveConsistencyTokenAndPackageVersionToUse(String string, String string2) {
        String[] stringArray = new String[2];
        ASTParser aSTParser = ASTParser.newParser((int)3);
        aSTParser.setProject(this.javaProject_);
        aSTParser.setSource(string.toCharArray());
        ASTNode aSTNode = aSTParser.createAST(null);
        ConTokenInfoVisitor conTokenInfoVisitor = new ConTokenInfoVisitor();
        aSTNode.accept((ASTVisitor)conTokenInfoVisitor);
        aSTParser.setSource(string2.toCharArray());
        aSTNode = aSTParser.createAST(null);
        ConTokenInfoVisitor conTokenInfoVisitor2 = new ConTokenInfoVisitor();
        aSTNode.accept((ASTVisitor)conTokenInfoVisitor2);
        ArrayList<String> arrayList = new ArrayList<String>(conTokenInfoVisitor.whatMattersForConToken_.values());
        String string3 = arrayList.toString();
        arrayList = new ArrayList<String>(conTokenInfoVisitor2.whatMattersForConToken_.values());
        String string4 = arrayList.toString();
        if (string3.equals(string4)) {
            String string5 = "\"" + StatementUtilities.getPackageVersion("AUTO", this.getConsistencyTokenLong(conTokenInfoVisitor.consistencyToken_)) + "\"";
            if (this.classInfo_.isPackageVersionAutoGenerated() && conTokenInfoVisitor.packageVersion_.equals(string5) || conTokenInfoVisitor.packageVersion_.equals(conTokenInfoVisitor2.packageVersion_)) {
                stringArray[0] = conTokenInfoVisitor.consistencyToken_;
                stringArray[1] = conTokenInfoVisitor.packageVersion_;
                return stringArray;
            }
        }
        return null;
    }

    private String readTargetFile(IFile iFile) {
        String string = null;
        Object var3_3 = null;
        try {
            InputStream inputStream = iFile.getContents(true);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray);
            bufferedInputStream.close();
            string = new String(byArray);
        }
        catch (CoreException coreException) {
            ToolsLogger.getLogger().log(Level.FINER, "Could not read targetFile", coreException);
        }
        catch (IOException iOException) {
            ToolsLogger.getLogger().log(Level.FINER, "Could not read targetFile", iOException);
        }
        string = string.replaceAll("\r[\n]?", "\n");
        return string;
    }

    private void saveGenerated(String string, IFile iFile, IProgressMonitor iProgressMonitor) throws CoreException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        if (!iFile.exists()) {
            File file = iFile.getLocation().toFile();
            if (file.exists()) {
                iFile.getParent().refreshLocal(1, iProgressMonitor);
                iFile.setContents((InputStream)byteArrayInputStream, true, false, iProgressMonitor);
            } else {
                iFile.create((InputStream)byteArrayInputStream, false, iProgressMonitor);
            }
        } else {
            iFile.setContents((InputStream)byteArrayInputStream, true, false, iProgressMonitor);
        }
    }

    private boolean shouldAttemptMerge(int n2, int n3) {
        if (n2 < 1) {
            return false;
        }
        return n2 != 1 || n3 >= 3;
    }

    private void writeOutputXml(String string, String string2) {
        try {
            File file = new File(string2);
            File file2 = file.getParentFile();
            if (null != file2 && !file2.exists()) {
                file2.mkdirs();
            }
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_WRITING_PUREQUERYXML_FILE", new Object[0]), iOException, 10358, null, null);
        }
    }

    static class ConTokenInfoVisitor
    extends ASTVisitor {
        public String consistencyToken_;
        public String packageVersion_;
        public TreeMap<String, String> whatMattersForConToken_ = new TreeMap();

        ConTokenInfoVisitor() {
        }

        public boolean visit(FieldDeclaration fieldDeclaration) {
            if (fieldDeclaration.fragments() != null && fieldDeclaration.fragments().size() > 0) {
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)fieldDeclaration.fragments().get(0);
                String string = variableDeclarationFragment.getName().toString();
                String string2 = variableDeclarationFragment.getInitializer().toString();
                if (string.equals("generationTime")) {
                    this.consistencyToken_ = string2;
                } else if (!string.equals("generatorVersion")) {
                    if (string.equals("packageVersion")) {
                        this.packageVersion_ = string2;
                    } else {
                        this.whatMattersForConToken_.put(string, string + "=" + string2);
                    }
                }
            }
            return true;
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            this.whatMattersForConToken_.put(methodDeclaration.toString(), methodDeclaration.toString());
            return true;
        }
    }
}

