/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.repository.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends InputStream {
    private InputStream sourceStream;
    private OutputStream outputStream;
    private long bytesRead = 0L;

    public TeeInputStream(InputStream inputStream, OutputStream outputStream) {
        this.sourceStream = inputStream;
        this.outputStream = outputStream;
    }

    @Override
    public int available() throws IOException {
        return this.sourceStream.available();
    }

    @Override
    public void close() throws IOException {
        this.sourceStream.close();
        this.outputStream.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        int n2 = this.sourceStream.read();
        if (n2 != -1) {
            ++this.bytesRead;
            this.outputStream.write(n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n2 = this.sourceStream.read(byArray);
        if (n2 != -1) {
            this.bytesRead += (long)n2;
            this.outputStream.write(byArray, 0, n2);
        }
        return n2;
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.sourceStream.read(byArray, n2, n3);
        if (n4 != -1) {
            this.bytesRead += (long)n4;
            this.outputStream.write(byArray, n2, n4);
        }
        return n4;
    }

    @Override
    public long skip(long l10) throws IOException {
        return this.sourceStream.skip(l10);
    }

    public long getBytesRead() {
        return this.bytesRead;
    }
}

