/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.proxy;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.Profile;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.client.CMXListener;
import com.ibm.db2.cmx.client.Configuration;
import com.ibm.db2.cmx.client.DataSourceProxy;
import com.ibm.db2.cmx.client.GenericInvoker;
import com.ibm.db2.cmx.client.ManageableProxy;
import com.ibm.db2.cmx.impl.CMXImplMessageHelper;
import com.ibm.db2.cmx.impl.ClientCacheFileImpl;
import com.ibm.db2.cmx.impl.DataSourceDescriptor;
import com.ibm.db2.cmx.impl.DriverDescriptor;
import com.ibm.db2.cmx.impl.Utils;
import com.ibm.db2.cmx.internal.Service;
import com.ibm.db2.cmx.internal.controller.CompositeControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDataSource;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDataSourcePool;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.internal.metadata.DataBean;
import com.ibm.db2.cmx.internal.metadata.DataBeanFirstConnection;
import com.ibm.db2.cmx.internal.monitor.MonitorAgent;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import javax.transaction.xa.XAResource;

public abstract class ProxiedJdbcDataSource
implements ManageableProxy,
DataSourceProxy,
GenericInvoker {
    private Map<String, Object> dataSourceDescriptorMap_ = null;
    private static int currentSerialNumber;
    protected static Object lock;
    protected String monitorURLFromStoredProc_;
    protected boolean disableProxies_ = false;
    private boolean isOPMClient_ = false;
    private boolean isOCMClient_ = false;
    protected int datasourceId_;
    protected boolean firstConnectionDataReported_ = false;
    protected DataBeanFirstConnection firstConnectionBean_ = null;
    protected boolean initialLookupReported_ = false;
    protected Object target_;
    protected int type_;
    protected static final int TYPE_DATASOURCE = 1;
    protected static final int TYPE_CONNECTIONPOOLDATASOURCE = 2;
    protected static final int TYPE_XADATASOURCE = 3;
    protected static final int DATASOURCE_STATE_STATIC_PUSHDOWN = 1;
    protected static final int DATASOURCE_STATE_DYNAMIC_PUSHDOWN = 2;
    protected int disableOCMDynamicControl_ = 0;
    protected int monitorLevel_;
    protected int monitorEnabled_;
    protected String monitorServer_;
    protected int monitorPort_;
    protected int monitorCollectionInterval_;
    protected String monitoredDataSourceName_;
    protected String monitoredDatabaseServerName_;
    protected int monitoredDatabasePort_;
    protected String monitoredDatabaseName_;
    protected String monitoredLocationName_ = null;
    protected boolean haveNewActualBackendLocation_ = false;
    protected String dbControllerURL_ = null;
    protected String profileName_ = null;
    protected String dataSourceName_ = null;
    protected int dataSourceState_ = 1;
    protected long lastAppliedDataSourceProfileVersion_ = -1L;
    HashSet<ClientInfo> clientInfoSet_ = null;
    HashSet<ClientInfo> auxClientInfoSet_ = null;
    Object clientInfoLock_ = null;
    protected HashSet<Integer> applicationExceptionSet_ = null;
    ArrayList<PushDownError> dynamicPushDownErrors_ = null;
    ArrayList<PushDownError> auxDynamicPushDownErrors_ = null;
    HashSet<String> duplicateErrorsMap_ = null;
    Object dynamicPushDownLock_ = null;
    protected long lastDatabaseVersion_ = -1L;
    protected long lastPhysicalLocationChangeVersion_ = -1L;
    protected long lastDataSrcProfileVersion_ = -1L;
    public MonitorAgent monitorAgent_ = null;
    protected ControlDataSource compositecds_ = null;
    private static boolean hasHttpControllerURL_;
    private static boolean disablePureQuery_;
    private static boolean disableExtendedInsight_;
    private static boolean hasControllerURL_;
    private static Configuration.ControllerAccessPolicy controllerAccessPolicy_;
    private int lastKnownCDSVersion_ = 0;
    protected boolean clientSideLookupPerformed_ = false;
    protected boolean isMonitoring_;
    protected static Logger logger__;
    protected Object[] firstConnectionWasData_;
    protected WeakHashMap<Object, Object> activeConnectionInvocationHandlers_ = new WeakHashMap();
    protected JSONObject nonDefaultClientProperties_;
    private SQLException OCMInitializationException_ = null;
    protected RuntimeException initializationExceptionToThrow_ = null;
    protected String driverNameOverride_ = null;
    protected String driverVersionOverride_ = null;
    protected CMXListener cmxListener_ = null;
    protected String appServerNameOverride_ = null;
    protected String appServerVersionOverride_ = null;
    protected String jndiNameOverride_ = null;
    protected int maxPoolConnectionsOverride_ = -1;
    protected int connectionTimeoutOverride_ = -1;
    protected int wasMaxPoolConnectionsApplied_ = -1;
    protected int wasConnTimeoutApplied_ = -1;
    protected HashMap<String, String> appliedPropsStatusFromWAS_ = null;
    protected int numOpenConnections_ = 0;
    protected boolean wasPoolPaused_ = false;
    protected boolean redirectPending_ = false;

    protected abstract JSONObject getCurrentNonDefaultClientProperties_();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getSerialNumber() {
        Object object = lock;
        synchronized (object) {
            return currentSerialNumber++;
        }
    }

    public ProxiedJdbcDataSource(Object object) {
        try {
            this.datasourceId_ = ProxiedJdbcDataSource.getSerialNumber();
            if (object instanceof XADataSource) {
                this.type_ = 3;
            } else if (object instanceof ConnectionPoolDataSource) {
                this.type_ = 2;
            } else if (object instanceof DataSource) {
                this.type_ = 1;
            } else {
                throw new RuntimeException(Messages.getText("ERR_CONSTRUCTOR_ARGUMENT_INVALID_TYPE", this.getClass().getCanonicalName(), object.getClass().getCanonicalName(), DataSource.class.getCanonicalName() + ", " + XADataSource.class.getCanonicalName() + ", " + ConnectionPoolDataSource.class.getCanonicalName()));
            }
            this.target_ = object;
            this.clientInfoSet_ = new HashSet();
            this.auxClientInfoSet_ = new HashSet();
            this.clientInfoLock_ = new Object();
            this.dynamicPushDownErrors_ = new ArrayList();
            this.auxDynamicPushDownErrors_ = new ArrayList();
            this.duplicateErrorsMap_ = new HashSet();
            this.dynamicPushDownLock_ = new Object();
            this.applicationExceptionSet_ = new HashSet();
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logMonitorMessage(logger__, this, "<init>", "datasource proxy created for " + object);
            }
        }
        catch (RuntimeException runtimeException) {
            this.initializationExceptionToThrow_ = runtimeException;
        }
    }

    @Override
    public Object invokeGetConnection(Method method, Object[] objectArray, String string) throws Throwable {
        Object object;
        block11: {
            if (logger__.isLoggable(Level.FINER) && !"toString".equals(object = method.getName()) && !"hashCode".equals(object) && !"equals".equals(object)) {
                DataLogger.logMonitorMessage(logger__, this, "invokeGetConnection", "");
            }
            if (null != this.initializationExceptionToThrow_) {
                throw this.initializationExceptionToThrow_;
            }
            if (DataProperties.getProperty("pdq.cmx.http.controllerURL") == null) {
                try {
                    object = ControlDriver.getInstance();
                    if (!((ControlDriver)object).isMonConnectionset(this.datasourceId_)) {
                        ((ControlDriver)object).setMonConnection(this.datasourceId_, (Connection)method.invoke(this.target_, objectArray));
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    Throwable throwable = invocationTargetException.getTargetException();
                    if (!(throwable instanceof SQLException)) break block11;
                    this.checkAndReportApplnException((SQLException)throwable);
                }
            }
        }
        object = null;
        this.resolve();
        try {
            object = method.invoke(this.target_, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SQLException) {
                this.checkAndReportApplnException((SQLException)throwable);
            }
            DataLogger.logThrowable(logger__, throwable);
            throw throwable;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_PROFILER_ILLEGAL_ACCESS_EXCEPTION", method.getName(), illegalAccessException.getMessage()), illegalAccessException, 11047);
        }
        if (this.type_ == 1) {
            object = this.createConnectionProxy((Connection)object, string, null);
        }
        this.refCount(true);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refCount(boolean bl2) {
        Object object = lock;
        synchronized (object) {
            if (bl2) {
                ++this.numOpenConnections_;
            } else {
                --this.numOpenConnections_;
                if (this.numOpenConnections_ <= 0) {
                    this.numOpenConnections_ = 0;
                    if (Boolean.parseBoolean(DataProperties.getProperty("pdq.cmx.purgeWASPool")) && Boolean.parseBoolean(DataProperties.getProperty("pdq.cmx.purgeWASPool.type")) && this.cmxListener_ != null && this.wasPoolPaused_) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("resume", "");
                        if (logger__.isLoggable(Level.FINEST)) {
                            logger__.log(Level.FINEST, "Before - About to resume WAS Pool : " + hashMap);
                        }
                        this.cmxListener_.configure(hashMap);
                        if (logger__.isLoggable(Level.FINEST)) {
                            logger__.log(Level.FINEST, "After - resumed WAS Pool : " + hashMap);
                        }
                        this.wasPoolPaused_ = false;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRefCount() {
        if (!Boolean.parseBoolean(DataProperties.getProperty("pdq.cmx.purgeWASPool"))) {
            return 1;
        }
        Object object = lock;
        synchronized (object) {
            return this.numOpenConnections_;
        }
    }

    private void getDataSourceDescriptor() {
        Map<String, Object> map = null;
        if (this.dataSourceDescriptorMap_ == null) {
            map = ControlDriver.getInstance().getDriverDescriptorMap();
            if (map.get("wasServerName") == null && this.firstConnectionWasData_ != null && DataBean.get(this.firstConnectionWasData_, 3) != null || map.get("wasServerVersion") == null && this.firstConnectionWasData_ != null && DataBean.get(this.firstConnectionWasData_, 4) != null) {
                ControlDriver.getInstance().updateDriverDescriptorMapWithWASData((String)DataBean.get(this.firstConnectionWasData_, 3), (String)DataBean.get(this.firstConnectionWasData_, 4));
            }
            if (this.appServerNameOverride_ != null && this.appServerVersionOverride_ != null) {
                ControlDriver.getInstance().updateDriverDescriptorMapWithWASData(this.appServerNameOverride_, this.appServerVersionOverride_);
            }
            this.dataSourceDescriptorMap_ = new HashMap<String, Object>();
            this.dataSourceDescriptorMap_.putAll(map);
            this.dataSourceDescriptorMap_.put("dsDescriptorProfileName", this.profileName_);
            this.dataSourceDescriptorMap_.put("dsDescriptorJDBCDSName", this.dataSourceName_);
            this.dataSourceDescriptorMap_.put("dsDescriptorWASMaxPoolSize", this.firstConnectionWasData_ != null && DataBean.get(this.firstConnectionWasData_, 1) != null ? (Integer)DataBean.get(this.firstConnectionWasData_, 1) : 0);
            if (this.maxPoolConnectionsOverride_ != -1) {
                this.dataSourceDescriptorMap_.put("dsDescriptorWASMaxPoolSize", this.maxPoolConnectionsOverride_);
            }
            if (this.connectionTimeoutOverride_ != -1) {
                this.dataSourceDescriptorMap_.put("dsDescriptorConnTimeout", this.connectionTimeoutOverride_);
            }
            this.dataSourceDescriptorMap_.put("dsDescriptorWASJNDIDSName", this.firstConnectionWasData_ != null ? (String)DataBean.get(this.firstConnectionWasData_, 2) : null);
            if (this.jndiNameOverride_ != null) {
                this.dataSourceDescriptorMap_.put("dsDescriptorWASJNDIDSName", this.jndiNameOverride_);
            }
            this.dataSourceDescriptorMap_.put("dsDescriptorDBServer", this.monitoredDatabaseServerName_);
            this.dataSourceDescriptorMap_.put("dsDescriptorDBPort", this.monitoredDatabasePort_);
            this.dataSourceDescriptorMap_.put("dsDescriptorDBName", this.monitoredDatabaseName_);
            this.dataSourceDescriptorMap_.put("dsDescriptorClientPropertySettings", this.getDataSourceDescriptorProperties());
        }
    }

    protected HashMap getDataSourceDescriptorProperties() {
        return null;
    }

    protected HashMap<String, Object> getDataSourceDescriptorPropertiesForWAS() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (this.wasMaxPoolConnectionsApplied_ != -1) {
            hashMap.put("dsDescriptorWASMaxPoolSize", this.wasMaxPoolConnectionsApplied_);
        }
        if (this.wasConnTimeoutApplied_ != -1) {
            hashMap.put("dsDescriptorConnTimeout", this.wasConnTimeoutApplied_);
        }
        return hashMap;
    }

    public boolean isOCMEnabled() {
        Boolean bl2 = false;
        bl2 = DataProperties.getPropertyBoolean("pdq.cmx.server");
        return hasHttpControllerURL_ && controllerAccessPolicy_ != Configuration.ControllerAccessPolicy.startWithNoControl && Configuration.isJCCAtCMX5ProtocolLevel__ && bl2 == false;
    }

    protected void compute_isOPMClient() {
        Boolean bl2 = DataProperties.getPropertyBoolean("pdq.cmx.server");
        this.isOPMClient_ = bl2 == false && (this.monitorURLFromStoredProc_ != null || hasControllerURL_);
    }

    protected void compute_isOCMClient() {
        Boolean bl2 = DataProperties.getPropertyBoolean("pdq.cmx.server");
        this.isOCMClient_ = bl2 == false && hasHttpControllerURL_;
    }

    public boolean isOPMClient() {
        return this.isOPMClient_;
    }

    public boolean isOCMClient() {
        return this.isOCMClient_;
    }

    public boolean isControllableClient() {
        Boolean bl2 = DataProperties.getPropertyBoolean("pdq.cmx.server");
        return bl2 == false && (hasHttpControllerURL_ || hasControllerURL_);
    }

    public boolean isExtendedInsightDisabled() {
        return !Configuration.isExtendedInsightLicensed__ || disableExtendedInsight_;
    }

    public boolean isPureQueryDisabled() {
        return !Configuration.isLicensed__ || disablePureQuery_;
    }

    @Override
    public boolean isOCMManagedClient() {
        return this.isOCMEnabled();
    }

    private void getAndProcessClientSettings() {
        this.getClientSettingsFromWrapper_();
        if (this.isOCMEnabled()) {
            this.getDataSourceDescriptor();
        }
    }

    private void updateCompositeCDS() {
        ControlDataSourceImpl controlDataSourceImpl = null;
        ControlDataSourceImpl controlDataSourceImpl2 = null;
        if (this.compositecds_ == null) {
            this.compositecds_ = new CompositeControlDataSourceImpl();
        }
        controlDataSourceImpl = ControlDataSourcePool.getInstance().getPooledInstanceOrCreateCDS(Service.ControllerType.OPM, this.dataSourceDescriptorMap_, this.datasourceId_, this.monitoredDataSourceName_, this.monitoredDatabaseServerName_, "" + this.monitoredDatabasePort_, this.monitoredDatabaseName_, this.monitoredLocationName_, this);
        if (this.isOCMEnabled()) {
            controlDataSourceImpl2 = ControlDataSourcePool.getInstance().getPooledInstanceOrCreateCDS(Service.ControllerType.OCM, this.dataSourceDescriptorMap_, this.datasourceId_, this.monitoredDataSourceName_, this.monitoredDatabaseServerName_, "" + this.monitoredDatabasePort_, this.monitoredDatabaseName_, this.monitoredLocationName_, null);
            controlDataSourceImpl2.registerDataSourceForUpdates(this);
            this.compositecds_.updateCDS(this.monitoredDataSourceName_, this.monitoredDatabaseServerName_, String.valueOf(this.monitoredDatabasePort_), this.monitoredDatabaseName_, this.monitoredLocationName_);
        }
        ((CompositeControlDataSourceImpl)this.compositecds_).updateControlDataSources(controlDataSourceImpl, controlDataSourceImpl2);
    }

    private SQLException createOCMInitializationException(Exception exception) {
        return new SQLException("[3.3306.7] " + exception.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolve() throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.enter(logger__, this, "resolve ()");
        }
        ProxiedJdbcDataSource proxiedJdbcDataSource = this;
        synchronized (proxiedJdbcDataSource) {
            if (this.OCMInitializationException_ != null) {
                throw this.OCMInitializationException_;
            }
            if (this.compositecds_ == null || this.haveNewActualBackendLocation_) {
                this.getAndProcessClientSettings();
                this.updateCompositeCDS();
                bl2 = true;
                if (this.haveNewActualBackendLocation_) {
                    bl3 = true;
                }
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, this, "resolve", "Datasource id:" + this.datasourceId_ + " used for " + ControlDataSourcePool.createKey(this.monitoredDataSourceName_, this.monitoredDatabaseServerName_, Integer.toString(this.monitoredDatabasePort_), this.monitoredDatabaseName_, this.monitoredLocationName_, true));
                }
                if (this.haveNewActualBackendLocation_) {
                    this.haveNewActualBackendLocation_ = false;
                    this.lastKnownCDSVersion_ = 0;
                }
            }
            if (bl2 && this.isOCMEnabled()) {
                try {
                    this.compositecds_.doInitialLookup(bl3);
                }
                catch (Exception exception) {
                    switch (controllerAccessPolicy_) {
                        case startWithRemoteControl: {
                            this.OCMInitializationException_ = this.createOCMInitializationException(exception);
                            throw this.OCMInitializationException_;
                        }
                        case startWithLimitedControl: {
                            this.getClientProfilesFromFile();
                            break;
                        }
                        default: {
                            if (this.getClientProfilesFromFile()) break;
                            this.OCMInitializationException_ = this.createOCMInitializationException(exception);
                            throw this.OCMInitializationException_;
                        }
                    }
                }
            }
            if (this.isOCMEnabled() && (this.firstConnectionBean_ == null || this.dataSourceState_ == 1)) {
                String string = this.monitoredDataSourceName_;
                String string2 = this.monitoredDatabaseServerName_;
                int n2 = this.monitoredDatabasePort_;
                String string3 = this.monitoredDatabaseName_;
                String string4 = this.monitoredLocationName_;
                this.applyStaticPushDownProperties();
                this.getClientSettingsFromWrapper_();
                if (!(Utils.areStringsEqual(string, this.monitoredDataSourceName_) && Utils.areStringsEqual(string2, this.monitoredDatabaseServerName_) && n2 == this.monitoredDatabasePort_ && Utils.areStringsEqual(string3, this.monitoredDatabaseName_) && Utils.areStringsEqual(string4, this.monitoredLocationName_))) {
                    this.haveNewActualBackendLocation_ = true;
                }
                this.dataSourceState_ = 2;
            }
            this.updateMonitorAgent();
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "resolve ()", null);
        }
    }

    private boolean getClientProfilesFromFile() {
        boolean bl2 = false;
        Object[] objectArray = Utils.readClientProfilesFromFile();
        ClientCacheFileImpl clientCacheFileImpl = (ClientCacheFileImpl)objectArray[0];
        if (clientCacheFileImpl != null) {
            DataSourceDescriptor dataSourceDescriptor;
            Profile.DataSource dataSource;
            if (clientCacheFileImpl.getCMXOnDiskFormatLevel() != 12) {
                Utils.writeClientProfilesToFile(true);
                return false;
            }
            DriverDescriptor driverDescriptor = CMXImplMessageHelper.getInstance().newDriverDescriptor();
            Profile.Driver driver = clientCacheFileImpl.readDriver(driverDescriptor);
            if (driver != null) {
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, this, "getClientProfilesFromFile", "Updating driver profile with profile name " + driver.getName() + ", profile version" + driver.getVersion());
                }
                bl2 = true;
                ControlDriver.getInstance().getDriverProfile().updateToNewVersion(driver);
            }
            if ((dataSource = clientCacheFileImpl.readDataSource(dataSourceDescriptor = CMXImplMessageHelper.getInstance().newDataSourceDescriptor(this.dataSourceDescriptorMap_))) != null) {
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, this, "getClientProfilesFromFile", "Updating datasource profile with profile name " + dataSource.getName() + ", profile version" + dataSource.getVersion());
                }
                bl2 = true;
                this.compositecds_.getDataSourceProfile().updateToNewVersion(dataSource);
            }
        }
        return bl2;
    }

    private void updateMonitorAgent() {
        Boolean bl2 = false;
        bl2 = DataProperties.getPropertyBoolean("pdq.cmx.server");
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.enter(logger__, this, "updateMonitorAgent");
        }
        if (this.compositecds_ == null || bl2.booleanValue()) {
            return;
        }
        if (this.compositecds_.getVersion() == 0 && !this.clientSideLookupPerformed_) {
            if (logger__.isLoggable(Level.CONFIG)) {
                this.logUsingClientSettingIfNonDefault();
            }
            this.updateMonitorAgentWithSettings(this.monitorEnabled_, this.monitorServer_, this.monitorPort_, this.monitorLevel_, this.monitorCollectionInterval_, null, null, null, null, null, 0);
            this.clientSideLookupPerformed_ = true;
        } else {
            this.compositecds_.lock();
            try {
                if (this.compositecds_.getVersion() > this.lastKnownCDSVersion_) {
                    if (logger__.isLoggable(Level.FINE)) {
                        this.logUsingControllerSettings();
                    }
                    if (this.compositecds_.getControllerAgent() != null && this.compositecds_.getControllerAgent().getNegotiatedVersion() >= 12) {
                        this.monitorEnabled_ = this.compositecds_.getMonitorEnabledFromCmxDirectives(this.monitorEnabled_);
                        this.monitorCollectionInterval_ = this.compositecds_.getMonitorCollectionIntervalFromCmxDirectives(this.monitorCollectionInterval_);
                        this.updateMonitorAgentWithSettings(this.monitorEnabled_, this.monitorServer_, this.monitorPort_, this.monitorLevel_, this.monitorCollectionInterval_, null, null, null, null, null, this.disableOCMDynamicControl_);
                    } else {
                        this.updateMonitorAgentWithSettings(this.compositecds_.getPropertyValue("monitorEnabled", this.monitorEnabled_), this.compositecds_.getPropertyValue("monitorServerName", this.monitorServer_), this.compositecds_.getPropertyValue("monitorPort", this.monitorPort_), this.compositecds_.getPropertyValue("monitorLevel", this.monitorLevel_), this.compositecds_.getPropertyValue("monitorCollectionInterval", this.monitorCollectionInterval_), this.compositecds_.getPropertyValue("supportedKeyTypes", null), this.compositecds_.getPropertyValue("clientUserMask", null), this.compositecds_.getPropertyValue("clientHostnameMask", null), this.compositecds_.getPropertyValue("applicationNameMask", null), this.compositecds_.getPropertyValue("clientAccountingInformationMask", null), this.compositecds_.getPropertyValue("disableOCMDynamicControl", this.disableOCMDynamicControl_));
                    }
                    this.lastKnownCDSVersion_ = this.compositecds_.getVersion();
                } else if (this.monitorAgent_ != null && !this.monitorAgent_.isConnectionActive() && this.monitorAgent_.getReconnectFlag()) {
                    if (logger__.isLoggable(Level.CONFIG)) {
                        DataLogger.logConnectedComponents(logger__, this, "updateMonitorAgent", "reconnect to monitor server based on flag set by controller lookup thread");
                    }
                    this.monitorAgent_.close();
                    this.monitorAgent_ = null;
                    this.updateMonitorAgentWithSettings(this.compositecds_.getPropertyValue("monitorEnabled", this.monitorEnabled_), this.compositecds_.getPropertyValue("monitorServerName", this.monitorServer_), this.compositecds_.getPropertyValue("monitorPort", this.monitorPort_), this.compositecds_.getPropertyValue("monitorLevel", this.monitorLevel_), this.compositecds_.getPropertyValue("monitorCollectionInterval", this.monitorCollectionInterval_), this.compositecds_.getPropertyValue("supportedKeyTypes", null), this.compositecds_.getPropertyValue("clientUserMask", null), this.compositecds_.getPropertyValue("clientHostnameMask", null), this.compositecds_.getPropertyValue("applicationNameMask", null), this.compositecds_.getPropertyValue("clientAccountingInformationMask", null), this.compositecds_.getPropertyValue("disableOCMDynamicControl", this.disableOCMDynamicControl_));
                    this.monitorAgent_.setReconnectFlag(false);
                }
            }
            finally {
                this.compositecds_.unlock();
            }
        }
    }

    public boolean isOCMDyanmicControlDisabled() {
        return this.disableOCMDynamicControl_ == 1;
    }

    private void logUsingControllerSettings() {
        DataLogger.logConnectedComponents(logger__, this, "updateMonitorAgent", "Datasource id:" + this.datasourceId_ + " using controller properties: monitorEnabled: " + this.compositecds_.getPropertyValue("monitorEnabled", this.monitorEnabled_) + ", monitorServer: " + this.compositecds_.getPropertyValue("monitorServerName", this.monitorServer_) + ", monitorPort: " + this.compositecds_.getPropertyValue("monitorPort", this.monitorPort_) + ", monitorLevel: " + this.compositecds_.getPropertyValue("monitorLevel", this.monitorLevel_) + ", monitorCollectionInterval: " + this.compositecds_.getPropertyValue("monitorCollectionInterval", this.monitorCollectionInterval_) + ", supportedKeyTypes: " + this.compositecds_.getPropertyValue("supportedKeyTypes", null) + ", clientUserMask: " + this.compositecds_.getPropertyValue("clientUserMask", null) + ", clientHostnameMask: " + this.compositecds_.getPropertyValue("clientHostnameMask", null) + ", clientApplicationNameMask: " + this.compositecds_.getPropertyValue("applicationNameMask", null) + ", clientAccountingInformationMask: " + this.compositecds_.getPropertyValue("clientAccountingInformationMask", null) + ", clientPollingInterval: " + this.compositecds_.getPropertyValue("clientPollingInterval", -1) + " for keyset: " + this.compositecds_.getMatchingKeySet() + ", dispatchToken: " + this.compositecds_.getPropertyValue("dispatchToken", -1) + " disableOCMDynamicControl: " + this.compositecds_.getPropertyValue("disableOCMDynamicControl", this.disableOCMDynamicControl_));
    }

    private void logUsingClientSettingIfNonDefault() {
        if (this.monitorEnabled_ != 0 || this.monitorServer_ != null || this.monitorPort_ != 0 || this.monitorLevel_ != 0 || this.monitorCollectionInterval_ != 0) {
            DataLogger.logConfigHighVis(logger__, this, "updateMonitorAgent", "Datasource id:" + this.datasourceId_ + " using client properties: monitorEnabled: " + this.monitorEnabled_ + ", monitorServer: " + this.monitorServer_ + ", monitorPort: " + this.monitorPort_ + ", monitorLevel: " + this.monitorLevel_ + ", monitorCollectionInterval: " + this.monitorCollectionInterval_, false);
        }
    }

    private synchronized void updateMonitorAgentWithSettings(int n2, String string, int n3, int n4, int n5, String string2, String string3, String string4, String string5, String string6, int n6) {
        block8: {
            boolean bl2;
            this.disableOCMDynamicControl_ = n6;
            boolean bl3 = bl2 = hasHttpControllerURL_ && string == null;
            if (n2 == 1 && (string != null || bl2) && (n3 > 0 || this.compositecds_.getControllerAgent() != null && this.compositecds_.getControllerAgent().getNegotiatedVersion() >= 12)) {
                if (this.monitorAgent_ == null) {
                    try {
                        this.monitorAgent_ = Service.getMonitorAgent(bl2, this.compositecds_ != null ? this.compositecds_.getControllerAgent() : null, 1, string, n3, n5, this, string2, string3, string4, string5, string6);
                        this.isMonitoring_ = true;
                        if (this.firstConnectionBean_ != null) {
                            this.monitorAgent_.reportFirstConnection(this.firstConnectionBean_);
                            this.firstConnectionDataReported_ = true;
                            break block8;
                        }
                        this.firstConnectionDataReported_ = false;
                    }
                    catch (Exception exception) {
                        if (logger__.isLoggable(Level.FINEST)) {
                            DataLogger.logTrappedMonitoringException(logger__, this, "updateMonitorAgentWithSettings", exception, "Failed to update monitor agent settings.");
                        }
                        break block8;
                    }
                }
                this.monitorAgent_.update(1, n2, string, n3, n4, n5, string2, string3, string4, string5, string6);
                this.isMonitoring_ = true;
            } else {
                this.isMonitoring_ = false;
                if (this.monitorAgent_ != null) {
                    this.monitorAgent_.close();
                    this.monitorAgent_ = null;
                }
            }
        }
    }

    public MonitorAgent getUpdatedMonitorAgent() {
        this.updateMonitorAgent();
        return this.monitorAgent_;
    }

    @Override
    public void pushData(int n2, Object[] objectArray, boolean bl2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "pushData", "ENTRY " + Arrays.deepToString(new Object[]{n2, objectArray != null ? Arrays.asList(objectArray) : null, bl2}));
        }
        if (n2 == 100 && !Boolean.parseBoolean(DataProperties.getProperty("pdq.cmx.purgeWASPool.type"))) {
            this.purgeWASPool();
        }
        if (n2 == 100) {
            this.prepToSendWasData(objectArray);
        } else if (n2 == 101) {
            this.prepToSendCLPPLUSData(objectArray);
        } else if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logMonitorMessage(logger__, this, "pushData", "unknown data type: " + n2);
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "pushData", null);
        }
    }

    @Override
    public void registerDataSource(Object[] objectArray, Object[] objectArray2, CMXListener cMXListener) {
        this.cmxListener_ = cMXListener;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerDataSource", "ENTRY " + Arrays.deepToString(new Object[]{objectArray, objectArray != null ? Arrays.asList(objectArray) : null, objectArray2, objectArray2 != null ? Arrays.asList(objectArray2) : null}));
        }
        if (objectArray != null) {
            this.appServerNameOverride_ = (String)objectArray[0];
            this.appServerVersionOverride_ = (String)objectArray[1];
            this.jndiNameOverride_ = (String)objectArray[2];
        }
        if (objectArray2 != null) {
            this.connectionTimeoutOverride_ = Integer.parseInt((String)objectArray2[0]);
            this.maxPoolConnectionsOverride_ = Integer.parseInt((String)objectArray2[1]);
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "registerDataSource", null);
        }
    }

    private void prepToSendCLPPLUSData(Object[] objectArray) {
        this.driverNameOverride_ = DataBean.get(objectArray, 0).toString();
        this.driverVersionOverride_ = DataBean.get(objectArray, 1).toString();
        if (this.firstConnectionBean_ != null) {
            this.firstConnectionBean_.driverName_ = this.driverNameOverride_;
            this.firstConnectionBean_.driverVersion_ = this.driverVersionOverride_;
            if (this.monitorAgent_ != null) {
                this.monitorAgent_.reportFirstConnection(this.firstConnectionBean_);
            }
        }
    }

    private void prepToSendWasData(Object[] objectArray) {
        this.firstConnectionWasData_ = objectArray;
        this.firstConnectionDataReported_ = false;
        if (this.firstConnectionBean_ != null) {
            this.firstConnectionBean_.wasData_ = this.firstConnectionWasData_;
            if (this.monitorAgent_ != null) {
                this.monitorAgent_.reportFirstConnection(this.firstConnectionBean_);
            }
        }
    }

    @Override
    public boolean isMonitoring() {
        return this.isMonitoring_;
    }

    @Override
    public abstract Object createXAResourceProxy(XAResource var1);

    protected abstract void getClientSettingsFromWrapper_();

    public abstract Object createMaterialConnectionProxy_(Connection var1, String var2, XAResource var3) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createConnectionProxy(Connection connection, String string, XAResource xAResource) throws Throwable {
        Object object;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "createConnectionProxy", "ENTRY " + Arrays.deepToString(new Object[]{connection, string, xAResource}));
        }
        this.initializeAndReportFirstConnectionData(connection);
        if (this.monitorEnabled_ == 2) {
            object = connection;
        } else if (this.disableProxies_) {
            object = connection;
        } else {
            object = this.createMaterialConnectionProxy_(connection, string, xAResource);
            WeakHashMap<Object, Object> weakHashMap = this.activeConnectionInvocationHandlers_;
            synchronized (weakHashMap) {
                this.activeConnectionInvocationHandlers_.put(Proxy.getInvocationHandler(object), null);
            }
        }
        return object;
    }

    private void initializeAndReportFirstConnectionData(Connection connection) throws SQLException {
        block7: {
            boolean bl2 = false;
            if (this.firstConnectionBean_ == null) {
                this.initializeFirstConnectionData_(connection);
                bl2 = true;
            }
            if (!this.firstConnectionDataReported_ && this.monitorAgent_ != null) {
                this.monitorAgent_.reportFirstConnection(this.firstConnectionBean_);
                this.firstConnectionDataReported_ = true;
            }
            if (this.haveNewActualBackendLocation_) {
                this.resolve();
            }
            if (bl2 && !hasHttpControllerURL_ && this.monitorURLFromStoredProc_ != null) {
                this.compositecds_.updateCDSWithMonitorDataFromSP(this.monitorURLFromStoredProc_);
                this.updateMonitorAgent();
                if (this.monitorAgent_ != null) {
                    try {
                        this.monitorAgent_.getConnection();
                    }
                    catch (Exception exception) {
                        if (!logger__.isLoggable(Level.FINER)) break block7;
                        logger__.log(Level.FINER, "Error connecting to the monitoring server.", exception);
                    }
                }
            }
        }
    }

    protected void purgeWASPool() {
    }

    protected abstract void initializeFirstConnectionData_(Connection var1);

    private void getResolvedMonitorInfo(ControlDataSource controlDataSource, StringBuilder stringBuilder) {
        stringBuilder.append("monitorLevel=" + (controlDataSource == null ? this.monitorLevel_ : controlDataSource.getPropertyValue("monitorLevel", this.monitorLevel_)) + "\n");
        stringBuilder.append("monitorEnabled=" + (controlDataSource == null ? this.monitorEnabled_ : controlDataSource.getPropertyValue("monitorEnabled", this.monitorEnabled_)) + "\n");
        stringBuilder.append("monitorServer=" + (controlDataSource == null ? this.monitorServer_ : controlDataSource.getPropertyValue("monitorServerName", this.monitorServer_)) + "\n");
        stringBuilder.append("monitorPort=" + (controlDataSource == null ? this.monitorPort_ : controlDataSource.getPropertyValue("monitorPort", this.monitorPort_)) + "\n");
        stringBuilder.append("monitorCollectionInterval=" + (controlDataSource == null ? this.monitorCollectionInterval_ : controlDataSource.getPropertyValue("monitorCollectionInterval", this.monitorCollectionInterval_)) + "\n");
        stringBuilder.append("supportedKeyTypes=" + (controlDataSource == null ? null : controlDataSource.getPropertyValue("supportedKeyTypes", null)) + "\n");
        stringBuilder.append("clientUserMask=" + (controlDataSource == null ? null : controlDataSource.getPropertyValue("clientUserMask", null)) + "\n");
        stringBuilder.append("clientHostnameMask=" + (controlDataSource == null ? null : controlDataSource.getPropertyValue("clientHostnameMask", null)) + "\n");
        stringBuilder.append("clientApplicationNameMask=" + (controlDataSource == null ? null : controlDataSource.getPropertyValue("applicationNameMask", null)) + "\n");
        stringBuilder.append("clientAccountingInformationMask=" + (controlDataSource == null ? null : controlDataSource.getPropertyValue("clientAccountingInformationMask", null)) + "\n");
        stringBuilder.append("clientPollingInterval=" + (controlDataSource == null ? -1 : controlDataSource.getPropertyValue("clientPollingInterval", -1)) + "\n");
        stringBuilder.append("dispatchToken=" + (controlDataSource == null ? -1 : controlDataSource.getPropertyValue("dispatchToken", -1)) + "\n");
        stringBuilder.append("logicalDatabaseLookupName=" + (controlDataSource == null ? this.monitoredDataSourceName_ : controlDataSource.getPropertyValue("logicalDatabaseLookupName", this.monitoredDataSourceName_)) + "\n");
        stringBuilder.append("monitoredDatabaseServerName=" + (controlDataSource == null ? this.monitoredDatabaseServerName_ : controlDataSource.getPropertyValue("monitoredDatabaseServerName", this.monitoredDatabaseServerName_)) + "\n");
        stringBuilder.append("monitoredDatabasePort=" + (controlDataSource == null ? this.monitoredDatabasePort_ : controlDataSource.getPropertyValue("monitoredDatabasePort", this.monitoredDatabasePort_)) + "\n");
        stringBuilder.append("monitoredDatabaseName=" + (controlDataSource == null ? this.monitoredDatabaseName_ : controlDataSource.getPropertyValue("monitoredDatabaseName", this.monitoredDatabaseName_)) + "\n");
        stringBuilder.append("monitoredLocationName=" + (controlDataSource == null ? this.monitoredLocationName_ : controlDataSource.getPropertyValue("monitoredLocationName", this.monitoredLocationName_)) + "\n");
        stringBuilder.append("disableOCMDynamicControl=" + (controlDataSource == null ? this.disableOCMDynamicControl_ : controlDataSource.getPropertyValue("disableOCMDynamicControl", this.disableOCMDynamicControl_)) + "\n");
    }

    public void getResolvedMonitorInfo(StringBuilder stringBuilder) {
        this.getResolvedMonitorInfo(this.compositecds_, stringBuilder);
    }

    private void getControllerInfo(ControlDataSourceImpl controlDataSourceImpl, StringBuilder stringBuilder) {
        if (controlDataSourceImpl != null) {
            ControllerAgent controllerAgent = controlDataSourceImpl.getControllerAgent();
            if (controllerAgent != null) {
                controllerAgent.getControllerInfo(stringBuilder);
            } else {
                stringBuilder.append("    " + (controlDataSourceImpl.getControllerType() == Service.ControllerType.OCM ? "Http " : "") + "Controller Agent is null.");
            }
        } else {
            stringBuilder.append("    " + (controlDataSourceImpl.getControllerType() == Service.ControllerType.OCM ? "Http " : "") + "Controller is NOT available.");
        }
    }

    public void getControllerInfo(StringBuilder stringBuilder) {
        ControlDataSourcePool controlDataSourcePool = ControlDataSourcePool.getInstance();
        ControlDataSourceImpl controlDataSourceImpl = null;
        controlDataSourceImpl = controlDataSourcePool.getPooledInstanceOrCreateCDS(Service.ControllerType.OPM, this.dataSourceDescriptorMap_, this.datasourceId_, this.monitoredDataSourceName_, this.monitoredDatabaseServerName_, String.valueOf(this.monitoredDatabasePort_), this.monitoredDatabaseName_, this.monitoredLocationName_, this);
        stringBuilder.append("  OPM:\n");
        this.getControllerInfo(controlDataSourceImpl, stringBuilder);
        if (this.isOCMEnabled()) {
            controlDataSourceImpl = controlDataSourcePool.getPooledInstanceOrCreateCDS(Service.ControllerType.OCM, this.dataSourceDescriptorMap_, this.datasourceId_, this.monitoredDataSourceName_, this.monitoredDatabaseServerName_, String.valueOf(this.monitoredDatabasePort_), this.monitoredDatabaseName_, this.monitoredLocationName_, null);
            stringBuilder.append("  OCM/DSM:\n");
            this.getControllerInfo(controlDataSourceImpl, stringBuilder);
        }
    }

    public String getMonitoredDatabaseServerName_() {
        return this.monitoredDatabaseServerName_;
    }

    public int getDatasourceId() {
        return this.datasourceId_;
    }

    protected void applyStaticPushDownProperties() {
    }

    protected void checkAndReportApplnException(SQLException sQLException) {
    }

    public WeakHashMap<Object, Object> getActiveConnectionInvocationHandlers() {
        return this.activeConnectionInvocationHandlers_;
    }

    public void getIntervalProperties() {
        if (this.compositecds_ != null) {
            this.compositecds_.lock();
            try {
                this.monitorAgent_.updateIntervalSettings(this.compositecds_.getPropertyValue("dispatchToken", -1), this.compositecds_.getPropertyValue("monitorEnabled", this.monitorEnabled_));
            }
            finally {
                this.compositecds_.unlock();
            }
        }
    }

    public boolean hasInitialLookupOccurred() {
        return this.compositecds_.hasInitialLookupOccurred();
    }

    protected void finalize() throws Throwable {
        if (this.isOCMEnabled()) {
            ControlDriver.getInstance().doLogStatisticsLookup();
            if (this.compositecds_ != null && this.dataSourceDescriptorMap_ != null && this.dataSourceDescriptorMap_.get("dataSourceId") != null) {
                this.compositecds_.sendDeregisterDataSource((String)this.dataSourceDescriptorMap_.get("dataSourceId"));
            }
            ControlDataSourcePool.getInstance().removeCDSFromPool(this.datasourceId_);
        }
        super.finalize();
    }

    public ControlDataSource getControlDataSource() {
        return this.compositecds_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientInfo(ClientInfo clientInfo) {
        int n2 = ControlDriver.getInstance().getDriverProfile().getMaxClientInfoToLogPerDataSource();
        Object object = this.clientInfoLock_;
        synchronized (object) {
            if (this.clientInfoSet_.size() < n2) {
                this.clientInfoSet_.add(clientInfo);
            }
        }
    }

    public Map<String, Object> getNewDataSourceDescriptorMap() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.dataSourceDescriptorMap_);
        HashMap hashMap2 = this.getDataSourceDescriptorProperties();
        HashMap<String, Object> hashMap3 = this.getDataSourceDescriptorPropertiesForWAS();
        if (hashMap2 != null) {
            hashMap.put("dsDescriptorProfileName", hashMap2.get("profileName"));
            hashMap.put("dsDescriptorJDBCDSName", hashMap2.get("dataSourceName"));
            hashMap.put("dsDescriptorDBServer", hashMap2.get("serverName"));
            hashMap.put("dsDescriptorDBPort", hashMap2.get("portNumber") != null ? hashMap2.get("portNumber") : Integer.valueOf(0));
            hashMap.put("dsDescriptorDBName", hashMap2.get("databaseName"));
            hashMap.put("dsDescriptorClientPropertySettings", hashMap2);
        }
        if (hashMap3 != null) {
            hashMap.putAll(hashMap3);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<ClientInfo> getClientInfo() {
        int n2 = 0;
        Iterator<ClientInfo> iterator = this.clientInfoLock_;
        synchronized (iterator) {
            HashSet<ClientInfo> hashSet = this.clientInfoSet_;
            this.clientInfoSet_ = this.auxClientInfoSet_;
            this.auxClientInfoSet_ = hashSet;
        }
        int n3 = ControlDriver.getInstance().getDriverProfile().getMaxClientInfoToLogPerDataSource();
        if (this.auxClientInfoSet_.size() > n3) {
            iterator = this.auxClientInfoSet_.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                if (++n2 <= n3) continue;
                iterator.remove();
            }
        }
        return this.auxClientInfoSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearApplicationExceptionSet() {
        HashSet<Integer> hashSet = this.applicationExceptionSet_;
        synchronized (hashSet) {
            this.applicationExceptionSet_.clear();
        }
    }

    public long getOcmDatabaseVersion() {
        return this.lastDatabaseVersion_;
    }

    public long getOcmLastPhysicalLocationChangeVersion() {
        return this.lastPhysicalLocationChangeVersion_;
    }

    public long getOcmLastDataSrcProfileVersion() {
        return this.lastDataSrcProfileVersion_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicPushDownErrors(ArrayList<PushDownError> arrayList) {
        String string = null;
        Object object = this.dynamicPushDownLock_;
        synchronized (object) {
            for (int i10 = 0; i10 < arrayList.size(); ++i10) {
                PushDownError pushDownError = arrayList.get(i10);
                string = "" + pushDownError.getPropertyName();
                PushDownError.ErrorType errorType = pushDownError.getErrorType();
                string = errorType == PushDownError.ErrorType.unrecognizedProperty || errorType == PushDownError.ErrorType.unsupportedPropertyForDynamicPushDown ? string + errorType.toString() : string + ((PushDownError.SQLException)pushDownError).getSQLException().getErrorCode();
                if (this.duplicateErrorsMap_.contains(string)) continue;
                this.dynamicPushDownErrors_.add(pushDownError);
                this.duplicateErrorsMap_.add(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PushDownError> getDynamicPushDownErrors() {
        Object object = this.dynamicPushDownLock_;
        synchronized (object) {
            ArrayList<PushDownError> arrayList = this.dynamicPushDownErrors_;
            this.dynamicPushDownErrors_ = this.auxDynamicPushDownErrors_;
            this.auxDynamicPushDownErrors_ = arrayList;
        }
        return this.auxDynamicPushDownErrors_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDynamicPushDownError(ArrayList<PushDownError> arrayList) {
        arrayList.clear();
        Object object = this.dynamicPushDownLock_;
        synchronized (object) {
            this.duplicateErrorsMap_.clear();
        }
    }

    public void applyDynamicProperties(Profile.DataSource dataSource) {
    }

    public long getDataSourceProfileVersion() {
        return this.lastAppliedDataSourceProfileVersion_;
    }

    public void setDataSourceProfileVersion(long l10) {
        this.lastAppliedDataSourceProfileVersion_ = l10;
    }

    public CMXListener getListener() {
        return this.cmxListener_;
    }

    public HashMap<String, String> getAppliedPropsStatusFromWAS_() {
        return this.appliedPropsStatusFromWAS_;
    }

    static {
        Configuration.class.getClass();
        currentSerialNumber = 1;
        lock = new Object();
        hasHttpControllerURL_ = true;
        disablePureQuery_ = false;
        disableExtendedInsight_ = false;
        hasControllerURL_ = DataProperties.getProperty("pdq.cmx.controllerURL") != null;
        controllerAccessPolicy_ = Configuration.ControllerAccessPolicy.values()[Integer.parseInt(DataProperties.getProperty("pdq.cmx.controllerAccessPolicy"))];
        logger__ = Log.getCMXClientLogger();
    }
}

