/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.controller;

import com.ibm.db2.cmx.ClientInfo;
import com.ibm.db2.cmx.MonitorInterface;
import com.ibm.db2.cmx.PushDownError;
import com.ibm.db2.cmx.TransportPoolStatistics;
import com.ibm.db2.cmx.impl.HttpControllerProcessorAS;
import com.ibm.db2.cmx.internal.controller.ControlDataSourceImpl;
import com.ibm.db2.cmx.internal.controller.ControlDriver;
import com.ibm.db2.cmx.internal.controller.ControllerAgent;
import com.ibm.db2.cmx.internal.controller.ControllerMessageHelper;
import com.ibm.db2.cmx.internal.core.Constants;
import com.ibm.db2.cmx.internal.core.CoreProcessor;
import com.ibm.db2.cmx.internal.core.HttpReply;
import com.ibm.db2.cmx.internal.core.HttpRequest;
import com.ibm.db2.cmx.internal.core.Message;
import com.ibm.db2.cmx.internal.core.Processor;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.internal.Configuration;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HttpControllerAgentImpl
implements ControllerAgent {
    private static Logger logger__ = Log.getCMXClientLogger();
    private CoreProcessor coreProcessor_ = new CoreProcessor();
    private static Map<String, HttpControllerAgentImpl> pool__ = new HashMap<String, HttpControllerAgentImpl>();
    private URL servletURL_ = null;
    private Proxy proxy_ = null;
    private static boolean bDisconnectHttpURLConnection__ = Boolean.valueOf(DataProperties.getProperty("pdq.cmx.http.disconnect"));
    private int negotiatedControllerProtocol_ = -1;

    public HttpControllerAgentImpl(String string, String string2) {
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "<init>", "ENTRY " + Arrays.deepToString(new Object[]{string, string2}));
        }
        this.initializeFixedAddress(string, string2);
    }

    private void initializeFixedAddress(String string, String string2) {
        InetSocketAddress inetSocketAddress;
        String string3 = null;
        if (string != null) {
            string3 = this.createURLString(string, string2);
        }
        try {
            this.servletURL_ = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            DataLogger.lowImpactLogger(logger__, this, "initializeFixedAddress", "Invalid controllerURL: '" + string3 + "'", malformedURLException);
        }
        if (DataProperties.getProperty("pdq.cmx.http.proxyURL") != null && (inetSocketAddress = this.getAddress(DataProperties.getProperty("pdq.cmx.http.proxyURL"))) != null) {
            this.proxy_ = new Proxy(Proxy.Type.HTTP, inetSocketAddress);
        }
    }

    private InetSocketAddress getAddress(String string) {
        try {
            String string2 = string;
            int n2 = 80;
            int n3 = string.lastIndexOf(58);
            if (n3 > 0) {
                string2 = string.substring(0, n3);
                n2 = Integer.valueOf(string.substring(n3 + 1).trim());
            }
            return new InetSocketAddress(string2, n2);
        }
        catch (NumberFormatException numberFormatException) {
            DataLogger.lowImpactLogger(logger__, this, "getAddress", "Invalid number format when parsing proxyURL: '" + string + "'", numberFormatException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpControllerAgentImpl getInstance(String string, String string2, boolean bl2) {
        Map<String, HttpControllerAgentImpl> map = pool__;
        synchronized (map) {
            if (pool__.containsKey(string)) {
                return pool__.get(string);
            }
            HttpControllerAgentImpl httpControllerAgentImpl = new HttpControllerAgentImpl(string, string2);
            if (!bl2) {
                pool__.put(string, httpControllerAgentImpl);
                ControlDriver.getInstance().initializeRegisterDriverTask();
            }
            return httpControllerAgentImpl;
        }
    }

    private String createURLString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        String string3 = null;
        stringBuilder.append(string);
        string3 = DataProperties.getProperty("pdq.cmx.http.requestPath");
        if (string3 != null) {
            if (!string3.startsWith("/")) {
                stringBuilder.append("/");
            }
            stringBuilder.append(string3);
        }
        if (string2 != null) {
            stringBuilder.append("?" + string2);
        }
        return stringBuilder.toString();
    }

    @Override
    public void getControllerInfo(StringBuilder stringBuilder) {
        stringBuilder.append("    Http Controller Agent Connection URL: " + this.servletURL_ + "\n    Http Controller Agent Connection Active: " + this.isConnected() + "\n");
    }

    @Override
    public synchronized void lookupOverNetwork(ControlDataSourceImpl controlDataSourceImpl) throws Exception {
        Message message = null;
        HttpURLConnection httpURLConnection = null;
        if (this.servletURL_ != null) {
            ControllerMessageHelper controllerMessageHelper = null;
            Message message2 = null;
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "lookupOverNetwork", "Sending remote property lookup request to " + this.servletURL_ + " for " + controlDataSourceImpl.getLogicalName() + ", " + controlDataSourceImpl.getMonitoredServerName() + ", " + controlDataSourceImpl.getMonitoredServerHostname() + ", " + controlDataSourceImpl.getMonitoredPortNumber() + ", " + controlDataSourceImpl.getMonitoredDatabaseName() + ", " + controlDataSourceImpl.getMonitoredLocationName());
            }
            controllerMessageHelper = ControllerMessageHelper.getInstance();
            message2 = controllerMessageHelper.createLookupRequest(controlDataSourceImpl.getLogicalName(), controlDataSourceImpl.getMonitoredServerName(), controlDataSourceImpl.getMonitoredServerHostname(), controlDataSourceImpl.getMonitoredPortNumber(), controlDataSourceImpl.getMonitoredDatabaseName(), controlDataSourceImpl.getMonitoredLocationName(), 12);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, message2, (byte)1, true);
            message = this.receiveHttpCMXMessage(httpURLConnection, (byte)1, true);
            controllerMessageHelper.parseLookupReply(message, controlDataSourceImpl, null);
            this.disconnectHttpURLConnection(httpURLConnection);
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logControlDataSource(logger__, this, "lookupOverNetwork", controlDataSourceImpl);
                DataLogger.exit(logger__, this, "lookupOverNetwork", controlDataSourceImpl);
            }
        }
    }

    @Override
    public boolean isConnected() {
        try {
            HttpURLConnection httpURLConnection = this.connectUsingFixedAddressWithCurrentThread();
            this.checkPreconditions(httpURLConnection);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void deregisterMonitorDataSource(String string, String string2, int n2, String string3, String string4, int n3) throws Exception {
        Message message = null;
        HttpURLConnection httpURLConnection = null;
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "deregisterMonitorDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string, string2, n2, string3, string4}));
        }
        httpURLConnection = this.connectToControllerUsingCurrentThread();
        this.checkPreconditions(httpURLConnection);
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logConnectedComponents(logger__, this, "deregisterMonitorDataSource", "Sending deregister monitor datasource request");
        }
        message = controllerMessageHelper.createDeregisterRequest(string, string2, Configuration.resolveHostname(string2), n2 + "", string3, string4, n3, 12);
        httpURLConnection = this.getHttpURLConnection(1);
        this.sendHttpCMXMessage(httpURLConnection, message, (byte)1, true);
        this.receiveHttpCMXMessage(httpURLConnection, (byte)1, true);
        this.disconnectHttpURLConnection(httpURLConnection);
    }

    private void disconnectHttpURLConnection(HttpURLConnection httpURLConnection) {
        if (bDisconnectHttpURLConnection__ && httpURLConnection != null) {
            httpURLConnection.disconnect();
        }
    }

    private int connectToProcessor(HttpURLConnection httpURLConnection, Processor processor) {
        int n2;
        block5: {
            Message message = null;
            Message message2 = null;
            if (logger__.isLoggable(Level.FINER)) {
                DataLogger.logAtLevelFiner(logger__, this, "connectToProcessor", "ENTRY " + Arrays.deepToString(new Object[]{processor}));
            }
            n2 = -1;
            try {
                if (logger__.isLoggable(Level.FINE)) {
                    DataLogger.logConnectedComponents(logger__, this, "connectToProcessor", "Sending connect to processor request");
                }
                message = this.coreProcessor_.createConnectToProcessorRequest(processor);
                this.sendHttpCMXMessage(httpURLConnection, message, (byte)1, true);
                message2 = this.receiveHttpCMXMessage(httpURLConnection, (byte)1, true);
                this.negotiatedControllerProtocol_ = n2 = this.coreProcessor_.parseConnectReply(message2);
            }
            catch (Exception exception) {
                if (!logger__.isLoggable(Level.FINEST)) break block5;
                DataLogger.logTrappedException(logger__, this, "connectToProcessor", exception, null);
            }
        }
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.exit(logger__, this, "connectToProcessor", n2);
        }
        return n2;
    }

    private HttpURLConnection createConnection() {
        HttpURLConnection httpURLConnection = null;
        int n2 = -1;
        try {
            httpURLConnection = this.getHttpURLConnection(1);
        }
        catch (IOException iOException) {
            if (logger__.isLoggable(Level.INFO)) {
                DataLogger.lowImpactLogger(logger__, this, "createConnection", "WARNING: Failed to establish a socket connection to controller server at " + this.servletURL_, iOException);
            }
            return null;
        }
        if (n2 == -1) {
            n2 = this.connectToProcessor(httpURLConnection, new HttpControllerProcessorAS());
            if (n2 != -1) {
                if (logger__.isLoggable(Level.CONFIG)) {
                    DataLogger.logConfigHighVis(logger__, this, "createConnection", "Successfully connected to a controller server at " + this.servletURL_, false);
                }
            } else {
                if (logger__.isLoggable(Level.INFO)) {
                    DataLogger.lowImpactLogger(logger__, this, "createConnection", "WARNING: Incompatible controller server version.  Did not successfully connect to a compatible controller server at " + this.servletURL_, null);
                }
                return null;
            }
        }
        return httpURLConnection;
    }

    private HttpURLConnection connectUsingFixedAddressWithCurrentThread() {
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "connectUsingFixedAddressWithCurrentThread", "Attempting to connect to a controller server using " + this.servletURL_);
        }
        return this.createConnection();
    }

    private HttpURLConnection connectToControllerUsingCurrentThread() throws Exception {
        return this.connectUsingFixedAddressWithCurrentThread();
    }

    private void checkPreconditions(HttpURLConnection httpURLConnection) throws Exception {
        if (httpURLConnection == null) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_MONITOR_UNABLE_TO_CONNECT_TO_CONTOLLER", new Object[0]) + " (" + this.servletURL_ + ")", null, 11242);
        }
    }

    @Override
    public void registerMonitorDataSource(String string, String string2, String[] stringArray, int n2, String string3, String[] stringArray2, int n3, int n4, int n5, int n6, boolean bl2, int[] nArray, String[] stringArray3, String string4, int n7, int n8) throws Exception {
        HttpURLConnection httpURLConnection = null;
        Message message = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (logger__.isLoggable(Level.FINER)) {
            DataLogger.logAtLevelFiner(logger__, this, "registerMonitorDataSource", "ENTRY " + Arrays.deepToString(new Object[]{string, string2, stringArray, n2, string3, stringArray2, n3, nArray, n5, n6, bl2, nArray, stringArray3, string4}));
        }
        httpURLConnection = this.connectToControllerUsingCurrentThread();
        this.checkPreconditions(httpURLConnection);
        if (logger__.isLoggable(Level.FINE)) {
            DataLogger.logConnectedComponents(logger__, this, "registerMonitorDataSource", "Sending register monitor datasource request");
        }
        message = controllerMessageHelper.createRegisterRequest(string, string2, Configuration.resolveToIPAddress(string2), Configuration.resolveHostname(string2), stringArray, n2 + "", string3, stringArray2, n3, n4, n5, n6, bl2, nArray, stringArray3, string4, n7, 12, n8);
        httpURLConnection = this.getHttpURLConnection(1);
        this.sendHttpCMXMessage(httpURLConnection, message, (byte)1, true);
        this.receiveHttpCMXMessage(httpURLConnection, (byte)1, true);
        this.disconnectHttpURLConnection(httpURLConnection);
    }

    private void setHttpURLConnectionOptions(HttpURLConnection httpURLConnection, int n2) {
        try {
            httpURLConnection.setRequestMethod("POST");
        }
        catch (ProtocolException protocolException) {
            DataLogger.lowImpactLogger(logger__, this, "setHttpURLConnectionOptions", "error calling setRequestMethod with method POST", protocolException);
        }
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setConnectTimeout(Constants.SOCKET_CONNECT_TIMEOUT);
        httpURLConnection.setReadTimeout(Constants.REPLY_TIMEOUT);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setRequestProperty("Content-Type", "application/vnd-cmx+jason");
        httpURLConnection.setRequestProperty("CMX-Client-Version", "3.3306.7");
        httpURLConnection.setRequestProperty("CMX-Client-Processor-Version", Integer.toString(12));
        httpURLConnection.setRequestProperty("CMX-Num-Chained-Requests", Integer.toString(n2));
    }

    private PrivilegedExceptionAction<Object> doPrivilegedConnect(final HttpURLConnection httpURLConnection) {
        return new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws IOException {
                httpURLConnection.connect();
                return null;
            }
        };
    }

    private HttpURLConnection getHttpURLConnection(int n2) throws IOException {
        HttpURLConnection httpURLConnection = null;
        if (this.servletURL_ != null) {
            httpURLConnection = this.proxy_ != null ? (HttpURLConnection)this.servletURL_.openConnection(this.proxy_) : (HttpURLConnection)this.servletURL_.openConnection();
            this.setHttpURLConnectionOptions(httpURLConnection, n2);
            try {
                AccessController.doPrivileged(this.doPrivilegedConnect(httpURLConnection));
            }
            catch (PrivilegedActionException privilegedActionException) {
                DataLogger.lowImpactLogger(logger__, this, "getHttpURLConnection", "WARNING: Failed to establish a socket connection to controller server at " + this.servletURL_, privilegedActionException);
                throw new IOException(privilegedActionException.getCause() != null ? privilegedActionException.getCause().getMessage() : null);
            }
        }
        return httpURLConnection;
    }

    private void getHttpReplyBytes(HttpURLConnection httpURLConnection) throws Exception {
        InputStream inputStream = httpURLConnection.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        inputStream.close();
        byteArrayOutputStream.close();
    }

    private void getHttpReplyString(HttpURLConnection httpURLConnection) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuilder.append(string + '\n');
        }
        bufferedReader.close();
    }

    private void sendHttpCMXMessage(HttpURLConnection httpURLConnection, Message message, byte by2, boolean bl2) throws IOException {
        OutputStream outputStream = null;
        HttpRequest httpRequest = null;
        if (httpURLConnection == null) {
            throw new IOException("Http connection is null");
        }
        outputStream = httpURLConnection.getOutputStream();
        httpRequest = new HttpRequest(outputStream);
        httpRequest.flushMessage(message, by2);
        if (bl2) {
            outputStream.close();
        }
        if (logger__.isLoggable(Level.FINEST)) {
            DataLogger.logMonitorBuffer(logger__, this, "sendHttpCMXMessage", "Chaining " + (bl2 ? "off" : "on") + ", payload(UTF-8): ", message);
        }
    }

    private Message receiveHttpCMXMessage(HttpURLConnection httpURLConnection, byte by2, boolean bl2) throws Exception {
        Message message = null;
        if (httpURLConnection == null) {
            throw new IOException("Http connection is null");
        }
        if (by2 == 3) {
            InputStream inputStream = httpURLConnection.getInputStream();
            if (bl2 && inputStream != null) {
                inputStream.close();
            }
        } else {
            InputStream inputStream = httpURLConnection.getInputStream();
            HttpReply httpReply = new HttpReply(inputStream);
            message = httpReply.parseReply();
            if (message.getProcessorName().equals("CMXCoreProcessor")) {
                this.coreProcessor_.checkForError(message);
            }
            if (bl2) {
                inputStream.close();
            }
            if (logger__.isLoggable(Level.FINEST)) {
                DataLogger.logMonitorBuffer(logger__, this, "receiveHttpCMXMessage", "Chaining " + (bl2 ? "off" : "on") + ", payload(UTF-8): ", message);
            }
        }
        return message;
    }

    @Override
    public void registerDriverOverNetwork(Map<String, Object> map, String string, String string2, long l10) throws Exception {
        Message message = null;
        HttpURLConnection httpURLConnection = null;
        if (this.servletURL_ != null) {
            ControllerMessageHelper controllerMessageHelper = null;
            Message message2 = null;
            if (logger__.isLoggable(Level.FINE)) {
                StringBuilder stringBuilder = new StringBuilder();
                if (map != null) {
                    String[] stringArray = null;
                    stringBuilder.append("[");
                    stringBuilder.append(map.get("driverDescriptorUUID"));
                    stringArray = (String[])map.get("driverDescriptorClientIP");
                    if (stringArray != null) {
                        for (String string3 : stringArray) {
                            stringBuilder.append(", ");
                            stringBuilder.append(string3);
                        }
                    }
                    stringBuilder.append("]");
                } else {
                    stringBuilder.append("[");
                    stringBuilder.append(string);
                    stringBuilder.append(", ");
                    stringBuilder.append(string2);
                    stringBuilder.append("]");
                }
                DataLogger.logConnectedComponents(logger__, this, "registerDriverOverNetwork", "Sending remote property lookup request to " + this.servletURL_ + " for " + stringBuilder);
            }
            controllerMessageHelper = ControllerMessageHelper.getInstance();
            message2 = controllerMessageHelper.createRegisterDriverRequest(map, string, string2, l10, 12);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, message2, (byte)1, true);
            message = this.receiveHttpCMXMessage(httpURLConnection, (byte)1, true);
            controllerMessageHelper.parseRegisterDriverReply(message, this.negotiatedControllerProtocol_, null);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    @Override
    public void sendDeregisterDriver(String string) throws Exception {
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.servletURL_ != null) {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "sendDeregisterDriver", "Sending deregister driver to " + this.servletURL_ + " for " + string);
            }
            Message message = controllerMessageHelper.createDeregisterDriverRequest(string);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, message, (byte)1, true);
            this.receiveHttpCMXMessage(httpURLConnection, (byte)1, true);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    @Override
    public void sendDeregisterDataSource(String string) throws Exception {
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.servletURL_ != null) {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "sendDeregisterDataSource", "Sending deregister datasource to " + this.servletURL_ + " for " + string);
            }
            Message message = controllerMessageHelper.createDeregisterDataSourceRequest(string);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, message, (byte)1, true);
            this.receiveHttpCMXMessage(httpURLConnection, (byte)1, true);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    public boolean sendClearServerCache() throws Exception {
        HttpURLConnection httpURLConnection = null;
        int n2 = -1;
        if (this.servletURL_ != null) {
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "sendClearServerCache", "Sending clear server cache request " + this.servletURL_);
            }
            httpURLConnection = (HttpURLConnection)this.servletURL_.openConnection();
            httpURLConnection.setRequestProperty("Accept-Charset", "UTF-8");
            httpURLConnection.setConnectTimeout(Constants.SOCKET_CONNECT_TIMEOUT);
            httpURLConnection.setReadTimeout(Constants.REPLY_TIMEOUT);
            this.doConnectForSendClearServerCache(httpURLConnection);
            n2 = httpURLConnection.getResponseCode();
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "sendClearServerCache", "Received http response code " + n2);
            }
        }
        return n2 == 200;
    }

    private void doConnectForSendClearServerCache(HttpURLConnection httpURLConnection) throws IOException {
        try {
            AccessController.doPrivileged(this.doPrivilegedConnect(httpURLConnection));
        }
        catch (PrivilegedActionException privilegedActionException) {
            DataLogger.lowImpactLogger(logger__, this, "doConnectForSendClearServerCache", "WARNING: Failed to establish a socket connection using " + this.servletURL_, privilegedActionException);
            throw new IOException(privilegedActionException.getCause() != null ? privilegedActionException.getCause().getMessage() : null);
        }
    }

    @Override
    public void sendAndReceiveChainedMessages(ArrayList<ControlDriver.RequestInfo> arrayList) throws Exception {
        Message message = null;
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = null;
        if (this.servletURL_ != null) {
            controllerMessageHelper = ControllerMessageHelper.getInstance();
            if (logger__.isLoggable(Level.FINE)) {
                DataLogger.logConnectedComponents(logger__, this, "sendAndReceiveChainedMessages", "Sending chained registration requests to " + this.servletURL_);
            }
            httpURLConnection = this.getHttpURLConnection(arrayList.size());
            for (ControlDriver.RequestInfo requestInfo : arrayList) {
                this.sendHttpCMXMessage(httpURLConnection, requestInfo.getMessage(), (byte)1, false);
            }
            httpURLConnection.getOutputStream().close();
            for (ControlDriver.RequestInfo requestInfo : arrayList) {
                ControlDataSourceImpl controlDataSourceImpl;
                message = this.receiveHttpCMXMessage(httpURLConnection, (byte)1, false);
                if (requestInfo.getMessageType().equals("4")) {
                    controllerMessageHelper.parseRegisterDriverReply(message, this.negotiatedControllerProtocol_, null);
                    continue;
                }
                if (requestInfo.getMessageType().equals("5")) {
                    controllerMessageHelper.parseLookupDatabaseReply(requestInfo.getLogicalDatabaseName(), message, this.negotiatedControllerProtocol_);
                    continue;
                }
                if (requestInfo.getMessageType().equals("6")) {
                    controlDataSourceImpl = requestInfo.getCDS();
                    controllerMessageHelper.parseRegisterDataSourceReply(message, controlDataSourceImpl, this.negotiatedControllerProtocol_, null);
                    if (this.negotiatedControllerProtocol_ < 9) continue;
                    controllerMessageHelper.processCMXProperties(controlDataSourceImpl);
                    continue;
                }
                if (!requestInfo.getMessageType().equals("1")) continue;
                controlDataSourceImpl = requestInfo.getCDS();
                controllerMessageHelper.parseLookupReply(message, controlDataSourceImpl, null);
                controlDataSourceImpl.initialLookupOccurred();
            }
            httpURLConnection.getInputStream().close();
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    @Override
    public void logLookup(String string, String string2, String string3, String string4, String string5, String string6, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5) throws Exception {
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.servletURL_ != null && this.negotiatedControllerProtocol_ < 6) {
            Object object;
            if (logger__.isLoggable(Level.FINE)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string3);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string4);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string5);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string6);
                ((StringBuilder)object).append("]");
                DataLogger.logConnectedComponents(logger__, this, "logLookup", "Sending logLookup to " + this.servletURL_ + " for " + object);
            }
            object = controllerMessageHelper.createLogLookupMessage(string, string2, string3, string4, string5, string6, stringArray, stringArray2, stringArray3, stringArray4, stringArray5);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, (Message)object, (byte)3, true);
            this.receiveHttpCMXMessage(httpURLConnection, (byte)3, true);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    @Override
    public void logStatistics(String string, String string2, String string3, String string4, String[] stringArray, String[] stringArray2, String[] stringArray3, Set<ClientInfo>[] setArray, HashMap<String, TransportPoolStatistics> hashMap, long[][] lArray, Long[] longArray, Object[][] objectArray, String[] stringArray4, String[] stringArray5, String[] stringArray6, String[] stringArray7, long[][] lArray2) throws Exception {
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.servletURL_ != null) {
            Object object;
            if (logger__.isLoggable(Level.FINE)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string3);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string4);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(Arrays.deepToString(stringArray));
                ((StringBuilder)object).append("]");
                DataLogger.logConnectedComponents(logger__, this, "logStatistics", "Sending logStatistics to " + this.servletURL_ + " for " + object);
            }
            object = null;
            object = controllerMessageHelper.createLogStatisticsMessage(string, string2, string3, string4, stringArray, stringArray2, stringArray3, setArray, hashMap, lArray, longArray, objectArray, stringArray4, stringArray5, stringArray6, stringArray7, lArray2, this.negotiatedControllerProtocol_);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, (Message)object, (byte)3, true);
            this.receiveHttpCMXMessage(httpURLConnection, (byte)3, true);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    @Override
    public void logPushDownErrors(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, ArrayList<PushDownError> arrayList) throws Exception {
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.servletURL_ != null) {
            Object object;
            if (logger__.isLoggable(Level.FINE)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string3);
                ((StringBuilder)object).append("]");
                DataLogger.logConnectedComponents(logger__, this, "logPushDownErrors", "Sending pushdown errors to " + this.servletURL_ + " for " + object);
            }
            object = controllerMessageHelper.createLogPushDownErrorsMessage(string, string2, string3, clientRuntime, arrayList);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, (Message)object, (byte)3, true);
            this.receiveHttpCMXMessage(httpURLConnection, (byte)3, true);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    @Override
    public void logApplicationException(String string, String string2, String string3, MonitorInterface.ClientRuntime clientRuntime, SQLException sQLException) throws Exception {
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.servletURL_ != null) {
            Object object;
            if (logger__.isLoggable(Level.FINE)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string3);
                ((StringBuilder)object).append("]");
                DataLogger.logConnectedComponents(logger__, this, "logApplicationException", "Sending application exception to " + this.servletURL_ + " for " + object);
            }
            object = controllerMessageHelper.createLogApplicationExceptionMessage(string, string2, string3, clientRuntime, sQLException);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, (Message)object, (byte)3, true);
            this.receiveHttpCMXMessage(httpURLConnection, (byte)3, true);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    @Override
    public void logPushDownApplication(String string, String string2, Map<String, Object> map, String string3, String string4, String string5, String string6, String[] stringArray, Map<String, Object>[] mapArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, String[] stringArray5, HashMap<String, String>[] hashMapArray) throws Exception {
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.servletURL_ != null && this.negotiatedControllerProtocol_ >= 6) {
            Object object;
            if (logger__.isLoggable(Level.FINE)) {
                object = new StringBuilder();
                ((StringBuilder)object).append("[");
                ((StringBuilder)object).append(string);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string3);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string4);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string5);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string6);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(Arrays.deepToString(stringArray));
                ((StringBuilder)object).append("]");
                DataLogger.logConnectedComponents(logger__, this, "logPushDownApplication", "Sending pushdown application to " + this.servletURL_ + " for " + object);
            }
            object = null;
            object = controllerMessageHelper.createLogPushDownApplicationMessage(string, string2, map, string3, string4, string5, string6, stringArray, mapArray, stringArray2, stringArray3, stringArray4, stringArray5, hashMapArray, this.negotiatedControllerProtocol_);
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, (Message)object, (byte)3, true);
            this.receiveHttpCMXMessage(httpURLConnection, (byte)3, true);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }

    @Override
    public int getNegotiatedVersion() {
        return this.negotiatedControllerProtocol_;
    }

    public void sendHttpEIPayloadWithReceive(Message message) throws Exception {
        HttpURLConnection httpURLConnection = null;
        ControllerMessageHelper controllerMessageHelper = ControllerMessageHelper.getInstance();
        if (this.servletURL_ != null) {
            httpURLConnection = this.getHttpURLConnection(1);
            this.sendHttpCMXMessage(httpURLConnection, message, (byte)3, true);
            this.receiveHttpCMXMessage(httpURLConnection, (byte)3, true);
            this.disconnectHttpURLConnection(httpURLConnection);
        }
    }
}

