/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.r2dbc;

import com.ibm.db2.r2dbc.DB2Connection;
import com.ibm.db2.r2dbc.DB2PreparedStatement;
import com.ibm.db2.r2dbc.DB2Row;
import com.ibm.db2.r2dbc.DB2RowMetadata;
import com.ibm.db2.r2dbc.a.E;
import com.ibm.db2.r2dbc.a.K;
import com.ibm.db2.r2dbc.a.L;
import com.ibm.db2.r2dbc.a.aN;
import com.ibm.db2.r2dbc.b.b;
import com.ibm.db2.r2dbc.b.d;
import com.ibm.db2.r2dbc.b.f;
import com.ibm.db2.r2dbc.b.n;
import com.ibm.db2.r2dbc.b.o;
import com.ibm.db2.r2dbc.d.a;
import com.ibm.db2.r2dbc.e.c;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.Result;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class DB2Result
implements Result {
    private static final Logger _logger = LoggerFactory.getLogger((String)DB2Result.class.getName());
    private DB2PreparedStatement _ps;
    private n _query;
    private L _omd;
    private int _cid;
    private int _pid;
    private DB2RowMetadata _metadata;
    private LinkedList<DB2Row> _rows;
    private AtomicBoolean _isEndOfData = new AtomicBoolean(false);
    private int _fetchSize;
    private int _numRowsUpdated = 0;

    protected DB2Result(DB2PreparedStatement dB2PreparedStatement, int n2) {
        this._cid = dB2PreparedStatement.getConnection().getConnectionId();
        this._pid = dB2PreparedStatement.getSectionNumber();
        this._ps = dB2PreparedStatement;
        this._numRowsUpdated = n2;
    }

    protected DB2Result(DB2PreparedStatement dB2PreparedStatement, n n2, L l2, DB2RowMetadata dB2RowMetadata, E e2) {
        this._cid = dB2PreparedStatement.getConnection().getConnectionId();
        this._pid = dB2PreparedStatement.getSectionNumber();
        this._ps = dB2PreparedStatement;
        this._query = n2;
        this._omd = l2;
        this._metadata = dB2RowMetadata;
        this._rows = new LinkedList();
        for (aN aN2 : e2.a()) {
            this._rows.add(new DB2Row(this._metadata, aN2));
        }
        this._isEndOfData.set(n2.f());
        this._fetchSize = n2.e();
    }

    protected DB2Result(DB2PreparedStatement dB2PreparedStatement, n n2, L l2, DB2RowMetadata dB2RowMetadata, List<E> list) {
        this._cid = dB2PreparedStatement.getConnection().getConnectionId();
        this._pid = dB2PreparedStatement.getSectionNumber();
        this._ps = dB2PreparedStatement;
        this._query = n2;
        this._omd = l2;
        this._metadata = dB2RowMetadata;
        this._rows = new LinkedList();
        for (E e2 : list) {
            for (aN aN2 : e2.a()) {
                this._rows.add(new DB2Row(this._metadata, aN2));
            }
        }
        this._isEndOfData.set(n2.f());
        this._fetchSize = n2.e();
    }

    public String toString() {
        String string = "DB2Result {\n";
        if (this._rows != null) {
            string = string + "  rows {\n";
            for (DB2Row dB2Row : this._rows) {
                string = string + dB2Row.toString("    ");
            }
            string = string + "  }\n";
        }
        string = string + "  numRowsUpdated: " + this._numRowsUpdated + "\n";
        string = string + "}\n";
        return string;
    }

    public Publisher<Integer> getRowsUpdated() {
        return Mono.just((Object)this._numRowsUpdated);
    }

    public int getNumRowsUpdated() {
        return this._numRowsUpdated;
    }

    public <T> Publisher<T> map(BiFunction<Row, RowMetadata, ? extends T> biFunction) {
        Objects.requireNonNull(biFunction, c.a("null-function"));
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] map function called");
        AtomicReference<Object> atomicReference = new AtomicReference<Object>(null);
        AtomicInteger atomicInteger = new AtomicInteger(0);
        return Flux.create(arg_0 -> this.lambda$map$11(atomicReference, atomicInteger, biFunction, arg_0)).doOnRequest(arg_0 -> this.lambda$map$12(atomicInteger, arg_0));
    }

    protected <T> Publisher<List<T>> map2l(BiFunction<Row, RowMetadata, ? extends T> biFunction) {
        Objects.requireNonNull(biFunction, c.a("null-function"));
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] map2l function called");
        EmitterProcessor emitterProcessor = EmitterProcessor.create((boolean)false);
        FluxSink fluxSink = emitterProcessor.sink();
        Flux flux = emitterProcessor.doOnRequest(arg_0 -> this.lambda$map2l$16(biFunction, fluxSink, arg_0));
        return flux;
    }

    public DB2Connection getConnection() {
        return this._ps.getConnection();
    }

    public Mono<Void> close() {
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Closing resultset..");
        if (this._isEndOfData.get()) {
            return Mono.just((Object)1).then();
        }
        this._ps.getConnection().removeOpenQry(this);
        EmitterProcessor emitterProcessor = EmitterProcessor.create((boolean)false);
        FluxSink fluxSink = emitterProcessor.sink();
        new b(this._cid, this._query.a(), this._query.b(), this._query.c()).a(this._ps.getConnection().getEndpoint()).subscribe(arg_0 -> DB2Result.lambda$close$17(fluxSink, arg_0), arg_0 -> DB2Result.lambda$close$18(fluxSink, arg_0));
        return emitterProcessor.count().then();
    }

    private Mono<Void> closeAndCommit() {
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Closing and commiting resultset..");
        this._ps.getConnection().removeOpenQry(this);
        d d2 = this._ps.getConnection().getEndpoint();
        ByteBufAllocator byteBufAllocator = d2.c();
        o o2 = d2.a();
        b b2 = new b(this._cid, this._query.a(), this._query.b(), this._query.c());
        ByteBuf byteBuf = b2.a(byteBufAllocator, 1, d2.i(), o2, true);
        ByteBuf byteBuf2 = com.ibm.db2.r2dbc.b.c.a(this._cid, byteBufAllocator, o2, d2.i(), false);
        return d2.a(this._cid, (Flux<ByteBuf>)Flux.just((Object[])new ByteBuf[]{byteBuf, byteBuf2})).then();
    }

    private static void lambda$close$18(FluxSink fluxSink, Throwable throwable) {
        fluxSink.error(throwable);
    }

    private static void lambda$close$17(FluxSink fluxSink, K k2) {
        fluxSink.complete();
    }

    private void lambda$map2l$16(BiFunction biFunction, FluxSink fluxSink, long l2) {
        int n2 = this._rows.size();
        ArrayList arrayList = new ArrayList(n2);
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList.add(biFunction.apply(this._rows.get(i2), this._metadata));
            }
            fluxSink.next(arrayList);
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] map2l filled item with already available data");
            this._rows.clear();
            return;
        }
        if (this._isEndOfData.get()) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Reached end of data");
            fluxSink.complete();
            return;
        }
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] map2l requesting for more data from server starting fetch next flow");
        f f2 = new f(this._cid, this._pid, this._query.a(), this._query.b(), this._query.c(), this._fetchSize, this._omd);
        f2.a(this._ps.getConnection().getEndpoint()).doOnError(arg_0 -> DB2Result.lambda$null$13(fluxSink, arg_0)).doOnComplete(() -> this.lambda$null$14(f2, fluxSink)).subscribe(arg_0 -> this.lambda$null$15(biFunction, fluxSink, f2, arg_0));
    }

    private void lambda$null$15(BiFunction biFunction, FluxSink fluxSink, f f2, E e2) {
        ArrayList arrayList = new ArrayList(e2.a().size());
        for (aN aN2 : e2.a()) {
            DB2Row dB2Row = new DB2Row(this._metadata, aN2);
            arrayList.add(biFunction.apply(dB2Row, this._metadata));
        }
        fluxSink.next(arrayList);
        if (f2.a()) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Reached end of data");
            this._isEndOfData.set(true);
            this._ps.getConnection().removeOpenQry(this);
            fluxSink.complete();
        }
    }

    private void lambda$null$14(f f2, FluxSink fluxSink) {
        if (f2.a()) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Reached end of data");
            this._isEndOfData.set(true);
            this._ps.getConnection().removeOpenQry(this);
            fluxSink.complete();
        }
    }

    private static void lambda$null$13(FluxSink fluxSink, Throwable throwable) {
        fluxSink.error(throwable);
    }

    private void lambda$map$12(AtomicInteger atomicInteger, long l2) {
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] doOnRequest N = " + l2);
        if (l2 > Integer.MAX_VALUE) {
            atomicInteger.set(Integer.MAX_VALUE);
        } else {
            atomicInteger.set((int)l2);
        }
    }

    private void lambda$map$11(AtomicReference atomicReference, AtomicInteger atomicInteger, BiFunction biFunction, FluxSink fluxSink) {
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Flux.create() called");
        atomicReference.set(fluxSink);
        if (this._rows.size() > atomicInteger.get()) {
            for (int i2 = 0; i2 < atomicInteger.get(); ++i2) {
                ((FluxSink)atomicReference.get()).next(biFunction.apply(this._rows.remove(), this._metadata));
            }
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] filled " + atomicInteger + " items with already available data");
            atomicInteger.set(0);
            return;
        }
        if (this._rows.size() > 0) {
            int n2 = this._rows.size();
            for (int i3 = 0; i3 < n2; ++i3) {
                ((FluxSink)atomicReference.get()).next(biFunction.apply(this._rows.remove(), this._metadata));
            }
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] partially filled " + n2 + " items with already available data");
            atomicInteger.addAndGet(-n2);
        }
        if (this._isEndOfData.get()) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Reached end of data");
            ((FluxSink)atomicReference.get()).complete();
            return;
        }
        if (atomicInteger.get() > 0) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] requesting for more data starting fetch next flow for " + atomicInteger + " items");
            f f2 = new f(this._cid, this._pid, this._query.a(), this._query.b(), this._query.c(), atomicInteger.get(), this._omd);
            f2.a(this._ps.getConnection().getEndpoint()).doOnError(arg_0 -> DB2Result.lambda$null$0(atomicReference, arg_0)).doOnComplete(() -> this.lambda$null$1(f2, atomicReference)).subscribe(arg_0 -> this.lambda$null$10(atomicReference, biFunction, f2, arg_0));
        }
    }

    private void lambda$null$10(AtomicReference atomicReference, BiFunction biFunction, f f2, E e2) {
        AtomicReference atomicReference2 = new AtomicReference();
        Flux flux = Flux.create(arg_0 -> DB2Result.lambda$null$2(atomicReference2, arg_0));
        LinkedList<DB2Row> linkedList = new LinkedList<DB2Row>();
        LinkedList<List<a>> linkedList2 = new LinkedList<List<a>>();
        AtomicInteger atomicInteger = new AtomicInteger();
        flux.subscribe(arg_0 -> this.lambda$null$8(linkedList2, atomicInteger, atomicReference, linkedList, atomicReference2, biFunction, arg_0));
        if (e2.b() == 0 && this._metadata.hasLobColumn()) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] No rows");
            this.closeAndCommit().doOnTerminate(() -> DB2Result.lambda$null$9(atomicReference, atomicReference2)).subscribe();
        }
        boolean bl2 = true;
        for (aN aN2 : e2.a()) {
            DB2Row dB2Row;
            if (this._metadata.hasLobColumn()) {
                dB2Row = new DB2Row(this._metadata, aN2);
                linkedList.add(dB2Row);
                linkedList2.add(aN2.b());
                if (!bl2) continue;
                bl2 = false;
                linkedList.poll();
                ((FluxSink)atomicReference2.get()).next((Object)true);
                ((FluxSink)atomicReference.get()).next(biFunction.apply(dB2Row, this._metadata));
                continue;
            }
            dB2Row = new DB2Row(this._metadata, aN2);
            ((FluxSink)atomicReference.get()).next(biFunction.apply(dB2Row, this._metadata));
        }
        if (f2.a()) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Reached end of data");
            this._isEndOfData.set(true);
            this._ps.getConnection().removeOpenQry(this);
            ((FluxSink)atomicReference.get()).complete();
            ((FluxSink)atomicReference2.get()).complete();
        }
    }

    private static void lambda$null$9(AtomicReference atomicReference, AtomicReference atomicReference2) {
        ((FluxSink)atomicReference.get()).complete();
        ((FluxSink)atomicReference2.get()).complete();
    }

    private void lambda$null$8(Queue queue, AtomicInteger atomicInteger, AtomicReference atomicReference, Queue queue2, AtomicReference atomicReference2, BiFunction biFunction, Boolean bl2) {
        List list = (List)queue.poll();
        if (list == null) {
            return;
        }
        atomicInteger.set(list.size());
        for (a a10 : list) {
            Flux flux = a10.a().doOnSubscribe(arg_0 -> this.lambda$null$6(atomicInteger, atomicReference, queue2, atomicReference2, biFunction, arg_0));
            a10.a((Flux<? extends Object>)flux);
        }
        if (atomicInteger.get() == 0) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] No data for large objects in the row");
            DB2Row dB2Row = (DB2Row)queue2.poll();
            if (dB2Row == null) {
                _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] No more rows to process");
                this.closeAndCommit().doOnTerminate(() -> DB2Result.lambda$null$7(atomicReference, atomicReference2)).subscribe();
                return;
            }
            ((FluxSink)atomicReference2.get()).next((Object)true);
            ((FluxSink)atomicReference.get()).next(biFunction.apply(dB2Row, this._metadata));
        }
    }

    private static void lambda$null$7(AtomicReference atomicReference, AtomicReference atomicReference2) {
        ((FluxSink)atomicReference.get()).complete();
        ((FluxSink)atomicReference2.get()).complete();
    }

    private void lambda$null$6(AtomicInteger atomicInteger, AtomicReference atomicReference, Queue queue, AtomicReference atomicReference2, BiFunction biFunction, Subscription subscription) {
        if (atomicInteger.decrementAndGet() == 0) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] starting fetch next flow to get large objects");
            f f2 = new f(this._cid, this._pid, this._query.a(), this._query.b(), this._query.c(), 1, this._omd);
            f2.a(this._ps.getConnection().getEndpoint()).doOnError(arg_0 -> DB2Result.lambda$null$3(atomicReference, arg_0)).doOnComplete(() -> this.lambda$null$5(queue, atomicReference, atomicReference2, biFunction)).subscribe();
        }
    }

    private void lambda$null$5(Queue queue, AtomicReference atomicReference, AtomicReference atomicReference2, BiFunction biFunction) {
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Reached end of large object data");
        DB2Row dB2Row = (DB2Row)queue.poll();
        if (dB2Row == null) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] No more rows to process");
            this.closeAndCommit().doOnTerminate(() -> DB2Result.lambda$null$4(atomicReference, atomicReference2)).subscribe();
            return;
        }
        ((FluxSink)atomicReference2.get()).next((Object)true);
        ((FluxSink)atomicReference.get()).next(biFunction.apply(dB2Row, this._metadata));
    }

    private static void lambda$null$4(AtomicReference atomicReference, AtomicReference atomicReference2) {
        ((FluxSink)atomicReference.get()).complete();
        ((FluxSink)atomicReference2.get()).complete();
    }

    private static void lambda$null$3(AtomicReference atomicReference, Throwable throwable) {
        ((FluxSink)atomicReference.get()).error(throwable);
    }

    private static void lambda$null$2(AtomicReference atomicReference, FluxSink fluxSink) {
        atomicReference.set(fluxSink);
    }

    private void lambda$null$1(f f2, AtomicReference atomicReference) {
        if (f2.a()) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Reached end of data");
            this._isEndOfData.set(true);
            this._ps.getConnection().removeOpenQry(this);
            ((FluxSink)atomicReference.get()).complete();
        }
    }

    private static void lambda$null$0(AtomicReference atomicReference, Throwable throwable) {
        ((FluxSink)atomicReference.get()).error(throwable);
    }
}

