/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.r2dbc;

import com.ibm.db2.r2dbc.DB2ColumnMetadata;
import com.ibm.db2.r2dbc.DB2Connection;
import com.ibm.db2.r2dbc.DB2Exception$Type;
import com.ibm.db2.r2dbc.DB2Result;
import com.ibm.db2.r2dbc.DB2RowMetadata;
import com.ibm.db2.r2dbc.a.K;
import com.ibm.db2.r2dbc.a.L;
import com.ibm.db2.r2dbc.a.a9;
import com.ibm.db2.r2dbc.a.aP;
import com.ibm.db2.r2dbc.b.m;
import com.ibm.db2.r2dbc.b.n;
import com.ibm.db2.r2dbc.b.r;
import com.ibm.db2.r2dbc.e.a;
import com.ibm.db2.r2dbc.e.c;
import com.ibm.db2.r2dbc.e.d;
import io.r2dbc.spi.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class DB2PreparedStatement
implements Statement {
    private static final Logger _logger = LoggerFactory.getLogger((String)DB2PreparedStatement.class.getName());
    private DB2Connection _con;
    private String _dbname;
    private int _secno;
    private String _sql;
    private int _isolation;
    private boolean _autoCommit;
    private int _fetchSize;
    private aP _qryinsid;
    private boolean _isEndOfData;
    private int _cid;
    private int _pid;
    private boolean _isPrepared;
    private ArrayList<L> _sqldaList;
    private L _rsSqlda;
    private DB2RowMetadata _parameterMetadata;
    private DB2RowMetadata _resultsetMetadata;
    private boolean _hasResultSet;
    private HashMap<String, int[]> _namedParamMap;
    private String _updatedSql;
    private HashMap<Integer, Object> _bindValues;
    private HashSet<Integer> _bindNulls;
    private boolean _isCached;
    private boolean _keepDynamic;

    protected DB2PreparedStatement(DB2Connection dB2Connection, String string, int n2, boolean bl2) {
        block5: {
            this._isCached = false;
            this._con = dB2Connection;
            this._cid = this._con.getConnectionId();
            this._dbname = this._con.getEndpoint().g().getDatabase();
            this._pid = this._secno = this._con.getFreeSectionNumber();
            this._sql = string;
            this._isolation = n2;
            this._autoCommit = bl2;
            this._fetchSize = this._con.getEndpoint().g().getFetchSize();
            this._keepDynamic = this._con.getEndpoint().g().getKeepDynamic();
            this._isPrepared = false;
            this._sqldaList = new ArrayList(2);
            this._bindValues = new HashMap();
            this._bindNulls = new HashSet();
            this._hasResultSet = false;
            try {
                block4: {
                    d d2 = d.a(this._sql);
                    try {
                        if (d2 == null) break block4;
                        this._namedParamMap = d2.a();
                        this._updatedSql = d2.b();
                        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] param names : " + d2.d());
                        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] updated sql : " + this._updatedSql);
                        break block5;
                    }
                    catch (a a10) {
                        throw DB2PreparedStatement.b(a10);
                    }
                }
                this._namedParamMap = new HashMap();
                this._updatedSql = this._sql;
            }
            catch (a a11) {
                _logger.error("[rdb2-" + this._cid + "-" + this._pid + "] " + a11.getLocalizedMessage());
                throw a11;
            }
        }
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] Created DB2PreparedStatement instance, cid = " + this._cid + ", secno = " + this._secno);
    }

    public DB2Connection getConnection() {
        return this._con;
    }

    public int getSectionNumber() {
        return this._secno;
    }

    public void clearParameters() {
        this._bindValues.clear();
        this._bindNulls.clear();
    }

    public void close() {
        this._con.releaseSectionNumber(this._secno);
    }

    public DB2PreparedStatement add() {
        throw new UnsupportedOperationException();
    }

    public DB2PreparedStatement bind(String string, Object object) {
        String string2 = string.toUpperCase();
        try {
            if (!this._namedParamMap.containsKey(string2)) {
                _logger.error("[rdb2-" + this._cid + "-" + this._pid + "] Unknown parameter name " + string);
                throw new a(DB2Exception$Type.PARAMETER, String.format(c.a("unknown-parameter-name"), string));
            }
        }
        catch (a a10) {
            throw DB2PreparedStatement.b(a10);
        }
        int[] nArray = this._namedParamMap.get(string2);
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this._bindValues.put(nArray[i2], object);
            }
        }
        catch (a a11) {
            throw DB2PreparedStatement.b(a11);
        }
        return this;
    }

    public DB2PreparedStatement bind(int n2, Object object) {
        this._bindValues.put(n2, object);
        return this;
    }

    public DB2PreparedStatement bindNull(String string, Class<?> clazz) {
        try {
            if (!this._namedParamMap.containsKey(string)) {
                throw new a(DB2Exception$Type.PARAMETER, String.format(c.a("unknown-named-parameter"), new Object[0]));
            }
        }
        catch (a a10) {
            throw DB2PreparedStatement.b(a10);
        }
        int[] nArray = this._namedParamMap.get(string);
        try {
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this._bindNulls.add(nArray[i2]);
            }
        }
        catch (a a11) {
            throw DB2PreparedStatement.b(a11);
        }
        return this;
    }

    public DB2PreparedStatement bindNull(int n2, Class<?> clazz) {
        this._bindNulls.add(n2);
        return this;
    }

    protected Mono<Void> prepare() {
        try {
            if (this._isPrepared) {
                return Mono.just((Object)1).then();
            }
        }
        catch (a a10) {
            throw DB2PreparedStatement.b(a10);
        }
        _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] prepare SQL: " + this._updatedSql);
        return Mono.create(this::lambda$prepare$2).then();
    }

    public DB2RowMetadata getResultSetMetadata() {
        try {
            if (!this._isPrepared) {
                return null;
            }
        }
        catch (a a10) {
            throw DB2PreparedStatement.b(a10);
        }
        if (this._sqldaList.size() > 0) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] getting resultset metadata");
            this._rsSqlda = this._sqldaList.get(0);
            ArrayList<DB2ColumnMetadata> arrayList = this.getColumnMetadataList(this._sqldaList.remove(0));
            try {
                if (arrayList.size() > 0) {
                    this._hasResultSet = true;
                }
            }
            catch (a a11) {
                throw DB2PreparedStatement.b(a11);
            }
            this._resultsetMetadata = new DB2RowMetadata(arrayList);
        }
        return this._resultsetMetadata;
    }

    public DB2RowMetadata getParameterMetadata() {
        try {
            if (!this._isPrepared) {
                return null;
            }
        }
        catch (a a10) {
            throw DB2PreparedStatement.b(a10);
        }
        if (this._sqldaList.size() > 0) {
            _logger.debug("[rdb2-" + this._cid + "-" + this._pid + "] getting parameter metadata");
            ArrayList<DB2ColumnMetadata> arrayList = this.getColumnMetadataList(this._sqldaList.remove(0));
            this._parameterMetadata = new DB2RowMetadata(arrayList);
        }
        return this._parameterMetadata;
    }

    public Mono<DB2Result> execute() {
        return Mono.create(this::lambda$execute$11);
    }

    private ArrayList<DB2ColumnMetadata> getColumnMetadataList(L l2) {
        ArrayList<DB2ColumnMetadata> arrayList = new ArrayList<DB2ColumnMetadata>();
        int n2 = l2.e().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            a9 a92 = l2.e().get(i2);
            DB2ColumnMetadata dB2ColumnMetadata = new DB2ColumnMetadata();
            dB2ColumnMetadata.setName(a92.i().b());
            dB2ColumnMetadata.setLabel(a92.i().c());
            dB2ColumnMetadata.setComments(a92.i().d());
            dB2ColumnMetadata.setJdbcType(a92.e());
            dB2ColumnMetadata.setSqlType(a92.d());
            dB2ColumnMetadata.setCcsid(a92.f());
            dB2ColumnMetadata.setColumnLength(a92.c());
            dB2ColumnMetadata.setScale(a92.b());
            dB2ColumnMetadata.setPrecision(a92.a());
            arrayList.add(dB2ColumnMetadata);
        }
        return arrayList;
    }

    private boolean isQuery() {
        block7: {
            this._sql = this._sql.trim();
            int n2 = this._sql.indexOf(32);
            String string = this._sql.substring(0, n2).toUpperCase();
            try {
                block6: {
                    try {
                        try {
                            if (string.equals("SELECT") || string.equals("WITH")) break block6;
                        }
                        catch (a a10) {
                            throw DB2PreparedStatement.b(a10);
                        }
                        if (!string.equals("CALL")) break block7;
                    }
                    catch (a a11) {
                        throw DB2PreparedStatement.b(a11);
                    }
                }
                return true;
            }
            catch (a a12) {
                throw DB2PreparedStatement.b(a12);
            }
        }
        return false;
    }

    private Mono<DB2Result> executeQuery() {
        boolean bl2;
        block2: {
            bl2 = false;
            try {
                if (!this._isCached || this._keepDynamic) break block2;
            }
            catch (a a10) {
                throw DB2PreparedStatement.b(a10);
            }
            bl2 = true;
        }
        n n2 = new n(this._cid, this._dbname, this._updatedSql, this._secno, this._isolation, this._fetchSize, this._parameterMetadata, this._bindValues, this._bindNulls, this._rsSqlda, bl2, this._autoCommit);
        return n2.a(this._con.getEndpoint()).map(arg_0 -> this.lambda$executeQuery$12(n2, arg_0));
    }

    private Mono<DB2Result> prepareAndExecuteQuery() {
        boolean bl2;
        block5: {
            block4: {
                bl2 = false;
                try {
                    try {
                        if (!this._isPrepared) break block4;
                        if (!this._isCached) break block5;
                    }
                    catch (a a10) {
                        throw DB2PreparedStatement.b(a10);
                    }
                    if (this._keepDynamic) break block5;
                }
                catch (a a11) {
                    throw DB2PreparedStatement.b(a11);
                }
            }
            bl2 = true;
        }
        n n2 = new n(this._cid, this._dbname, this._sql, this._secno, this._isolation, this._fetchSize, this._bindValues, this._bindNulls, bl2, this._autoCommit);
        _logger.debug("prepareAndExecuteQuery: " + this._sql);
        return n2.a(this._con.getEndpoint()).map(arg_0 -> this.lambda$prepareAndExecuteQuery$13(n2, arg_0));
    }

    private Mono<DB2Result> executeUpdate() {
        boolean bl2;
        block2: {
            bl2 = false;
            try {
                if (!this._isCached || this._keepDynamic) break block2;
            }
            catch (a a10) {
                throw DB2PreparedStatement.b(a10);
            }
            bl2 = true;
        }
        r r2 = new r(this._cid, this._dbname, this._secno, this._parameterMetadata, this._bindValues, this._bindNulls, this._autoCommit, this._updatedSql, this._isolation, bl2);
        return Mono.create(arg_0 -> this.lambda$executeUpdate$16(r2, arg_0));
    }

    private Mono<DB2Result> prepareAndExecuteUpdate() {
        boolean bl2;
        block5: {
            block4: {
                bl2 = false;
                try {
                    try {
                        if (!this._isPrepared) break block4;
                        if (!this._isCached) break block5;
                    }
                    catch (a a10) {
                        throw DB2PreparedStatement.b(a10);
                    }
                    if (this._keepDynamic) break block5;
                }
                catch (a a11) {
                    throw DB2PreparedStatement.b(a11);
                }
            }
            bl2 = true;
        }
        r r2 = new r(this._cid, this._dbname, this._secno, this._bindValues, this._bindNulls, this._autoCommit, this._sql, this._isolation, bl2);
        _logger.debug("prepareAndUpdateQuery: " + this._sql);
        return Mono.create(arg_0 -> this.lambda$prepareAndExecuteUpdate$19(r2, arg_0));
    }

    protected void isCached(boolean bl2) {
        this._isCached = bl2;
    }

    public boolean isCached() {
        return this._isCached;
    }

    private void lambda$prepareAndExecuteUpdate$19(r r2, MonoSink monoSink) {
        r2.a(this._con.getEndpoint()).doOnSuccess(arg_0 -> this.lambda$null$17(r2, monoSink, arg_0)).doOnError(arg_0 -> this.lambda$null$18(monoSink, arg_0)).subscribe();
    }

    private void lambda$null$18(MonoSink monoSink, Throwable throwable) {
        _logger.error("[rdb2-" + this._cid + "-" + this._pid + "] prepareAndExecuteUpdate() failed - " + throwable);
        monoSink.error(throwable);
    }

    private void lambda$null$17(r r2, MonoSink monoSink, Void void_) {
        block7: {
            block6: {
                try {
                    this._isPrepared = true;
                    this._sqldaList = r2.a();
                    if (this._sqldaList.size() != 2) break block6;
                    this.getResultSetMetadata();
                    this.getParameterMetadata();
                    break block7;
                }
                catch (a a10) {
                    throw DB2PreparedStatement.b(a10);
                }
            }
            try {
                if (this._sqldaList.size() == 1) {
                    this.getParameterMetadata();
                }
            }
            catch (a a11) {
                throw DB2PreparedStatement.b(a11);
            }
        }
        int n2 = -1;
        for (K k2 : r2.b()) {
            if (k2.g()) continue;
            n2 = k2.h()[2];
        }
        monoSink.success((Object)new DB2Result(this, n2));
    }

    private void lambda$executeUpdate$16(r r2, MonoSink monoSink) {
        r2.a(this._con.getEndpoint()).doOnSuccess(arg_0 -> this.lambda$null$14(r2, monoSink, arg_0)).doOnError(arg_0 -> this.lambda$null$15(monoSink, arg_0)).subscribe();
    }

    private void lambda$null$15(MonoSink monoSink, Throwable throwable) {
        _logger.error("[rdb2-" + this._cid + "-" + this._pid + "] executeUpdate() failed - " + throwable);
        monoSink.error(throwable);
    }

    private void lambda$null$14(r r2, MonoSink monoSink, Void void_) {
        int n2 = -1;
        for (K k2 : r2.b()) {
            if (k2.g()) continue;
            n2 = k2.h()[2];
        }
        monoSink.success((Object)new DB2Result(this, n2));
    }

    private DB2Result lambda$prepareAndExecuteQuery$13(n n2, List list) {
        try {
            this._qryinsid = n2.c();
            this._isEndOfData = n2.f();
            this._sqldaList = n2.d();
            this._isPrepared = true;
            if (this._sqldaList.size() < 1) {
                new RuntimeException("[rdb2-" + this._cid + "-" + this._pid + "] Error getting prepared statement metadata");
            }
        }
        catch (a a10) {
            throw DB2PreparedStatement.b(a10);
        }
        this.getResultSetMetadata();
        this.getParameterMetadata();
        DB2Result dB2Result = new DB2Result(this, n2, this._rsSqlda, this._resultsetMetadata, list);
        try {
            if (!this._isEndOfData) {
                this._con.addOpenQry(dB2Result);
            }
        }
        catch (a a11) {
            throw DB2PreparedStatement.b(a11);
        }
        return dB2Result;
    }

    private DB2Result lambda$executeQuery$12(n n2, List list) {
        this._qryinsid = n2.c();
        this._isEndOfData = n2.f();
        DB2Result dB2Result = new DB2Result(this, n2, this._rsSqlda, this._resultsetMetadata, list);
        try {
            if (!this._isEndOfData) {
                this._con.addOpenQry(dB2Result);
            }
        }
        catch (a a10) {
            throw DB2PreparedStatement.b(a10);
        }
        return dB2Result;
    }

    private void lambda$execute$11(MonoSink monoSink) {
        this.prepare().doOnSuccess(arg_0 -> this.lambda$null$8(monoSink, arg_0)).subscribe(DB2PreparedStatement::lambda$null$9, arg_0 -> DB2PreparedStatement.lambda$null$10(monoSink, arg_0));
    }

    private static void lambda$null$10(MonoSink monoSink, Throwable throwable) {
        monoSink.error(throwable);
    }

    private static void lambda$null$9(Void void_) {
    }

    private void lambda$null$8(MonoSink monoSink, Void void_) {
        block3: {
            block2: {
                try {
                    if (!this.isQuery()) break block2;
                    this.executeQuery().subscribe(arg_0 -> DB2PreparedStatement.lambda$null$3(monoSink, arg_0), arg_0 -> DB2PreparedStatement.lambda$null$4(monoSink, arg_0), () -> DB2PreparedStatement.lambda$null$5(monoSink));
                    break block3;
                }
                catch (a a10) {
                    throw DB2PreparedStatement.b(a10);
                }
            }
            this.executeUpdate().subscribe(arg_0 -> DB2PreparedStatement.lambda$null$6(monoSink, arg_0), arg_0 -> DB2PreparedStatement.lambda$null$7(monoSink, arg_0));
        }
    }

    private static void lambda$null$7(MonoSink monoSink, Throwable throwable) {
        monoSink.error(throwable);
    }

    private static void lambda$null$6(MonoSink monoSink, DB2Result dB2Result) {
        monoSink.success((Object)dB2Result);
    }

    private static void lambda$null$5(MonoSink monoSink) {
        monoSink.success();
    }

    private static void lambda$null$4(MonoSink monoSink, Throwable throwable) {
        monoSink.error(throwable);
    }

    private static void lambda$null$3(MonoSink monoSink, DB2Result dB2Result) {
        monoSink.success((Object)dB2Result);
    }

    private void lambda$prepare$2(MonoSink monoSink) {
        m m2 = new m(this._cid, this._dbname, this._secno, this._updatedSql, this._isolation);
        m2.a(this._con.getEndpoint()).doOnSuccess(arg_0 -> this.lambda$null$0(m2, monoSink, arg_0)).doOnError(arg_0 -> DB2PreparedStatement.lambda$null$1(monoSink, arg_0)).subscribe();
    }

    private static void lambda$null$1(MonoSink monoSink, Throwable throwable) {
        monoSink.error(throwable);
    }

    private void lambda$null$0(m m2, MonoSink monoSink, Void void_) {
        block7: {
            block8: {
                block6: {
                    try {
                        this._isPrepared = true;
                        this._sqldaList = m2.a();
                        if (this._sqldaList.size() != 2) break block6;
                        this.getResultSetMetadata();
                        this.getParameterMetadata();
                        break block7;
                    }
                    catch (a a10) {
                        throw DB2PreparedStatement.b(a10);
                    }
                }
                try {
                    try {
                        if (this._sqldaList.size() != 1) break block7;
                        if (!this.isQuery()) break block8;
                    }
                    catch (a a11) {
                        throw DB2PreparedStatement.b(a11);
                    }
                    this.getResultSetMetadata();
                    break block7;
                }
                catch (a a12) {
                    throw DB2PreparedStatement.b(a12);
                }
            }
            this.getParameterMetadata();
        }
        monoSink.success();
    }

    private static a b(a a10) {
        return a10;
    }
}

