/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.r2dbc;

import com.ibm.db2.r2dbc.DB2Connection;
import com.ibm.db2.r2dbc.DB2ConnectionFactory;
import com.ibm.db2.r2dbc.e.c;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class DB2ConnectionPool {
    private static final Logger _logger = LoggerFactory.getLogger((String)DB2ConnectionPool.class.getName());
    private DB2ConnectionFactory _factory;
    private int _maxConnections;
    private int _numCreating;
    private HashSet<DB2Connection> _availableConnections = new HashSet();
    private HashSet<DB2Connection> _inuseConnections = new HashSet();
    private Queue<MonoSink<DB2Connection>> _waitList = new LinkedList<MonoSink<DB2Connection>>();
    private boolean _isClosed = false;

    public DB2ConnectionPool(DB2ConnectionFactory dB2ConnectionFactory) {
        this._factory = dB2ConnectionFactory;
        this._maxConnections = dB2ConnectionFactory.getConfig().getConPoolSize();
        this._numCreating = 0;
        for (int i2 = 0; i2 < this._maxConnections; ++i2) {
            ++this._numCreating;
            this.createConnection(null);
        }
    }

    private void createConnection(MonoSink<DB2Connection> monoSink) {
        _logger.debug("creating new DB2 connection ");
        this._factory.create().subscribe(arg_0 -> this.lambda$createConnection$0(monoSink, arg_0), this::lambda$createConnection$1);
    }

    public Mono<DB2Connection> getConnection() {
        _logger.debug("getConnection() called, getting a free connection from the pool");
        return Mono.create(this::lambda$getConnection$2);
    }

    protected synchronized void releaseConnection(DB2Connection dB2Connection) {
        _logger.debug("[rdb2-" + dB2Connection.getConnectionId() + "-0] DB2Connection being released, id = " + dB2Connection.getConnectionId());
        if (this._isClosed) {
            _logger.error("connection pool is closed");
            return;
        }
        if (this._waitList.size() > 0) {
            _logger.debug("[rdb2-" + dB2Connection.getConnectionId() + "-0] Wait list assigned with the DB2Connection id = " + dB2Connection.getConnectionId() + ", waitList size = " + this._waitList.size());
            this._waitList.poll().success((Object)dB2Connection);
        } else {
            this._inuseConnections.remove(dB2Connection);
            this._availableConnections.add(dB2Connection);
            _logger.debug("DB2Connection is available, id = " + dB2Connection.getConnectionId());
        }
    }

    protected synchronized void remove(DB2Connection dB2Connection) {
        _logger.debug("[rdb2-" + dB2Connection.getConnectionId() + "-0] removing connection from pool");
        if (this._isClosed) {
            _logger.error("connection pool is closed");
            return;
        }
        this._inuseConnections.remove(dB2Connection);
        this._availableConnections.remove(dB2Connection);
    }

    public synchronized Mono<Void> closeAll() {
        Mono mono;
        _logger.debug("[rdb2-0-0] connection pool is closing");
        if (this._isClosed) {
            _logger.error("connection pool is closed already");
            return Mono.empty();
        }
        while (this._waitList.size() > 0) {
            mono = (MonoSink)this._waitList.iterator().next();
            this._waitList.remove(mono);
            mono.error((Throwable)new Exception("connection pool is closing"));
        }
        mono = Mono.just((Object)1).then();
        for (DB2Connection object : this._availableConnections) {
            object.setConPool(null);
            mono = mono.and(object.close());
        }
        this._availableConnections.clear();
        for (DB2Connection dB2Connection : this._inuseConnections) {
            dB2Connection.setConPool(null);
            mono = mono.and(dB2Connection.close());
        }
        this._inuseConnections.clear();
        this._isClosed = true;
        return mono;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lambda$getConnection$2(MonoSink monoSink) {
        DB2Connection dB2Connection = null;
        DB2ConnectionPool dB2ConnectionPool = this;
        synchronized (dB2ConnectionPool) {
            if (this._isClosed) {
                _logger.error("connection pool is closed");
                monoSink.error((Throwable)new Exception(c.a("conpool-closed")));
                return;
            }
            if (this._availableConnections.size() > 0) {
                dB2Connection = this._availableConnections.iterator().next();
                this._availableConnections.remove(dB2Connection);
                this._inuseConnections.add(dB2Connection);
                _logger.debug("[rdb2-" + dB2Connection.getConnectionId() + "-0] got DB2Connection, id = " + dB2Connection.getConnectionId());
            } else {
                this._waitList.add((MonoSink<DB2Connection>)monoSink);
                _logger.debug("waiting for connection, waitlist size = " + this._waitList.size());
                if (this._inuseConnections.size() + this._numCreating < this._maxConnections) {
                    ++this._numCreating;
                    this.createConnection((MonoSink<DB2Connection>)monoSink);
                }
            }
        }
        if (dB2Connection != null) {
            monoSink.success((Object)dB2Connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lambda$createConnection$1(Throwable throwable) {
        --this._numCreating;
        _logger.error("Error creating DB2 connection " + throwable);
        MonoSink<DB2Connection> monoSink = null;
        DB2ConnectionPool dB2ConnectionPool = this;
        synchronized (dB2ConnectionPool) {
            if (this._waitList.size() > 0) {
                monoSink = this._waitList.poll();
            }
        }
        if (monoSink != null) {
            monoSink.error(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lambda$createConnection$0(MonoSink monoSink, DB2Connection dB2Connection) {
        dB2Connection.setConPool(this);
        MonoSink<DB2Connection> monoSink2 = null;
        DB2ConnectionPool dB2ConnectionPool = this;
        synchronized (dB2ConnectionPool) {
            if (this._waitList.size() > 0) {
                this._inuseConnections.add(dB2Connection);
                _logger.debug("[rdb2-" + dB2Connection.getConnectionId() + "-0] Wait list assigned with DB2Connection id = " + dB2Connection.getConnectionId() + ", waitList size = " + this._waitList.size());
                monoSink2 = this._waitList.poll();
            } else {
                this._availableConnections.add(dB2Connection);
                _logger.debug("[rdb2-" + dB2Connection.getConnectionId() + "-0] DB2Connection id = " + dB2Connection.getConnectionId() + " is added to available list");
            }
        }
        if (monoSink2 != null) {
            monoSink2.success((Object)dB2Connection);
        }
        --this._numCreating;
        if (monoSink != null) {
            monoSink.success((Object)dB2Connection);
        }
    }
}

