/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.r2dbc;

import com.ibm.db2.r2dbc.DB2ConnectionConfiguration;
import com.ibm.db2.r2dbc.DB2ConnectionConfiguration$Builder;
import com.ibm.db2.r2dbc.e.c;
import io.r2dbc.spi.IsolationLevel;
import java.util.HashMap;
import java.util.Objects;

public class DB2ConnectionConfiguration {
    private final String _database;
    private final String _host;
    private final Integer _port;
    private final int _securityMechanism;
    private final String _kerberosServerPrincipal;
    private final String _username;
    private final String _password;
    private final boolean _enableSSL;
    private final String _trustStorePath;
    private final String _trustStorePassword;
    private final boolean _autoCommit;
    private final int _fetchSize;
    private final int _conPoolSize;
    private final int _stmtCacheSize;
    private final IsolationLevel _isolation;
    private final boolean _keepDynamic;
    private final String _licenseFilePath;
    public static final int USERID_PASSWORD = 3;
    public static final int KERBEROS_SECURITY = 11;
    private static HashMap<Integer, String> _nameMap = new HashMap();

    private DB2ConnectionConfiguration(String string, String string2, Integer n2, int n3, String string3, String string4, String string5, boolean bl2, String string6, String string7, boolean bl3, int n4, int n5, int n6, IsolationLevel isolationLevel, boolean bl4, String string8) {
        block10: {
            block9: {
                block8: {
                    this._database = Objects.requireNonNull(string, c.a("require-database"));
                    this._host = Objects.requireNonNull(string2, c.a("require-host"));
                    this._port = Objects.requireNonNull(n2, c.a("require-port"));
                    this._securityMechanism = Objects.requireNonNull(Integer.valueOf(n3), c.a("require-port"));
                    if (this._securityMechanism == 3) {
                        this._kerberosServerPrincipal = "";
                        this._username = Objects.requireNonNull(string4, c.a("require-user"));
                        this._password = Objects.requireNonNull(string5, c.a("require-password"));
                    } else {
                        this._kerberosServerPrincipal = Objects.requireNonNull(string3, c.a("require-kerberosServerPrincipal"));
                        this._username = string4;
                        this._password = string5;
                    }
                    try {
                        this._enableSSL = bl2;
                        if (!this._enableSSL) break block8;
                        this._trustStorePath = Objects.requireNonNull(string6, c.a("require-ssl-trust-store-path"));
                        this._trustStorePassword = Objects.requireNonNull(string7, c.a("require-ssl-trust-store-password"));
                        break block9;
                    }
                    catch (RuntimeException runtimeException) {
                        throw DB2ConnectionConfiguration.b(runtimeException);
                    }
                }
                this._trustStorePath = "";
                this._trustStorePassword = "";
            }
            try {
                try {
                    this._autoCommit = bl3;
                    this._fetchSize = n4;
                    this._conPoolSize = n5;
                    this._stmtCacheSize = n6;
                    if (this._stmtCacheSize <= 384 && this._stmtCacheSize >= 0) break block10;
                }
                catch (RuntimeException runtimeException) {
                    throw DB2ConnectionConfiguration.b(runtimeException);
                }
                throw new RuntimeException(c.a("illegal-stmt-cache-size"));
            }
            catch (RuntimeException runtimeException) {
                throw DB2ConnectionConfiguration.b(runtimeException);
            }
        }
        this._isolation = isolationLevel;
        this._keepDynamic = bl4;
        this._licenseFilePath = string8;
    }

    public static DB2ConnectionConfiguration$Builder builder() {
        return new DB2ConnectionConfiguration$Builder(null);
    }

    public String toString() {
        return "DB2ConnectionConfiguration {\n    database = '" + this._database + '\'' + "\n    host = '" + this._host + '\'' + "\n    port = " + this._port + "\n    username = '" + this._username + '\'' + "\n}\n";
    }

    public String getConnectionDetails() {
        return "/database=" + this._database + "/host=" + this._host + "/port=" + this._port + "/username=" + this._username + "/autocommit=" + this._autoCommit + "/conPoolSize=" + this._conPoolSize + "/stmtCacheSize=" + this._stmtCacheSize + "/fetchSize=" + this._fetchSize + "/";
    }

    public String getDatabase() {
        return this._database;
    }

    public String getHost() {
        return this._host;
    }

    public String getPassword() {
        return this._password;
    }

    public int getPort() {
        return this._port;
    }

    public String getUsername() {
        return this._username;
    }

    public int getSecurityMechanism() {
        return this._securityMechanism;
    }

    public String getKerberosServerPrincipal() {
        return this._kerberosServerPrincipal;
    }

    public String getSecurityMechanismStr() {
        return _nameMap.get(this._securityMechanism);
    }

    public boolean isSSLEnabled() {
        return this._enableSSL;
    }

    public String getTrustStorePath() {
        return this._trustStorePath;
    }

    public String getTrustStorePassword() {
        return this._trustStorePassword;
    }

    public int getFetchSize() {
        return this._fetchSize;
    }

    public int getConPoolSize() {
        return this._conPoolSize;
    }

    public int getStmtCacheSize() {
        return this._stmtCacheSize;
    }

    public IsolationLevel getIsolationLevel() {
        return this._isolation;
    }

    public boolean getKeepDynamic() {
        return this._keepDynamic;
    }

    DB2ConnectionConfiguration(String string, String string2, Integer n2, int n3, String string3, String string4, String string5, boolean bl2, String string6, String string7, boolean bl3, int n4, int n5, int n6, IsolationLevel isolationLevel, boolean bl4, String string8, 1 var18_18) {
        this(string, string2, n2, n3, string3, string4, string5, bl2, string6, string7, bl3, n4, n5, n6, isolationLevel, bl4, string8);
    }

    static {
        _nameMap.put(3, "USERID_PASSWORD");
        _nameMap.put(11, "KERBEROS_SECURITY");
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

