/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.r2dbc;

import com.ibm.db2.r2dbc.DB2Blob;
import com.ibm.db2.r2dbc.DB2Clob;
import com.ibm.db2.r2dbc.DB2Connection$1;
import com.ibm.db2.r2dbc.DB2ConnectionConfiguration;
import com.ibm.db2.r2dbc.DB2ConnectionPool;
import com.ibm.db2.r2dbc.DB2PreparedStatement;
import com.ibm.db2.r2dbc.DB2Result;
import com.ibm.db2.r2dbc.a.K;
import com.ibm.db2.r2dbc.b.d;
import com.ibm.db2.r2dbc.b.e;
import com.ibm.db2.r2dbc.b.p;
import com.ibm.db2.r2dbc.d.b;
import com.ibm.db2.r2dbc.d.c;
import io.r2dbc.spi.Batch;
import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionMetadata;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.ValidationDepth;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DB2Connection
implements Connection {
    private static final Logger _logger = LoggerFactory.getLogger((String)DB2Connection.class.getName());
    private static final int READ_UNCOMMITED = 1;
    private static final int READ_COMMITTED = 2;
    private static final int REPEATABLE_READ = 3;
    private static final int SERIALIZABLE = 4;
    private final int _cid;
    private d _endpoint;
    private DB2ConnectionConfiguration _config;
    private boolean _isClosed;
    private K _lastSqlca;
    private Set<Integer> _secnosInUse = new HashSet<Integer>();
    private Set<Integer> _secnosAvailable = new HashSet<Integer>();
    private DB2ConnectionPool _conPool = null;
    private boolean _autocommit;
    private int _isolationLevel = 2;
    private int _stmtCacheSize;
    LinkedHashMap<String, DB2PreparedStatement> _stmtCache;
    private ArrayList<DB2Result> _openQueries = new ArrayList();

    protected DB2Connection(d d2) {
        this._cid = d2.h();
        _logger.debug("[rdb2-" + this._cid + "-0] Creating DB2Connection instance id = " + this._cid);
        this._endpoint = d2;
        this._isClosed = false;
        this._endpoint.a(this);
        this._config = this._endpoint.g();
        this._autocommit = true;
        this.setTransactionIsolationLevel(this._config.getIsolationLevel());
        try {
            for (int i2 = 1; i2 < 385; ++i2) {
                this._secnosAvailable.add(i2);
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        this._stmtCacheSize = this._config.getStmtCacheSize();
        this._stmtCache = new DB2Connection$1(this, 5, 0.75f, true);
        _logger.info("[rdb2-" + this._cid + "-0] Connected");
        _logger.debug("CONNECTION: id = " + this._cid + " " + this._config.getConnectionDetails());
    }

    protected synchronized void releaseSectionNumber(int n2) {
        this._secnosInUse.remove(n2);
        this._secnosAvailable.add(n2);
    }

    protected synchronized int getFreeSectionNumber() {
        try {
            if (this._secnosAvailable.size() == 0) {
                throw new RuntimeException("[rdb2-" + this._cid + "-0] : Section Numbers Unavailable");
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        int n2 = this._secnosAvailable.iterator().next();
        this._secnosAvailable.remove(n2);
        this._secnosInUse.add(n2);
        return n2;
    }

    protected void setConPool(DB2ConnectionPool dB2ConnectionPool) {
        this._conPool = dB2ConnectionPool;
    }

    public boolean isPooledConnection() {
        try {
            if (this._conPool != null) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        return false;
    }

    public int getConnectionId() {
        return this._cid;
    }

    public synchronized void release() {
        try {
            _logger.debug("[rdb2-" + this._cid + "-0] releasing DB2Connection id = " + this._cid);
            if (this._conPool == null) {
                _logger.error("[rdb2-" + this._cid + "-0] release(): Not a pooled connection");
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        Flux.fromIterable(this._openQueries).flatMap(DB2Connection::lambda$release$0).doOnComplete(this::lambda$release$1).subscribe();
    }

    private void reset() {
        this._autocommit = true;
        this.setTransactionIsolationLevel(this._config.getIsolationLevel());
    }

    public Mono<Void> close() {
        try {
            _logger.debug("[rdb2-" + this._cid + "-0] closing DB2Connection id = " + this._cid);
            if (this._isClosed) {
                return Mono.empty();
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        try {
            this._isClosed = true;
            if (this._conPool != null) {
                this._conPool.remove(this);
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        _logger.debug("CONNECTION: id = " + this._cid + " disconnecting");
        return this._endpoint.d();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public Mono<Void> beginTransaction() {
        _logger.debug("[rdb2-" + this._cid + "-0] begin transaction, autocommit set to false");
        this._autocommit = false;
        return Mono.just((Object)1).then();
    }

    public Mono<Void> commitTransaction() {
        _logger.debug("[rdb2-" + this._cid + "-0] commit transaction, autocommit reset to true");
        this._autocommit = true;
        return new com.ibm.db2.r2dbc.b.c(this._cid).a(this._endpoint).doOnNext(this::lambda$commitTransaction$2).then();
    }

    public Batch createBatch() {
        throw new UnsupportedOperationException();
    }

    public Mono<Void> createSavepoint(String string) {
        throw new UnsupportedOperationException();
    }

    public DB2Clob createDB2Clob(String string) {
        return new c(string);
    }

    public DB2Clob createDB2Clob(Flux<? extends CharSequence> flux) {
        return new c(flux);
    }

    public DB2Blob createDB2Blob(byte[] byArray) {
        return new b(byArray);
    }

    public DB2Blob createDB2Blob(Flux<ByteBuffer> flux) {
        return new b(flux);
    }

    public DB2PreparedStatement createStatement(String string) {
        if (this._stmtCache.containsKey(string)) {
            DB2PreparedStatement dB2PreparedStatement = this._stmtCache.get(string);
            dB2PreparedStatement.isCached(true);
            dB2PreparedStatement.clearParameters();
            _logger.debug("[rdb2-" + this._cid + "-" + dB2PreparedStatement.getSectionNumber() + "] getting DB2PreparedStatement from cache, cid = " + this._cid + ", secno: " + dB2PreparedStatement.getSectionNumber());
            return dB2PreparedStatement;
        }
        DB2PreparedStatement dB2PreparedStatement = new DB2PreparedStatement(this, string, this._isolationLevel, this._autocommit);
        try {
            if (DB2Connection.canCacheSQL(string)) {
                this._stmtCache.put(string, dB2PreparedStatement);
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        return dB2PreparedStatement;
    }

    public Mono<Void> executeUpdate(String string) {
        _logger.debug(this._cid + ": executeUpdate: " + string);
        return new e(this._cid, string, this._autocommit, this._isolationLevel, this._endpoint.a()).a(this._endpoint).doOnNext(this::lambda$executeUpdate$3).then();
    }

    public Mono<Void> releaseSavepoint(String string) {
        throw new UnsupportedOperationException();
    }

    public Mono<Void> rollbackTransaction() {
        _logger.debug("[rdb2-" + this._cid + "-0] rollback transaction, autocommit reset to true");
        this._autocommit = true;
        return new p(this._cid).a(this._endpoint).doOnNext(this::lambda$rollbackTransaction$4).then();
    }

    public Mono<Void> rollbackTransactionToSavepoint(String string) {
        throw new UnsupportedOperationException();
    }

    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        block9: {
            block12: {
                block11: {
                    block10: {
                        block8: {
                            try {
                                if (isolationLevel != IsolationLevel.READ_UNCOMMITTED) break block8;
                                this._isolationLevel = 1;
                                break block9;
                            }
                            catch (RuntimeException runtimeException) {
                                throw DB2Connection.b(runtimeException);
                            }
                        }
                        try {
                            if (isolationLevel != IsolationLevel.READ_COMMITTED) break block10;
                            this._isolationLevel = 2;
                            break block9;
                        }
                        catch (RuntimeException runtimeException) {
                            throw DB2Connection.b(runtimeException);
                        }
                    }
                    try {
                        if (isolationLevel != IsolationLevel.REPEATABLE_READ) break block11;
                        this._isolationLevel = 3;
                        break block9;
                    }
                    catch (RuntimeException runtimeException) {
                        throw DB2Connection.b(runtimeException);
                    }
                }
                try {
                    if (isolationLevel != IsolationLevel.SERIALIZABLE) break block12;
                    this._isolationLevel = 4;
                    break block9;
                }
                catch (RuntimeException runtimeException) {
                    throw DB2Connection.b(runtimeException);
                }
            }
            return Mono.error((Throwable)new Exception("Unsupported Isolation Level"));
        }
        return Mono.empty();
    }

    protected synchronized void addOpenQry(DB2Result dB2Result) {
        this._openQueries.add(dB2Result);
    }

    protected synchronized void removeOpenQry(DB2Result dB2Result) {
        this._openQueries.remove(dB2Result);
    }

    protected d getEndpoint() {
        return this._endpoint;
    }

    public int getSqlCode() {
        try {
            if (this._lastSqlca == null) {
                return 0;
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        return this._lastSqlca.d();
    }

    public String getSqlState() {
        try {
            if (this._lastSqlca == null) {
                return "";
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        return this._lastSqlca.e();
    }

    public String getSqlErrProc() {
        try {
            if (this._lastSqlca == null) {
                return "";
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        return this._lastSqlca.f();
    }

    protected static boolean canCacheSQL(String string) {
        String string2 = string.trim();
        try {
            if (string2.startsWith("SELECT")) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        try {
            if (string2.startsWith("INSERT")) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        try {
            if (string2.startsWith("UPDATE")) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        try {
            if (string2.startsWith("DELETE")) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw DB2Connection.b(runtimeException);
        }
        return false;
    }

    public boolean isAutoCommit() {
        return this._autocommit;
    }

    public ConnectionMetadata getMetadata() {
        throw new UnsupportedOperationException();
    }

    public IsolationLevel getTransactionIsolationLevel() {
        IsolationLevel isolationLevel = IsolationLevel.READ_COMMITTED;
        if (this._isolationLevel == 1) {
            isolationLevel = IsolationLevel.READ_UNCOMMITTED;
        } else if (this._isolationLevel == 2) {
            isolationLevel = IsolationLevel.READ_COMMITTED;
        } else if (this._isolationLevel == 3) {
            isolationLevel = IsolationLevel.REPEATABLE_READ;
        } else if (this._isolationLevel == 4) {
            isolationLevel = IsolationLevel.SERIALIZABLE;
        }
        return isolationLevel;
    }

    public Publisher<Void> setAutoCommit(boolean bl2) {
        throw new UnsupportedOperationException();
    }

    public Publisher<Boolean> validate(ValidationDepth validationDepth) {
        throw new UnsupportedOperationException();
    }

    private void lambda$rollbackTransaction$4(K k2) {
        this._lastSqlca = k2;
    }

    private void lambda$executeUpdate$3(K k2) {
        this._lastSqlca = k2;
    }

    private void lambda$commitTransaction$2(K k2) {
        this._lastSqlca = k2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lambda$release$1() {
        DB2Connection dB2Connection = this;
        synchronized (dB2Connection) {
            this._openQueries.clear();
            this.reset();
            this._conPool.releaseConnection(this);
        }
    }

    private static Publisher lambda$release$0(DB2Result dB2Result) {
        return dB2Result.close();
    }

    static int access$000(DB2Connection dB2Connection) {
        return dB2Connection._stmtCacheSize;
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

