/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.r2dbc;

import com.ibm.db2.r2dbc.d.b;
import com.ibm.db2.r2dbc.e.c;
import io.r2dbc.spi.ColumnMetadata;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DB2ColumnMetadata
implements ColumnMetadata {
    private static final Logger _logger = LoggerFactory.getLogger((String)DB2ColumnMetadata.class.getName());
    private String _name;
    private int _jdbcType;
    private int _sqlType;
    private long _columnLength;
    private int _scale;
    private int _precision;
    private int _ccsid;
    private String _label;
    private String _comments;

    protected DB2ColumnMetadata() {
    }

    protected void setName(String string) {
        this._name = string;
    }

    protected void setJdbcType(int n2) {
        this._jdbcType = n2;
    }

    protected void setSqlType(int n2) {
        this._sqlType = n2;
    }

    protected void setColumnLength(long l2) {
        this._columnLength = l2;
    }

    protected void setScale(int n2) {
        this._scale = n2;
    }

    protected void setPrecision(int n2) {
        this._precision = n2;
    }

    protected void setCcsid(int n2) {
        this._ccsid = n2;
    }

    protected void setLabel(String string) {
        this._label = string;
    }

    protected void setComments(String string) {
        this._comments = string;
    }

    public String getName() {
        return this._name;
    }

    public int getJdbcType() {
        return this._jdbcType;
    }

    public Class<?> getJavaType() {
        Class clazz = null;
        switch (this._jdbcType) {
            case 1: 
            case 12: {
                clazz = String.class;
                break;
            }
            case -3: 
            case -2: {
                clazz = byte[].class;
                break;
            }
            case 5: {
                clazz = Short.class;
                break;
            }
            case 4: {
                clazz = Integer.class;
                break;
            }
            case -5: {
                clazz = Long.class;
                break;
            }
            case 7: {
                clazz = Float.class;
                break;
            }
            case 6: 
            case 8: {
                clazz = Double.class;
                break;
            }
            case 2: 
            case 3: {
                clazz = BigDecimal.class;
                break;
            }
            case -100001: {
                clazz = BigDecimal.class;
                break;
            }
            case 91: {
                clazz = Date.class;
                break;
            }
            case 92: {
                clazz = Time.class;
                break;
            }
            case 93: {
                clazz = Timestamp.class;
                break;
            }
            case 502: 
            case 2005: {
                clazz = com.ibm.db2.r2dbc.d.c.class;
                break;
            }
            case 2004: {
                clazz = b.class;
                break;
            }
            default: {
                throw new RuntimeException(String.format(c.a("unknown-type-id"), this._jdbcType));
            }
        }
        return clazz;
    }

    public int getSqlType() {
        return this._sqlType;
    }

    public long getColumnLength() {
        return this._columnLength;
    }

    public Integer getScale() {
        return this._scale;
    }

    public Integer getPrecision() {
        return this._precision;
    }

    public int getCcsid() {
        return this._ccsid;
    }

    public String getLabel() {
        return this._label;
    }

    public String getComments() {
        return this._comments;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        return string + "DB2ColumnMetadata {\n" + string + "  name: " + this._name + "\n" + string + "  jdbcType: " + this._jdbcType + "\n" + string + "  sqlType: " + this._sqlType + "\n" + string + "  columnLength: " + this._columnLength + "\n" + string + "  scale: " + this._scale + "\n" + string + "  precision: " + this._precision + "\n" + string + "  ccsid: " + this._ccsid + "\n" + string + "  label: " + this._label + "\n" + string + "  comments: " + this._comments + "\n" + string + "}\n";
    }
}

