/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.test;

import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProviderChain;
import com.ibm.cloud.objectstorage.auth.EnvironmentVariableCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.PropertiesFileCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.SystemPropertiesCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.profile.ProfileCredentialsProvider;
import com.ibm.cloud.objectstorage.util.IOUtils;
import java.io.InputStream;
import org.junit.BeforeClass;

public abstract class AWSIntegrationTestBase {
    private static AWSCredentials credentials;
    private static final String propertiesFilePath;
    private static final String TEST_CREDENTIALS_PROFILE_NAME = "aws-java-sdk-test";
    private static final AWSCredentialsProviderChain chain;

    @BeforeClass
    public static void setUpCredentials() {
        if (credentials == null) {
            try {
                credentials = chain.getCredentials();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static AWSCredentials getCredentials() {
        return credentials;
    }

    protected String getResourceAsString(String location) {
        try {
            InputStream resourceStream = this.getClass().getResourceAsStream(location);
            String resourceAsString = IOUtils.toString((InputStream)resourceStream);
            resourceStream.close();
            return resourceAsString;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        propertiesFilePath = System.getProperty("user.home") + "/.aws/awsTestAccount.properties";
        chain = new AWSCredentialsProviderChain(new AWSCredentialsProvider[]{new PropertiesFileCredentialsProvider(propertiesFilePath), new ProfileCredentialsProvider(TEST_CREDENTIALS_PROFILE_NAME), new EnvironmentVariableCredentialsProvider(), new SystemPropertiesCredentialsProvider()});
    }
}

