/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.smoketest;

import com.google.inject.Inject;
import com.ibm.cloud.objectstorage.AmazonServiceException;
import com.ibm.cloud.objectstorage.AmazonWebServiceClient;
import com.ibm.cloud.objectstorage.regions.RegionUtils;
import com.ibm.cloud.objectstorage.smoketest.ReflectionUtils;
import com.ibm.cloud.objectstorage.util.Classes;
import cucumber.api.java.en.And;
import cucumber.api.java.en.Then;
import cucumber.api.java.en.When;
import cucumber.runtime.java.guice.ScenarioScoped;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.junit.Assert;

@ScenarioScoped
public class AWSCucumberStepdefs {
    private AmazonWebServiceClient client;
    private String packageName;
    private Object result;
    private AmazonServiceException exception;

    @Inject
    public AWSCucumberStepdefs(AmazonWebServiceClient client) {
        this.client = client;
        this.client.setRegion(RegionUtils.getRegion((String)"us-east-1"));
        Class httpClientClass = Classes.childClassOf(AmazonWebServiceClient.class, (Object)this.client);
        this.packageName = httpClientClass.getPackage().getName();
    }

    @When(value="^I call the \"(.*?)\" API$")
    public void when_I_call_the_API(String operation) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.call(operation, null);
    }

    @When(value="^I call the \"(.*?)\" API with:$")
    public void when_I_call_the_API(String operation, Map<String, String> args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.call(operation, args);
    }

    @When(value="^I attempt to call the \"(.+?)\" API with:$")
    public void when_I_attempt_to_call_API(String operation, Map<String, String> args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.attemptCall(operation, args);
    }

    @Then(value="^the response should contain a \"([^\"]*)\"$")
    public void the_response_should_contain_a(String memberName) throws Throwable {
        String[] path = memberName.split("[.]");
        Object member = ReflectionUtils.getByPath(this.result, Arrays.asList(path));
        Assert.assertNotNull((Object)member);
    }

    @Then(value="^the value at \"(.*?)\" should be a list")
    public void then_the_value_at_should_be_a_list(String memberName) {
        String[] path = memberName.split("[.]");
        Object member = ReflectionUtils.getByPath(this.result, Arrays.asList(path));
        Assert.assertTrue((boolean)(member instanceof List));
    }

    @Then(value="^the value at \"(.*?)\" should be a map")
    public void then_the_value_at_should_be_a_map(String memberName) {
        String[] path = memberName.split("[.]");
        Object member = ReflectionUtils.getByPath(this.result, Arrays.asList(path));
        Assert.assertTrue((boolean)(member instanceof Map));
    }

    @Then(value="^I expect the response error code to be \"(.+?)\"$")
    public void then_I_expect_response_error_code(String expected) {
        Assert.assertNotNull((Object)this.exception);
        Assert.assertTrue((boolean)(this.exception instanceof AmazonServiceException));
        String actual = this.exception.getErrorCode();
        Assert.assertEquals((String)("Error code doesn't match. Expected : " + expected + ". Actual :" + actual), (Object)expected, (Object)actual);
    }

    @And(value="^I expect the response error message to include:$")
    public void and_I_expect_the_response_error_message_include(String expected) {
        Assert.assertNotNull((Object)this.exception);
        Assert.assertTrue((boolean)(this.exception instanceof AmazonServiceException));
        String actual = this.exception.getErrorMessage().toLowerCase();
        Assert.assertTrue((String)("Error message doesn't match. Expected : " + expected + ". Actual :" + actual), (boolean)actual.contains(expected.toLowerCase()));
    }

    private void attemptCall(String operation, Map<String, String> args) throws IllegalAccessException, IllegalArgumentException {
        try {
            this.call(operation, args);
        }
        catch (InvocationTargetException ite) {
            this.exception = (AmazonServiceException)ite.getCause();
        }
    }

    private void call(String operation, Map<String, String> args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String requestClassName = this.packageName + ".model." + operation + "Request";
        String operationMethodName = operation.substring(0, 1).toLowerCase() + operation.substring(1);
        Class requestClass = ReflectionUtils.loadClass(this.getClass(), requestClassName);
        Object requestObject = ReflectionUtils.newInstance(requestClass, new Object[0]);
        if (args != null && !args.isEmpty()) {
            for (Map.Entry<String, String> entry : args.entrySet()) {
                String key = entry.getKey().substring(0, 1).toUpperCase() + entry.getKey().substring(1);
                Object value = this.convertTo(ReflectionUtils.getParameterTypes(requestObject, Arrays.asList(key)), entry.getValue());
                ReflectionUtils.setByPath(requestObject, value, Arrays.asList(key));
            }
        }
        Method method = ReflectionUtils.findMethod(this.client, operationMethodName, requestClass);
        this.result = method.invoke((Object)this.client, requestObject);
    }

    private Object convertTo(Class<?> type, String value) {
        if (type.equals(Integer.class)) {
            return Integer.valueOf(value);
        }
        if (type.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (type.equals(List.class)) {
            return Arrays.asList(value);
        }
        return value;
    }

    static class ServiceConfig {
        private String serviceInterfaceName;
        private String sourcePackageName;

        ServiceConfig() {
        }

        public void setServiceInterfaceName(String serviceInterfaceName) {
            this.serviceInterfaceName = serviceInterfaceName;
        }

        public String getServiceInterfaceName() {
            return this.serviceInterfaceName;
        }

        public void setSourcePackageName(String sourcePackageName) {
            this.sourcePackageName = sourcePackageName;
        }

        public String getSourcePackageName() {
            return this.sourcePackageName;
        }
    }
}

