/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.test.util;

import com.ibm.cloud.objectstorage.internal.SdkInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;

public class ConstantInputStream
extends SdkInputStream {
    private final byte val;
    private long remaining;
    private final boolean randomlyReturnZeros;
    private int randomZerosCount;
    private static final Random rand = new Random();

    public ConstantInputStream(long total, byte val) {
        this.remaining = total;
        this.val = val;
        this.randomlyReturnZeros = false;
    }

    public ConstantInputStream(long total, byte val, boolean randomlyReturnZeros) {
        this.remaining = total;
        this.val = val;
        this.randomlyReturnZeros = randomlyReturnZeros;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.randomlyReturnZeros && rand.nextBoolean()) {
            ++this.randomZerosCount;
            return 0;
        }
        if (this.remaining <= 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        this.remaining -= (long)len;
        Arrays.fill(b, off, off + len, this.val);
        return len;
    }

    public int read() throws IOException {
        if (this.randomlyReturnZeros && rand.nextBoolean()) {
            ++this.randomZerosCount;
            return 0;
        }
        if (this.remaining <= 0L) {
            return -1;
        }
        --this.remaining;
        return this.val;
    }

    public int getRandomZerosCount() {
        return this.randomZerosCount;
    }

    protected InputStream getWrappedInputStream() {
        return null;
    }
}

