/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3;

import com.ibm.cloud.objectstorage.AmazonClientException;
import com.ibm.cloud.objectstorage.AmazonServiceException;
import com.ibm.cloud.objectstorage.AmazonWebServiceClient;
import com.ibm.cloud.objectstorage.AmazonWebServiceRequest;
import com.ibm.cloud.objectstorage.AmazonWebServiceResponse;
import com.ibm.cloud.objectstorage.ClientConfiguration;
import com.ibm.cloud.objectstorage.DefaultRequest;
import com.ibm.cloud.objectstorage.HttpMethod;
import com.ibm.cloud.objectstorage.Protocol;
import com.ibm.cloud.objectstorage.Request;
import com.ibm.cloud.objectstorage.ResetException;
import com.ibm.cloud.objectstorage.Response;
import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.SignableRequest;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.annotation.SdkTestInternalApi;
import com.ibm.cloud.objectstorage.annotation.ThreadSafe;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.Presigner;
import com.ibm.cloud.objectstorage.auth.Signer;
import com.ibm.cloud.objectstorage.auth.SignerFactory;
import com.ibm.cloud.objectstorage.event.ProgressEventType;
import com.ibm.cloud.objectstorage.event.ProgressInputStream;
import com.ibm.cloud.objectstorage.event.ProgressListener;
import com.ibm.cloud.objectstorage.event.SDKProgressPublisher;
import com.ibm.cloud.objectstorage.handlers.HandlerChainFactory;
import com.ibm.cloud.objectstorage.handlers.HandlerContextKey;
import com.ibm.cloud.objectstorage.handlers.RequestHandler2;
import com.ibm.cloud.objectstorage.http.ExecutionContext;
import com.ibm.cloud.objectstorage.http.HttpMethodName;
import com.ibm.cloud.objectstorage.http.HttpResponseHandler;
import com.ibm.cloud.objectstorage.internal.DefaultServiceEndpointBuilder;
import com.ibm.cloud.objectstorage.internal.IdentityEndpointBuilder;
import com.ibm.cloud.objectstorage.internal.ReleasableInputStream;
import com.ibm.cloud.objectstorage.internal.ResettableInputStream;
import com.ibm.cloud.objectstorage.internal.ServiceEndpointBuilder;
import com.ibm.cloud.objectstorage.internal.StaticCredentialsProvider;
import com.ibm.cloud.objectstorage.internal.auth.SignerProvider;
import com.ibm.cloud.objectstorage.metrics.AwsSdkMetrics;
import com.ibm.cloud.objectstorage.metrics.MetricType;
import com.ibm.cloud.objectstorage.metrics.RequestMetricCollector;
import com.ibm.cloud.objectstorage.oauth.IBMOAuthCredentials;
import com.ibm.cloud.objectstorage.oauth.IBMOAuthSigner;
import com.ibm.cloud.objectstorage.oauth.OAuthServiceException;
import com.ibm.cloud.objectstorage.regions.RegionUtils;
import com.ibm.cloud.objectstorage.regions.Regions;
import com.ibm.cloud.objectstorage.retry.PredefinedRetryPolicies;
import com.ibm.cloud.objectstorage.retry.RetryPolicy;
import com.ibm.cloud.objectstorage.retry.internal.AuthErrorRetryStrategy;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3ClientBuilder;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3ClientConfigurationFactory;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3ClientParams;
import com.ibm.cloud.objectstorage.services.s3.S3ClientOptions;
import com.ibm.cloud.objectstorage.services.s3.S3CredentialsProviderChain;
import com.ibm.cloud.objectstorage.services.s3.S3ResponseMetadata;
import com.ibm.cloud.objectstorage.services.s3.UploadObjectObserver;
import com.ibm.cloud.objectstorage.services.s3.internal.AWSS3V4Signer;
import com.ibm.cloud.objectstorage.services.s3.internal.BucketNameUtils;
import com.ibm.cloud.objectstorage.services.s3.internal.CompleteMultipartUploadRetryCondition;
import com.ibm.cloud.objectstorage.services.s3.internal.Constants;
import com.ibm.cloud.objectstorage.services.s3.internal.DeleteObjectTaggingHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.DeleteObjectsResponse;
import com.ibm.cloud.objectstorage.services.s3.internal.DigestValidationInputStream;
import com.ibm.cloud.objectstorage.services.s3.internal.DualstackEndpointBuilder;
import com.ibm.cloud.objectstorage.services.s3.internal.GetObjectTaggingResponseHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.InitiateMultipartUploadHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.InputSubstream;
import com.ibm.cloud.objectstorage.services.s3.internal.ListPartsHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.MD5DigestCalculatingInputStream;
import com.ibm.cloud.objectstorage.services.s3.internal.Mimetypes;
import com.ibm.cloud.objectstorage.services.s3.internal.MultiFileOutputStream;
import com.ibm.cloud.objectstorage.services.s3.internal.ObjectExpirationHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.ResponseHeaderHandlerChain;
import com.ibm.cloud.objectstorage.services.s3.internal.S3ErrorResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3MetadataResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3ObjectResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3QueryStringSigner;
import com.ibm.cloud.objectstorage.services.s3.internal.S3RequestEndpointResolver;
import com.ibm.cloud.objectstorage.services.s3.internal.S3RequesterChargedHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3Signer;
import com.ibm.cloud.objectstorage.services.s3.internal.S3V4AuthErrorRetryStrategy;
import com.ibm.cloud.objectstorage.services.s3.internal.S3VersionHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.S3XmlResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.ServerSideEncryptionHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.ServiceUtils;
import com.ibm.cloud.objectstorage.services.s3.internal.SetObjectTaggingResponseHeaderHandler;
import com.ibm.cloud.objectstorage.services.s3.internal.SkipMd5CheckStrategy;
import com.ibm.cloud.objectstorage.services.s3.internal.XmlWriter;
import com.ibm.cloud.objectstorage.services.s3.internal.auth.S3SignerProvider;
import com.ibm.cloud.objectstorage.services.s3.metrics.S3ServiceMetric;
import com.ibm.cloud.objectstorage.services.s3.model.AbortMultipartUploadRequest;
import com.ibm.cloud.objectstorage.services.s3.model.AccessControlList;
import com.ibm.cloud.objectstorage.services.s3.model.AddLegalHoldRequest;
import com.ibm.cloud.objectstorage.services.s3.model.AmazonS3Exception;
import com.ibm.cloud.objectstorage.services.s3.model.Bucket;
import com.ibm.cloud.objectstorage.services.s3.model.BucketCrossOriginConfiguration;
import com.ibm.cloud.objectstorage.services.s3.model.BucketLifecycleConfiguration;
import com.ibm.cloud.objectstorage.services.s3.model.BucketProtectionConfiguration;
import com.ibm.cloud.objectstorage.services.s3.model.BucketTaggingConfiguration;
import com.ibm.cloud.objectstorage.services.s3.model.BucketVersioningConfiguration;
import com.ibm.cloud.objectstorage.services.s3.model.BucketWebsiteConfiguration;
import com.ibm.cloud.objectstorage.services.s3.model.CannedAccessControlList;
import com.ibm.cloud.objectstorage.services.s3.model.CompleteMultipartUploadRequest;
import com.ibm.cloud.objectstorage.services.s3.model.CompleteMultipartUploadResult;
import com.ibm.cloud.objectstorage.services.s3.model.CopyObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.CopyObjectResult;
import com.ibm.cloud.objectstorage.services.s3.model.CopyPartRequest;
import com.ibm.cloud.objectstorage.services.s3.model.CopyPartResult;
import com.ibm.cloud.objectstorage.services.s3.model.CreateBucketRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteBucketCrossOriginConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteBucketLifecycleConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteBucketRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteBucketTaggingConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteBucketWebsiteConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteLegalHoldRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteObjectTaggingRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteObjectTaggingResult;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteObjectsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteObjectsResult;
import com.ibm.cloud.objectstorage.services.s3.model.DeleteVersionRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ExtendObjectRetentionRequest;
import com.ibm.cloud.objectstorage.services.s3.model.FASPConnectionInfo;
import com.ibm.cloud.objectstorage.services.s3.model.GeneratePresignedUrlRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GenericBucketRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetBucketAclRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetBucketCrossOriginConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetBucketFaspConnectionInfoRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetBucketLifecycleConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetBucketProtectionConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetBucketTaggingConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetBucketVersioningConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetBucketWebsiteConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectAclRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectMetadataRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectTaggingRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectTaggingResult;
import com.ibm.cloud.objectstorage.services.s3.model.GetRequestPaymentConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.GetS3AccountOwnerRequest;
import com.ibm.cloud.objectstorage.services.s3.model.Grant;
import com.ibm.cloud.objectstorage.services.s3.model.Grantee;
import com.ibm.cloud.objectstorage.services.s3.model.HeadBucketRequest;
import com.ibm.cloud.objectstorage.services.s3.model.HeadBucketResult;
import com.ibm.cloud.objectstorage.services.s3.model.InitiateMultipartUploadRequest;
import com.ibm.cloud.objectstorage.services.s3.model.InitiateMultipartUploadResult;
import com.ibm.cloud.objectstorage.services.s3.model.ListBucketsExtendedRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListBucketsExtendedResponse;
import com.ibm.cloud.objectstorage.services.s3.model.ListBucketsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListLegalHoldsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListLegalHoldsResult;
import com.ibm.cloud.objectstorage.services.s3.model.ListMultipartUploadsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListNextBatchOfObjectsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListNextBatchOfVersionsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListObjectsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListObjectsV2Request;
import com.ibm.cloud.objectstorage.services.s3.model.ListObjectsV2Result;
import com.ibm.cloud.objectstorage.services.s3.model.ListPartsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.ListVersionsRequest;
import com.ibm.cloud.objectstorage.services.s3.model.MultiFactorAuthentication;
import com.ibm.cloud.objectstorage.services.s3.model.MultiObjectDeleteException;
import com.ibm.cloud.objectstorage.services.s3.model.MultipartUploadListing;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectListing;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectMetadata;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectTagging;
import com.ibm.cloud.objectstorage.services.s3.model.Owner;
import com.ibm.cloud.objectstorage.services.s3.model.PartETag;
import com.ibm.cloud.objectstorage.services.s3.model.PartListing;
import com.ibm.cloud.objectstorage.services.s3.model.Permission;
import com.ibm.cloud.objectstorage.services.s3.model.PutObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.PutObjectResult;
import com.ibm.cloud.objectstorage.services.s3.model.Region;
import com.ibm.cloud.objectstorage.services.s3.model.RequestPaymentConfiguration;
import com.ibm.cloud.objectstorage.services.s3.model.ResponseHeaderOverrides;
import com.ibm.cloud.objectstorage.services.s3.model.RestoreObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.S3AccelerateUnsupported;
import com.ibm.cloud.objectstorage.services.s3.model.S3DataSource;
import com.ibm.cloud.objectstorage.services.s3.model.S3Object;
import com.ibm.cloud.objectstorage.services.s3.model.S3ObjectInputStream;
import com.ibm.cloud.objectstorage.services.s3.model.SSEAwsKeyManagementParams;
import com.ibm.cloud.objectstorage.services.s3.model.SSEAwsKeyManagementParamsProvider;
import com.ibm.cloud.objectstorage.services.s3.model.SSECustomerKey;
import com.ibm.cloud.objectstorage.services.s3.model.SSECustomerKeyProvider;
import com.ibm.cloud.objectstorage.services.s3.model.SetBucketAclRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetBucketCrossOriginConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetBucketLifecycleConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetBucketProtectionConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetBucketTaggingConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetBucketVersioningConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetBucketWebsiteConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetObjectAclRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetObjectTaggingRequest;
import com.ibm.cloud.objectstorage.services.s3.model.SetObjectTaggingResult;
import com.ibm.cloud.objectstorage.services.s3.model.SetRequestPaymentConfigurationRequest;
import com.ibm.cloud.objectstorage.services.s3.model.StorageClass;
import com.ibm.cloud.objectstorage.services.s3.model.Tag;
import com.ibm.cloud.objectstorage.services.s3.model.UploadObjectRequest;
import com.ibm.cloud.objectstorage.services.s3.model.UploadPartRequest;
import com.ibm.cloud.objectstorage.services.s3.model.UploadPartResult;
import com.ibm.cloud.objectstorage.services.s3.model.VersionListing;
import com.ibm.cloud.objectstorage.services.s3.model.transform.AclXmlFactory;
import com.ibm.cloud.objectstorage.services.s3.model.transform.BucketConfigurationXmlFactory;
import com.ibm.cloud.objectstorage.services.s3.model.transform.HeadBucketResultHandler;
import com.ibm.cloud.objectstorage.services.s3.model.transform.MultiObjectDeleteXmlFactory;
import com.ibm.cloud.objectstorage.services.s3.model.transform.ObjectTaggingXmlFactory;
import com.ibm.cloud.objectstorage.services.s3.model.transform.RequestPaymentConfigurationXmlFactory;
import com.ibm.cloud.objectstorage.services.s3.model.transform.RequestXmlFactory;
import com.ibm.cloud.objectstorage.services.s3.model.transform.Unmarshallers;
import com.ibm.cloud.objectstorage.services.s3.model.transform.XmlResponsesSaxParser;
import com.ibm.cloud.objectstorage.services.s3.request.S3HandlerContextKeys;
import com.ibm.cloud.objectstorage.services.s3.waiters.AmazonS3Waiters;
import com.ibm.cloud.objectstorage.transform.Unmarshaller;
import com.ibm.cloud.objectstorage.util.AWSRequestMetrics;
import com.ibm.cloud.objectstorage.util.AwsHostNameUtils;
import com.ibm.cloud.objectstorage.util.Base16;
import com.ibm.cloud.objectstorage.util.Base64;
import com.ibm.cloud.objectstorage.util.BinaryUtils;
import com.ibm.cloud.objectstorage.util.CredentialUtils;
import com.ibm.cloud.objectstorage.util.DateUtils;
import com.ibm.cloud.objectstorage.util.IOUtils;
import com.ibm.cloud.objectstorage.util.LengthCheckInputStream;
import com.ibm.cloud.objectstorage.util.Md5Utils;
import com.ibm.cloud.objectstorage.util.RuntimeHttpUtils;
import com.ibm.cloud.objectstorage.util.SdkHttpUtils;
import com.ibm.cloud.objectstorage.util.ServiceClientHolderInputStream;
import com.ibm.cloud.objectstorage.util.StringUtils;
import com.ibm.cloud.objectstorage.util.Throwables;
import com.ibm.cloud.objectstorage.util.ValidationUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.HttpRequestBase;

@ThreadSafe
public class AmazonS3Client
extends AmazonWebServiceClient
implements AmazonS3 {
    public static final String S3_SERVICE_NAME = "s3";
    private static final String S3_SIGNER = "S3SignerType";
    private static final String S3_V4_SIGNER = "AWSS3V4SignerType";
    public static final String OAUTH_SIGNER = "OAuthSignerType";
    protected static final AmazonS3ClientConfigurationFactory configFactory = new AmazonS3ClientConfigurationFactory();
    private static Log log = LogFactory.getLog(AmazonS3Client.class);
    private volatile AmazonS3Waiters waiters;
    protected final AWSCredentialsProvider awsCredentialsProvider;
    protected final S3ErrorResponseHandler errorResponseHandler = new S3ErrorResponseHandler();
    private final S3XmlResponseHandler<Void> voidResponseHandler = new S3XmlResponseHandler(null);
    private static final BucketConfigurationXmlFactory bucketConfigurationXmlFactory;
    private static final RequestPaymentConfigurationXmlFactory requestPaymentConfigurationXmlFactory;
    private volatile S3ClientOptions clientOptions = S3ClientOptions.builder().build();
    private volatile String clientRegion;
    private static final int BUCKET_REGION_CACHE_SIZE = 300;
    private static final Map<String, String> bucketRegionCache;
    private final SkipMd5CheckStrategy skipMd5CheckStrategy;
    private final CompleteMultipartUploadRetryCondition completeMultipartUploadRetryCondition = new CompleteMultipartUploadRetryCondition();

    static Map<String, String> getBucketRegionCache() {
        return bucketRegionCache;
    }

    @Deprecated
    public AmazonS3Client() {
        this((AWSCredentialsProvider)new S3CredentialsProviderChain());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new StaticCredentialsProvider(awsCredentials), clientConfiguration);
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider credentialsProvider) {
        this(credentialsProvider, configFactory.getConfig());
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, null);
    }

    @Deprecated
    public AmazonS3Client(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this(credentialsProvider, clientConfiguration, requestMetricCollector, SkipMd5CheckStrategy.INSTANCE);
    }

    @SdkTestInternalApi
    AmazonS3Client(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector, SkipMd5CheckStrategy skipMd5CheckStrategy) {
        super(clientConfiguration, requestMetricCollector, true);
        this.awsCredentialsProvider = credentialsProvider;
        this.skipMd5CheckStrategy = skipMd5CheckStrategy;
        this.init();
    }

    @Deprecated
    public AmazonS3Client(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new S3CredentialsProviderChain(), clientConfiguration);
    }

    @SdkInternalApi
    AmazonS3Client(AmazonS3ClientParams s3ClientParams) {
        super(s3ClientParams.getClientParams());
        this.awsCredentialsProvider = s3ClientParams.getClientParams().getCredentialsProvider();
        this.skipMd5CheckStrategy = SkipMd5CheckStrategy.INSTANCE;
        this.setS3ClientOptions(s3ClientParams.getS3ClientOptions());
        this.init();
    }

    public static AmazonS3ClientBuilder builder() {
        return AmazonS3ClientBuilder.standard();
    }

    private void init() {
        this.setEndpoint("s3.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/s3/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/s3/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    @Deprecated
    public synchronized void setEndpoint(String endpoint) {
        if (ServiceUtils.isS3AccelerateEndpoint(endpoint)) {
            throw new IllegalStateException("To enable accelerate mode, please use AmazonS3ClientBuilder.withAccelerateModeEnabled(true)");
        }
        super.setEndpoint(endpoint);
        if (!ServiceUtils.isS3USStandardEndpoint(endpoint)) {
            this.clientRegion = AwsHostNameUtils.parseRegionName((String)this.endpoint.getHost(), (String)S3_SERVICE_NAME);
        }
    }

    @Override
    @Deprecated
    public synchronized void setRegion(com.ibm.cloud.objectstorage.regions.Region region) {
        super.setRegion(region);
        this.clientRegion = region.getName();
    }

    @Override
    public synchronized void setS3ClientOptions(S3ClientOptions clientOptions) {
        this.checkMutability();
        this.clientOptions = new S3ClientOptions(clientOptions);
    }

    protected boolean useStrictHostNameVerification() {
        return false;
    }

    @Override
    public VersionListing listNextBatchOfVersions(VersionListing previousVersionListing) throws SdkClientException, AmazonServiceException {
        return this.listNextBatchOfVersions(new ListNextBatchOfVersionsRequest(previousVersionListing));
    }

    @Override
    public VersionListing listNextBatchOfVersions(ListNextBatchOfVersionsRequest listNextBatchOfVersionsRequest) {
        listNextBatchOfVersionsRequest = (ListNextBatchOfVersionsRequest)this.beforeClientExecution(listNextBatchOfVersionsRequest);
        this.rejectNull(listNextBatchOfVersionsRequest, "The request object parameter must be specified when listing the next batch of versions in a bucket");
        VersionListing previousVersionListing = listNextBatchOfVersionsRequest.getPreviousVersionListing();
        if (!previousVersionListing.isTruncated()) {
            VersionListing emptyListing = new VersionListing();
            emptyListing.setBucketName(previousVersionListing.getBucketName());
            emptyListing.setDelimiter(previousVersionListing.getDelimiter());
            emptyListing.setKeyMarker(previousVersionListing.getNextKeyMarker());
            emptyListing.setVersionIdMarker(previousVersionListing.getNextVersionIdMarker());
            emptyListing.setMaxKeys(previousVersionListing.getMaxKeys());
            emptyListing.setPrefix(previousVersionListing.getPrefix());
            emptyListing.setEncodingType(previousVersionListing.getEncodingType());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listVersions(listNextBatchOfVersionsRequest.toListVersionsRequest());
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix) throws SdkClientException, AmazonServiceException {
        return this.listVersions(new ListVersionsRequest(bucketName, prefix, null, null, null, null));
    }

    @Override
    public VersionListing listVersions(String bucketName, String prefix, String keyMarker, String versionIdMarker, String delimiter, Integer maxKeys) throws SdkClientException, AmazonServiceException {
        ListVersionsRequest request = new ListVersionsRequest().withBucketName(bucketName).withPrefix(prefix).withDelimiter(delimiter).withKeyMarker(keyMarker).withVersionIdMarker(versionIdMarker).withMaxResults(maxKeys);
        return this.listVersions(request);
    }

    @Override
    public VersionListing listVersions(ListVersionsRequest listVersionsRequest) throws SdkClientException, AmazonServiceException {
        listVersionsRequest = (ListVersionsRequest)this.beforeClientExecution(listVersionsRequest);
        this.rejectNull(listVersionsRequest.getBucketName(), "The bucket name parameter must be specified when listing versions in a bucket");
        boolean shouldSDKDecodeResponse = listVersionsRequest.getEncodingType() == null;
        Request<ListVersionsRequest> request = this.createRequest(listVersionsRequest.getBucketName(), null, listVersionsRequest, HttpMethodName.GET);
        request.addParameter("versions", null);
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listVersionsRequest.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "key-marker", listVersionsRequest.getKeyMarker());
        AmazonS3Client.addParameterIfNotNull(request, "version-id-marker", listVersionsRequest.getVersionIdMarker());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listVersionsRequest.getDelimiter());
        if (listVersionsRequest.getMaxResults() != null && listVersionsRequest.getMaxResults() >= 0) {
            request.addParameter("max-keys", listVersionsRequest.getMaxResults().toString());
        }
        request.addParameter("encoding-type", shouldSDKDecodeResponse ? "url" : listVersionsRequest.getEncodingType());
        return this.invoke(request, new Unmarshallers.VersionListUnmarshaller(shouldSDKDecodeResponse), listVersionsRequest.getBucketName(), null);
    }

    @Override
    public ObjectListing listObjects(String bucketName) throws SdkClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, null, null, null, null));
    }

    @Override
    public ObjectListing listObjects(String bucketName, String prefix) throws SdkClientException, AmazonServiceException {
        return this.listObjects(new ListObjectsRequest(bucketName, prefix, null, null, null));
    }

    @Override
    public ObjectListing listObjects(ListObjectsRequest listObjectsRequest) throws SdkClientException, AmazonServiceException {
        listObjectsRequest = (ListObjectsRequest)this.beforeClientExecution(listObjectsRequest);
        this.rejectNull(listObjectsRequest.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        boolean shouldSDKDecodeResponse = listObjectsRequest.getEncodingType() == null;
        Request<ListObjectsRequest> request = this.createRequest(listObjectsRequest.getBucketName(), null, listObjectsRequest, HttpMethodName.GET);
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listObjectsRequest.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "marker", listObjectsRequest.getMarker());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listObjectsRequest.getDelimiter());
        if (listObjectsRequest.getMaxKeys() != null && listObjectsRequest.getMaxKeys() >= 0) {
            request.addParameter("max-keys", listObjectsRequest.getMaxKeys().toString());
        }
        request.addParameter("encoding-type", shouldSDKDecodeResponse ? "url" : listObjectsRequest.getEncodingType());
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", listObjectsRequest.getWormMirrorDestination());
        return this.invoke(request, new Unmarshallers.ListObjectsUnmarshaller(shouldSDKDecodeResponse), listObjectsRequest.getBucketName(), null);
    }

    @Override
    public ListObjectsV2Result listObjectsV2(String bucketName) throws SdkClientException, AmazonServiceException {
        return this.listObjectsV2(new ListObjectsV2Request().withBucketName(bucketName));
    }

    @Override
    public ListObjectsV2Result listObjectsV2(String bucketName, String prefix) throws SdkClientException, AmazonServiceException {
        return this.listObjectsV2(new ListObjectsV2Request().withBucketName(bucketName).withPrefix(prefix));
    }

    @Override
    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request listObjectsV2Request) throws SdkClientException, AmazonServiceException {
        listObjectsV2Request = (ListObjectsV2Request)this.beforeClientExecution(listObjectsV2Request);
        this.rejectNull(listObjectsV2Request.getBucketName(), "The bucket name parameter must be specified when listing objects in a bucket");
        Request<ListObjectsV2Request> request = this.createRequest(listObjectsV2Request.getBucketName(), null, listObjectsV2Request, HttpMethodName.GET);
        request.addParameter("list-type", "2");
        AmazonS3Client.addParameterIfNotNull(request, "start-after", listObjectsV2Request.getStartAfter());
        AmazonS3Client.addParameterIfNotNull(request, "continuation-token", listObjectsV2Request.getContinuationToken());
        AmazonS3Client.addParameterIfNotNull(request, "delimiter", listObjectsV2Request.getDelimiter());
        AmazonS3Client.addParameterIfNotNull(request, "max-keys", listObjectsV2Request.getMaxKeys());
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listObjectsV2Request.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "encoding-type", listObjectsV2Request.getEncodingType());
        request.addParameter("fetch-owner", Boolean.toString(listObjectsV2Request.isFetchOwner()));
        boolean shouldSDKDecodeResponse = listObjectsV2Request.getEncodingType() == "url";
        return this.invoke(request, new Unmarshallers.ListObjectsV2Unmarshaller(shouldSDKDecodeResponse), listObjectsV2Request.getBucketName(), null);
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ObjectListing previousObjectListing) throws SdkClientException, AmazonServiceException {
        return this.listNextBatchOfObjects(new ListNextBatchOfObjectsRequest(previousObjectListing));
    }

    @Override
    public ObjectListing listNextBatchOfObjects(ListNextBatchOfObjectsRequest listNextBatchOfObjectsRequest) throws SdkClientException, AmazonServiceException {
        listNextBatchOfObjectsRequest = (ListNextBatchOfObjectsRequest)this.beforeClientExecution(listNextBatchOfObjectsRequest);
        this.rejectNull(listNextBatchOfObjectsRequest, "The request object parameter must be specified when listing the next batch of objects in a bucket");
        ObjectListing previousObjectListing = listNextBatchOfObjectsRequest.getPreviousObjectListing();
        if (!previousObjectListing.isTruncated()) {
            ObjectListing emptyListing = new ObjectListing();
            emptyListing.setBucketName(previousObjectListing.getBucketName());
            emptyListing.setDelimiter(previousObjectListing.getDelimiter());
            emptyListing.setMarker(previousObjectListing.getNextMarker());
            emptyListing.setMaxKeys(previousObjectListing.getMaxKeys());
            emptyListing.setPrefix(previousObjectListing.getPrefix());
            emptyListing.setEncodingType(previousObjectListing.getEncodingType());
            emptyListing.setTruncated(false);
            return emptyListing;
        }
        return this.listObjects(listNextBatchOfObjectsRequest.toListObjectsRequest());
    }

    @Override
    public Owner getS3AccountOwner() throws SdkClientException, AmazonServiceException {
        return this.getS3AccountOwner(new GetS3AccountOwnerRequest());
    }

    @Override
    public Owner getS3AccountOwner(GetS3AccountOwnerRequest getS3AccountOwnerRequest) throws SdkClientException, AmazonServiceException {
        getS3AccountOwnerRequest = (GetS3AccountOwnerRequest)this.beforeClientExecution(getS3AccountOwnerRequest);
        this.rejectNull(getS3AccountOwnerRequest, "The request object parameter getS3AccountOwnerRequest must be specified.");
        Request<GetS3AccountOwnerRequest> request = this.createRequest(null, null, getS3AccountOwnerRequest, HttpMethodName.GET);
        return this.invoke(request, new Unmarshallers.ListBucketsOwnerUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets(ListBucketsRequest listBucketsRequest) throws SdkClientException, AmazonServiceException {
        IBMOAuthCredentials oAuthCreds;
        listBucketsRequest = (ListBucketsRequest)this.beforeClientExecution(listBucketsRequest);
        this.rejectNull(listBucketsRequest, "The request object parameter listBucketsRequest must be specified.");
        Request<ListBucketsRequest> request = this.createRequest(null, null, listBucketsRequest, HttpMethodName.GET);
        if (null != this.awsCredentialsProvider && this.awsCredentialsProvider.getCredentials() instanceof IBMOAuthCredentials && (oAuthCreds = (IBMOAuthCredentials)this.awsCredentialsProvider.getCredentials()).getServiceInstanceId() != null) {
            request.addHeader("ibm-service-instance-id", oAuthCreds.getServiceInstanceId());
        }
        return this.invoke(request, new Unmarshallers.ListBucketsUnmarshaller(), null, null);
    }

    @Override
    public List<Bucket> listBuckets() throws SdkClientException, AmazonServiceException {
        return this.listBuckets(new ListBucketsRequest());
    }

    @Override
    public ListBucketsExtendedResponse listBucketsExtended() throws SdkClientException, AmazonServiceException {
        return this.listBucketsExtended(new ListBucketsExtendedRequest());
    }

    @Override
    public ListBucketsExtendedResponse listBucketsExtended(ListBucketsExtendedRequest listBucketsExtendedRequest) throws SdkClientException, AmazonServiceException {
        IBMOAuthCredentials oAuthCreds;
        listBucketsExtendedRequest = (ListBucketsExtendedRequest)this.beforeClientExecution(listBucketsExtendedRequest);
        this.rejectNull(listBucketsExtendedRequest, "The request object parameter listBucketsExtendedRequest must be specified.");
        Request<ListBucketsExtendedRequest> request = this.createRequest(null, null, listBucketsExtendedRequest, HttpMethodName.GET);
        request.addParameter("extended", null);
        AmazonS3Client.addParameterIfNotNull(request, "marker", listBucketsExtendedRequest.getMarker());
        AmazonS3Client.addParameterIfNotNull(request, "prefix", listBucketsExtendedRequest.getPrefix());
        AmazonS3Client.addParameterIfNotNull(request, "max-keys", listBucketsExtendedRequest.getMaxKeys());
        if (null != this.awsCredentialsProvider && this.awsCredentialsProvider.getCredentials() instanceof IBMOAuthCredentials && (oAuthCreds = (IBMOAuthCredentials)this.awsCredentialsProvider.getCredentials()).getServiceInstanceId() != null) {
            request.addHeader("ibm-service-instance-id", oAuthCreds.getServiceInstanceId());
        }
        return this.invoke(request, new Unmarshallers.ListBucketsExtendedUnmarshaller(), null, null);
    }

    @Override
    public Bucket createBucket(String bucketName) throws SdkClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName));
    }

    @Override
    @Deprecated
    public Bucket createBucket(String bucketName, Region region) throws SdkClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName, region));
    }

    @Override
    @Deprecated
    public Bucket createBucket(String bucketName, String region) throws SdkClientException, AmazonServiceException {
        return this.createBucket(new CreateBucketRequest(bucketName, region));
    }

    @Override
    public Bucket createBucket(CreateBucketRequest createBucketRequest) throws SdkClientException, AmazonServiceException {
        createBucketRequest = (CreateBucketRequest)this.beforeClientExecution(createBucketRequest);
        this.rejectNull(createBucketRequest, "The CreateBucketRequest parameter must be specified when creating a bucket");
        String bucketName = createBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when creating a bucket");
        bucketName = bucketName.trim();
        String requestRegion = createBucketRequest.getRegion();
        URI requestEndpoint = this.getCreateBucketEndpoint(requestRegion);
        BucketNameUtils.validateBucketName(bucketName);
        Request<CreateBucketRequest> request = this.createRequest(bucketName, null, createBucketRequest, HttpMethodName.PUT, requestEndpoint);
        request = this.addIAMHeaders(request, createBucketRequest);
        if (createBucketRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, createBucketRequest.getAccessControlList());
        } else if (createBucketRequest.getCannedAcl() != null) {
            request.addHeader("x-amz-acl", createBucketRequest.getCannedAcl().toString());
        }
        if (this.getSignerRegion() != null && !this.getSignerRegion().equals("us-east-1") && StringUtils.isNullOrEmpty((String)requestRegion)) {
            requestRegion = AwsHostNameUtils.parseRegion((String)requestEndpoint.getHost(), (String)S3_SERVICE_NAME);
        }
        if (requestRegion != null && !StringUtils.upperCase((String)requestRegion).equals(Region.US_Standard.toString())) {
            XmlWriter xml = new XmlWriter();
            xml.start("CreateBucketConfiguration", "xmlns", "http://s3.amazonaws.com/doc/2006-03-01/");
            xml.start("LocationConstraint").value(requestRegion).end();
            xml.end();
            request.setContent((InputStream)new ByteArrayInputStream(xml.getBytes()));
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
        return new Bucket(bucketName);
    }

    private URI getCreateBucketEndpoint(String requestRegion) {
        if (requestRegion == null || requestRegion.equals(this.clientRegion) || !this.clientOptions.isForceGlobalBucketAccessEnabled()) {
            return this.endpoint;
        }
        com.ibm.cloud.objectstorage.regions.Region targetRegion = com.ibm.cloud.objectstorage.regions.Region.getRegion((Regions)Regions.fromName((String)requestRegion));
        return new DefaultServiceEndpointBuilder(this.getEndpointPrefix(), this.clientConfiguration.getProtocol().toString()).withRegion(targetRegion).getServiceEndpoint();
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key) throws SdkClientException, AmazonServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, key));
    }

    @Override
    public AccessControlList getObjectAcl(String bucketName, String key, String versionId) throws SdkClientException, AmazonServiceException {
        return this.getObjectAcl(new GetObjectAclRequest(bucketName, key, versionId));
    }

    @Override
    public AccessControlList getObjectAcl(GetObjectAclRequest getObjectAclRequest) {
        getObjectAclRequest = (GetObjectAclRequest)this.beforeClientExecution(getObjectAclRequest);
        this.rejectNull(getObjectAclRequest, "The request parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when requesting an object's ACL");
        this.rejectNull(getObjectAclRequest.getKey(), "The key parameter must be specified when requesting an object's ACL");
        AmazonS3Client.addHeaderIfNotEmptyForAwsRequest(getObjectAclRequest, "mirror-destination", getObjectAclRequest.getWormMirrorDestination());
        return this.getAcl(getObjectAclRequest.getBucketName(), getObjectAclRequest.getKey(), getObjectAclRequest.getVersionId(), getObjectAclRequest.isRequesterPays(), getObjectAclRequest);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, AccessControlList acl) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl(bucketName, key, null, acl);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, CannedAccessControlList acl) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl(bucketName, key, null, acl);
    }

    @Override
    public void setObjectAcl(String bucketName, String key, String versionId, AccessControlList acl) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, versionId, acl));
    }

    public void setObjectAcl(String bucketName, String key, String versionId, AccessControlList acl, RequestMetricCollector requestMetricCollector) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl((SetObjectAclRequest)new SetObjectAclRequest(bucketName, key, versionId, acl).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setObjectAcl(String bucketName, String key, String versionId, CannedAccessControlList acl) throws SdkClientException, AmazonServiceException {
        this.setObjectAcl(new SetObjectAclRequest(bucketName, key, versionId, acl));
    }

    public void setObjectAcl(String bucketName, String key, String versionId, CannedAccessControlList acl, RequestMetricCollector requestMetricCollector) {
        this.setObjectAcl((SetObjectAclRequest)new SetObjectAclRequest(bucketName, key, versionId, acl).withRequestMetricCollector(requestMetricCollector));
    }

    @Override
    public void setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws SdkClientException, AmazonServiceException {
        setObjectAclRequest = (SetObjectAclRequest)this.beforeClientExecution(setObjectAclRequest);
        this.rejectNull(setObjectAclRequest, "The request must not be null.");
        this.rejectNull(setObjectAclRequest.getBucketName(), "The bucket name parameter must be specified when setting an object's ACL");
        this.rejectNull(setObjectAclRequest.getKey(), "The key parameter must be specified when setting an object's ACL");
        if (setObjectAclRequest.getAcl() != null && setObjectAclRequest.getCannedAcl() != null) {
            throw new IllegalArgumentException("Only one of the ACL and CannedACL parameters can be specified, not both.");
        }
        if (setObjectAclRequest.getAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getAcl(), setObjectAclRequest.isRequesterPays(), (AmazonWebServiceRequest)setObjectAclRequest);
        } else if (setObjectAclRequest.getCannedAcl() != null) {
            this.setAcl(setObjectAclRequest.getBucketName(), setObjectAclRequest.getKey(), setObjectAclRequest.getVersionId(), setObjectAclRequest.getCannedAcl(), setObjectAclRequest.isRequesterPays(), (AmazonWebServiceRequest)setObjectAclRequest);
        } else {
            throw new IllegalArgumentException("At least one of the ACL and CannedACL parameters should be specified");
        }
    }

    @Override
    public AccessControlList getBucketAcl(String bucketName) throws SdkClientException, AmazonServiceException {
        return this.getBucketAcl(new GetBucketAclRequest(bucketName));
    }

    @Override
    public AccessControlList getBucketAcl(GetBucketAclRequest getBucketAclRequest) throws SdkClientException, AmazonServiceException {
        getBucketAclRequest = (GetBucketAclRequest)this.beforeClientExecution(getBucketAclRequest);
        String bucketName = getBucketAclRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's ACL");
        return this.getAcl(bucketName, null, null, false, getBucketAclRequest);
    }

    @Override
    public void setBucketAcl(String bucketName, AccessControlList acl) throws SdkClientException, AmazonServiceException {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, acl));
    }

    public void setBucketAcl(String bucketName, AccessControlList acl, RequestMetricCollector requestMetricCollector) {
        SetBucketAclRequest request = (SetBucketAclRequest)new SetBucketAclRequest(bucketName, acl).withRequestMetricCollector(requestMetricCollector);
        this.setBucketAcl(request);
    }

    @Override
    public void setBucketAcl(String bucketName, CannedAccessControlList cannedAcl) throws SdkClientException, AmazonServiceException {
        this.setBucketAcl(new SetBucketAclRequest(bucketName, cannedAcl));
    }

    public void setBucketAcl(String bucketName, CannedAccessControlList cannedAcl, RequestMetricCollector requestMetricCollector) throws SdkClientException, AmazonServiceException {
        SetBucketAclRequest request = (SetBucketAclRequest)new SetBucketAclRequest(bucketName, cannedAcl).withRequestMetricCollector(requestMetricCollector);
        this.setBucketAcl(request);
    }

    @Override
    public void setBucketAcl(SetBucketAclRequest setBucketAclRequest) throws SdkClientException, AmazonServiceException {
        setBucketAclRequest = (SetBucketAclRequest)this.beforeClientExecution(setBucketAclRequest);
        String bucketName = setBucketAclRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting a bucket's ACL");
        AccessControlList acl = setBucketAclRequest.getAcl();
        CannedAccessControlList cannedAcl = setBucketAclRequest.getCannedAcl();
        if (acl == null && cannedAcl == null) {
            throw new IllegalArgumentException("The ACL parameter must be specified when setting a bucket's ACL");
        }
        if (acl != null && cannedAcl != null) {
            throw new IllegalArgumentException("Only one of the acl and cannedAcl parameter can be specified, not both.");
        }
        if (acl != null) {
            this.setAcl(bucketName, null, null, acl, false, (AmazonWebServiceRequest)setBucketAclRequest);
        } else {
            this.setAcl(bucketName, null, null, cannedAcl, false, (AmazonWebServiceRequest)setBucketAclRequest);
        }
    }

    @Override
    public ObjectMetadata getObjectMetadata(String bucketName, String key) throws SdkClientException, AmazonServiceException {
        return this.getObjectMetadata(new GetObjectMetadataRequest(bucketName, key));
    }

    @Override
    public ObjectMetadata getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws SdkClientException, AmazonServiceException {
        getObjectMetadataRequest = (GetObjectMetadataRequest)this.beforeClientExecution(getObjectMetadataRequest);
        this.rejectNull(getObjectMetadataRequest, "The GetObjectMetadataRequest parameter must be specified when requesting an object's metadata");
        String bucketName = getObjectMetadataRequest.getBucketName();
        String key = getObjectMetadataRequest.getKey();
        String versionId = getObjectMetadataRequest.getVersionId();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting an object's metadata");
        this.rejectNull(key, "The key parameter must be specified when requesting an object's metadata");
        Request<GetObjectMetadataRequest> request = this.createRequest(bucketName, key, getObjectMetadataRequest, HttpMethodName.HEAD);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectMetadataRequest.isRequesterPays());
        this.addPartNumberIfNotNull(request, getObjectMetadataRequest.getPartNumber());
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", getObjectMetadataRequest.getWormMirrorDestination());
        AmazonS3Client.populateSSE_C(request, getObjectMetadataRequest.getSSECustomerKey());
        return this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
    }

    @Override
    public S3Object getObject(String bucketName, String key) throws SdkClientException, AmazonServiceException {
        return this.getObject(new GetObjectRequest(bucketName, key));
    }

    @Override
    public boolean doesBucketExist(String bucketName) throws SdkClientException, AmazonServiceException {
        try {
            ValidationUtils.assertStringNotEmpty((String)bucketName, (String)"bucketName");
            this.headBucket(new HeadBucketRequest(bucketName));
            return true;
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() == 301 || ase.getStatusCode() == 403) {
                return true;
            }
            if (ase.getStatusCode() == 404) {
                return false;
            }
            throw ase;
        }
    }

    @Override
    public boolean doesBucketExistV2(String bucketName) throws SdkClientException {
        try {
            ValidationUtils.assertStringNotEmpty((String)bucketName, (String)"bucketName");
            this.getBucketAcl(bucketName);
            return true;
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() == 301 || "AccessDenied".equals(ase.getErrorCode())) {
                return true;
            }
            if (ase.getStatusCode() == 404) {
                return false;
            }
            throw ase;
        }
    }

    @Override
    public boolean doesObjectExist(String bucketName, String objectName) throws AmazonServiceException, SdkClientException {
        try {
            ValidationUtils.assertStringNotEmpty((String)bucketName, (String)"bucketName");
            ValidationUtils.assertStringNotEmpty((String)objectName, (String)"objectName");
            this.getObjectMetadata(bucketName, objectName);
            return true;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public HeadBucketResult headBucket(HeadBucketRequest headBucketRequest) throws SdkClientException, AmazonServiceException {
        headBucketRequest = (HeadBucketRequest)this.beforeClientExecution(headBucketRequest);
        String bucketName = headBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucketName parameter must be specified.");
        Request<HeadBucketRequest> request = this.createRequest(bucketName, null, headBucketRequest, HttpMethodName.HEAD);
        return this.invoke(request, new HeadBucketResultHandler(), bucketName, null);
    }

    @Override
    public void changeObjectStorageClass(String bucketName, String key, StorageClass newStorageClass) throws SdkClientException, AmazonServiceException {
        this.rejectNull(bucketName, "The bucketName parameter must be specified when changing an object's storage class");
        this.rejectNull(key, "The key parameter must be specified when changing an object's storage class");
        this.rejectNull((Object)newStorageClass, "The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(bucketName, key, bucketName, key).withStorageClass(newStorageClass.toString()));
    }

    @Override
    public void setObjectRedirectLocation(String bucketName, String key, String newRedirectLocation) throws SdkClientException, AmazonServiceException {
        this.rejectNull(bucketName, "The bucketName parameter must be specified when changing an object's storage class");
        this.rejectNull(key, "The key parameter must be specified when changing an object's storage class");
        this.rejectNull(newRedirectLocation, "The newStorageClass parameter must be specified when changing an object's storage class");
        this.copyObject(new CopyObjectRequest(bucketName, key, bucketName, key).withRedirectLocation(newRedirectLocation));
    }

    @Override
    public S3Object getObject(GetObjectRequest getObjectRequest) throws SdkClientException, AmazonServiceException {
        getObjectRequest = (GetObjectRequest)this.beforeClientExecution(getObjectRequest);
        ValidationUtils.assertNotNull((Object)getObjectRequest, (String)"GetObjectRequest");
        ValidationUtils.assertStringNotEmpty((String)getObjectRequest.getBucketName(), (String)"BucketName");
        ValidationUtils.assertStringNotEmpty((String)getObjectRequest.getKey(), (String)"Key");
        Request<GetObjectRequest> request = this.createRequest(getObjectRequest.getBucketName(), getObjectRequest.getKey(), getObjectRequest, HttpMethodName.GET);
        if (getObjectRequest.getVersionId() != null) {
            request.addParameter("versionId", getObjectRequest.getVersionId());
        }
        this.addPartNumberIfNotNull(request, getObjectRequest.getPartNumber());
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", getObjectRequest.getWormMirrorDestination());
        long[] range = getObjectRequest.getRange();
        if (range != null) {
            request.addHeader("Range", "bytes=" + Long.toString(range[0]) + "-" + Long.toString(range[1]));
        }
        AmazonS3Client.populateRequesterPaysHeader(request, getObjectRequest.isRequesterPays());
        AmazonS3Client.addResponseHeaderParameters(request, getObjectRequest.getResponseHeaders());
        AmazonS3Client.addDateHeader(request, "If-Modified-Since", getObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "If-Unmodified-Since", getObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "If-Match", getObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "If-None-Match", getObjectRequest.getNonmatchingETagConstraints());
        AmazonS3Client.populateSSE_C(request, getObjectRequest.getSSECustomerKey());
        ProgressListener listener = getObjectRequest.getGeneralProgressListener();
        SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_STARTED_EVENT);
        try {
            S3Object s3Object = this.invoke(request, new S3ObjectResponseHandler(), getObjectRequest.getBucketName(), getObjectRequest.getKey());
            s3Object.setBucketName(getObjectRequest.getBucketName());
            s3Object.setKey(getObjectRequest.getKey());
            Object is = s3Object.getObjectContent();
            HttpRequestBase httpRequest = s3Object.getObjectContent().getHttpRequest();
            is = new ServiceClientHolderInputStream((InputStream)is, (AmazonWebServiceClient)this);
            ProgressInputStream progressInputStream = new ProgressInputStream((InputStream)is, listener){

                protected void onEOF() {
                    SDKProgressPublisher.publishProgress((ProgressListener)this.getListener(), (ProgressEventType)ProgressEventType.TRANSFER_COMPLETED_EVENT);
                }
            };
            is = progressInputStream;
            if (!this.skipMd5CheckStrategy.skipClientSideValidation(getObjectRequest, s3Object.getObjectMetadata())) {
                byte[] serverSideHash = BinaryUtils.fromHex((String)s3Object.getObjectMetadata().getETag());
                try {
                    MessageDigest digest = MessageDigest.getInstance("MD5");
                    is = new DigestValidationInputStream((InputStream)is, digest, serverSideHash);
                }
                catch (NoSuchAlgorithmException e) {
                    log.warn((Object)"No MD5 digest algorithm available.  Unable to calculate checksum and verify data integrity.", (Throwable)e);
                }
            } else {
                is = new LengthCheckInputStream((InputStream)is, s3Object.getObjectMetadata().getContentLength(), true);
            }
            s3Object.setObjectContent(new S3ObjectInputStream((InputStream)is, httpRequest, false));
            return s3Object;
        }
        catch (AmazonS3Exception ase) {
            if (ase.getStatusCode() == 412 || ase.getStatusCode() == 304) {
                SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_CANCELED_EVENT);
                return null;
            }
            SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
            throw ase;
        }
    }

    @Override
    public ObjectMetadata getObject(final GetObjectRequest getObjectRequest, File destinationFile) throws SdkClientException, AmazonServiceException {
        this.rejectNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        S3Object s3Object = ServiceUtils.retryableDownloadS3ObjectToFile(destinationFile, new ServiceUtils.RetryableS3DownloadTask(){

            @Override
            public S3Object getS3ObjectStream() {
                return AmazonS3Client.this.getObject(getObjectRequest);
            }

            @Override
            public boolean needIntegrityCheck() {
                return !AmazonS3Client.this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(getObjectRequest);
            }
        }, false);
        if (s3Object == null) {
            return null;
        }
        return s3Object.getObjectMetadata();
    }

    @Override
    public String getObjectAsString(String bucketName, String key) throws AmazonServiceException, SdkClientException {
        this.rejectNull(bucketName, "Bucket name must be provided");
        this.rejectNull(key, "Object key must be provided");
        S3Object object = this.getObject(bucketName, key);
        try {
            String string = IOUtils.toString((InputStream)((Object)object.getObjectContent()));
            return string;
        }
        catch (IOException e) {
            throw new SdkClientException("Error streaming content from S3 during download");
        }
        finally {
            IOUtils.closeQuietly((Closeable)object, (Log)log);
        }
    }

    @Override
    public GetObjectTaggingResult getObjectTagging(GetObjectTaggingRequest getObjectTaggingRequest) {
        getObjectTaggingRequest = (GetObjectTaggingRequest)this.beforeClientExecution(getObjectTaggingRequest);
        this.rejectNull(getObjectTaggingRequest, "The request parameter must be specified when getting the object tags");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)getObjectTaggingRequest.getBucketName(), (String)"BucketName");
        String key = (String)ValidationUtils.assertNotNull((Object)getObjectTaggingRequest.getKey(), (String)"Key");
        Request<GetObjectTaggingRequest> request = this.createRequest(bucketName, key, getObjectTaggingRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetObjectTagging");
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", getObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<GetObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<GetObjectTaggingResult>(new Unmarshallers.GetObjectTaggingResponseUnmarshaller(), new GetObjectTaggingResponseHeaderHandler());
        return (GetObjectTaggingResult)this.invoke(request, handlerChain, bucketName, key);
    }

    @Override
    public SetObjectTaggingResult setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) {
        setObjectTaggingRequest = (SetObjectTaggingRequest)this.beforeClientExecution(setObjectTaggingRequest);
        this.rejectNull(setObjectTaggingRequest, "The request parameter must be specified setting the object tags");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)setObjectTaggingRequest.getBucketName(), (String)"BucketName");
        String key = (String)ValidationUtils.assertNotNull((Object)setObjectTaggingRequest.getKey(), (String)"Key");
        ObjectTagging tagging = (ObjectTagging)ValidationUtils.assertNotNull((Object)setObjectTaggingRequest.getTagging(), (String)"ObjectTagging");
        Request<SetObjectTaggingRequest> request = this.createRequest(bucketName, key, setObjectTaggingRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutObjectTagging");
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", setObjectTaggingRequest.getVersionId());
        byte[] content = new ObjectTaggingXmlFactory().convertToXmlByteArray(tagging);
        this.setContent(request, content, "application/xml", true);
        ResponseHeaderHandlerChain<SetObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<SetObjectTaggingResult>(new Unmarshallers.SetObjectTaggingResponseUnmarshaller(), new SetObjectTaggingResponseHeaderHandler());
        return (SetObjectTaggingResult)this.invoke(request, handlerChain, bucketName, key);
    }

    @Override
    public DeleteObjectTaggingResult deleteObjectTagging(DeleteObjectTaggingRequest deleteObjectTaggingRequest) {
        deleteObjectTaggingRequest = (DeleteObjectTaggingRequest)this.beforeClientExecution(deleteObjectTaggingRequest);
        this.rejectNull(deleteObjectTaggingRequest, "The request parameter must be specified when delete the object tags");
        String bucketName = ValidationUtils.assertStringNotEmpty((String)deleteObjectTaggingRequest.getBucketName(), (String)"BucketName");
        String key = ValidationUtils.assertStringNotEmpty((String)deleteObjectTaggingRequest.getKey(), (String)"Key");
        Request<DeleteObjectTaggingRequest> request = this.createRequest(bucketName, key, deleteObjectTaggingRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteObjectTagging");
        request.addParameter("tagging", null);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", deleteObjectTaggingRequest.getVersionId());
        ResponseHeaderHandlerChain<DeleteObjectTaggingResult> handlerChain = new ResponseHeaderHandlerChain<DeleteObjectTaggingResult>(new Unmarshallers.DeleteObjectTaggingResponseUnmarshaller(), new DeleteObjectTaggingHeaderHandler());
        return (DeleteObjectTaggingResult)this.invoke(request, handlerChain, bucketName, key);
    }

    @Override
    public void deleteBucket(String bucketName) throws SdkClientException, AmazonServiceException {
        this.deleteBucket(new DeleteBucketRequest(bucketName));
    }

    @Override
    public void deleteBucket(DeleteBucketRequest deleteBucketRequest) throws SdkClientException, AmazonServiceException {
        deleteBucketRequest = (DeleteBucketRequest)this.beforeClientExecution(deleteBucketRequest);
        this.rejectNull(deleteBucketRequest, "The DeleteBucketRequest parameter must be specified when deleting a bucket");
        String bucketName = deleteBucketRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting a bucket");
        Request<DeleteBucketRequest> request = this.createRequest(bucketName, null, deleteBucketRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
        bucketRegionCache.remove(bucketName);
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, File file) throws SdkClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, file).withMetadata(new ObjectMetadata()));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, InputStream input, ObjectMetadata metadata) throws SdkClientException, AmazonServiceException {
        return this.putObject(new PutObjectRequest(bucketName, key, input, metadata));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws SdkClientException, AmazonServiceException {
        byte[] serverSideHash;
        byte[] clientSideHash;
        ObjectMetadata returnedMetadata;
        ProgressListener listener;
        putObjectRequest = (PutObjectRequest)this.beforeClientExecution(putObjectRequest);
        this.rejectNull(putObjectRequest, "The PutObjectRequest parameter must be specified when uploading an object");
        File file = putObjectRequest.getFile();
        InputStream isOrig = putObjectRequest.getInputStream();
        String bucketName = putObjectRequest.getBucketName();
        String key = putObjectRequest.getKey();
        ObjectMetadata metadata = putObjectRequest.getMetadata();
        Object input = isOrig;
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        this.rejectNull(bucketName, "The bucket name parameter must be specified when uploading an object");
        this.rejectNull(key, "The key parameter must be specified when uploading an object");
        if (file == null) {
            if (input != null) {
                input = ReleasableInputStream.wrap((InputStream)input);
            }
        } else {
            boolean calculateMD5;
            metadata.setContentLength(file.length());
            boolean bl = calculateMD5 = metadata.getContentMD5() == null;
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(file));
            }
            if (calculateMD5 && !this.skipMd5CheckStrategy.skipServerSideValidation(putObjectRequest)) {
                try {
                    String contentMd5_b64 = Md5Utils.md5AsBase64((File)file);
                    metadata.setContentMD5(contentMd5_b64);
                }
                catch (Exception e) {
                    throw new SdkClientException("Unable to calculate MD5 hash: " + e.getMessage(), (Throwable)e);
                }
            }
            input = ResettableInputStream.newResettableInputStream((File)file, (String)"Unable to find file to upload");
        }
        MD5DigestCalculatingInputStream md5DigestStream = null;
        try {
            Long contentLength;
            Request<PutObjectRequest> request = this.createRequest(bucketName, key, putObjectRequest, HttpMethodName.PUT);
            Integer bufsize = Constants.getS3StreamBufferSize();
            if (bufsize != null) {
                AmazonWebServiceRequest awsreq = request.getOriginalRequest();
                awsreq.getRequestClientOptions().setReadLimit(bufsize.intValue());
            }
            if (putObjectRequest.getAccessControlList() != null) {
                AmazonS3Client.addAclHeaders(request, putObjectRequest.getAccessControlList());
            } else if (putObjectRequest.getCannedAcl() != null) {
                request.addHeader("x-amz-acl", putObjectRequest.getCannedAcl().toString());
            }
            if (putObjectRequest.getStorageClass() != null) {
                request.addHeader("x-amz-storage-class", putObjectRequest.getStorageClass());
            }
            if (putObjectRequest.getRedirectLocation() != null) {
                request.addHeader("x-amz-website-redirect-location", putObjectRequest.getRedirectLocation());
                if (input == null) {
                    input = new ByteArrayInputStream(new byte[0]);
                }
            }
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-tagging", this.urlEncodeTags(putObjectRequest.getTagging()));
            AmazonS3Client.populateRequesterPaysHeader(request, putObjectRequest.isRequesterPays());
            AmazonS3Client.populateSSE_C(request, putObjectRequest.getSSECustomerKey());
            AmazonS3Client.populateSSE_KMS(request, putObjectRequest.getSSEAwsKeyManagementParams());
            if (putObjectRequest.getRetentionExpirationDate() != null) {
                request.addHeader("retention-expiration-date", DateUtils.formatRFC822Date((Date)putObjectRequest.getRetentionExpirationDate()));
            }
            if (putObjectRequest.getRetentionLegalHoldId() != null) {
                request.addHeader("retention-legal-hold-id", putObjectRequest.getRetentionLegalHoldId());
            }
            if (putObjectRequest.getRetentionPeriod() != null) {
                request.addHeader("retention-period", putObjectRequest.getRetentionPeriod().toString());
            }
            if ((contentLength = (Long)metadata.getRawMetadataValue("Content-Length")) == null) {
                log.warn((Object)"No content length specified for stream data.  Stream contents will be buffered in memory and could result in out of memory errors.");
            } else {
                long expectedLength = contentLength;
                if (expectedLength >= 0L) {
                    LengthCheckInputStream lcis = new LengthCheckInputStream(input, expectedLength, false);
                    input = lcis;
                }
            }
            if (metadata.getContentMD5() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(putObjectRequest)) {
                md5DigestStream = new MD5DigestCalculatingInputStream((InputStream)input);
                input = md5DigestStream;
            }
            if (metadata.getContentType() == null) {
                metadata.setContentType("application/octet-stream");
            }
            AmazonS3Client.populateRequestMetadata(request, metadata);
            request.setContent(input);
            listener = putObjectRequest.getGeneralProgressListener();
            SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_STARTED_EVENT);
            try {
                returnedMetadata = this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
            }
            catch (Throwable t) {
                SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
                throw Throwables.failure((Throwable)t);
            }
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(putObjectRequest, file, isOrig, input, log);
        }
        String contentMd5 = metadata.getContentMD5();
        if (md5DigestStream != null) {
            contentMd5 = Base64.encodeAsString((byte[])md5DigestStream.getMd5Digest());
        }
        String etag = returnedMetadata.getETag();
        if (contentMd5 != null && !this.skipMd5CheckStrategy.skipClientSideValidationPerPutResponse(returnedMetadata) && !Arrays.equals(clientSideHash = BinaryUtils.fromBase64((String)contentMd5), serverSideHash = BinaryUtils.fromHex((String)etag))) {
            SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_FAILED_EVENT);
            throw new SdkClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + contentMd5 + " in base 64) didn't match hash (etag: " + etag + " in hex) calculated by Amazon S3.  You may need to delete the data stored in Amazon S3. (metadata.contentMD5: " + metadata.getContentMD5() + ", md5DigestStream: " + (Object)((Object)md5DigestStream) + ", bucketName: " + bucketName + ", key: " + key + ")");
        }
        SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_COMPLETED_EVENT);
        PutObjectResult result = AmazonS3Client.createPutObjectResult(returnedMetadata);
        result.setContentMd5(contentMd5);
        return result;
    }

    private static PutObjectResult createPutObjectResult(ObjectMetadata metadata) {
        PutObjectResult result = new PutObjectResult();
        result.setVersionId(metadata.getVersionId());
        result.setSSEAlgorithm(metadata.getSSEAlgorithm());
        result.setSSECustomerAlgorithm(metadata.getSSECustomerAlgorithm());
        result.setSSECustomerKeyMd5(metadata.getSSECustomerKeyMd5());
        result.setExpirationTime(metadata.getExpirationTime());
        result.setExpirationTimeRuleId(metadata.getExpirationTimeRuleId());
        result.setETag(metadata.getETag());
        result.setMetadata(metadata);
        result.setRequesterCharged(metadata.isRequesterCharged());
        return result;
    }

    private static void addAclHeaders(Request<? extends AmazonWebServiceRequest> request, AccessControlList acl) {
        List<Grant> grants = acl.getGrantsAsList();
        HashMap grantsByPermission = new HashMap();
        for (Grant grant : grants) {
            if (!grantsByPermission.containsKey((Object)grant.getPermission())) {
                grantsByPermission.put(grant.getPermission(), new LinkedList());
            }
            ((Collection)grantsByPermission.get((Object)grant.getPermission())).add(grant.getGrantee());
        }
        for (Permission permission : Permission.values()) {
            if (!grantsByPermission.containsKey((Object)permission)) continue;
            Collection grantees = (Collection)grantsByPermission.get((Object)permission);
            boolean seenOne = false;
            StringBuilder granteeString = new StringBuilder();
            for (Grantee grantee : grantees) {
                if (!seenOne) {
                    seenOne = true;
                } else {
                    granteeString.append(", ");
                }
                granteeString.append(grantee.getTypeIdentifier()).append("=").append("\"").append(grantee.getIdentifier()).append("\"");
            }
            request.addHeader(permission.getHeaderName(), granteeString.toString());
        }
    }

    @Override
    public CopyObjectResult copyObject(String sourceBucketName, String sourceKey, String destinationBucketName, String destinationKey) throws SdkClientException, AmazonServiceException {
        return this.copyObject(new CopyObjectRequest(sourceBucketName, sourceKey, destinationBucketName, destinationKey));
    }

    @Override
    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws SdkClientException, AmazonServiceException {
        copyObjectRequest = (CopyObjectRequest)this.beforeClientExecution(copyObjectRequest);
        this.rejectNull(copyObjectRequest.getSourceBucketName(), "The source bucket name must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getSourceKey(), "The source object key must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying an object");
        this.rejectNull(copyObjectRequest.getDestinationKey(), "The destination object key must be specified when copying an object");
        String destinationKey = copyObjectRequest.getDestinationKey();
        String destinationBucketName = copyObjectRequest.getDestinationBucketName();
        Request<CopyObjectRequest> request = this.createRequest(destinationBucketName, destinationKey, copyObjectRequest, HttpMethodName.PUT);
        this.populateRequestWithCopyObjectParameters(request, copyObjectRequest);
        AmazonS3Client.populateSSE_KMS(request, copyObjectRequest.getSSEAwsKeyManagementParams());
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler> handler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3VersionHeaderHandler(), new ObjectExpirationHeaderHandler(), new S3RequesterChargedHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke(request, handler, destinationBucketName, destinationKey);
        }
        catch (AmazonS3Exception ase) {
            if (ase.getStatusCode() == 412) {
                return null;
            }
            throw ase;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            String errorCode = copyObjectResultHandler.getErrorCode();
            String errorMessage = copyObjectResultHandler.getErrorMessage();
            String requestId = copyObjectResultHandler.getErrorRequestId();
            String hostId = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception ase = new AmazonS3Exception(errorMessage);
            ase.setErrorCode(errorCode);
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(hostId);
            ase.setServiceName(request.getServiceName());
            ase.setStatusCode(200);
            throw ase;
        }
        CopyObjectResult copyObjectResult = new CopyObjectResult();
        copyObjectResult.setETag(copyObjectResultHandler.getETag());
        copyObjectResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyObjectResult.setVersionId(copyObjectResultHandler.getVersionId());
        copyObjectResult.setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        copyObjectResult.setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        copyObjectResult.setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        copyObjectResult.setExpirationTime(copyObjectResultHandler.getExpirationTime());
        copyObjectResult.setExpirationTimeRuleId(copyObjectResultHandler.getExpirationTimeRuleId());
        copyObjectResult.setRequesterCharged(copyObjectResultHandler.isRequesterCharged());
        return copyObjectResult;
    }

    @Override
    public CopyPartResult copyPart(CopyPartRequest copyPartRequest) {
        copyPartRequest = (CopyPartRequest)this.beforeClientExecution(copyPartRequest);
        this.rejectNull(copyPartRequest.getSourceBucketName(), "The source bucket name must be specified when copying a part");
        this.rejectNull(copyPartRequest.getSourceKey(), "The source object key must be specified when copying a part");
        this.rejectNull(copyPartRequest.getDestinationBucketName(), "The destination bucket name must be specified when copying a part");
        this.rejectNull(copyPartRequest.getUploadId(), "The upload id must be specified when copying a part");
        this.rejectNull(copyPartRequest.getDestinationKey(), "The destination object key must be specified when copying a part");
        this.rejectNull(copyPartRequest.getPartNumber(), "The part number must be specified when copying a part");
        String destinationKey = copyPartRequest.getDestinationKey();
        String destinationBucketName = copyPartRequest.getDestinationBucketName();
        Request<CopyPartRequest> request = this.createRequest(destinationBucketName, destinationKey, copyPartRequest, HttpMethodName.PUT);
        AmazonS3Client.populateRequestWithCopyPartParameters(request, copyPartRequest);
        request.addParameter("uploadId", copyPartRequest.getUploadId());
        request.addParameter("partNumber", Integer.toString(copyPartRequest.getPartNumber()));
        AmazonS3Client.populateRequesterPaysHeader(request, copyPartRequest.isRequesterPays());
        this.setZeroContentLength(request);
        XmlResponsesSaxParser.CopyObjectResultHandler copyObjectResultHandler = null;
        try {
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler> handler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CopyObjectResultHandler>(new Unmarshallers.CopyObjectUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3VersionHeaderHandler());
            copyObjectResultHandler = (XmlResponsesSaxParser.CopyObjectResultHandler)this.invoke(request, handler, destinationBucketName, destinationKey);
        }
        catch (AmazonS3Exception ase) {
            if (ase.getStatusCode() == 412) {
                return null;
            }
            throw ase;
        }
        if (copyObjectResultHandler.getErrorCode() != null) {
            String errorCode = copyObjectResultHandler.getErrorCode();
            String errorMessage = copyObjectResultHandler.getErrorMessage();
            String requestId = copyObjectResultHandler.getErrorRequestId();
            String hostId = copyObjectResultHandler.getErrorHostId();
            AmazonS3Exception ase = new AmazonS3Exception(errorMessage);
            ase.setErrorCode(errorCode);
            ase.setErrorType(AmazonServiceException.ErrorType.Service);
            ase.setRequestId(requestId);
            ase.setExtendedRequestId(hostId);
            ase.setServiceName(request.getServiceName());
            ase.setStatusCode(200);
            throw ase;
        }
        CopyPartResult copyPartResult = new CopyPartResult();
        copyPartResult.setETag(copyObjectResultHandler.getETag());
        copyPartResult.setPartNumber(copyPartRequest.getPartNumber());
        copyPartResult.setLastModifiedDate(copyObjectResultHandler.getLastModified());
        copyPartResult.setVersionId(copyObjectResultHandler.getVersionId());
        copyPartResult.setSSEAlgorithm(copyObjectResultHandler.getSSEAlgorithm());
        copyPartResult.setSSECustomerAlgorithm(copyObjectResultHandler.getSSECustomerAlgorithm());
        copyPartResult.setSSECustomerKeyMd5(copyObjectResultHandler.getSSECustomerKeyMd5());
        return copyPartResult;
    }

    @Override
    public void deleteObject(String bucketName, String key) throws SdkClientException, AmazonServiceException {
        this.deleteObject(new DeleteObjectRequest(bucketName, key));
    }

    @Override
    public void deleteObject(DeleteObjectRequest deleteObjectRequest) throws SdkClientException, AmazonServiceException {
        deleteObjectRequest = (DeleteObjectRequest)this.beforeClientExecution(deleteObjectRequest);
        this.rejectNull(deleteObjectRequest, "The delete object request must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getBucketName(), "The bucket name must be specified when deleting an object");
        this.rejectNull(deleteObjectRequest.getKey(), "The key must be specified when deleting an object");
        Request<DeleteObjectRequest> request = this.createRequest(deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey(), deleteObjectRequest, HttpMethodName.DELETE);
        this.invoke(request, this.voidResponseHandler, deleteObjectRequest.getBucketName(), deleteObjectRequest.getKey());
    }

    @Override
    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        deleteObjectsRequest = (DeleteObjectsRequest)this.beforeClientExecution(deleteObjectsRequest);
        Request<DeleteObjectsRequest> request = this.createRequest(deleteObjectsRequest.getBucketName(), null, deleteObjectsRequest, HttpMethodName.POST);
        request.addParameter("delete", null);
        if (deleteObjectsRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteObjectsRequest.getMfa());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, deleteObjectsRequest.isRequesterPays());
        byte[] content = new MultiObjectDeleteXmlFactory().convertToXmlByteArray(deleteObjectsRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new SdkClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        ResponseHeaderHandlerChain<DeleteObjectsResponse> responseHandler = new ResponseHeaderHandlerChain<DeleteObjectsResponse>(new Unmarshallers.DeleteObjectsResultUnmarshaller(), new S3RequesterChargedHeaderHandler());
        DeleteObjectsResponse response = (DeleteObjectsResponse)this.invoke(request, responseHandler, deleteObjectsRequest.getBucketName(), null);
        if (!response.getErrors().isEmpty()) {
            Map<String, String> headers = responseHandler.getResponseHeaders();
            MultiObjectDeleteException ex = new MultiObjectDeleteException(response.getErrors(), response.getDeletedObjects());
            ex.setStatusCode(200);
            ex.setRequestId(headers.get("x-amz-request-id"));
            ex.setExtendedRequestId(headers.get("x-amz-id-2"));
            ex.setCloudFrontId(headers.get("X-Amz-Cf-Id"));
            throw ex;
        }
        DeleteObjectsResult result = new DeleteObjectsResult(response.getDeletedObjects(), response.isRequesterCharged());
        return result;
    }

    @Override
    public void deleteVersion(String bucketName, String key, String versionId) throws SdkClientException, AmazonServiceException {
        this.deleteVersion(new DeleteVersionRequest(bucketName, key, versionId));
    }

    @Override
    public void deleteVersion(DeleteVersionRequest deleteVersionRequest) throws SdkClientException, AmazonServiceException {
        deleteVersionRequest = (DeleteVersionRequest)this.beforeClientExecution(deleteVersionRequest);
        this.rejectNull(deleteVersionRequest, "The delete version request object must be specified when deleting a version");
        String bucketName = deleteVersionRequest.getBucketName();
        String key = deleteVersionRequest.getKey();
        String versionId = deleteVersionRequest.getVersionId();
        this.rejectNull(bucketName, "The bucket name must be specified when deleting a version");
        this.rejectNull(key, "The key must be specified when deleting a version");
        this.rejectNull(versionId, "The version ID must be specified when deleting a version");
        Request<DeleteVersionRequest> request = this.createRequest(bucketName, key, deleteVersionRequest, HttpMethodName.DELETE);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        if (deleteVersionRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, deleteVersionRequest.getMfa());
        }
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public void setBucketVersioningConfiguration(SetBucketVersioningConfigurationRequest setBucketVersioningConfigurationRequest) throws SdkClientException, AmazonServiceException {
        setBucketVersioningConfigurationRequest = (SetBucketVersioningConfigurationRequest)this.beforeClientExecution(setBucketVersioningConfigurationRequest);
        this.rejectNull(setBucketVersioningConfigurationRequest, "The SetBucketVersioningConfigurationRequest object must be specified when setting versioning configuration");
        String bucketName = setBucketVersioningConfigurationRequest.getBucketName();
        BucketVersioningConfiguration versioningConfiguration = setBucketVersioningConfigurationRequest.getVersioningConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting versioning configuration");
        this.rejectNull(versioningConfiguration, "The bucket versioning parameter must be specified when setting versioning configuration");
        if (versioningConfiguration.isMfaDeleteEnabled() != null) {
            this.rejectNull(setBucketVersioningConfigurationRequest.getMfa(), "The MFA parameter must be specified when changing MFA Delete status in the versioning configuration");
        }
        Request<SetBucketVersioningConfigurationRequest> request = this.createRequest(bucketName, null, setBucketVersioningConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("versioning", null);
        if (versioningConfiguration.isMfaDeleteEnabled() != null && setBucketVersioningConfigurationRequest.getMfa() != null) {
            this.populateRequestWithMfaDetails(request, setBucketVersioningConfigurationRequest.getMfa());
        }
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(versioningConfiguration);
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(String bucketName) throws SdkClientException, AmazonServiceException {
        return this.getBucketVersioningConfiguration(new GetBucketVersioningConfigurationRequest(bucketName));
    }

    @Override
    public BucketVersioningConfiguration getBucketVersioningConfiguration(GetBucketVersioningConfigurationRequest getBucketVersioningConfigurationRequest) throws SdkClientException, AmazonServiceException {
        getBucketVersioningConfigurationRequest = (GetBucketVersioningConfigurationRequest)this.beforeClientExecution(getBucketVersioningConfigurationRequest);
        this.rejectNull(getBucketVersioningConfigurationRequest, "The request object parameter getBucketVersioningConfigurationRequest must be specified.");
        String bucketName = getBucketVersioningConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when querying versioning configuration");
        Request<GetBucketVersioningConfigurationRequest> request = this.createRequest(bucketName, null, getBucketVersioningConfigurationRequest, HttpMethodName.GET);
        request.addParameter("versioning", null);
        return this.invoke(request, new Unmarshallers.BucketVersioningConfigurationUnmarshaller(), bucketName, null);
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(String bucketName) throws SdkClientException, AmazonServiceException {
        return this.getBucketWebsiteConfiguration(new GetBucketWebsiteConfigurationRequest(bucketName));
    }

    @Override
    public BucketWebsiteConfiguration getBucketWebsiteConfiguration(GetBucketWebsiteConfigurationRequest getBucketWebsiteConfigurationRequest) throws SdkClientException, AmazonServiceException {
        getBucketWebsiteConfigurationRequest = (GetBucketWebsiteConfigurationRequest)this.beforeClientExecution(getBucketWebsiteConfigurationRequest);
        this.rejectNull(getBucketWebsiteConfigurationRequest, "The request object parameter getBucketWebsiteConfigurationRequest must be specified.");
        String bucketName = getBucketWebsiteConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's website configuration");
        Request<GetBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, getBucketWebsiteConfigurationRequest, HttpMethodName.GET);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"GetBucketWebsite");
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        try {
            return this.invoke(request, new Unmarshallers.BucketWebsiteConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            if (ase.getStatusCode() == 404) {
                return null;
            }
            throw ase;
        }
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(String bucketName) {
        return this.getBucketLifecycleConfiguration(new GetBucketLifecycleConfigurationRequest(bucketName));
    }

    @Override
    public BucketLifecycleConfiguration getBucketLifecycleConfiguration(GetBucketLifecycleConfigurationRequest getBucketLifecycleConfigurationRequest) {
        getBucketLifecycleConfigurationRequest = (GetBucketLifecycleConfigurationRequest)this.beforeClientExecution(getBucketLifecycleConfigurationRequest);
        this.rejectNull(getBucketLifecycleConfigurationRequest, "The request object pamameter getBucketLifecycleConfigurationRequest must be specified.");
        String bucketName = getBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specifed when retrieving the bucket lifecycle configuration.");
        Request<GetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, getBucketLifecycleConfigurationRequest, HttpMethodName.GET);
        request.addParameter("lifecycle", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketLifecycleConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void setBucketLifecycleConfiguration(String bucketName, BucketLifecycleConfiguration bucketLifecycleConfiguration) {
        this.setBucketLifecycleConfiguration(new SetBucketLifecycleConfigurationRequest(bucketName, bucketLifecycleConfiguration));
    }

    @Override
    public void setBucketLifecycleConfiguration(SetBucketLifecycleConfigurationRequest setBucketLifecycleConfigurationRequest) {
        setBucketLifecycleConfigurationRequest = (SetBucketLifecycleConfigurationRequest)this.beforeClientExecution(setBucketLifecycleConfigurationRequest);
        this.rejectNull(setBucketLifecycleConfigurationRequest, "The set bucket lifecycle configuration request object must be specified.");
        String bucketName = setBucketLifecycleConfigurationRequest.getBucketName();
        BucketLifecycleConfiguration bucketLifecycleConfiguration = setBucketLifecycleConfigurationRequest.getLifecycleConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket lifecycle configuration.");
        this.rejectNull(bucketLifecycleConfiguration, "The lifecycle configuration parameter must be specified when setting bucket lifecycle configuration.");
        Request<SetBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, setBucketLifecycleConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("lifecycle", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketLifecycleConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new SdkClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketLifecycleConfiguration(String bucketName) {
        this.deleteBucketLifecycleConfiguration(new DeleteBucketLifecycleConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketLifecycleConfiguration(DeleteBucketLifecycleConfigurationRequest deleteBucketLifecycleConfigurationRequest) {
        deleteBucketLifecycleConfigurationRequest = (DeleteBucketLifecycleConfigurationRequest)this.beforeClientExecution(deleteBucketLifecycleConfigurationRequest);
        this.rejectNull(deleteBucketLifecycleConfigurationRequest, "The delete bucket lifecycle configuration request object must be specified.");
        String bucketName = deleteBucketLifecycleConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting bucket lifecycle configuration.");
        Request<DeleteBucketLifecycleConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketLifecycleConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("lifecycle", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(String bucketName) {
        return this.getBucketCrossOriginConfiguration(new GetBucketCrossOriginConfigurationRequest(bucketName));
    }

    @Override
    public BucketCrossOriginConfiguration getBucketCrossOriginConfiguration(GetBucketCrossOriginConfigurationRequest getBucketCrossOriginConfigurationRequest) {
        getBucketCrossOriginConfigurationRequest = (GetBucketCrossOriginConfigurationRequest)this.beforeClientExecution(getBucketCrossOriginConfigurationRequest);
        this.rejectNull(getBucketCrossOriginConfigurationRequest, "The request object parameter getBucketCrossOriginConfigurationRequest must be specified.");
        String bucketName = getBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket cross origin configuration.");
        Request<GetBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, getBucketCrossOriginConfigurationRequest, HttpMethodName.GET);
        request.addParameter("cors", null);
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", getBucketCrossOriginConfigurationRequest.getWormMirrorDestination());
        try {
            return this.invoke(request, new Unmarshallers.BucketCrossOriginConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void setBucketCrossOriginConfiguration(String bucketName, BucketCrossOriginConfiguration bucketCrossOriginConfiguration) {
        this.setBucketCrossOriginConfiguration(new SetBucketCrossOriginConfigurationRequest(bucketName, bucketCrossOriginConfiguration));
    }

    @Override
    public void setBucketCrossOriginConfiguration(SetBucketCrossOriginConfigurationRequest setBucketCrossOriginConfigurationRequest) {
        setBucketCrossOriginConfigurationRequest = (SetBucketCrossOriginConfigurationRequest)this.beforeClientExecution(setBucketCrossOriginConfigurationRequest);
        this.rejectNull(setBucketCrossOriginConfigurationRequest, "The set bucket cross origin configuration request object must be specified.");
        String bucketName = setBucketCrossOriginConfigurationRequest.getBucketName();
        BucketCrossOriginConfiguration bucketCrossOriginConfiguration = setBucketCrossOriginConfigurationRequest.getCrossOriginConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket cross origin configuration.");
        this.rejectNull(bucketCrossOriginConfiguration, "The cross origin configuration parameter must be specified when setting bucket cross origin configuration.");
        Request<SetBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, setBucketCrossOriginConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("cors", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketCrossOriginConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new SdkClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(String bucketName) {
        this.deleteBucketCrossOriginConfiguration(new DeleteBucketCrossOriginConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketCrossOriginConfiguration(DeleteBucketCrossOriginConfigurationRequest deleteBucketCrossOriginConfigurationRequest) {
        deleteBucketCrossOriginConfigurationRequest = (DeleteBucketCrossOriginConfigurationRequest)this.beforeClientExecution(deleteBucketCrossOriginConfigurationRequest);
        this.rejectNull(deleteBucketCrossOriginConfigurationRequest, "The delete bucket cross origin configuration request object must be specified.");
        String bucketName = deleteBucketCrossOriginConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting bucket cross origin configuration.");
        Request<DeleteBucketCrossOriginConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketCrossOriginConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("cors", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(String bucketName) {
        return this.getBucketTaggingConfiguration(new GetBucketTaggingConfigurationRequest(bucketName));
    }

    @Override
    public BucketTaggingConfiguration getBucketTaggingConfiguration(GetBucketTaggingConfigurationRequest getBucketTaggingConfigurationRequest) {
        getBucketTaggingConfigurationRequest = (GetBucketTaggingConfigurationRequest)this.beforeClientExecution(getBucketTaggingConfigurationRequest);
        this.rejectNull(getBucketTaggingConfigurationRequest, "The request object parameter getBucketTaggingConfigurationRequest must be specifed.");
        String bucketName = getBucketTaggingConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket tagging configuration.");
        Request<GetBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, getBucketTaggingConfigurationRequest, HttpMethodName.GET);
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", getBucketTaggingConfigurationRequest.getWormMirrorDestination());
        request.addParameter("tagging", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketTaggingConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void setBucketTaggingConfiguration(String bucketName, BucketTaggingConfiguration bucketTaggingConfiguration) {
        this.setBucketTaggingConfiguration(new SetBucketTaggingConfigurationRequest(bucketName, bucketTaggingConfiguration));
    }

    @Override
    public void setBucketTaggingConfiguration(SetBucketTaggingConfigurationRequest setBucketTaggingConfigurationRequest) {
        setBucketTaggingConfigurationRequest = (SetBucketTaggingConfigurationRequest)this.beforeClientExecution(setBucketTaggingConfigurationRequest);
        this.rejectNull(setBucketTaggingConfigurationRequest, "The set bucket tagging configuration request object must be specified.");
        String bucketName = setBucketTaggingConfigurationRequest.getBucketName();
        BucketTaggingConfiguration bucketTaggingConfiguration = setBucketTaggingConfigurationRequest.getTaggingConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket tagging configuration.");
        this.rejectNull(bucketTaggingConfiguration, "The tagging configuration parameter must be specified when setting bucket tagging configuration.");
        Request<SetBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, setBucketTaggingConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("tagging", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketTaggingConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new SdkClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketTaggingConfiguration(String bucketName) {
        this.deleteBucketTaggingConfiguration(new DeleteBucketTaggingConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketTaggingConfiguration(DeleteBucketTaggingConfigurationRequest deleteBucketTaggingConfigurationRequest) {
        deleteBucketTaggingConfigurationRequest = (DeleteBucketTaggingConfigurationRequest)this.beforeClientExecution(deleteBucketTaggingConfigurationRequest);
        this.rejectNull(deleteBucketTaggingConfigurationRequest, "The delete bucket tagging configuration request object must be specified.");
        String bucketName = deleteBucketTaggingConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting bucket tagging configuration.");
        Request<DeleteBucketTaggingConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketTaggingConfigurationRequest, HttpMethodName.DELETE);
        request.addParameter("tagging", null);
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void setBucketWebsiteConfiguration(String bucketName, BucketWebsiteConfiguration configuration) throws SdkClientException, AmazonServiceException {
        this.setBucketWebsiteConfiguration(new SetBucketWebsiteConfigurationRequest(bucketName, configuration));
    }

    @Override
    public void setBucketWebsiteConfiguration(SetBucketWebsiteConfigurationRequest setBucketWebsiteConfigurationRequest) throws SdkClientException, AmazonServiceException {
        setBucketWebsiteConfigurationRequest = (SetBucketWebsiteConfigurationRequest)this.beforeClientExecution(setBucketWebsiteConfigurationRequest);
        String bucketName = setBucketWebsiteConfigurationRequest.getBucketName();
        BucketWebsiteConfiguration configuration = setBucketWebsiteConfigurationRequest.getConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting a bucket's website configuration");
        this.rejectNull(configuration, "The bucket website configuration parameter must be specified when setting a bucket's website configuration");
        if (configuration.getRedirectAllRequestsTo() == null) {
            this.rejectNull(configuration.getIndexDocumentSuffix(), "The bucket website configuration parameter must specify the index document suffix when setting a bucket's website configuration");
        }
        Request<SetBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, setBucketWebsiteConfigurationRequest, HttpMethodName.PUT);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutBucketWebsite");
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] bytes = bucketConfigurationXmlFactory.convertToXmlByteArray(configuration);
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void deleteBucketWebsiteConfiguration(String bucketName) throws SdkClientException, AmazonServiceException {
        this.deleteBucketWebsiteConfiguration(new DeleteBucketWebsiteConfigurationRequest(bucketName));
    }

    @Override
    public void deleteBucketWebsiteConfiguration(DeleteBucketWebsiteConfigurationRequest deleteBucketWebsiteConfigurationRequest) throws SdkClientException, AmazonServiceException {
        deleteBucketWebsiteConfigurationRequest = (DeleteBucketWebsiteConfigurationRequest)this.beforeClientExecution(deleteBucketWebsiteConfigurationRequest);
        String bucketName = deleteBucketWebsiteConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when deleting a bucket's website configuration");
        Request<DeleteBucketWebsiteConfigurationRequest> request = this.createRequest(bucketName, null, deleteBucketWebsiteConfigurationRequest, HttpMethodName.DELETE);
        request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteBucketWebsite");
        request.addParameter("website", null);
        request.addHeader("Content-Type", "application/xml");
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration) throws SdkClientException {
        return this.generatePresignedUrl(bucketName, key, expiration, HttpMethod.GET);
    }

    @Override
    public URL generatePresignedUrl(String bucketName, String key, Date expiration, HttpMethod method) throws SdkClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key, method);
        request.setExpiration(expiration);
        return this.generatePresignedUrl(request);
    }

    @Override
    public URL generatePresignedUrl(GeneratePresignedUrlRequest req) {
        IBMOAuthCredentials creds;
        this.rejectNull(req, "The request parameter must be specified when generating a pre-signed URL");
        req.rejectIllegalArguments();
        if (this.awsCredentialsProvider.getCredentials() instanceof IBMOAuthCredentials && ((creds = (IBMOAuthCredentials)this.awsCredentialsProvider.getCredentials()).getApiKey() != null || creds.getTokenManager() != null)) {
            throw new AmazonS3Exception("generatePresignedUrl() is not supported with IAM credentials");
        }
        String bucketName = req.getBucketName();
        String key = req.getKey();
        if (req.getExpiration() == null) {
            req.setExpiration(new Date(System.currentTimeMillis() + 900000L));
        }
        HttpMethodName httpMethod = HttpMethodName.valueOf((String)req.getMethod().toString());
        Request<GeneratePresignedUrlRequest> request = this.createRequest(bucketName, key, req, httpMethod);
        AmazonS3Client.addParameterIfNotNull(request, "versionId", req.getVersionId());
        if (req.isZeroByteContent()) {
            request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        }
        for (Map.Entry<String, String> entry : req.getRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        AmazonS3Client.addHeaderIfNotNull(request, "Content-Type", req.getContentType());
        AmazonS3Client.addHeaderIfNotNull(request, "Content-MD5", req.getContentMd5());
        AmazonS3Client.populateSSE_C(request, req.getSSECustomerKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption", req.getSSEAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-aws-kms-key-id", req.getKmsCmkId());
        Map customHeaders = req.getCustomRequestHeaders();
        if (customHeaders != null) {
            for (Map.Entry entry : customHeaders.entrySet()) {
                request.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        AmazonS3Client.addResponseHeaderParameters(request, req.getResponseHeaders());
        Signer signer = this.createSigner(request, bucketName, key);
        if (signer instanceof Presigner) {
            ((Presigner)signer).presignRequest(request, CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider).getCredentials(), req.getExpiration());
        } else {
            this.presignRequest(request, req.getMethod(), bucketName, key, req.getExpiration(), null);
        }
        return ServiceUtils.convertRequestToUrl(request, true, false);
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadRequest abortMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        abortMultipartUploadRequest = (AbortMultipartUploadRequest)this.beforeClientExecution(abortMultipartUploadRequest);
        this.rejectNull(abortMultipartUploadRequest, "The request parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getKey(), "The key parameter must be specified when aborting a multipart upload");
        this.rejectNull(abortMultipartUploadRequest.getUploadId(), "The upload ID parameter must be specified when aborting a multipart upload");
        String bucketName = abortMultipartUploadRequest.getBucketName();
        String key = abortMultipartUploadRequest.getKey();
        Request<AbortMultipartUploadRequest> request = this.createRequest(bucketName, key, abortMultipartUploadRequest, HttpMethodName.DELETE);
        request.addParameter("uploadId", abortMultipartUploadRequest.getUploadId());
        AmazonS3Client.populateRequesterPaysHeader(request, abortMultipartUploadRequest.isRequesterPays());
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest completeMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        XmlResponsesSaxParser.CompleteMultipartUploadHandler handler;
        completeMultipartUploadRequest = (CompleteMultipartUploadRequest)this.beforeClientExecution(completeMultipartUploadRequest);
        this.rejectNull(completeMultipartUploadRequest, "The request parameter must be specified when completing a multipart upload");
        String bucketName = completeMultipartUploadRequest.getBucketName();
        String key = completeMultipartUploadRequest.getKey();
        String uploadId = completeMultipartUploadRequest.getUploadId();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when completing a multipart upload");
        this.rejectNull(key, "The key parameter must be specified when completing a multipart upload");
        this.rejectNull(uploadId, "The upload ID parameter must be specified when completing a multipart upload");
        this.rejectNull(completeMultipartUploadRequest.getPartETags(), "The part ETags parameter must be specified when completing a multipart upload");
        int retries = 0;
        do {
            Request<CompleteMultipartUploadRequest> request = this.createRequest(bucketName, key, completeMultipartUploadRequest, HttpMethodName.POST);
            request.addParameter("uploadId", uploadId);
            AmazonS3Client.populateRequesterPaysHeader(request, completeMultipartUploadRequest.isRequesterPays());
            byte[] xml = RequestXmlFactory.convertToXmlByteArray(completeMultipartUploadRequest.getPartETags());
            request.addHeader("Content-Type", "application/xml");
            request.addHeader("Content-Length", String.valueOf(xml.length));
            if (completeMultipartUploadRequest.getRetentionExpirationDate() != null) {
                request.addHeader("retention-expiration-date", DateUtils.formatRFC822Date((Date)completeMultipartUploadRequest.getRetentionExpirationDate()));
            }
            if (completeMultipartUploadRequest.getRetentionPeriod() != null) {
                request.addHeader("retention-period", completeMultipartUploadRequest.getRetentionPeriod().toString());
            }
            AmazonS3Client.addHeaderIfNotNull(request, "retention-legal-hold-id", completeMultipartUploadRequest.getRetentionLegalHoldId());
            request.setContent((InputStream)new ByteArrayInputStream(xml));
            try {
                byte[] md5 = Md5Utils.computeMD5Hash((InputStream)new ByteArrayInputStream(xml));
                String md5Base64 = BinaryUtils.toBase64((byte[])md5);
                request.addHeader("Content-MD5", md5Base64);
            }
            catch (Exception e) {
                throw new SdkClientException("Couldn't compute md5 sum", (Throwable)e);
            }
            ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler> responseHandler = new ResponseHeaderHandlerChain<XmlResponsesSaxParser.CompleteMultipartUploadHandler>(new Unmarshallers.CompleteMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new ObjectExpirationHeaderHandler(), new S3VersionHeaderHandler(), new S3RequesterChargedHeaderHandler());
            handler = (XmlResponsesSaxParser.CompleteMultipartUploadHandler)this.invoke(request, responseHandler, bucketName, key);
            if (handler.getCompleteMultipartUploadResult() == null) continue;
            return handler.getCompleteMultipartUploadResult();
        } while (this.shouldRetryCompleteMultipartUpload(completeMultipartUploadRequest, handler.getAmazonS3Exception(), retries++));
        throw handler.getAmazonS3Exception();
    }

    private boolean shouldRetryCompleteMultipartUpload(AmazonWebServiceRequest originalRequest, AmazonS3Exception exception, int retriesAttempted) {
        RetryPolicy retryPolicy = this.clientConfiguration.getRetryPolicy();
        if (retryPolicy == null || retryPolicy.getRetryCondition() == null) {
            return false;
        }
        if (retryPolicy == PredefinedRetryPolicies.NO_RETRY_POLICY) {
            return false;
        }
        return this.completeMultipartUploadRetryCondition.shouldRetry(originalRequest, (AmazonClientException)((Object)exception), retriesAttempted);
    }

    @Override
    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest initiateMultipartUploadRequest) throws SdkClientException, AmazonServiceException {
        initiateMultipartUploadRequest = (InitiateMultipartUploadRequest)this.beforeClientExecution(initiateMultipartUploadRequest);
        this.rejectNull(initiateMultipartUploadRequest, "The request parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getBucketName(), "The bucket name parameter must be specified when initiating a multipart upload");
        this.rejectNull(initiateMultipartUploadRequest.getKey(), "The key parameter must be specified when initiating a multipart upload");
        Request<InitiateMultipartUploadRequest> request = this.createRequest(initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey(), initiateMultipartUploadRequest, HttpMethodName.POST);
        request.addParameter("uploads", null);
        if (initiateMultipartUploadRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", initiateMultipartUploadRequest.getStorageClass().toString());
        }
        if (initiateMultipartUploadRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", initiateMultipartUploadRequest.getRedirectLocation());
        }
        if (initiateMultipartUploadRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, initiateMultipartUploadRequest.getAccessControlList());
        } else if (initiateMultipartUploadRequest.getCannedACL() != null) {
            request.addHeader("x-amz-acl", initiateMultipartUploadRequest.getCannedACL().toString());
        }
        if (initiateMultipartUploadRequest.objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, initiateMultipartUploadRequest.objectMetadata);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, initiateMultipartUploadRequest.isRequesterPays());
        AmazonS3Client.populateSSE_C(request, initiateMultipartUploadRequest.getSSECustomerKey());
        AmazonS3Client.populateSSE_KMS(request, initiateMultipartUploadRequest.getSSEAwsKeyManagementParams());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-tagging", this.urlEncodeTags(initiateMultipartUploadRequest.getTagging()));
        this.setZeroContentLength(request);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        ResponseHeaderHandlerChain<InitiateMultipartUploadResult> responseHandler = new ResponseHeaderHandlerChain<InitiateMultipartUploadResult>(new Unmarshallers.InitiateMultipartUploadResultUnmarshaller(), new ServerSideEncryptionHeaderHandler(), new S3RequesterChargedHeaderHandler(), new InitiateMultipartUploadHeaderHandler());
        return (InitiateMultipartUploadResult)this.invoke(request, responseHandler, initiateMultipartUploadRequest.getBucketName(), initiateMultipartUploadRequest.getKey());
    }

    @Override
    public MultipartUploadListing listMultipartUploads(ListMultipartUploadsRequest listMultipartUploadsRequest) throws SdkClientException, AmazonServiceException {
        listMultipartUploadsRequest = (ListMultipartUploadsRequest)this.beforeClientExecution(listMultipartUploadsRequest);
        this.rejectNull(listMultipartUploadsRequest, "The request parameter must be specified when listing multipart uploads");
        this.rejectNull(listMultipartUploadsRequest.getBucketName(), "The bucket name parameter must be specified when listing multipart uploads");
        Request<ListMultipartUploadsRequest> request = this.createRequest(listMultipartUploadsRequest.getBucketName(), null, listMultipartUploadsRequest, HttpMethodName.GET);
        request.addParameter("uploads", null);
        if (listMultipartUploadsRequest.getKeyMarker() != null) {
            request.addParameter("key-marker", listMultipartUploadsRequest.getKeyMarker());
        }
        if (listMultipartUploadsRequest.getMaxUploads() != null) {
            request.addParameter("max-uploads", listMultipartUploadsRequest.getMaxUploads().toString());
        }
        if (listMultipartUploadsRequest.getUploadIdMarker() != null) {
            request.addParameter("upload-id-marker", listMultipartUploadsRequest.getUploadIdMarker());
        }
        if (listMultipartUploadsRequest.getDelimiter() != null) {
            request.addParameter("delimiter", listMultipartUploadsRequest.getDelimiter());
        }
        if (listMultipartUploadsRequest.getPrefix() != null) {
            request.addParameter("prefix", listMultipartUploadsRequest.getPrefix());
        }
        if (listMultipartUploadsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listMultipartUploadsRequest.getEncodingType());
        }
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", listMultipartUploadsRequest.getWormMirrorDestination());
        return this.invoke(request, new Unmarshallers.ListMultipartUploadsResultUnmarshaller(), listMultipartUploadsRequest.getBucketName(), null);
    }

    @Override
    public PartListing listParts(ListPartsRequest listPartsRequest) throws SdkClientException, AmazonServiceException {
        listPartsRequest = (ListPartsRequest)this.beforeClientExecution(listPartsRequest);
        this.rejectNull(listPartsRequest, "The request parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getBucketName(), "The bucket name parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getKey(), "The key parameter must be specified when listing parts");
        this.rejectNull(listPartsRequest.getUploadId(), "The upload ID parameter must be specified when listing parts");
        Request<ListPartsRequest> request = this.createRequest(listPartsRequest.getBucketName(), listPartsRequest.getKey(), listPartsRequest, HttpMethodName.GET);
        request.addParameter("uploadId", listPartsRequest.getUploadId());
        if (listPartsRequest.getMaxParts() != null) {
            request.addParameter("max-parts", listPartsRequest.getMaxParts().toString());
        }
        if (listPartsRequest.getPartNumberMarker() != null) {
            request.addParameter("part-number-marker", listPartsRequest.getPartNumberMarker().toString());
        }
        if (listPartsRequest.getEncodingType() != null) {
            request.addParameter("encoding-type", listPartsRequest.getEncodingType());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, listPartsRequest.isRequesterPays());
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", listPartsRequest.getWormMirrorDestination());
        ResponseHeaderHandlerChain<PartListing> responseHandler = new ResponseHeaderHandlerChain<PartListing>(new Unmarshallers.ListPartsResultUnmarshaller(), new S3RequesterChargedHeaderHandler(), new ListPartsHeaderHandler());
        return (PartListing)this.invoke(request, responseHandler, listPartsRequest.getBucketName(), listPartsRequest.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadPartResult uploadPart(UploadPartRequest uploadPartRequest) throws SdkClientException, AmazonServiceException {
        uploadPartRequest = (UploadPartRequest)this.beforeClientExecution(uploadPartRequest);
        this.rejectNull(uploadPartRequest, "The request parameter must be specified when uploading a part");
        File fileOrig = uploadPartRequest.getFile();
        InputStream isOrig = uploadPartRequest.getInputStream();
        String bucketName = uploadPartRequest.getBucketName();
        String key = uploadPartRequest.getKey();
        String uploadId = uploadPartRequest.getUploadId();
        int partNumber = uploadPartRequest.getPartNumber();
        long partSize = uploadPartRequest.getPartSize();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when uploading a part");
        this.rejectNull(key, "The key parameter must be specified when uploading a part");
        this.rejectNull(uploadId, "The upload ID parameter must be specified when uploading a part");
        Request<UploadPartRequest> request = this.createRequest(bucketName, key, uploadPartRequest, HttpMethodName.PUT);
        request.addParameter("uploadId", uploadId);
        request.addParameter("partNumber", Integer.toString(partNumber));
        ObjectMetadata objectMetadata = uploadPartRequest.getObjectMetadata();
        if (objectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, objectMetadata);
        }
        AmazonS3Client.addHeaderIfNotNull(request, "Content-MD5", uploadPartRequest.getMd5Digest());
        request.addHeader("Content-Length", Long.toString(partSize));
        AmazonS3Client.populateRequesterPaysHeader(request, uploadPartRequest.isRequesterPays());
        AmazonS3Client.populateSSE_C(request, uploadPartRequest.getSSECustomerKey());
        Object isCurr = isOrig;
        try {
            if (fileOrig == null) {
                if (isOrig == null) {
                    throw new IllegalArgumentException("A File or InputStream must be specified when uploading part");
                }
                isCurr = ReleasableInputStream.wrap((InputStream)isCurr);
                Integer bufsize = Constants.getS3StreamBufferSize();
                if (bufsize != null) {
                    AmazonWebServiceRequest awsreq = request.getOriginalRequest();
                    awsreq.getRequestClientOptions().setReadLimit(bufsize.intValue());
                }
            } else {
                try {
                    isCurr = new ResettableInputStream(fileOrig);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Failed to open file " + fileOrig, e);
                }
            }
            boolean closeStream = uploadPartRequest.isCalculateMD5() ? false : uploadPartRequest.isLastPart();
            isCurr = new InputSubstream((InputStream)isCurr, uploadPartRequest.getFileOffset(), partSize, closeStream);
            if (uploadPartRequest.getMd5Digest() == null && uploadPartRequest.isCalculateMD5() && isCurr.markSupported()) {
                try {
                    uploadPartRequest.setMd5Digest(Md5Utils.md5AsBase64((InputStream)isCurr));
                    request.addHeader("Content-MD5", uploadPartRequest.getMd5Digest());
                    isCurr.reset();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            MD5DigestCalculatingInputStream md5DigestStream = null;
            if (uploadPartRequest.getMd5Digest() == null && !this.skipMd5CheckStrategy.skipClientSideValidationPerRequest(uploadPartRequest)) {
                md5DigestStream = new MD5DigestCalculatingInputStream((InputStream)isCurr);
                isCurr = md5DigestStream;
            }
            ProgressListener listener = uploadPartRequest.getGeneralProgressListener();
            SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_PART_STARTED_EVENT);
            UploadPartResult uploadPartResult = this.doUploadPart(bucketName, key, uploadId, partNumber, partSize, request, (InputStream)isCurr, md5DigestStream, listener);
            return uploadPartResult;
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(uploadPartRequest, fileOrig, isOrig, isCurr, log);
        }
    }

    private UploadPartResult doUploadPart(String bucketName, String key, String uploadId, int partNumber, long partSize, Request<UploadPartRequest> request, InputStream inputStream, MD5DigestCalculatingInputStream md5DigestStream, ProgressListener listener) {
        try {
            byte[] serverSideHash;
            byte[] clientSideHash;
            request.setContent(inputStream);
            ObjectMetadata metadata = this.invoke(request, new S3MetadataResponseHandler(), bucketName, key);
            String etag = metadata.getETag();
            if (md5DigestStream != null && !this.skipMd5CheckStrategy.skipClientSideValidationPerUploadPartResponse(metadata) && !Arrays.equals(clientSideHash = md5DigestStream.getMd5Digest(), serverSideHash = BinaryUtils.fromHex((String)etag))) {
                String info = "bucketName: " + bucketName + ", key: " + key + ", uploadId: " + uploadId + ", partNumber: " + partNumber + ", partSize: " + partSize;
                throw new SdkClientException("Unable to verify integrity of data upload.  Client calculated content hash (contentMD5: " + Base16.encodeAsString((byte[])clientSideHash) + " in hex) didn't match hash (etag: " + etag + " in hex) calculated by Amazon S3.  You may need to delete the data stored in Amazon S3. (" + info + ")");
            }
            SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_PART_COMPLETED_EVENT);
            UploadPartResult result = new UploadPartResult();
            result.setETag(etag);
            result.setPartNumber(partNumber);
            result.setSSEAlgorithm(metadata.getSSEAlgorithm());
            result.setSSECustomerAlgorithm(metadata.getSSECustomerAlgorithm());
            result.setSSECustomerKeyMd5(metadata.getSSECustomerKeyMd5());
            result.setRequesterCharged(metadata.isRequesterCharged());
            return result;
        }
        catch (Throwable t) {
            SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_PART_FAILED_EVENT);
            SDKProgressPublisher.publishProgress((ProgressListener)listener, (ProgressEventType)ProgressEventType.TRANSFER_PART_COMPLETED_EVENT);
            throw Throwables.failure((Throwable)t);
        }
    }

    @Override
    public S3ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return (S3ResponseMetadata)this.client.getResponseMetadataForRequest(request);
    }

    @Override
    public void restoreObject(RestoreObjectRequest restoreObjectRequest) throws AmazonServiceException {
        restoreObjectRequest = (RestoreObjectRequest)this.beforeClientExecution(restoreObjectRequest);
        String bucketName = restoreObjectRequest.getBucketName();
        String key = restoreObjectRequest.getKey();
        String versionId = restoreObjectRequest.getVersionId();
        int expirationIndays = restoreObjectRequest.getExpirationInDays();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when copying a glacier object");
        this.rejectNull(key, "The key parameter must be specified when copying a glacier object");
        if (expirationIndays == -1) {
            throw new IllegalArgumentException("The expiration in days parameter must be specified when copying a glacier object");
        }
        Request<RestoreObjectRequest> request = this.createRequest(bucketName, key, restoreObjectRequest, HttpMethodName.POST);
        request.addParameter("restore", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, restoreObjectRequest.isRequesterPays());
        byte[] content = RequestXmlFactory.convertToXmlByteArray(restoreObjectRequest);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new SdkClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public void restoreObject(String bucketName, String key, int expirationInDays) throws AmazonServiceException {
        this.restoreObject(new RestoreObjectRequest(bucketName, key, expirationInDays));
    }

    @Override
    public PutObjectResult putObject(String bucketName, String key, String content) throws AmazonServiceException, SdkClientException {
        this.rejectNull(bucketName, "Bucket name must be provided");
        this.rejectNull(key, "Object key must be provided");
        this.rejectNull(content, "String content must be provided");
        byte[] contentBytes = content.getBytes(StringUtils.UTF8);
        ByteArrayInputStream is = new ByteArrayInputStream(contentBytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentType("text/plain");
        metadata.setContentLength(contentBytes.length);
        return this.putObject(new PutObjectRequest(bucketName, key, is, metadata));
    }

    private void rejectNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private AccessControlList getAcl(String bucketName, String key, String versionId, boolean isRequesterPays, AmazonWebServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.GET);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, isRequesterPays);
        ResponseHeaderHandlerChain<AccessControlList> responseHandler = new ResponseHeaderHandlerChain<AccessControlList>(new Unmarshallers.AccessControlListUnmarshaller(), new S3RequesterChargedHeaderHandler());
        return (AccessControlList)this.invoke(request, responseHandler, bucketName, key);
    }

    private void setAcl(String bucketName, String key, String versionId, CannedAccessControlList cannedAcl, boolean isRequesterPays, AmazonWebServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        request.addHeader("x-amz-acl", cannedAcl.toString());
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, isRequesterPays);
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    private void setAcl(String bucketName, String key, String versionId, AccessControlList acl, boolean isRequesterPays, AmazonWebServiceRequest originalRequest) {
        if (originalRequest == null) {
            originalRequest = new GenericBucketRequest(bucketName);
        }
        Request<AmazonWebServiceRequest> request = this.createRequest(bucketName, key, originalRequest, HttpMethodName.PUT);
        request.addParameter("acl", null);
        if (versionId != null) {
            request.addParameter("versionId", versionId);
        }
        AmazonS3Client.populateRequesterPaysHeader(request, isRequesterPays);
        byte[] aclAsXml = new AclXmlFactory().convertToXmlByteArray(acl);
        request.addHeader("Content-Type", "application/xml");
        request.addHeader("Content-Length", String.valueOf(aclAsXml.length));
        request.setContent((InputStream)new ByteArrayInputStream(aclAsXml));
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    protected Signer createSigner(Request<?> request, String bucketName, String key) {
        return this.createSigner(request, bucketName, key, false);
    }

    protected Signer createSigner(Request<?> request, String bucketName, String key, boolean isAdditionalHeadRequestToFindRegion) {
        IBMOAuthCredentials oAuthCreds;
        URI uri = this.clientOptions.isAccelerateModeEnabled() ? this.endpoint : request.getEndpoint();
        Signer signer = this.getSignerByURI(uri);
        if (this.awsCredentialsProvider.getCredentials() instanceof IBMOAuthCredentials && ((oAuthCreds = (IBMOAuthCredentials)this.awsCredentialsProvider.getCredentials()).getApiKey() != null || oAuthCreds.getTokenManager() != null)) {
            return new IBMOAuthSigner(this.clientConfiguration);
        }
        if (!this.isSignerOverridden()) {
            String regionOverride;
            if (signer instanceof AWSS3V4Signer && this.bucketRegionShouldBeCached(request)) {
                String region = bucketRegionCache.get(bucketName);
                if (region != null) {
                    this.resolveRequestEndpoint(request, bucketName, key, RuntimeHttpUtils.toUri((String)RegionUtils.getRegion((String)region).getServiceEndpoint(S3_SERVICE_NAME), (ClientConfiguration)this.clientConfiguration));
                    return this.updateSigV4SignerWithRegion((AWSS3V4Signer)signer, region);
                }
                if (request.getOriginalRequest() instanceof GeneratePresignedUrlRequest) {
                    return this.createSigV2Signer(request, bucketName, key);
                }
                if (isAdditionalHeadRequestToFindRegion) {
                    return this.updateSigV4SignerWithRegion((AWSS3V4Signer)signer, "us-east-1");
                }
            }
            if ((regionOverride = this.getSignerRegionOverride()) != null) {
                return this.updateSigV4SignerWithRegion(new AWSS3V4Signer(), regionOverride);
            }
        }
        if (signer instanceof S3Signer) {
            return this.createSigV2Signer(request, bucketName, key);
        }
        return signer;
    }

    private S3Signer createSigV2Signer(Request<?> request, String bucketName, String key) {
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? key : "");
        return new S3Signer(request.getHttpMethod().toString(), resourcePath);
    }

    private AWSS3V4Signer updateSigV4SignerWithRegion(AWSS3V4Signer v4Signer, String region) {
        v4Signer.setServiceName(this.getServiceNameIntern());
        v4Signer.setRegionName(region);
        return v4Signer;
    }

    private String getSignerRegion() {
        String region = this.getSignerRegionOverride();
        if (region == null) {
            region = this.clientRegion;
        }
        return region;
    }

    private boolean isSignerOverridden() {
        return this.clientConfiguration != null && this.clientConfiguration.getSignerOverride() != null;
    }

    private boolean noExplicitRegionProvided(Request<?> request) {
        return this.isStandardEndpoint(request.getEndpoint()) && this.getSignerRegion() == null;
    }

    private boolean isStandardEndpoint(URI endpoint) {
        return endpoint.getHost().endsWith("s3.amazonaws.com");
    }

    protected <T> void presignRequest(Request<T> request, HttpMethod methodName, String bucketName, String key, Date expiration, String subResource) {
        this.beforeRequest(request);
        String resourcePath = "/" + (bucketName != null ? bucketName + "/" : "") + (key != null ? SdkHttpUtils.urlEncode((String)key, (boolean)true) : "") + (subResource != null ? "?" + subResource : "");
        resourcePath = resourcePath.replaceAll("(?<=/)/", "%2F");
        new S3QueryStringSigner(methodName.toString(), resourcePath, expiration).sign((SignableRequest<?>)request, CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider).getCredentials());
        if (request.getHeaders().containsKey("x-amz-security-token")) {
            String value = (String)request.getHeaders().get("x-amz-security-token");
            request.addParameter("x-amz-security-token", value);
            request.getHeaders().remove("x-amz-security-token");
        }
    }

    private <T> void beforeRequest(Request<T> request) {
        if (this.requestHandler2s != null) {
            for (RequestHandler2 requestHandler2 : this.requestHandler2s) {
                requestHandler2.beforeRequest(request);
            }
        }
    }

    protected static void populateRequestMetadata(Request<?> request, ObjectMetadata metadata) {
        Map<String, String> userMetadata;
        Date httpExpiresDate;
        Map<String, Object> rawMetadata = metadata.getRawMetadata();
        if (rawMetadata != null) {
            for (Map.Entry<String, Object> entry : rawMetadata.entrySet()) {
                request.addHeader(entry.getKey(), entry.getValue().toString());
            }
        }
        if ((httpExpiresDate = metadata.getHttpExpiresDate()) != null) {
            request.addHeader("Expires", DateUtils.formatRFC822Date((Date)httpExpiresDate));
        }
        if ((userMetadata = metadata.getUserMetadata()) != null) {
            for (Map.Entry<String, String> entry : userMetadata.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key != null) {
                    key = key.trim();
                }
                if (value != null) {
                    value = value.trim();
                }
                request.addHeader("x-amz-meta-" + key, value);
            }
        }
    }

    protected static void populateRequesterPaysHeader(Request<?> request, boolean isRequesterPays) {
        if (isRequesterPays) {
            request.addHeader("x-amz-request-payer", "requester");
        }
    }

    private void populateRequestWithMfaDetails(Request<?> request, MultiFactorAuthentication mfa) {
        if (mfa == null) {
            return;
        }
        String endpoint = request.getEndpoint().toString();
        if (endpoint.startsWith("http://")) {
            String httpsEndpoint = endpoint.replace("http://", "https://");
            request.setEndpoint(URI.create(httpsEndpoint));
            log.info((Object)"Overriding current endpoint to use HTTPS as required by S3 for requests containing an MFA header");
        }
        request.addHeader("x-amz-mfa", mfa.getDeviceSerialNumber() + " " + mfa.getToken());
    }

    private void populateRequestWithCopyObjectParameters(Request<? extends AmazonWebServiceRequest> request, CopyObjectRequest copyObjectRequest) {
        ObjectTagging newObjectTagging;
        String copySourceHeader = "/" + SdkHttpUtils.urlEncode((String)copyObjectRequest.getSourceBucketName(), (boolean)true) + "/" + SdkHttpUtils.urlEncode((String)copyObjectRequest.getSourceKey(), (boolean)true);
        if (copyObjectRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        request.addHeader("x-amz-copy-source", copySourceHeader);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyObjectRequest.getNonmatchingETagConstraints());
        if (copyObjectRequest.getAccessControlList() != null) {
            AmazonS3Client.addAclHeaders(request, copyObjectRequest.getAccessControlList());
        } else if (copyObjectRequest.getCannedAccessControlList() != null) {
            request.addHeader("x-amz-acl", copyObjectRequest.getCannedAccessControlList().toString());
        }
        if (copyObjectRequest.getStorageClass() != null) {
            request.addHeader("x-amz-storage-class", copyObjectRequest.getStorageClass());
        }
        if (copyObjectRequest.getRedirectLocation() != null) {
            request.addHeader("x-amz-website-redirect-location", copyObjectRequest.getRedirectLocation());
        }
        if (copyObjectRequest.getRetentionDirective() != null) {
            request.addHeader("retention-directive", copyObjectRequest.getRetentionDirective().toString());
        }
        if (copyObjectRequest.getRetentionExpirationDate() != null) {
            request.addHeader("retention-expiration-date", DateUtils.formatRFC822Date((Date)copyObjectRequest.getRetentionExpirationDate()));
        }
        if (copyObjectRequest.getRetentionLegalHoldId() != null) {
            request.addHeader("retention-legal-hold-id", copyObjectRequest.getRetentionLegalHoldId());
        }
        if (copyObjectRequest.getRetentionPeriod() != null) {
            request.addHeader("retention-period", copyObjectRequest.getRetentionPeriod().toString());
        }
        AmazonS3Client.populateRequesterPaysHeader(request, copyObjectRequest.isRequesterPays());
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (copyObjectRequest.getMetadataDirective() != null) {
            request.addHeader("x-amz-metadata-directive", copyObjectRequest.getMetadataDirective());
        } else if (newObjectMetadata != null) {
            request.addHeader("x-amz-metadata-directive", "REPLACE");
        }
        if (newObjectMetadata != null) {
            AmazonS3Client.populateRequestMetadata(request, newObjectMetadata);
        }
        if ((newObjectTagging = copyObjectRequest.getNewObjectTagging()) != null) {
            request.addHeader("x-amz-tagging-directive", "REPLACE");
            request.addHeader("x-amz-tagging", this.urlEncodeTags(newObjectTagging));
        }
        AmazonS3Client.populateSourceSSE_C(request, copyObjectRequest.getSourceSSECustomerKey());
        AmazonS3Client.populateSSE_C(request, copyObjectRequest.getDestinationSSECustomerKey());
    }

    private static void populateRequestWithCopyPartParameters(Request<?> request, CopyPartRequest copyPartRequest) {
        String copySourceHeader = "/" + SdkHttpUtils.urlEncode((String)copyPartRequest.getSourceBucketName(), (boolean)true) + "/" + SdkHttpUtils.urlEncode((String)copyPartRequest.getSourceKey(), (boolean)true);
        if (copyPartRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyPartRequest.getSourceVersionId();
        }
        request.addHeader("x-amz-copy-source", copySourceHeader);
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-modified-since", copyPartRequest.getModifiedSinceConstraint());
        AmazonS3Client.addDateHeader(request, "x-amz-copy-source-if-unmodified-since", copyPartRequest.getUnmodifiedSinceConstraint());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-match", copyPartRequest.getMatchingETagConstraints());
        AmazonS3Client.addStringListHeader(request, "x-amz-copy-source-if-none-match", copyPartRequest.getNonmatchingETagConstraints());
        if (copyPartRequest.getFirstByte() != null && copyPartRequest.getLastByte() != null) {
            String range = "bytes=" + copyPartRequest.getFirstByte() + "-" + copyPartRequest.getLastByte();
            request.addHeader("x-amz-copy-source-range", range);
        }
        AmazonS3Client.populateSourceSSE_C(request, copyPartRequest.getSourceSSECustomerKey());
        AmazonS3Client.populateSSE_C(request, copyPartRequest.getDestinationSSECustomerKey());
    }

    private static void populateSSE_C(Request<?> request, SSECustomerKey sseKey) {
        if (sseKey == null) {
            return;
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-algorithm", sseKey.getAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-key", sseKey.getKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-customer-key-MD5", sseKey.getMd5());
        if (sseKey.getKey() != null && sseKey.getMd5() == null) {
            String encryptionKey_b64 = sseKey.getKey();
            byte[] encryptionKey = Base64.decode((String)encryptionKey_b64);
            request.addHeader("x-amz-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64((byte[])encryptionKey));
        }
    }

    private static void populateSourceSSE_C(Request<?> request, SSECustomerKey sseKey) {
        if (sseKey == null) {
            return;
        }
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-algorithm", sseKey.getAlgorithm());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-key", sseKey.getKey());
        AmazonS3Client.addHeaderIfNotNull(request, "x-amz-copy-source-server-side-encryption-customer-key-MD5", sseKey.getMd5());
        if (sseKey.getKey() != null && sseKey.getMd5() == null) {
            String encryptionKey_b64 = sseKey.getKey();
            byte[] encryptionKey = Base64.decode((String)encryptionKey_b64);
            request.addHeader("x-amz-copy-source-server-side-encryption-customer-key-MD5", Md5Utils.md5AsBase64((byte[])encryptionKey));
        }
    }

    private static void populateSSE_KMS(Request<?> request, SSEAwsKeyManagementParams sseParams) {
        if (sseParams != null) {
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption", sseParams.getEncryption());
            AmazonS3Client.addHeaderIfNotNull(request, "x-amz-server-side-encryption-aws-kms-key-id", sseParams.getAwsKmsKeyId());
        }
    }

    private void addPartNumberIfNotNull(Request<?> request, Integer partNumber) {
        if (partNumber != null) {
            request.addParameter("partNumber", partNumber.toString());
        }
    }

    private static void addHeaderIfNotNull(Request<?> request, String header, String value) {
        if (value != null) {
            request.addHeader(header, value);
        }
    }

    private static void addHeaderIfNotEmpty(Request<?> request, String header, String value) {
        if (StringUtils.hasValue((String)value)) {
            request.addHeader(header, value);
        }
    }

    private static void addHeaderIfNotEmptyForAwsRequest(AmazonWebServiceRequest request, String header, String value) {
        if (StringUtils.hasValue((String)value)) {
            request.putCustomRequestHeader(header, value);
        }
    }

    private static void addParameterIfNotNull(Request<?> request, String paramName, Integer paramValue) {
        if (paramValue != null) {
            AmazonS3Client.addParameterIfNotNull(request, paramName, paramValue.toString());
        }
    }

    private static void addParameterIfNotNull(Request<?> request, String paramName, String paramValue) {
        if (paramValue != null) {
            request.addParameter(paramName, paramValue);
        }
    }

    private static void addDateHeader(Request<?> request, String header, Date value) {
        if (value != null) {
            request.addHeader(header, ServiceUtils.formatRfc822Date(value));
        }
    }

    private static void addStringListHeader(Request<?> request, String header, List<String> values) {
        if (values != null && !values.isEmpty()) {
            request.addHeader(header, ServiceUtils.join(values));
        }
    }

    private static void addResponseHeaderParameters(Request<?> request, ResponseHeaderOverrides responseHeaders) {
        if (responseHeaders != null) {
            if (responseHeaders.getCacheControl() != null) {
                request.addParameter("response-cache-control", responseHeaders.getCacheControl());
            }
            if (responseHeaders.getContentDisposition() != null) {
                request.addParameter("response-content-disposition", responseHeaders.getContentDisposition());
            }
            if (responseHeaders.getContentEncoding() != null) {
                request.addParameter("response-content-encoding", responseHeaders.getContentEncoding());
            }
            if (responseHeaders.getContentLanguage() != null) {
                request.addParameter("response-content-language", responseHeaders.getContentLanguage());
            }
            if (responseHeaders.getContentType() != null) {
                request.addParameter("response-content-type", responseHeaders.getContentType());
            }
            if (responseHeaders.getExpires() != null) {
                request.addParameter("response-expires", responseHeaders.getExpires());
            }
        }
    }

    public String getResourceUrl(String bucketName, String key) {
        try {
            return this.getUrl(bucketName, key).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public URL getUrl(String bucketName, String key) {
        DefaultRequest request = new DefaultRequest("Amazon S3");
        this.resolveRequestEndpoint((Request<?>)request, bucketName, key, this.endpoint);
        return ServiceUtils.convertRequestToUrl(request, false, false);
    }

    @Override
    public synchronized Region getRegion() {
        String authority = this.endpoint.getAuthority();
        if ("s3.amazonaws.com".equals(authority)) {
            return Region.US_Standard;
        }
        Matcher m = Region.S3_REGIONAL_ENDPOINT_PATTERN.matcher(authority);
        if (m.matches()) {
            return Region.fromValue(m.group(1));
        }
        throw new IllegalStateException("S3 client with invalid S3 endpoint configured: " + authority);
    }

    @Override
    public String getRegionName() {
        String authority = this.endpoint.getAuthority();
        if ("s3.amazonaws.com".equals(authority)) {
            return "us-east-1";
        }
        Matcher m = Region.S3_REGIONAL_ENDPOINT_PATTERN.matcher(authority);
        try {
            m.matches();
            return RegionUtils.getRegion((String)m.group(1)).getName();
        }
        catch (Exception e) {
            throw new IllegalStateException("No valid region has been specified. Unable to return region name", e);
        }
    }

    protected <X extends AmazonWebServiceRequest> Request<X> createRequest(String bucketName, String key, X originalRequest, HttpMethodName httpMethod) {
        return this.createRequest(bucketName, key, originalRequest, httpMethod, this.endpoint);
    }

    protected <X extends AmazonWebServiceRequest> Request<X> createRequest(String bucketName, String key, X originalRequest, HttpMethodName httpMethod, URI endpoint) {
        if (this.clientOptions.isAccelerateModeEnabled() && !(originalRequest instanceof S3AccelerateUnsupported)) {
            endpoint = this.clientOptions.isDualstackEnabled() ? RuntimeHttpUtils.toUri((String)"s3-accelerate.dualstack.amazonaws.com", (ClientConfiguration)this.clientConfiguration) : RuntimeHttpUtils.toUri((String)"s3-accelerate.amazonaws.com", (ClientConfiguration)this.clientConfiguration);
        }
        DefaultRequest request = new DefaultRequest(originalRequest, "Amazon S3");
        request.setHttpMethod(httpMethod);
        request.addHandlerContext(S3HandlerContextKeys.IS_CHUNKED_ENCODING_DISABLED, (Object)this.clientOptions.isChunkedEncodingDisabled());
        request.addHandlerContext(S3HandlerContextKeys.IS_PAYLOAD_SIGNING_ENABLED, (Object)this.clientOptions.isPayloadSigningEnabled());
        this.resolveRequestEndpoint((Request<?>)request, bucketName, key, endpoint);
        return request;
    }

    private void resolveRequestEndpoint(Request<?> request, String bucketName, String key, URI endpoint) {
        ServiceEndpointBuilder builder = this.getBuilder(endpoint, endpoint.getScheme(), false);
        this.buildEndpointResolver(builder, bucketName, key).resolveRequestEndpoint(request);
    }

    private S3RequestEndpointResolver buildDefaultEndpointResolver(String protocol, String bucketName, String key) {
        ServiceEndpointBuilder builder = this.getBuilder(this.endpoint, protocol, true);
        return new S3RequestEndpointResolver(builder, this.clientOptions.isPathStyleAccess(), bucketName, key);
    }

    private ServiceEndpointBuilder getBuilder(URI endpoint, String protocol, boolean useDefaultBuilder) {
        if (this.clientOptions.isDualstackEnabled() && !this.clientOptions.isAccelerateModeEnabled()) {
            return new DualstackEndpointBuilder(this.getServiceNameIntern(), protocol, this.getRegion().toAWSRegion());
        }
        if (useDefaultBuilder) {
            return new DefaultServiceEndpointBuilder(this.getServiceName(), protocol);
        }
        return new IdentityEndpointBuilder(endpoint);
    }

    private S3RequestEndpointResolver buildEndpointResolver(ServiceEndpointBuilder serviceEndpointBuilder, String bucketName, String key) {
        return new S3RequestEndpointResolver(serviceEndpointBuilder, this.clientOptions.isPathStyleAccess(), bucketName, key);
    }

    protected final SignerProvider createSignerProvider(Signer signer) {
        return new S3SignerProvider(this, signer);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, Unmarshaller<X, InputStream> unmarshaller, String bucketName, String key) {
        return this.invoke(request, new S3XmlResponseHandler<X>(unmarshaller), bucketName, key);
    }

    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, String bucket, String key) {
        return this.invoke(request, responseHandler, bucket, key, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <X, Y extends AmazonWebServiceRequest> X invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, String bucket, String key, boolean isAdditionalHeadRequestToFindRegion) {
        Object object;
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        this.checkHttps(originalRequest);
        S3SignerProvider signerProvider = new S3SignerProvider(this, this.getSigner());
        ExecutionContext executionContext = this.createExecutionContext(originalRequest, signerProvider);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        request.setAWSRequestMetrics(awsRequestMetrics);
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Response response = null;
        try {
            request.setTimeOffset(this.timeOffset);
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/octet-stream");
            }
            if (!isAdditionalHeadRequestToFindRegion && this.shouldPerformHeadRequestToFindRegion(request, bucket)) {
                this.fetchRegionFromCache(bucket);
            }
            Signer signer = this.createSigner(request, bucket, key, isAdditionalHeadRequestToFindRegion);
            signerProvider.setSigner(signer);
            if (this.isSignerOverridden() && !(signer instanceof AWSS3V4Signer)) {
                executionContext.setAuthErrorRetryStrategy((AuthErrorRetryStrategy)new S3V4AuthErrorRetryStrategy(this.buildDefaultEndpointResolver(AmazonS3Client.getProtocol(request), bucket, key)));
            }
            executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
            this.validateRequestBeforeTransmit(request);
            response = this.client.execute(request, responseHandler, (HttpResponseHandler)this.errorResponseHandler, executionContext);
            object = response.getAwsResponse();
        }
        catch (ResetException ex) {
            try {
                ex.setExtraInfo("If the request involves an input stream, the maximum stream buffer size can be configured via request.getRequestClientOptions().setReadLimit(int)");
                throw ex;
                catch (AmazonS3Exception ase) {
                    if (ase.getStatusCode() == 301 && ase.getAdditionalDetails() != null) {
                        String region = ase.getAdditionalDetails().get("x-amz-bucket-region");
                        bucketRegionCache.put(bucket, region);
                        ase.setErrorMessage("The bucket is in this region: " + region + ". Please use this region to retry the request");
                    }
                    throw ase;
                }
                catch (OAuthServiceException ose) {
                    AmazonS3Exception ase = new AmazonS3Exception(ose.getErrorMessage());
                    ase.setStatusCode(ose.getStatusCode());
                    ase.setServiceName("IAM");
                    ase.setStackTrace(ose.getStackTrace());
                    throw ase;
                }
            }
            catch (Throwable throwable) {
                this.endClientExecution(awsRequestMetrics, request, response);
                throw throwable;
            }
        }
        this.endClientExecution(awsRequestMetrics, request, response);
        return (X)object;
    }

    private void validateRequestBeforeTransmit(Request<?> request) {
        boolean implicitCrossRegionForbidden = this.areImplicitGlobalClientsDisabled();
        boolean explicitCrossRegionEnabled = this.clientOptions.isForceGlobalBucketAccessEnabled();
        if (this.noExplicitRegionProvided(request) && implicitCrossRegionForbidden && !explicitCrossRegionEnabled) {
            String error = String.format("While the %s system property is enabled, Amazon S3 clients cannot be used without first configuring a region or explicitly enabling global bucket access discovery in the S3 client builder.", "com.amazonaws.services.s3.disableImplicitGlobalClients");
            throw new IllegalStateException(error);
        }
    }

    private boolean areImplicitGlobalClientsDisabled() {
        String setting = System.getProperty("com.amazonaws.services.s3.disableImplicitGlobalClients");
        return setting != null && !setting.equals("false");
    }

    private boolean shouldPerformHeadRequestToFindRegion(Request<?> request, String bucket) {
        return bucket != null && !(request.getOriginalRequest() instanceof CreateBucketRequest) && this.bucketRegionShouldBeCached(request);
    }

    private boolean bucketRegionShouldBeCached(Request<?> request) {
        return this.clientOptions.isForceGlobalBucketAccessEnabled() || this.noExplicitRegionProvided(request);
    }

    private void setBucketRequestPayment(SetRequestPaymentConfigurationRequest setRequestPaymentConfigurationRequest) {
        String bucketName = setRequestPaymentConfigurationRequest.getBucketName();
        RequestPaymentConfiguration configuration = setRequestPaymentConfigurationRequest.getConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified while setting the Requester Pays.");
        this.rejectNull(configuration, "The request payment configuration parameter must be specified when setting the Requester Pays.");
        Request<SetRequestPaymentConfigurationRequest> request = this.createRequest(bucketName, null, setRequestPaymentConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("requestPayment", null);
        request.addHeader("Content-Type", "application/xml");
        byte[] bytes = requestPaymentConfigurationXmlFactory.convertToXmlByteArray(configuration);
        request.setContent((InputStream)new ByteArrayInputStream(bytes));
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    private RequestPaymentConfiguration getBucketRequestPayment(GetRequestPaymentConfigurationRequest getRequestPaymentConfigurationRequest) {
        String bucketName = getRequestPaymentConfigurationRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified while getting the Request Payment Configuration.");
        Request<GetRequestPaymentConfigurationRequest> request = this.createRequest(bucketName, null, getRequestPaymentConfigurationRequest, HttpMethodName.GET);
        request.addParameter("requestPayment", null);
        request.addHeader("Content-Type", "application/xml");
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", getRequestPaymentConfigurationRequest.getWormMirrorDestination());
        return this.invoke(request, new Unmarshallers.RequestPaymentConfigurationUnmarshaller(), bucketName, null);
    }

    private void setZeroContentLength(Request<?> req) {
        req.addHeader("Content-Length", String.valueOf(0));
    }

    private void checkHttps(AmazonWebServiceRequest req) {
        CopyPartRequest cpr;
        Object p;
        if (req instanceof SSECustomerKeyProvider) {
            p = (SSECustomerKeyProvider)req;
            if (p.getSSECustomerKey() != null) {
                this.assertHttps();
            }
        } else if (req instanceof CopyObjectRequest) {
            CopyObjectRequest cor = (CopyObjectRequest)req;
            if (cor.getSourceSSECustomerKey() != null || cor.getDestinationSSECustomerKey() != null) {
                this.assertHttps();
            }
        } else if (req instanceof CopyPartRequest && ((cpr = (CopyPartRequest)req).getSourceSSECustomerKey() != null || cpr.getDestinationSSECustomerKey() != null)) {
            this.assertHttps();
        }
        if (req instanceof SSEAwsKeyManagementParamsProvider && (p = (SSEAwsKeyManagementParamsProvider)req).getSSEAwsKeyManagementParams() != null) {
            this.assertHttps();
        }
    }

    private void assertHttps() {
        String scheme;
        URI endpoint = this.endpoint;
        String string = scheme = endpoint == null ? null : endpoint.getScheme();
        if (!Protocol.HTTPS.toString().equalsIgnoreCase(scheme)) {
            throw new IllegalArgumentException("HTTPS must be used when sending customer encryption keys (SSE-C) to S3, in order to protect your encryption keys.");
        }
    }

    synchronized URI getEndpoint() {
        return this.endpoint;
    }

    private static String getProtocol(Request<?> request) {
        if (request == null || request.getEndpoint() == null) {
            return null;
        }
        return request.getEndpoint().getScheme();
    }

    protected final InitiateMultipartUploadRequest newInitiateMultipartUploadRequest(UploadObjectRequest req) {
        return (InitiateMultipartUploadRequest)new InitiateMultipartUploadRequest(req.getBucketName(), req.getKey(), req.getMetadata()).withRedirectLocation(req.getRedirectLocation()).withSSEAwsKeyManagementParams(req.getSSEAwsKeyManagementParams()).withSSECustomerKey(req.getSSECustomerKey()).withStorageClass(req.getStorageClass()).withAccessControlList(req.getAccessControlList()).withCannedACL(req.getCannedAcl()).withGeneralProgressListener(req.getGeneralProgressListener()).withRequestMetricCollector(req.getRequestMetricCollector());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putLocalObject(UploadObjectRequest reqIn, OutputStream os) throws IOException {
        UploadObjectRequest req = reqIn.clone();
        File fileOrig = req.getFile();
        InputStream isOrig = req.getInputStream();
        if (isOrig == null) {
            if (fileOrig == null) {
                throw new IllegalArgumentException("Either a file lor input stream must be specified");
            }
            req.setInputStream(new FileInputStream(fileOrig));
            req.setFile(null);
        }
        try {
            IOUtils.copy((InputStream)req.getInputStream(), (OutputStream)os);
        }
        finally {
            S3DataSource.Utils.cleanupDataSource(req, fileOrig, isOrig, req.getInputStream(), log);
            IOUtils.closeQuietly((Closeable)os, (Log)log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompleteMultipartUploadResult uploadObject(UploadObjectRequest req) throws IOException, InterruptedException, ExecutionException {
        UploadObjectObserver observer;
        boolean defaultExecutorService;
        ExecutorService es = req.getExecutorService();
        boolean bl = defaultExecutorService = es == null;
        if (es == null) {
            es = Executors.newFixedThreadPool(this.clientConfiguration.getMaxConnections());
        }
        if ((observer = req.getUploadObjectObserver()) == null) {
            observer = new UploadObjectObserver();
        }
        observer.init(req, this, this, es);
        observer.onUploadInitiation(req);
        ArrayList<PartETag> partETags = new ArrayList<PartETag>();
        MultiFileOutputStream mfos = req.getMultiFileOutputStream();
        if (mfos == null) {
            mfos = new MultiFileOutputStream();
        }
        try {
            mfos.init(observer, req.getPartSize(), req.getDiskLimit());
            this.putLocalObject(req, mfos);
            for (Future<UploadPartResult> future : observer.getFutures()) {
                UploadPartResult partResult = future.get();
                partETags.add(new PartETag(partResult.getPartNumber(), partResult.getETag()));
            }
        }
        finally {
            if (defaultExecutorService) {
                es.shutdownNow();
            }
            mfos.cleanup();
        }
        return observer.onCompletion(partETags);
    }

    URI resolveServiceEndpoint(String bucketName) {
        if (this.getSignerRegion() != null || this.isSignerOverridden()) {
            return this.endpoint;
        }
        String regionStr = this.fetchRegionFromCache(bucketName);
        com.ibm.cloud.objectstorage.regions.Region region = RegionUtils.getRegion((String)regionStr);
        if (region == null) {
            log.warn((Object)("Region information for " + regionStr + " is not available. Please upgrade to latest version of AWS Java SDK"));
        }
        return region != null ? RuntimeHttpUtils.toUri((String)region.getServiceEndpoint(S3_SERVICE_NAME), (ClientConfiguration)this.clientConfiguration) : this.endpoint;
    }

    private String fetchRegionFromCache(String bucketName) {
        String bucketRegion = bucketRegionCache.get(bucketName);
        if (bucketRegion == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bucket region cache doesn't have an entry for " + bucketName + ". Trying to get bucket region from Amazon S3."));
            }
            if ((bucketRegion = this.getBucketRegionViaHeadRequest(bucketName)) != null) {
                bucketRegionCache.put(bucketName, bucketRegion);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Region for " + bucketName + " is " + bucketRegion));
        }
        return bucketRegion;
    }

    private String getBucketRegionViaHeadRequest(String bucketName) {
        String bucketRegion;
        block3: {
            bucketRegion = null;
            try {
                Request<HeadBucketRequest> request = this.createRequest(bucketName, null, new HeadBucketRequest(bucketName), HttpMethodName.HEAD);
                HeadBucketResult result = this.invoke(request, new HeadBucketResultHandler(), bucketName, null, true);
                bucketRegion = result.getBucketRegion();
            }
            catch (AmazonS3Exception exception) {
                if (exception.getAdditionalDetails() == null) break block3;
                bucketRegion = exception.getAdditionalDetails().get("x-amz-bucket-region");
            }
        }
        if (bucketRegion == null && log.isDebugEnabled()) {
            log.debug((Object)("Not able to derive region of the " + bucketName + " from the HEAD Bucket requests."));
        }
        return bucketRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AmazonS3Waiters waiters() {
        if (this.waiters == null) {
            AmazonS3Client amazonS3Client = this;
            synchronized (amazonS3Client) {
                if (this.waiters == null) {
                    this.waiters = new AmazonS3Waiters(this);
                }
            }
        }
        return this.waiters;
    }

    private String urlEncodeTags(ObjectTagging tagging) {
        if (tagging == null || tagging.getTagSet() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Iterator<Tag> tagIter = tagging.getTagSet().iterator();
        while (tagIter.hasNext()) {
            Tag tag = tagIter.next();
            sb.append(SdkHttpUtils.urlEncode((String)tag.getKey(), (boolean)false)).append('=').append(SdkHttpUtils.urlEncode((String)tag.getValue(), (boolean)false));
            if (!tagIter.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    private void setContent(Request<?> request, byte[] content, String contentType, boolean setMd5) {
        request.setContent((InputStream)new ByteArrayInputStream(content));
        request.addHeader("Content-Length", Integer.toString(content.length));
        request.addHeader("Content-Type", contentType);
        if (setMd5) {
            try {
                byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
                String md5Base64 = BinaryUtils.toBase64((byte[])md5);
                request.addHeader("Content-MD5", md5Base64);
            }
            catch (Exception e) {
                throw new AmazonClientException("Couldn't compute md5 sum", (Throwable)e);
            }
        }
    }

    protected Request<CreateBucketRequest> addIAMHeaders(Request<CreateBucketRequest> request, CreateBucketRequest createBucketRequest) {
        if (null != this.awsCredentialsProvider && this.awsCredentialsProvider.getCredentials() instanceof IBMOAuthCredentials) {
            if (null != createBucketRequest.getServiceInstanceId()) {
                request.addHeader("ibm-service-instance-id", createBucketRequest.getServiceInstanceId());
                if (null != createBucketRequest.getEncryptionType()) {
                    request.addHeader("ibm-sse-kp-encryption-algorithm", createBucketRequest.getEncryptionType().getKmsEncryptionAlgorithm());
                    request.addHeader("ibm-sse-kp-customer-root-key-crn", createBucketRequest.getEncryptionType().getIBMSSEKMSCustomerRootKeyCrn());
                }
            } else {
                IBMOAuthCredentials oAuthCreds = (IBMOAuthCredentials)this.awsCredentialsProvider.getCredentials();
                if (oAuthCreds.getServiceInstanceId() != null) {
                    request.addHeader("ibm-service-instance-id", oAuthCreds.getServiceInstanceId());
                    if (null != createBucketRequest.getEncryptionType()) {
                        request.addHeader("ibm-sse-kp-encryption-algorithm", createBucketRequest.getEncryptionType().getKmsEncryptionAlgorithm());
                        request.addHeader("ibm-sse-kp-customer-root-key-crn", createBucketRequest.getEncryptionType().getIBMSSEKMSCustomerRootKeyCrn());
                    }
                }
            }
        }
        return request;
    }

    @Override
    public void setBucketProtectionConfiguration(SetBucketProtectionConfigurationRequest setBucketProtectionConfigurationRequest) throws SdkClientException, AmazonServiceException {
        setBucketProtectionConfigurationRequest = (SetBucketProtectionConfigurationRequest)this.beforeClientExecution(setBucketProtectionConfigurationRequest);
        this.rejectNull(setBucketProtectionConfigurationRequest, "The set bucket protection configuration request object must be specified.");
        String bucketName = setBucketProtectionConfigurationRequest.getBucketName();
        BucketProtectionConfiguration bucketProtectionConfiguration = setBucketProtectionConfigurationRequest.getProtectionConfiguration();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when setting bucket protection configuration.");
        this.rejectNull(bucketProtectionConfiguration, "The protection configuration parameter must be specified when setting bucket protection configuration.");
        Request<SetBucketProtectionConfigurationRequest> request = this.createRequest(bucketName, null, setBucketProtectionConfigurationRequest, HttpMethodName.PUT);
        request.addParameter("protection", null);
        byte[] content = new BucketConfigurationXmlFactory().convertToXmlByteArray(bucketProtectionConfiguration);
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new SdkClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, null);
    }

    @Override
    public void setBucketProtection(String bucketName, BucketProtectionConfiguration protectionConfiguration) throws SdkClientException, AmazonServiceException {
        this.setBucketProtectionConfiguration(new SetBucketProtectionConfigurationRequest().withBucketName(bucketName).withProtectionConfiguration(protectionConfiguration));
    }

    @Override
    public BucketProtectionConfiguration getBucketProtection(String bucketName) throws SdkClientException, AmazonServiceException {
        return this.getBucketProtectionConfiguration(new GetBucketProtectionConfigurationRequest(bucketName));
    }

    @Override
    public BucketProtectionConfiguration getBucketProtectionConfiguration(GetBucketProtectionConfigurationRequest getBucketProtectionRequest) throws SdkClientException, AmazonServiceException {
        getBucketProtectionRequest = (GetBucketProtectionConfigurationRequest)this.beforeClientExecution(getBucketProtectionRequest);
        this.rejectNull(getBucketProtectionRequest, "The request object parameter GetBucketProtectionConfigurationRequest must be specified.");
        String bucketName = getBucketProtectionRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the bucket protection configuration.");
        Request<GetBucketProtectionConfigurationRequest> request = this.createRequest(bucketName, null, getBucketProtectionRequest, HttpMethodName.GET);
        request.addParameter("protection", null);
        try {
            return this.invoke(request, new Unmarshallers.BucketProtectionConfigurationUnmarshaller(), bucketName, null);
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void addLegalHold(String bucketName, String key, String legalHoldId) throws SdkClientException, AmazonServiceException {
        this.addLegalHold(new AddLegalHoldRequest(bucketName, key, legalHoldId));
    }

    @Override
    public void addLegalHold(AddLegalHoldRequest addLegalHoldRequest) throws SdkClientException, AmazonServiceException {
        addLegalHoldRequest = (AddLegalHoldRequest)this.beforeClientExecution(addLegalHoldRequest);
        this.rejectNull(addLegalHoldRequest, "The add legal hold configuration request object must be specified.");
        String bucketName = addLegalHoldRequest.getBucketName();
        String key = addLegalHoldRequest.getKey();
        String legalHoldId = addLegalHoldRequest.getLegalHoldId();
        this.rejectNull(bucketName, "The bucket name must be specified when adding a legal hold id.");
        this.rejectNull(key, "The bucket name must be specified when adding a legal hold id.");
        this.rejectNull(legalHoldId, "The legal hold id must be specified when adding a legal hold id.");
        Request<AddLegalHoldRequest> request = this.createRequest(bucketName, key, addLegalHoldRequest, HttpMethodName.POST);
        request.addParameter("legalHold", null);
        request.addParameter("add", legalHoldId);
        byte[] content = addLegalHoldRequest.getLegalHoldId().getBytes();
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "application/xml");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        try {
            byte[] md5 = Md5Utils.computeMD5Hash((byte[])content);
            String md5Base64 = BinaryUtils.toBase64((byte[])md5);
            request.addHeader("Content-MD5", md5Base64);
        }
        catch (Exception e) {
            throw new SdkClientException("Couldn't compute md5 sum", (Throwable)e);
        }
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public ListLegalHoldsResult listLegalHolds(String bucketName, String key) throws SdkClientException, AmazonServiceException {
        return this.listLegalHolds(new ListLegalHoldsRequest(bucketName, key));
    }

    @Override
    public ListLegalHoldsResult listLegalHolds(ListLegalHoldsRequest listLegalHoldsRequest) throws SdkClientException, AmazonServiceException {
        listLegalHoldsRequest = (ListLegalHoldsRequest)this.beforeClientExecution(listLegalHoldsRequest);
        this.rejectNull(listLegalHoldsRequest, "The request object parameter ListLegalHoldsRequest must be specified.");
        String bucketName = listLegalHoldsRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name must be specified when retrieving the list of legal holds.");
        String key = listLegalHoldsRequest.getKey();
        this.rejectNull(key, "The object key must be specified when retrieving the list of legal holds.");
        Request<ListLegalHoldsRequest> request = this.createRequest(bucketName, key, listLegalHoldsRequest, HttpMethodName.GET);
        request.addParameter("legalHold", null);
        AmazonS3Client.addHeaderIfNotEmpty(request, "mirror-destination", listLegalHoldsRequest.getWormMirrorDestination());
        try {
            return this.invoke(request, new Unmarshallers.ListLegalHoldsRequestUnmarshaller(), bucketName, key);
        }
        catch (AmazonServiceException ase) {
            switch (ase.getStatusCode()) {
                case 404: {
                    return null;
                }
            }
            throw ase;
        }
    }

    @Override
    public void deleteLegalHold(String bucketName, String key, String legalHoldId) throws SdkClientException, AmazonServiceException {
        this.deleteLegalHold(new DeleteLegalHoldRequest(bucketName, key, legalHoldId));
    }

    @Override
    public void deleteLegalHold(DeleteLegalHoldRequest deleteLegalHoldRequest) throws SdkClientException, AmazonServiceException {
        deleteLegalHoldRequest = (DeleteLegalHoldRequest)this.beforeClientExecution(deleteLegalHoldRequest);
        this.rejectNull(deleteLegalHoldRequest, "The delete legal hold configuration request object must be specified.");
        String bucketName = deleteLegalHoldRequest.getBucketName();
        String key = deleteLegalHoldRequest.getKey();
        String legalHoldId = deleteLegalHoldRequest.getLegalHoldId();
        this.rejectNull(bucketName, "The bucket name must be specified when deleting a legal hold id.");
        this.rejectNull(key, "The bucket name must be specified when deleting a legal hold id.");
        this.rejectNull(legalHoldId, "The legal hold id must be specified when deleting a legal hold id.");
        Request<DeleteLegalHoldRequest> request = this.createRequest(bucketName, key, deleteLegalHoldRequest, HttpMethodName.POST);
        request.addParameter("legalHold", null);
        request.addParameter("remove", legalHoldId);
        byte[] content = "".getBytes();
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "text/plain");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public void extendObjectRetention(String bucketName, String key, Long additionalRetentionPeriod, Long extendRetentionFromCurrentTime, Date newRetentionExpirationDate, Long newRetentionPeriod) throws SdkClientException, AmazonServiceException {
        this.extendObjectRetention(new ExtendObjectRetentionRequest().withBucketName(bucketName).withKey(key).withAdditionalRetentionPeriod(additionalRetentionPeriod).withExtendRetentionFromCurrentTime(extendRetentionFromCurrentTime).withNewRetentionExpirationDate(newRetentionExpirationDate).withNewRetentionPeriod(newRetentionPeriod));
    }

    @Override
    public void extendObjectRetention(ExtendObjectRetentionRequest extendObjectRetentionRequest) throws SdkClientException, AmazonServiceException {
        extendObjectRetentionRequest = (ExtendObjectRetentionRequest)this.beforeClientExecution(extendObjectRetentionRequest);
        this.rejectNull(extendObjectRetentionRequest, "The extend object retention request object must be specified.");
        String bucketName = extendObjectRetentionRequest.getBucketName();
        String key = extendObjectRetentionRequest.getKey();
        Long additionalRetentionPeriod = extendObjectRetentionRequest.getAdditionalRetentionPeriod();
        Long extendRetentionFromCurrentTime = extendObjectRetentionRequest.getExtendRetentionFromCurrentTime();
        Date newRetentionExpirationDate = extendObjectRetentionRequest.getNewRetentionExpirationDate();
        Long newRetentionPeriod = extendObjectRetentionRequest.getNewRetentionPeriod();
        this.rejectNull(bucketName, "The bucket name must be specified when adding a legal hold id.");
        this.rejectNull(key, "The bucket name must be specified when adding a legal hold id.");
        String argumentExceptionMessage = "Only one of additionalRetentionPeriod, extendRetentionFromCurrentTime, newRetentionExpirationDate or newRetentionPeriod can be specified.";
        if (additionalRetentionPeriod != null && (extendRetentionFromCurrentTime != null || newRetentionExpirationDate != null || newRetentionPeriod != null)) {
            throw new IllegalArgumentException(argumentExceptionMessage);
        }
        if (extendRetentionFromCurrentTime != null && (newRetentionExpirationDate != null || newRetentionPeriod != null)) {
            throw new IllegalArgumentException(argumentExceptionMessage);
        }
        if (newRetentionExpirationDate != null && newRetentionPeriod != null) {
            throw new IllegalArgumentException(argumentExceptionMessage);
        }
        Request<ExtendObjectRetentionRequest> request = this.createRequest(bucketName, key, extendObjectRetentionRequest, HttpMethodName.POST);
        request.addParameter("extendRetention", null);
        if (additionalRetentionPeriod != null) {
            request.addHeader("additional-retention-period", extendObjectRetentionRequest.getAdditionalRetentionPeriod().toString());
        }
        if (extendRetentionFromCurrentTime != null) {
            request.addHeader("extend-retention-from-current-time", extendRetentionFromCurrentTime.toString());
        }
        if (newRetentionExpirationDate != null) {
            request.addHeader("new-retention-expiration-date", DateUtils.formatRFC822Date((Date)newRetentionExpirationDate));
        }
        if (newRetentionPeriod != null) {
            request.addHeader("new-retention-period", newRetentionPeriod.toString());
        }
        byte[] content = new byte[]{};
        request.addHeader("Content-Length", String.valueOf(content.length));
        request.addHeader("Content-Type", "text/plain");
        request.setContent((InputStream)new ByteArrayInputStream(content));
        this.invoke(request, this.voidResponseHandler, bucketName, key);
    }

    @Override
    public FASPConnectionInfo getBucketFaspConnectionInfo(String bucketName) throws SdkClientException, AmazonServiceException {
        return this.getBucketFaspConnectionInfo(new GetBucketFaspConnectionInfoRequest(bucketName));
    }

    @Override
    public FASPConnectionInfo getBucketFaspConnectionInfo(GetBucketFaspConnectionInfoRequest getBucketFaspConnectionInfoRequest) throws SdkClientException, AmazonServiceException {
        getBucketFaspConnectionInfoRequest = (GetBucketFaspConnectionInfoRequest)this.beforeClientExecution(getBucketFaspConnectionInfoRequest);
        String bucketName = getBucketFaspConnectionInfoRequest.getBucketName();
        this.rejectNull(bucketName, "The bucket name parameter must be specified when requesting a bucket's FASP Connection Info");
        Request<GetBucketFaspConnectionInfoRequest> request = this.createRequest(bucketName, null, getBucketFaspConnectionInfoRequest, HttpMethodName.GET);
        request.addParameter("faspConnectionInfo", null);
        AmazonS3Client.populateRequesterPaysHeader(request, false);
        ResponseHeaderHandlerChain<FASPConnectionInfo> responseHandler = new ResponseHeaderHandlerChain<FASPConnectionInfo>(new Unmarshallers.FASPConnectionInfoUnmarshaller(), new S3RequesterChargedHeaderHandler());
        return (FASPConnectionInfo)this.invoke(request, responseHandler, bucketName, null);
    }

    static {
        AwsSdkMetrics.addAll(Arrays.asList(S3ServiceMetric.values()));
        SignerFactory.registerSigner((String)S3_SIGNER, S3Signer.class);
        SignerFactory.registerSigner((String)S3_V4_SIGNER, AWSS3V4Signer.class);
        SignerFactory.registerSigner((String)OAUTH_SIGNER, IBMOAuthSigner.class);
        bucketConfigurationXmlFactory = new BucketConfigurationXmlFactory();
        requestPaymentConfigurationXmlFactory = new RequestPaymentConfigurationXmlFactory();
        bucketRegionCache = Collections.synchronizedMap(new LinkedHashMap<String, String>(300, 1.1f, true){
            private static final long serialVersionUID = 23453L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, String> eldest) {
                return this.size() > 300;
            }
        });
    }
}

