/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.transfer.internal;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.services.s3.AmazonS3;
import com.ibm.cloud.objectstorage.services.s3.model.GetObjectRequest;
import com.ibm.cloud.objectstorage.util.StringUtils;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadPartCallable
implements Callable<File> {
    private static final Log LOG = LogFactory.getLog(DownloadPartCallable.class);
    private static final String TEMP_FILE_MIDDLE_NAME = ".part.";
    private final AmazonS3 s3;
    private final GetObjectRequest getPartRequest;
    private final File destinationFile;
    private final String destinationFilePath;

    public DownloadPartCallable(AmazonS3 s3, GetObjectRequest getPartRequest, File destinationFile) {
        this.s3 = s3;
        this.getPartRequest = getPartRequest;
        this.destinationFile = destinationFile;
        this.destinationFilePath = destinationFile.getAbsolutePath();
    }

    @Override
    public File call() throws Exception {
        File partFile = File.createTempFile(UUID.nameUUIDFromBytes(this.destinationFile.getName().getBytes(StringUtils.UTF8)).toString(), TEMP_FILE_MIDDLE_NAME + this.getPartRequest.getPartNumber().toString(), new File(this.destinationFilePath.substring(0, this.destinationFilePath.lastIndexOf(File.separator))));
        try {
            partFile.deleteOnExit();
        }
        catch (SecurityException exception) {
            LOG.warn((Object)("SecurityException denied delete access to file " + partFile.getAbsolutePath()));
        }
        if (this.s3.getObject(this.getPartRequest, partFile) == null) {
            throw new SdkClientException("There is no object in S3 satisfying this request. The getObject method returned null");
        }
        return partFile;
    }
}

