/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.http.HttpResponse;
import com.amazonaws.services.s3.internal.AbstractS3ResponseHandler;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.StringUtils;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class S3XmlResponseHandler<T>
extends AbstractS3ResponseHandler<T> {
    private Unmarshaller<T, InputStream> responseUnmarshaller;
    private static final Log log = LogFactory.getLog((String)"com.amazonaws.request");
    private Map<String, String> responseHeaders;

    public S3XmlResponseHandler(Unmarshaller<T, InputStream> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
    }

    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        AmazonWebServiceResponse awsResponse = this.parseResponseMetadata(response);
        this.responseHeaders = response.getHeaders();
        if (this.responseUnmarshaller != null) {
            log.trace((Object)"Beginning to parse service response XML");
            Object result = this.responseUnmarshaller.unmarshall((Object)response.getContent());
            log.trace((Object)"Done parsing service response XML");
            awsResponse.setResult(result);
            if (result instanceof ObjectListing) {
                if (!StringUtils.isNullOrEmpty((String)this.responseHeaders.get("ibm-sse-kp-enabled"))) {
                    ((ObjectListing)result).setIBMSSEKPEnabled(Boolean.parseBoolean(this.responseHeaders.get("ibm-sse-kp-enabled")));
                }
                if (!StringUtils.isNullOrEmpty((String)this.responseHeaders.get("ibm-sse-kp-customer-root-key-crn"))) {
                    ((ObjectListing)result).setIBMSSEKPCrk(this.responseHeaders.get("ibm-sse-kp-customer-root-key-crn"));
                }
            }
        }
        return awsResponse;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

