/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.protocol;

import com.ibm.cloud.objectstorage.thirdparty.apache.http.ContentTooLongException;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpResponse;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.entity.ContentType;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.ContentDecoder;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.IOControl;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.entity.ContentBufferEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.protocol.AbstractAsyncResponseConsumer;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.util.HeapByteBufferAllocator;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.util.SimpleInputBuffer;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpContext;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.util.Asserts;
import java.io.IOException;

public class BasicAsyncResponseConsumer
extends AbstractAsyncResponseConsumer<HttpResponse> {
    private volatile HttpResponse response;
    private volatile SimpleInputBuffer buf;

    @Override
    protected void onResponseReceived(HttpResponse response) throws IOException {
        this.response = response;
    }

    @Override
    protected void onEntityEnclosed(HttpEntity entity, ContentType contentType) throws IOException {
        long len = entity.getContentLength();
        if (len > Integer.MAX_VALUE) {
            throw new ContentTooLongException("Entity content is too long: " + len);
        }
        if (len < 0L) {
            len = 4096L;
        }
        this.buf = new SimpleInputBuffer((int)len, new HeapByteBufferAllocator());
        this.response.setEntity(new ContentBufferEntity(entity, this.buf));
    }

    @Override
    protected void onContentReceived(ContentDecoder decoder, IOControl ioctrl) throws IOException {
        Asserts.notNull(this.buf, "Content buffer");
        this.buf.consumeContent(decoder);
    }

    @Override
    protected void releaseResources() {
        this.response = null;
        this.buf = null;
    }

    @Override
    protected HttpResponse buildResult(HttpContext context) {
        return this.response;
    }
}

