/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.reactor;

import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.Contract;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.ThreadingBehavior;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ExceptionEvent {
    private final Throwable ex;
    private final long time;

    public ExceptionEvent(Throwable ex, Date timestamp) {
        this.ex = ex;
        this.time = timestamp != null ? timestamp.getTime() : 0L;
    }

    public ExceptionEvent(Exception ex) {
        this(ex, new Date());
    }

    public Throwable getCause() {
        return this.ex;
    }

    public Date getTimestamp() {
        return new Date(this.time);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(new Date(this.time));
        buffer.append(" ");
        buffer.append(this.ex);
        return buffer.toString();
    }
}

