/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.pool;

import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpHost;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpRequest;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpResponse;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpResponseFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.Contract;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.ThreadingBehavior;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.config.ConnectionConfig;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.DefaultHttpResponseFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.DefaultNHttpClientConnectionFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.SSLNHttpClientConnectionFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.NHttpClientConnection;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.NHttpConnectionFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.NHttpMessageParserFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.NHttpMessageWriterFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.pool.NIOConnFactory;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.reactor.IOSession;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.reactor.ssl.SSLSetupHandler;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.util.ByteBufferAllocator;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.util.HeapByteBufferAllocator;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.params.HttpParams;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.util.Args;
import java.io.IOException;
import javax.net.ssl.SSLContext;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicNIOConnFactory
implements NIOConnFactory<HttpHost, NHttpClientConnection> {
    private final NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory;
    private final NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory;

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory, NHttpConnectionFactory<? extends NHttpClientConnection> sslFactory) {
        Args.notNull(plainFactory, "Plain HTTP client connection factory");
        this.plainFactory = plainFactory;
        this.sslFactory = sslFactory;
    }

    public BasicNIOConnFactory(NHttpConnectionFactory<? extends NHttpClientConnection> plainFactory) {
        this(plainFactory, null);
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpResponseFactory responseFactory, ByteBufferAllocator allocator, HttpParams params) {
        this(new DefaultNHttpClientConnectionFactory(responseFactory, allocator, params), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseFactory, allocator, params));
    }

    @Deprecated
    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, HttpParams params) {
        this(sslcontext, sslHandler, DefaultHttpResponseFactory.INSTANCE, HeapByteBufferAllocator.INSTANCE, params);
    }

    @Deprecated
    public BasicNIOConnFactory(HttpParams params) {
        this(null, null, params);
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, NHttpMessageParserFactory<HttpResponse> responseParserFactory, NHttpMessageWriterFactory<HttpRequest> requestWriterFactory, ByteBufferAllocator allocator, ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(responseParserFactory, requestWriterFactory, allocator, config), new SSLNHttpClientConnectionFactory(sslcontext, sslHandler, responseParserFactory, requestWriterFactory, allocator, config));
    }

    public BasicNIOConnFactory(SSLContext sslcontext, SSLSetupHandler sslHandler, ConnectionConfig config) {
        this(sslcontext, sslHandler, null, null, null, config);
    }

    public BasicNIOConnFactory(ConnectionConfig config) {
        this(new DefaultNHttpClientConnectionFactory(config), null);
    }

    @Override
    public NHttpClientConnection create(HttpHost route, IOSession session) throws IOException {
        NHttpClientConnection conn;
        if (route.getSchemeName().equalsIgnoreCase("https")) {
            if (this.sslFactory == null) {
                throw new IOException("SSL not supported");
            }
            conn = this.sslFactory.createConnection(session);
        } else {
            conn = this.plainFactory.createConnection(session);
        }
        session.setAttribute("http.connection", conn);
        return conn;
    }
}

