/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.client;

import com.ibm.cloud.objectstorage.thirdparty.apache.http.ConnectionReuseStrategy;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.protocol.RequestAddCookies;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.protocol.RequestClientConnControl;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.protocol.ResponseProcessCookies;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.ConnectionKeepAliveStrategy;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.DefaultConnectionReuseStrategy;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.client.IOReactorUtils;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.client.MinimalHttpAsyncClient;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.reactor.IOReactorConfig;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.conn.NHttpClientConnectionManager;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.protocol.HttpAsyncRequestExecutor;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpProcessor;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpProcessorBuilder;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.RequestContent;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.RequestTargetHost;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.RequestUserAgent;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.util.VersionInfo;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

class MinimalHttpAsyncClientBuilder {
    private NHttpClientConnectionManager connManager;
    private boolean connManagerShared;
    private ConnectionReuseStrategy reuseStrategy;
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    private String userAgent;
    private ThreadFactory threadFactory;
    private boolean cookieManagementDisabled;

    public static MinimalHttpAsyncClientBuilder create() {
        return new MinimalHttpAsyncClientBuilder();
    }

    protected MinimalHttpAsyncClientBuilder() {
    }

    public final MinimalHttpAsyncClientBuilder setConnectionManager(NHttpClientConnectionManager connManager) {
        this.connManager = connManager;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setConnectionManagerShared(boolean shared) {
        this.connManagerShared = shared;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setConnectionReuseStrategy(ConnectionReuseStrategy reuseStrategy) {
        this.reuseStrategy = reuseStrategy;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setKeepAliveStrategy(ConnectionKeepAliveStrategy keepAliveStrategy) {
        this.keepAliveStrategy = keepAliveStrategy;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder setThreadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public final MinimalHttpAsyncClientBuilder disableCookieManagement() {
        this.cookieManagementDisabled = true;
        return this;
    }

    public MinimalHttpAsyncClient build() {
        String userAgent;
        ConnectionKeepAliveStrategy keepAliveStrategy;
        ConnectionReuseStrategy reuseStrategy;
        NHttpClientConnectionManager connManager = this.connManager;
        if (connManager == null) {
            connManager = new PoolingNHttpClientConnectionManager(IOReactorUtils.create(IOReactorConfig.DEFAULT, this.threadFactory));
        }
        if ((reuseStrategy = this.reuseStrategy) == null) {
            reuseStrategy = DefaultConnectionReuseStrategy.INSTANCE;
        }
        if ((keepAliveStrategy = this.keepAliveStrategy) == null) {
            keepAliveStrategy = DefaultConnectionKeepAliveStrategy.INSTANCE;
        }
        if ((userAgent = this.userAgent) == null) {
            userAgent = VersionInfo.getUserAgent("Apache-HttpAsyncClient", "com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.client", this.getClass());
        }
        HttpProcessorBuilder b = HttpProcessorBuilder.create();
        b.addAll(new RequestContent(), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(userAgent));
        if (!this.cookieManagementDisabled) {
            b.add(new RequestAddCookies());
            b.add(new ResponseProcessCookies());
        }
        HttpProcessor httpprocessor = b.build();
        ThreadFactory threadFactory = null;
        HttpAsyncRequestExecutor eventHandler = null;
        if (!this.connManagerShared) {
            threadFactory = this.threadFactory;
            if (threadFactory == null) {
                threadFactory = Executors.defaultThreadFactory();
            }
            eventHandler = new HttpAsyncRequestExecutor();
        }
        return new MinimalHttpAsyncClient(connManager, threadFactory, eventHandler, httpprocessor, reuseStrategy, keepAliveStrategy);
    }
}

