/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.nio.client;

import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpConnection;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.Contract;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.annotation.ThreadingBehavior;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.AuthScheme;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.AuthState;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.auth.Credentials;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.UserTokenHandler;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.protocol.HttpClientContext;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.nio.conn.ManagedNHttpClientConnection;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.protocol.HttpContext;
import java.security.Principal;
import javax.net.ssl.SSLSession;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultAsyncUserTokenHandler
implements UserTokenHandler {
    public static final DefaultAsyncUserTokenHandler INSTANCE = new DefaultAsyncUserTokenHandler();

    @Override
    public Object getUserToken(HttpContext context) {
        SSLSession sslsession;
        HttpConnection conn;
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Principal userPrincipal = null;
        AuthState targetAuthState = clientContext.getTargetAuthState();
        if (targetAuthState != null && (userPrincipal = DefaultAsyncUserTokenHandler.getAuthPrincipal(targetAuthState)) == null) {
            AuthState proxyAuthState = clientContext.getProxyAuthState();
            userPrincipal = DefaultAsyncUserTokenHandler.getAuthPrincipal(proxyAuthState);
        }
        if (userPrincipal == null && (conn = clientContext.getConnection()).isOpen() && conn instanceof ManagedNHttpClientConnection && (sslsession = ((ManagedNHttpClientConnection)conn).getSSLSession()) != null) {
            userPrincipal = sslsession.getLocalPrincipal();
        }
        return userPrincipal;
    }

    private static Principal getAuthPrincipal(AuthState authState) {
        Credentials creds;
        AuthScheme scheme = authState.getAuthScheme();
        if (scheme != null && scheme.isComplete() && scheme.isConnectionBased() && (creds = authState.getCredentials()) != null) {
            return creds.getUserPrincipal();
        }
        return null;
    }
}

