/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal.auth;

import com.ibm.cloud.objectstorage.AmazonWebServiceClient;
import com.ibm.cloud.objectstorage.auth.RegionAwareSigner;
import com.ibm.cloud.objectstorage.auth.Signer;
import com.ibm.cloud.objectstorage.internal.auth.SignerProvider;
import com.ibm.cloud.objectstorage.internal.auth.SignerProviderContext;
import com.ibm.cloud.objectstorage.services.s3.internal.ServiceUtils;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import com.ibm.cloud.objectstorage.util.AwsHostNameUtils;
import java.net.URI;

public class S3SignerProvider
extends SignerProvider {
    private static Log log = LogFactory.getLog(S3SignerProvider.class);
    private final AmazonWebServiceClient awsClient;
    private Signer signer;

    public S3SignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.signer = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext signerProviderContext) {
        URI uri = signerProviderContext.getUri();
        if (uri == null || ServiceUtils.isS3AccelerateEndpoint(uri.getHost()) || this.isSignerRegionOverrideSet()) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(AwsHostNameUtils.parseRegionName(uri.getHost(), "s3"));
            }
            catch (RuntimeException e) {
                log.warn("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region", e);
            }
        }
        return this.signer;
    }

    private boolean isSignerRegionOverrideSet() {
        return this.awsClient != null && this.awsClient.getSignerRegionOverride() != null;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

