/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.services.s3.internal;

import com.ibm.cloud.objectstorage.AmazonWebServiceResponse;
import com.ibm.cloud.objectstorage.http.HttpResponse;
import com.ibm.cloud.objectstorage.services.s3.internal.AbstractS3ResponseHandler;
import com.ibm.cloud.objectstorage.services.s3.model.ObjectListing;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.Log;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import com.ibm.cloud.objectstorage.transform.Unmarshaller;
import com.ibm.cloud.objectstorage.util.StringUtils;
import java.io.InputStream;
import java.util.Map;

public class S3XmlResponseHandler<T>
extends AbstractS3ResponseHandler<T> {
    private Unmarshaller<T, InputStream> responseUnmarshaller;
    private static final Log log = LogFactory.getLog("com.ibm.cloud.objectstorage.request");
    private Map<String, String> responseHeaders;

    public S3XmlResponseHandler(Unmarshaller<T, InputStream> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
    }

    @Override
    public AmazonWebServiceResponse<T> handle(HttpResponse response) throws Exception {
        AmazonWebServiceResponse<T> awsResponse = this.parseResponseMetadata(response);
        this.responseHeaders = response.getHeaders();
        if (this.responseUnmarshaller != null) {
            log.trace("Beginning to parse service response XML");
            T result = this.responseUnmarshaller.unmarshall(response.getContent());
            log.trace("Done parsing service response XML");
            awsResponse.setResult(result);
            if (result instanceof ObjectListing) {
                if (!StringUtils.isNullOrEmpty(this.responseHeaders.get("ibm-sse-kp-enabled"))) {
                    ((ObjectListing)result).setIBMSSEKPEnabled(Boolean.parseBoolean(this.responseHeaders.get("ibm-sse-kp-enabled")));
                }
                if (!StringUtils.isNullOrEmpty(this.responseHeaders.get("ibm-sse-kp-customer-root-key-crn"))) {
                    ((ObjectListing)result).setIBMSSEKPCrk(this.responseHeaders.get("ibm-sse-kp-customer-root-key-crn"));
                }
            }
        }
        return awsResponse;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }
}

