/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.oauth;

import com.ibm.cloud.objectstorage.SDKGlobalConfiguration;
import com.ibm.cloud.objectstorage.http.apache.client.impl.ApacheConnectionManagerFactory;
import com.ibm.cloud.objectstorage.http.conn.ssl.SdkTLSSocketFactory;
import com.ibm.cloud.objectstorage.log.InternalLogApi;
import com.ibm.cloud.objectstorage.log.InternalLogFactory;
import com.ibm.cloud.objectstorage.oauth.DefaultTokenProvider;
import com.ibm.cloud.objectstorage.oauth.OAuthServiceException;
import com.ibm.cloud.objectstorage.oauth.Token;
import com.ibm.cloud.objectstorage.oauth.TokenManager;
import com.ibm.cloud.objectstorage.oauth.TokenProvider;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.HttpResponse;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.NameValuePair;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.ClientProtocolException;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.entity.UrlEncodedFormEntity;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.client.methods.HttpPost;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.conn.ssl.DefaultHostnameVerifier;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.client.CloseableHttpClient;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.impl.client.HttpClientBuilder;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.message.BasicNameValuePair;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.ssl.SSLContexts;
import com.ibm.cloud.objectstorage.thirdparty.apache.http.util.EntityUtils;
import com.ibm.cloud.objectstorage.thirdparty.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class DefaultTokenManager
implements TokenManager {
    protected static final InternalLogApi log = InternalLogFactory.getLog(DefaultTokenManager.class);
    private static final String BASIC_AUTH = "Basic Yng6Yng=";
    private static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String ACCEPT = "application/json";
    private static final String REFRESH_GRANT_TYPE = "refresh_token";
    private static final String RESPONSE_TYPE = "cloud_iam";
    private TokenProvider provider;
    private volatile Token token;
    private volatile boolean asyncInProgress = false;
    private String iamEndpoint = SDKGlobalConfiguration.IAM_ENDPOINT;
    private int iamMaxRetry = SDKGlobalConfiguration.IAM_MAX_RETRY;
    private double iamRefreshOffset = SDKGlobalConfiguration.IAM_REFRESH_OFFSET;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final Set<Integer> NON_RETRYABLE_STATUS_CODES = new HashSet<Integer>(4);

    public DefaultTokenManager(String apiKey) {
        log.debug("DefaultTokenManager api key constructor");
        this.provider = new DefaultTokenProvider(apiKey);
    }

    public DefaultTokenManager(TokenProvider provider) {
        this.provider = provider;
    }

    public void setIamEndpoint(String iamEndpoint) {
        this.iamEndpoint = iamEndpoint;
    }

    public void setIamRefreshOffset(double offset) {
        this.iamRefreshOffset = offset;
    }

    public void setIamMaxRetry(int count) {
        this.iamMaxRetry = count;
    }

    public TokenProvider getProvider() {
        return this.provider;
    }

    @Override
    public String getToken() {
        log.debug("DefaultTokenManager getToken()");
        if (!this.checkCache()) {
            this.retrieveToken();
        }
        if (this.token == null) {
            this.token = this.retrieveTokenFromCache();
        }
        if (this.hasTokenExpired(this.token)) {
            this.token = this.retrieveTokenFromCache();
        }
        if (this.isTokenExpiring(this.token) && !this.isAsyncInProgress()) {
            this.asyncInProgress = true;
            this.submitRefreshTask();
        }
        if (this.token.getAccess_token() != null && !this.token.getAccess_token().isEmpty()) {
            return this.token.getAccess_token();
        }
        if (this.token.getIms_token() != null && !this.token.getIms_token().isEmpty()) {
            return this.token.getIms_token();
        }
        return this.token.getUaa_token();
    }

    protected boolean checkCache() {
        log.debug("OAuthTokenManager.checkCache()");
        boolean tokenExists = this.getCachedToken() != null;
        return tokenExists;
    }

    protected synchronized void cacheToken(Token token) {
        long tokenExpirationTime;
        int tokenExpiresInSecs;
        log.debug("OAuthTokenManager.cacheToken");
        try {
            tokenExpiresInSecs = Integer.parseInt(token.getExpires_in());
        }
        catch (NumberFormatException exception) {
            tokenExpiresInSecs = 0;
        }
        try {
            tokenExpirationTime = Long.parseLong(token.getExpiration());
        }
        catch (NumberFormatException exception) {
            tokenExpirationTime = 0L;
        }
        long refreshBeforeExpirySecs = (long)((double)tokenExpiresInSecs * this.iamRefreshOffset);
        long tokenRefreshTime = tokenExpirationTime - refreshBeforeExpirySecs;
        token.setRefreshTime(tokenRefreshTime);
        token.setExpirationTime(tokenExpirationTime);
        this.setTokenCache(token);
    }

    protected Token retrieveTokenFromCache() {
        log.debug("OAuthTokenManager.retrieveTokenFromCache");
        return this.getCachedToken();
    }

    protected boolean hasTokenExpired(Token token) {
        log.debug("OAuthTokenManager.hasTokenExpired");
        long currentTime = System.currentTimeMillis() / 1000L;
        if (Long.valueOf(token.getExpiration()) < currentTime) {
            this.retrieveToken();
            return true;
        }
        return false;
    }

    protected boolean isTokenExpiring(Token token) {
        log.debug("OAuthTokenManager.isTokenExpiring");
        long currentTime = System.currentTimeMillis() / 1000L;
        if (currentTime > token.getRefreshTime()) {
            log.debug("Token is expiring");
            return true;
        }
        log.debug("Token is not expiring." + token.getRefreshTime() + " > " + currentTime);
        return false;
    }

    protected Token getCachedToken() {
        return this.token;
    }

    protected void setTokenCache(Token token) {
        this.token = token;
    }

    protected synchronized void retrieveToken() {
        log.debug("OAuthTokenManager.retrieveToken");
        if (this.token == null || Long.valueOf(this.token.getExpiration()) < System.currentTimeMillis() / 1000L) {
            log.debug("Token is null, retrieving initial token from provider");
            boolean tokenRequest = true;
            int retryCount = 0;
            while (tokenRequest && retryCount < this.iamMaxRetry) {
                try {
                    ++retryCount;
                    this.token = this.provider.retrieveToken();
                    tokenRequest = false;
                }
                catch (OAuthServiceException exception) {
                    log.debug("Exception retrieving IAM token. Returned status code " + exception.getStatusCode() + "Retry attempt " + retryCount);
                    boolean bl = tokenRequest = this.shouldRetry(exception.getStatusCode());
                    if (tokenRequest && retryCount != this.iamMaxRetry) continue;
                    throw exception;
                }
            }
            this.cacheToken(this.token);
        }
    }

    protected void submitRefreshTask() {
        TokenRefreshTask tokenRefreshTask = new TokenRefreshTask(this.iamEndpoint, this);
        this.executor.execute(tokenRefreshTask);
        log.debug("Submitted token refresh task");
    }

    protected boolean isAsyncInProgress() {
        log.debug("Aysnchrnonous job in progress : " + this.asyncInProgress);
        return this.asyncInProgress;
    }

    private boolean shouldRetry(int statusCode) {
        return !NON_RETRYABLE_STATUS_CODES.contains(statusCode);
    }

    protected void finalize() throws Throwable {
        try {
            this.executor.shutdown();
        }
        catch (Throwable t) {
            throw t;
        }
        finally {
            super.finalize();
        }
    }

    static {
        NON_RETRYABLE_STATUS_CODES.add(400);
        NON_RETRYABLE_STATUS_CODES.add(401);
        NON_RETRYABLE_STATUS_CODES.add(403);
        NON_RETRYABLE_STATUS_CODES.add(404);
    }

    class TokenRefreshTask
    implements Runnable {
        private String iamEndpoint;
        private DefaultTokenManager tokenManager;
        private Token refreshedToken = null;

        TokenRefreshTask(String iamEndpoint, DefaultTokenManager tokenManager) {
            this.iamEndpoint = iamEndpoint;
            this.tokenManager = tokenManager;
        }

        @Override
        public void run() {
            while (this.refreshedToken == null && System.currentTimeMillis() / 1000L < this.tokenManager.token.getExpirationTime()) {
                try {
                    this.refreshedToken = this.retrieveIAMToken(this.tokenManager.token.getRefresh_token());
                }
                catch (OAuthServiceException exception) {
                    log.info("Exception refreshing IAM token. Returned status code " + exception.getStatusCode());
                }
                if (this.refreshedToken != null) continue;
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    log.info("Token refresh task interrupted." + e.getMessage());
                }
            }
            if (this.refreshedToken != null) {
                this.tokenManager.cacheToken(this.refreshedToken);
                log.info("Token refreshed");
            } else {
                log.info("Token could not be refreshed.");
            }
            this.tokenManager.asyncInProgress = false;
        }

        protected Token retrieveIAMToken(String refreshToken) {
            log.debug("OAuthTokenManager.retrieveIAMToken");
            try {
                SSLContext sslContext;
                if (SDKGlobalConfiguration.isCertCheckingDisabled()) {
                    if (log.isWarnEnabled()) {
                        log.warn("SSL Certificate checking for endpoints has been explicitly disabled.");
                    }
                    sslContext = SSLContext.getInstance("TLS");
                    sslContext.init(null, new TrustManager[]{new ApacheConnectionManagerFactory.TrustingX509TrustManager()}, null);
                } else {
                    sslContext = SSLContexts.createDefault();
                }
                SdkTLSSocketFactory sslsf = new SdkTLSSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
                CloseableHttpClient client = HttpClientBuilder.create().setSSLSocketFactory(sslsf).build();
                HttpPost post = new HttpPost(this.iamEndpoint);
                post.setHeader("Authorization", DefaultTokenManager.BASIC_AUTH);
                post.setHeader("Content-Type", DefaultTokenManager.CONTENT_TYPE);
                post.setHeader("Accept", DefaultTokenManager.ACCEPT);
                ArrayList<BasicNameValuePair> urlParameters = new ArrayList<BasicNameValuePair>();
                urlParameters.add(new BasicNameValuePair("grant_type", DefaultTokenManager.REFRESH_GRANT_TYPE));
                urlParameters.add(new BasicNameValuePair("response_type", DefaultTokenManager.RESPONSE_TYPE));
                urlParameters.add(new BasicNameValuePair(DefaultTokenManager.REFRESH_GRANT_TYPE, refreshToken));
                post.setEntity(new UrlEncodedFormEntity((List<? extends NameValuePair>)urlParameters));
                HttpResponse response = client.execute(post);
                if (response.getStatusLine().getStatusCode() / 100 != 2) {
                    log.info("Response code= " + response.getStatusLine().getStatusCode() + ", Reason= " + response.getStatusLine().getReasonPhrase() + ".Throwing OAuthServiceException");
                    OAuthServiceException exception = new OAuthServiceException("Token retrival from IAM service failed with refresh token");
                    exception.setStatusCode(response.getStatusLine().getStatusCode());
                    exception.setStatusMessage(response.getStatusLine().getReasonPhrase());
                    throw exception;
                }
                HttpEntity entity = response.getEntity();
                String resultStr = EntityUtils.toString(entity);
                ObjectMapper mapper = new ObjectMapper();
                Token token = mapper.readValue(resultStr, Token.class);
                return token;
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            catch (ClientProtocolException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

