/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.metrics;

import com.ibm.cloud.objectstorage.annotation.NotThreadSafe;
import com.ibm.cloud.objectstorage.metrics.ServiceMetricType;
import com.ibm.cloud.objectstorage.thirdparty.apache.logging.LogFactory;
import com.ibm.cloud.objectstorage.util.TimingInfo;

@NotThreadSafe
public class ServiceLatencyProvider {
    private final long startNano;
    private long endNano;
    private final ServiceMetricType serviceMetricType;

    public ServiceLatencyProvider(ServiceMetricType type) {
        this.endNano = this.startNano = System.nanoTime();
        this.serviceMetricType = type;
    }

    public ServiceMetricType getServiceMetricType() {
        return this.serviceMetricType;
    }

    public ServiceLatencyProvider endTiming() {
        if (this.endNano != this.startNano) {
            throw new IllegalStateException();
        }
        this.endNano = System.nanoTime();
        return this;
    }

    public double getDurationMilli() {
        if (this.endNano == this.startNano) {
            LogFactory.getLog(this.getClass()).debug("Likely to be a missing invocation of endTiming().");
        }
        return TimingInfo.durationMilliOf(this.startNano, this.endNano);
    }

    public String getProviderId() {
        return super.toString();
    }

    public String toString() {
        return String.format("providerId=%s, serviceMetricType=%s, startNano=%d, endNano=%d", this.getProviderId(), this.serviceMetricType, this.startNano, this.endNano);
    }
}

